O /*****************************************************************************/  /**                                    wuCME.c  7 Pronounced "wack-mee" (perhaps with a slight "wooack").   O wuCME wraps the "uacme" ACME v2 implementation by Nicola Di Lieto, licensed and  distributed under GPLv3.  $    https://github.com/ndilieto/uacme8    https://github.com/ndilieto/uacme/blob/master/COPYING  M wuCME uses uacme to provide the core of the required functionality, with code O modifications for use on [Open]VMS, as well as additional code specifically for 3 WASD web server TLS service certificate management.   O wuCME is a contraction of "WASD u Certificate Management Environment".  The "u" I in uacme is not explained but is assumed to be a mu as used for micro and  meaning small.  K wuCME supercedes the functionality of the earlier wCME application.  Unlike M wCME, wuCME is tailored for WASD.  Apache now has the mod_md module for ACME.     	 COPYRIGHT 	 --------- % Copyright (C) 2020-2025 Mark G.Daniel / This program comes with ABSOLUTELY NO WARRANTY. G This is free software, and you are welcome to redistribute it under the N conditions of the GNU GENERAL PUBLIC LICENSE, version 3, or any later version.# http://www.gnu.org/licenses/gpl.txt     
 STANDALONE
 ----------M Also known as non-WASD mode, in that wuCME operates without the assistance of L or control by the WASD server environment.  It may be used in support of theH Apache server, or other non-webserver certifcate-employing applications.  D Standlone operation is initiated by executing the STARTUP.COM in theK WUCME_ROOT[000000] directory.  It even defines the /SYSTEM concealed device F logical for itself.  The COMMAND.COM file then defines the rest of theO (optionally) logical names as uncommented in LOGICAL.COM and executes the wuCME  image.  D A command STOP/IMAGE/ID= will immediately restart the wuCME process.   A STOP/ID= will shut it down.   L Any other error or non-error exit of the image will pause for one minute and then restart the image.     
 LOGICAL NAMES 
 ------------- 4 Names must be defined /SYSTEM and can be /EXECUTIVE.  G WUCME_ACTIVE *             this system's wuCME process is always active ? WUCME_CHALLEGE <string>    preferred challenge (e.g. "http-01") H WUCME_DAYS <integer>       number of days out from expiry renewal occursK WUCME_EXE                  location of WUCME.EXE image (used by Apache DCL) = WUCME_HERE <directory>     certificates and keys located here - WUCME_HOOK <file-name>     HOOK DCL procedure F WUCME_LOAD <DCL-command>   override internal certificate load commands4 WUCME_LOGFILE <file-name>  detached process log file3 WUCME_LOGS <directory>     wuCME <stderr> directory H WUCME_MAIL <address(es)>   email address(es) for notification of renewal@ WUCME_NO_DAILY *           disables daily certificate managementC WUCME_OPCOM <target(s)>    specify OPCOM target(s) for notification @ WUCME_PID                  process ID of Apache detached process5 WUCME_ROOT                 directory for Apache files F WUCME_STAGING *            if defined use staging URL (i.e. --staging)D WUCME_VERBOSE *            make wuCME rather chatty (i.e. --verbose)     INSTALLed PRIVILEGES --------------------> SYSPRV                     required to access files in [LOCAL]D SYSLCK                     instantiate the wuCME standby/active lockD SETPRV                     OPTIONAL if a WUCME_LOAD command requires=                              something other/more than SYSPRV D SHARE                      required for ALPN-TLS-01 access to BGnnnn     VERSION HISTORY  --------------- ' 01-OCT-2025  MGD  v2.2.c, (preliminary) /                           Apache implementation ' 20-MAY-2025  MGD  v2.2.b, (preliminary) /                           WUCME_HOOK for DNS-01 K                           staging cert,keys,etc. file names now prefixed by M                             "stg_" (e.g. [LOCAL]STG_WUCME_K_EGG_BORD_ORG.PEM) P 08-MAR-2025  MGD  v2.1.0, wuHTTPS.c httpsMakeRequest() if Content-Length: absentJ                             calculate response body length on socket close: 20-SEP-2024  MGD  v2.0.0, ALPN-TLS-01 (RFC8737) acme-tls/1G 14-SEP-2024  MGD  v1.1.9, bugfix; UACME.C authorize() decline challenge 9                           /wasd_root/local to /wasd_local ? 15-JAN-2023  MGD  v1.1.8, CRYPTO.C is_ip() made more "reliable" H 24-OCT-2021  MGD  v1.1.7, logical name WUCME_ACTIVE for when a clusteredG                             system has an independent WASD installation = 01-MAR-2021  MGD  v1.1.6, wucmeChallenge() use LNM$SYSCLUSTER 4                           Happy Birthday second-bornL 06-JAN-2021  MGD  v1.1.5, HttpsVerifyConnect() less specific, more adaptable3                           Happy Birthday first-born G 03-AUG-2020  MGD  v1.1.4, bugfix; wucmeProbe80() use hostname parameter 3                           many happy returns Philip J 10-JUL-2020  MGD  v1.1.3, wucmeProbe80() use WWW_SERVER_NAME not localhostH 04-JUL-2020  MGD  v1.1.2, ScriptAdmin() WATCHing advice on authorisationE                           UtilAdjustPriv() refine privilege reporting @ 17-JUN-2020  MGD  v1.1.1, ScriptBegin() refine script activationM                           handle multiple proctored instances (even if silly) D 03-JUN-2020  MGD  v1.1.0, allow INSTALLed with SETPRV for WUCME_LOAD>                           enhance CertManLoad() for WUCME_LOAD) 01-JUN-2020  MGD  v1.0.0, initial release % 08-AUG-2019  MGD  initial development  */O /*****************************************************************************/    #define SOFTWAREVN "2.2.c" #define SOFTWARENM "WUCME" /* version of uacme */ #define PACKAGE_VERSION "1.1.2"  #ifdef __ALPHA2 #  define SOFTWAREID SOFTWARENM " AXP-" SOFTWAREVN #endif
 #ifdef __ia64 3 #  define SOFTWAREID SOFTWARENM " IA64-" SOFTWAREVN  #endif #ifdef __VAX #   error VAX not implemented  #endif #ifdef __x86_64 2 #  define SOFTWAREID SOFTWARENM " X86-" SOFTWAREVN #endif   #include <stdarg.h>  #include <stdlib.h>  #include <stdio.h> #include <dirent.h>  #include <errno.h> #include <fcntl.h> #include <ints.h>  #include <stat.h>  #include <string.h>  #include <types.h> #include <unixlib.h> #include <unistd.h>    #include <descrip.h> #include <dvidef.h>  #include <jpidef.h>  #include <lnmdef.h>  #include <lib$routines.h>  #include <prvdef.h>  #include <ssdef.h> #include <starlet.h> #include <syidef.h>    #include "wucme.h" #include "wucertman.h" #include "wureport.h"    #define FI_LI "WUCME", __LINE__   
 int  dbug,      wucmeActive,       wucmeScript;   
 char  *argv0;    uchar  SyiClusterMember; char  SyiNodeName [16];   ! char  SoftwareId [] = SOFTWAREID, (       UacmeVersion [] = PACKAGE_VERSION;   extern int  g_loglevel;  extern uchar  SyiClusterMember;  extern char  SyiNodeName[],               UacmeVersion[];  O /*****************************************************************************/  /*- Various activities at the wuCME command-line.  */  & void wucmeCli (int argc, char *argv[])   {     int  argsc,         count,         force = 0,         retval;     char  *cptr;     #define MAX_ARGSV 128    char  *argsv [MAX_ARGSV];      /*********/    /* begin */    /*********/      if (argc == 2)     {0       /* these functions exit() independently */9       if (!strcasecmp (argv[1], "/begin")) wucmeBegin (); B       if (!strcasecmp (argv[1], "/detach")) wucmeDetach (argv[1]);C       if (!strcasecmp (argv[1], "/restart")) wucmeDetach (argv[1]); @       if (!strcasecmp (argv[1], "/stop")) wucmeDetach (argv[1]);    }  D    /* initialise the arguments to wuacme mainline - just in case! */,    memset (argsv, argsc = 0, sizeof(argsv));    argsv[argsc++] = argv0;    argsv[argsc++] = "--uacme";  )    if (cptr = UtilSysTrnLnm (WUCME_HOOK))     {        argsv[argsc++] = "--hook";       cptr = strdup(cptr);       argsv[argsc++] = cptr;    }  )    for (count = 1; count < argc; count++)     {       cptr = argv[count]; &       if (!strcasecmp (cptr, "issue"))       { /          if (force) argsv[argsc++] = "--force"; "          argsv[argsc++] = "issue";-          for (count++; count < argc; count++) 
          {8             if (argsc >= MAX_ARGSV) exit (SS$_BUGCHECK);             cptr = argv[count];              while (*cptr) 
             { 4                while (*cptr && *cptr == ',') cptr++;0                if (*cptr) argsv[argsc++] = cptr;4                while (*cptr && *cptr != ',') cptr++;)                if (*cptr) *cptr++ = '\0'; 
             } 
          }*          retval = mainline (argsc, argsv);          exit (retval);        }   &       if (!strcasecmp (cptr, "check"))       {           if (++count < argc)             cptr = argv[count]; 
          else              cptr = "";  '          if (!strcasecmp (cptr, "/ca")) 
          {$             argsv[argsc++] = "ping";-             retval = mainline (argsc, argsv);              exit (retval);
          }  +          if (!strcasecmp (cptr, "/http01")) 
          {?             /* spawn the standalone http-01 challenge server */              Http01Spawn (-999);              exit (SS$_NORMAL);
          }  )          if (!strcasecmp (cptr, "/load")) 
          {B             /* run the certificate (re)load at the command line */             CertManLoad ();              exit (SS$_NORMAL);
          }  (          if (!strcasecmp (cptr, "/log"))
          {?             /* output the current proctored cert manager log */              wucmeCheckLog ();              exit (SS$_NORMAL);
          }  )          if (!strcasecmp (cptr, "/mail")) 
          {/             /* test the (e)mail notification */ 2             if (cptr = UtilSysTrnLnm (WUCME_MAIL))#                cptr = strdup(cptr);              else#                exit (SS$_NOLOGNAM); @             ReportMail (MAIL_PERSONAL, cptr, "wucme test only!",8                         "wucme test of MAIL report...");             exit (SS$_NORMAL);
          }  *          if (!strcasecmp (cptr, "/opcom"))
          {-             /* test the OPCOM notification */              int  target;3             if (cptr = UtilSysTrnLnm (WUCME_OPCOM)) 2                target = ReportOpcomTargetOf(cptr);             else#                exit (SS$_NOLOGNAM); B             ReportOpcom (target, "wucme test of OPCOM report...");             exit (SS$_NORMAL);
          }            exit (SS$_BADPARAM);        }   )       if (!strcasecmp (cptr, "/force") || (           !strcasecmp (cptr, "--force"))       {           force = 1;           continue;       }   1       if (!strncasecmp (cptr, "certificates", 4))        { 1          /* list all the hosts being certified */           CertManAdminCert ();           exit (SS$_NORMAL);        }   +       if (!strcasecmp (cptr, "deactivate"))        { '          argsv[argsc++] = "deactivate"; *          retval = mainline (argsc, argsv);          exit (retval);        }   +       if (!strncasecmp (cptr, "http01", 6))        { 2          /* create the http-01 responder server */          Http01Begin (cptr);          exit (SS$_NORMAL);        }   '       if (!strcasecmp (cptr, "manage"))        { J          /* run the certificate management activity at the command line */          CertManBegin ();           exit (SS$_NORMAL);        }   &       if (!strcasecmp (cptr, "new") ||)           !strcasecmp (cptr, "register"))        {            argsv[argsc++] = "new";%          /* optional email address */ :          if (count < argc) argsv[argsc++] = argv[++count];*          retval = mainline (argsc, argsv);          exit (retval);        }   %       if (!strcasecmp (cptr, "ping"))        { !          argsv[argsc++] = "ping"; *          retval = mainline (argsc, argsv);          exit (retval);        }   '       if (!strcasecmp (cptr, "revoke"))        { #          argsv[argsc++] = "revoke"; :          if (count < argc) argsv[argsc++] = argv[++count];*          retval = mainline (argsc, argsv);          exit (retval);        }   +       if (!strncasecmp (cptr, "/test=", 6))        {           cptr += 6; (          if (!strcasecmp (cptr, "lock"))
          {J             /* execute two (mor more) different sessions ^Y one of them */+             printf ("try CertManLock()\n"); '             CertManLock ("WUCME-TEST"); E             printf ("got CertManLock() ^Y then $ EXIT when ready\n");              sleep (300);
          }          exit (1);       }   ,       if (!strcasecmp (cptr, "--version") ||)           !strcasecmp (cptr, "/version"))        { A          fprintf (stdout, "%%WUCME-I-VERSION, %s (%s) (%s) %s\n", +                   SoftwareId, UacmeVersion, ;                   OpenSSL_version(OPENSSL_VERSION), argv0);           exit (SS$_NORMAL);        }          /* more detail */ ,       if (!strcasecmp (cptr, "--verbose") ||)           !strcasecmp (cptr, "/verbose"))        { &          argsv[argsc++] = "--verbose";          continue;       }          exit (SS$_BADPARAM);    } }   O /*****************************************************************************/  /*N Return true if the image is using WASD_ROOT:[000000]COMMAND.C9M, false if not. */   int wucmeMode (int is)   {     static int  mode;  (    char  *cptr, *prcptr, *raptr, *saptr;    char  PidString [32];  !    if (mode) return (mode == is);   0    sprintf (PidString, "%08.08X", UtilGetPid());6    if (!(cptr = UtilSysTrnLnm (WUCME_PID))) cptr = "";B    if (!strcmp (PidString, cptr)) return ((mode = IS_ROOT) == is);  0    if (!(cptr = getenv ("WWW_SERVER_SOFTWARE")))(       cptr = getenv ("SERVER_SOFTWARE");  -    if (!cptr) return ((mode = IS_CLI) == is);   (    /* check for proctor instantiation */&    raptr = getenv ("WWW_REMOTE_ADDR");9    if (!raptr || !*raptr) raptr = getenv ("REMOTE_ADDR"); &    saptr = getenv ("WWW_SERVER_ADDR");9    if (!saptr || !*saptr) saptr = getenv ("SERVER_ADDR");   -    /* should have both these CGI variables */ *    if (raptr && *raptr && saptr && *saptr)    {N       if (!strncmp (cptr, "HTTPd-WASD/", 11)) return ((mode = IS_WASD) == is);K       if (!strncmp (cptr, "Apache/", 7)) return ((mode = IS_APACHE) == is);     }      /* otherwise proctored! */ &    return ((mode = IS_PROCTOR) == is); }   O /*****************************************************************************/  /* Get required system data.  */   void wucmeGetSyi (void)    { !    static ushort  NodeNameLength;     static struct {       short  BufferLength;       short  ItemCode;       void  *BufferPtr;        void  *LengthPtr;     } SyiItemList[] =    {O        { sizeof(SyiClusterMember), SYI$_CLUSTER_MEMBER, &SyiClusterMember, 0 }, M        { sizeof(SyiNodeName), SYI$_NODENAME, &SyiNodeName, &NodeNameLength },         {0,0,0,0}    };       int  status;     $DESCRIPTOR (NameDsc, "");       /*********/    /* begin */    /*********/  9    status = sys$getsyiw (0, 0, 0, &SyiItemList, 0, 0, 0); *    if (!(status & 1)) EXIT_FI_LI (status);  &    SyiNodeName[NodeNameLength] = '\0'; }   O /*****************************************************************************/  /*J This function is proctored into operation by ScriptBegin() and manages theL day-to-day certificate renewal.  Being proctored it is under server control.J To prevent the server from deleting the script timeouts are disabled.  TheJ proctored script never returns from being activated and so the server willM never attempt to use it to process a request.  Just sits there, quietly doing  its job. */   void wucmeBegin (void)   {     static int  PrevDay;   %    int  count, secs, status, startup,          PerHour,         PollSecs;     char  *NewLog;     ulong  BinTime [2];    ushort  NumTime [7];     char  *cptr;       /*********/    /* begin */    /*********/      if (wucmeMode (IS_ROOT))     {>       fprintf (stdout, "%%WUCME-I-STARTUP, %s (%s) (%s) %s\n",(                SoftwareId, UacmeVersion,8                OpenSSL_version(OPENSSL_VERSION), argv0);    }      if (wucmeMode (IS_PROCTOR))    {0       /* tell the server to leave wuCME alone */4       ScriptCallout ("!LIFETIME: DO-NOT-DISTURB\n");    }  !    /* avoid proctor contention */ '    for (count = 0; count < 10; count++)     {        if (wucmeMode (IS_ROOT)) {1          if (UtilSetPrn ("wuCME~standby")) break;        }        else {1          if (UtilSetPrn ("wuCME-standby")) break;        }        sleep (1);    }    if (count >= 10)     {D       /* now it's really silly but prevent proctor from thrashing */       char  prcnam [16];*       for (count = 2; count < 99; count++)       { !          if (wucmeMode (IS_ROOT)) 7             sprintf (prcnam, "wuCME~standby%d", count); 
          else 7             sprintf (prcnam, "wuCME-standby%d", count); (          if (UtilSetPrn (prcnam)) break;       } $       /* now it's just rediculous */*       if (count >= 100) sys$delprc (0, 0);    }      UtilAdjustPriv();  /    /* only the one active per system/cluster */     CertManLock (NULL);  
    sleep (1);       if (wucmeMode (IS_ROOT)) { :       if (!UtilSetPrn ("wuCME~active")) sys$delprc (0, 0);    }	    else { :       if (!UtilSetPrn ("wuCME-active")) sys$delprc (0, 0);    }  /    /* only intended for development purposes */ )    if (cptr = UtilSysTrnLnm (WUCME_POLL))     {       PollSecs = atoi(cptr);:       if (PollSecs <= 0 || PollSecs > 3600) PollSecs = 60;    }    else        PollSecs = 0;   !    for (startup = 1;;startup = 0)     {       sys$gettim (&BinTime);&       sys$numtim (&NumTime, &BinTime);         /* open the log */       NewLog = wucmeLog (1);  @       if (startup) warnx ("%s %s", SoftwareId, UtilImageName());         if (!PrevDay)           warnx ("starting");
       else       if (NewLog)           warnx ("running");   2       /* only intended for development purposes */5       PerHour = UtilSysTrnLnm (WUCME_HOURLY) != NULL;   8       if ((PrevDay && PrevDay != NumTime[2]) || PerHour)       { @          /* day has changed so perform certificate management */,          if (UtilSysTrnLnm (WUCME_NO_DAILY))8             warnx ("certificate management disabled by "2                    "logical name WUCME_NO_DAILY");
          else 
          {-             warnx ("certificate management");              CertManBegin ();L             /* reload the time in case of extended certificate activities */"             sys$gettim (&BinTime);,             sys$numtim (&NumTime, &BinTime);
          }       }   )       if (NumTime[3] || NumTime[4] >= 20)        { 6          /* polls at twenty minutes after each hour */          PrevDay = NumTime[2];K          secs = (3600 - (NumTime[4] * 60)) + (60 - NumTime[5]) + (19 * 60);        } 
       else       { O          /* except if starting after midnight but before twenty minutes past */           PrevDay = -1;B          secs = (20 * 60) - (NumTime[4] * 60) - (60 - NumTime[5]);       }          /* close the log */        wucmeLog (0);        if (PollSecs)        {           PrevDay = -1;          sleep (PollSecs);       } 
       else          sleep (secs);    }      /* should never */     exit (SS$_BUGCHECK);  }   O /*****************************************************************************/  /*K Really just intended to normalise multiple periods in a file specification.  Also ensures 39.39 compliance. */   int wucme2Ods2 (char *spec)  { $    char  *aptr, *cptr, *sptr, *tptr;      /*********/    /* begin */    /*********/  C    if (dbug) printf ("wucme2Ods2() %d |%s|\n", strlen(spec), spec); 1    for (cptr = aptr = sptr = spec; *cptr; cptr++)     {J       if (*cptr == '/' || *cptr == '-'  || *cptr == '$' || isalnum(*cptr))       {           *sptr++ = *cptr; '          if (*cptr == '/') aptr = cptr;        } 
       else       if (*cptr == '.')        { &          /* reduce multiple periods */L          for (tptr = cptr+1; *tptr && *tptr != '.' && *tptr != '/'; tptr++);          if (*tptr == '.')             *sptr++ = '_';
          else %             *sptr++ = *(aptr = cptr);        } 
       else          *sptr++ = '_'; 4       /* if exceeds 39.39 just undo the last copy */!       if (cptr > aptr+39) sptr--;     }    *sptr = '\0';5    if (dbug) printf ("%d |%s|\n", sptr - spec, spec);     return (sptr - spec); }   O /*****************************************************************************/  /*L Manage the HTTP01 challenge key and token.  Store using a logical name.  TheO token in index 0 and the key in index 1.  If a token is not supplied delete the M logical name.  If the key is not supplied then translate the logical name and M check the token values match and return the key.  Logical name does not exist O or tokens not matched return NULL.  If both are supplied the create the logical F name containing the token and key in index 0 and 1.  Return the key if" successful or NULL if unsucessful. */  - char* wucmeChallenge (char *token, char *key)  {     static char  LogName [64]; ,    static $DESCRIPTOR (LogNameDsc, LogName);8    static $DESCRIPTOR (LnmClusterDsc, "LNM$SYSCLUSTER");#    static ushort  lenkey, lentoken;      static ulong  lattr0, lattr1;    static ulong  lindex0 = 0,                   lindex1 = 1;     static char  lkey [256],                  ltoken [256];     static struct {       short int  buf_len;        short int  item;       void  *buf_addr;       ushort  *ret_len;     } CreLnmItems [] =     {       { 0, LNM$_STRING, 0, 0 },        { 0, LNM$_STRING, 0, 0 },        { 0,0,0,0 }     }, TrnLnmItems [] =    {3       { sizeof(lindex0), LNM$_INDEX, &lindex0, 0 }, 6       { sizeof(lattr0), LNM$_ATTRIBUTES, &lattr0, 0 },;       { sizeof(ltoken)-1, LNM$_STRING, ltoken, &lentoken }, 3       { sizeof(lindex1), LNM$_INDEX, &lindex1, 0 }, 6       { sizeof(lattr1), LNM$_ATTRIBUTES, &lattr1, 0 },5       { sizeof(lkey)-1, LNM$_STRING, lkey, &lenkey },        { 0,0,0,0 }     };       int  len, status;      /*********/    /* begin */    /*********/   if(0)warnx ("+++++0");    if (!LogName[0])     {+       if (SyiClusterMember && !wucmeActive) @          len = sprintf (LogName, "%s_CLUSTER", WUCME_CHALLENGE);
       elseH          len = sprintf (LogName, "%s_%s", WUCME_CHALLENGE, SyiNodeName);$       LogNameDsc.dsc$w_length = len;# if(0)warnx ("+++++1 |%s|",LogName);     }      if (!token)    { if(0)warnx ("+++++2");       /* delete logical name */ 2       sys$dellnm (&LnmClusterDsc, &LogNameDsc, 0);       LogName[0] = '\0';       return (NULL);      }  ! if(0)warnx ("+++++3 |%s|",token); *    if (!strcmp (token, WUCME_ALPN1_TOKEN))    {4       /* this token returns the key (tls-alpn-01) */L       status = sys$trnlnm (0, &LnmClusterDsc, &LogNameDsc, 0, &TrnLnmItems);( if(0)warnx ("+++++4 %%X%08.08X",status);(       if (!(status & 1)) return (NULL); 2       if (!(lattr0 & LNM$M_EXISTS)) return (NULL);2       if (!(lattr1 & LNM$M_EXISTS)) return (NULL);       /* return the key */       lkey[lenkey] = '\0';  if(0)warnx ("+++++5 |%s|",lkey);       return (lkey);    }    else     if (!key)    { if(0)warnx ("+++++6");A       /* translate the name, compare the token, return the key */ L       status = sys$trnlnm (0, &LnmClusterDsc, &LogNameDsc, 0, &TrnLnmItems);( if(0)warnx ("+++++7 %%X%08.08X",status);(       if (!(status & 1)) return (NULL); 2       if (!(lattr0 & LNM$M_EXISTS)) return (NULL);2       if (!(lattr1 & LNM$M_EXISTS)) return (NULL);       ltoken[lentoken] = '\0';" if(0)warnx ("+++++8 |%s|",ltoken);.       /* if the supplied key does not match */0       if (strcmp (token, ltoken)) return (NULL);       /* return the key */       lkey[lenkey] = '\0';  if(0)warnx ("+++++8 |%s|",lkey);       return (lkey);    }  *    CreLnmItems[0].buf_len = strlen(token);#    CreLnmItems[0].buf_addr = token;   (    CreLnmItems[1].buf_len = strlen(key);!    CreLnmItems[1].buf_addr = key;   I    status = sys$crelnm (0, &LnmClusterDsc, &LogNameDsc, 0, &CreLnmItems); F if(0)warnx ("+++++9 %s |%s|%s| %%X%08.08X",LogName, token,key,status);       if (status & 1) return (key);    return (NULL);  }   O /*****************************************************************************/  /*J Ensure there is a port 80 listener for processing the challenge responses. */  ) void wucmeChallenge80 (const char *ident)    {     int  rcode;      /*********/    /* begin */    /*********/  K    /* this logical name disables the listener (for development purposes) */ /    if (UtilSysTrnLnm (WUCME_NO_HTTP01)) return;   .    /* probe port 80 for challenge responses */#    rcode = wucmeProbe80 (ident, 5);     if (rcode <= 0)    {'       /* port 80 was not contactable */ 5       warnx ("FAILED to connect to port 80 service"); 5       warnx ("deploying internal port 80 responder");        Http01Spawn (1);    }    else     if (rcode != 200)0       warnx("challenge probe failed %d", rcode); }   O /*****************************************************************************/  /*B Probe port 80 to check if it is available for challenge responses. */  / int wucmeProbe80 (const char *ident, int retry)    {     int  rcode;    char  *cptr, *sptr, *zptr;     char  buf [256];       /*********/    /* begin */    /*********/  '    zptr = (sptr = buf) + sizeof(buf)-1; C    for (cptr = "http://"; *cptr && sptr < zptr; *sptr++ = *cptr++); F    for (cptr = (char*)ident; *cptr && sptr < zptr; *sptr++ = *cptr++);?    for (cptr = ":80"; *cptr && sptr < zptr; *sptr++ = *cptr++); O    for (cptr = WUCME_PROBE_CHALLENGE; *cptr && sptr < zptr; *sptr++ = *cptr++);     *sptr = '\0';      while (retry > 0)    {       sleep (1);*       rcode = httpsGetRequest (buf, NULL);       if (rcode > 0) break;        retry--;    }    return (rcode); }   O /*****************************************************************************/  /*A Manage the detached (proctored script process) <stderr> log file.  */   char* wucmeLog (int logit)   {     static char  fname [256];      int  retval;     ulong  BinTime [2];    ushort  NumTime [7];     char  *cptr, *sptr, *zptr ;
    FILE  *fp;     struct stat  stat_buf;       /*********/    /* begin */    /*********/      if (!logit)    {=       /* close the log file (by reopening <stderr> to NL:) */ ,       stderr = freopen ("/nl", "w", stderr);+       if (!stderr) EXIT_FI_LI (vaxc$errno);        return (NULL);    }      sys$gettim (&BinTime); #    sys$numtim (&NumTime, &BinTime);       if (wucmeMode (IS_ROOT)) $       cptr = "apache$common:[logs]";    else     if (wucmeMode (IS_APACHE)) $       cptr = "apache$common:[logs]";    else !       cptr = "wasd_server_logs:";   0    sprintf (fname, "%swucme_%04.04d%02.02d.log",*             cptr, NumTime[0], NumTime[1]);  .    /* just return the current log file name */!    if (logit < 0) return (fname);   $    retval = stat (fname, &stat_buf);(    stderr = freopen (fname, "a", stderr,4                      "ctx=rec", "rfm=var", "rat=cr",6                      "rop=rlk", "shr=get", "shr=put");(    if (!stderr) EXIT_FI_LI (vaxc$errno);  L    /* returning the file name indicates the file did not previously exist */    if (retval) return (fname);      return (NULL);  }   O /*****************************************************************************/  /*< Return an integer representing the server software version. ) "HTTPd-WASD/11.5.1" should become 110501. 3 Assign a global symbol for use at the command-line.  */   int wucmeServerSoftware (void)   {     static int  ServerSoftware;    char  *cptr;   /    if (ServerSoftware) return (ServerSoftware); 0    if (!(cptr = getenv ("WWW_SERVER_SOFTWARE")))/       if (!(cptr = getenv ("SERVER_SOFTWARE"))) ,          /* at CLI then no automatic load */%          return (ServerSoftware = 0); +    while (*cptr && !isdigit(*cptr)) cptr++; '    ServerSoftware = atoi(cptr) * 10000; *    while (*cptr && isdigit(*cptr)) cptr++;    if (*cptr == '.') cptr++;&    ServerSoftware += atoi(cptr) * 100;*    while (*cptr && isdigit(*cptr)) cptr++;    if (*cptr == '.') cptr++;     ServerSoftware += atoi(cptr);    return (ServerSoftware);  }   O /*****************************************************************************/  /*. Report the current "wuCME-active" process log. */   void wucmeCheckLog (void)    {     char line [8192];    char  *cptr; 
    FILE  *fp;       /*********/    /* begin */    /*********/  4    fp = fopen (cptr = wucmeLog(-1), "r", "shr=put");      if (!fp)     {:       warnx ("open %s failed: %s", cptr, strerror(errno));
       return;     }  )    while (fgets (line, sizeof(line), fp))     {       fputs (line, stdout);        fflush (stdout);    }      fclose (fp);  }   O /*****************************************************************************/  /*8 Simply replaces the regex calls in the original uacme.c. */  = char* wucmeFindHeader (const char *headers, const char *name)    { $    char  *aptr, *cptr, *hptr, *sptr;      /*********/    /* begin */    /*********/  -    for (hptr = (char*)headers; *hptr; hptr++)     {%       if (!isalpha (*hptr)) continue; 5       if (tolower(*hptr) != tolower(*name)) continue;        cptr = hptr;5       for (aptr = (char*)name; *aptr; aptr++, cptr++) E          if (tolower(*aptr) != tolower(*cptr) || *cptr == ':') break; *       if (*aptr || *cptr != ':') continue;2       for (cptr++; *cptr && *cptr == ' '; cptr++);I       for (sptr = cptr; *cptr && *cptr != '\r' && *cptr != '\n'; cptr++); 0       if (*cptr == '\r' || *cptr == '\n') break;    }    if (!*hptr) return (NULL); -    aptr = hptr = calloc (1, cptr - sptr + 1); )    while (sptr < cptr) *aptr++ = *sptr++;     return (hptr);  }   O /*****************************************************************************/  /*8 Return the location of the server certificates and keys.A Logical name value can be be defined as VMS or Unix-style syntax.  */   char* wucmeDir (void)    {     static char  *dptr = NULL;       /*********/    /* begin */    /*********/      if (dptr) return (dptr);   ,    if (!(dptr = UtilSysTrnLnm (WUCME_HERE)))    {       if (wucmeMode (IS_WASD))           return ("/wasd_local");
       else!       if (wucmeMode (IS_PROCTOR))            return ("/wasd_local");
       else        if (wucmeMode (IS_APACHE))0          return ("/apache$common/conf/ssl_crt");
       else%       if (UtilSysTrnLnm (WUCME_ROOT)) 0          return ("/apache$common/conf/ssl_crt");
       else           return ("/wasd_local");    }6    if (*dptr != '/') dptr = decc$translate_vms (dptr);    return (dptr);  }   O /*****************************************************************************/  /*5 Output the argument array to <stderr> (the log file).  */  + void wucmeArgcArgv (int argc, char *argv[])    {     /*********/    /* begin */    /*********/  4    fprintf (stderr, "%s: (%d)", tstamp(NULL), argc);O    for (int acnt = 0; acnt < argc; acnt++) fprintf (stderr, " %s", argv[acnt]);     fputs ("\n", stderr); }   O /*****************************************************************************/  /*F If rcode < 0 disable logging.  Enable uacme logging using logical nameL WUCME_VERBOSE as "*" for level 1 (backward compatibility), "0" to disable or "1".."9" for levels 1..n.  */   int wucmeVerbose (int rcode)   {     char  *cptr;       /*********/    /* begin */    /*********/      if (rcode < 0)        g_loglevel = rcode = 0;     else ,    if (cptr = UtilSysTrnLnm (WUCME_VERBOSE))    {       if (isdigit(*cptr))           rcode = atoi(cptr);
       else          rcode = 1;        g_loglevel = rcode;     }    return (rcode); }   O /*****************************************************************************/  /*# See description in module prologue.  */   void wucmeDetach (char *how)   {  #define PRC$M_DETACH 0x200" #define STS$M_INHIB_MSG 0x10000000      static int  BasePrio = 4,(                PrcDetach = PRC$M_DETACH;  E    static $DESCRIPTOR (CommandDsc, "WUCME_ROOT:[000000]COMMAND.COM"); C    static $DESCRIPTOR (LogFileDsc, "WUCME_ROOT:[000000]wuCME.log"); ;    static $DESCRIPTOR (LoginOutDsc, "SYS$SYSTEM:LOGINOUT"); 4    static $DESCRIPTOR (PrcNamDsc, "wuCME~detached");      int  len, status, PrcId;     char  *cptr;     char  string [16],           tname [64];    FILE  *tfile;      UtilAdjustPriv();  9    /* test _HERE directory to check if it's accessible */ ,    if (!(cptr = UtilSysTrnLnm (WUCME_HERE))),       cptr = "apache$common:[conf.ssl_crt]";*    sprintf (tname, "%s_check_.txt", cptr);%    if (!(tfile = fopen (tname, "w")))     {4       fprintf (stdout, "%%WUCME-F-CRT, %s\n", cptr);       exit (vaxc$errno);    }    fclose (tfile);    remove (tname);  ;    /* test _LOGFILE direcory to check if it's accessible */ ?    if (!(tfile = fopen (cptr = LogFileDsc.dsc$a_pointer, "w")))s    {4       fprintf (stdout, "%%WUCME-F-LOG, %s\n", cptr);       exit (vaxc$errno);    }    fclose (tfile);    remove (cptr);P  ;    if (!strcmp (how, "/restart") || !strcmp (how, "/stop")).+       if (cptr = UtilSysTrnLnm (WUCME_PID))M       {c&          sscanf (cptr, "%8X", &PrcId);,          status = sys$delprc (&PrcId, 0, 0);'          if (!strcmp (how, "/restart"))e-             if (!(status & 1)) exit (status); 3          if (!strcmp (how, "/stop")) exit (status);        }e  J    status = sys$creprc (&PrcId, &LoginOutDsc, &CommandDsc, &LogFileDsc, 0,N                         0, 0, &PrcNamDsc, BasePrio, 0, 0, PrcDetach, 0, 0, 0);  &    sprintf (string, "%08.08X", PrcId);%    UtilSysCreLnm (WUCME_PID, string);e  :    fprintf (stdout, "%%WUCME-I-APACHE, pid %s\n", string);  Y    exit (status);  }y  O /*****************************************************************************/   