 /*E  * Copyright (C) 2019,2020 Nicola Di Lieto <nicola.dilieto@gmail.com>   *  * This file is part of uacme.  *C  * uacme is free software: you can redistribute it and/or modify it D  * under the terms of the GNU General Public License as published byD  * the Free Software Foundation, either version 3 of the License, or&  * (at your option) any later version.  *?  * uacme is distributed in the hope that it will be useful, but =  * WITHOUT ANY WARRANTY; without even the implied warranty of D  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU+  * General Public License for more details.   *D  * You should have received a copy of the GNU General Public License(  * along with this program.  If not, see"  * <http://www.gnu.org/licenses/>.  */    #ifdef __VMS #include "wucme.h" #else  #include "config.h"  #include <err.h> #endif   #include <limits.h>  #include <stdio.h> #include <stdlib.h>  #include <string.h>    #include "json.h"  #include "jsmn.h"   A static int json_build(const char *js, jsmntok_t *t, size_t count,          json_value_t *value) {     int i, j, k; #ifdef IS_WUCME      if ((int)count <= 0) #else      if (count <= 0)  #endif         return 0;      switch (t->type) {         case JSMN_PRIMITIVE:)             value->type = JSON_PRIMITIVE; E             value->v.value = strndup(js+t->start, t->end - t->start); "             if (!value->v.value) {3                 warn("json_build: strndup failed");                  return -1;
             }              return 1;            case JSMN_STRING: &             value->type = JSON_STRING;E             value->v.value = strndup(js+t->start, t->end - t->start); "             if (!value->v.value) {3                 warn("json_build: strndup failed");                  return -1;
             }              return 1;            case JSMN_OBJECT: &             value->type = JSON_OBJECT;+             value->v.object.size = t->size; J             value->v.object.names = calloc(t->size, sizeof(json_value_t));K             value->v.object.values = calloc(t->size, sizeof(json_value_t)); D             if (!value->v.object.names || !value->v.object.values) {2                 warn("json_build: calloc failed");                 return -1;
             } /             for (j = i = 0; i < t->size; i++) { 8                 value->v.object.names[i].parent = value;9                 value->v.object.values[i].parent = value; L                 k = json_build(js, t+1+j, count-j, value->v.object.names+i);1                 if (k < 0) return k; else j += k; M                 k = json_build(js, t+1+j, count-j, value->v.object.values+i); 1                 if (k < 0) return k; else j += k; 
             }              return j+1;            case JSMN_ARRAY:%             value->type = JSON_ARRAY; *             value->v.array.size = t->size;J             value->v.array.values = calloc(t->size, sizeof(json_value_t));)             if (!value->v.array.values) { 2                 warn("json_build: calloc failed");                 return -1;
             } /             for (j = i = 0; i < t->size; i++) { 8                 value->v.array.values[i].parent = value;L                 k = json_build(js, t+1+j, count-j, value->v.array.values+i);1                 if (k < 0) return k; else j += k; 
             }              return j+1;            default:)             value->type = JSON_UNDEFINED;              return 0;      }  }   I static void _json_dump(FILE *f, const json_value_t *value, size_t indent)  {      size_t i,j;      if (!value) return;      switch (value->type) {         case JSON_PRIMITIVE:-             fprintf(f, "%s", value->v.value);              return;            case JSON_STRING: 1             fprintf(f, "\"%s\"", value->v.value);              return;            case JSON_OBJECT:              fprintf(f, "{\n");8             for (i = 0; i < value->v.object.size; i++) {=                 for (j=0; j<4*(indent+1); j++) fputc(' ', f); C                 _json_dump(f, value->v.object.names+i, indent + 1); !                 fprintf(f, ": "); D                 _json_dump(f, value->v.object.values+i, indent + 1);@                 if (i < value->v.object.size - 1) fputc(',', f);                 fputc('\n', f); 
             } 5             for (j=0; j<4*indent; j++) fputc(' ', f);              fputc('}', f);             if (indent == 0)                 fputc('\n', f);              return;            case JSON_ARRAY:             fprintf(f, "[\n");7             for (i = 0; i < value->v.array.size; i++) { =                 for (j=0; j<4*(indent+1); j++) fputc(' ', f); C                 _json_dump(f, value->v.array.values+i, indent + 1); ?                 if (i < value->v.array.size - 1) fputc(',', f);                  fputc('\n', f); 
             } 5             for (j=0; j<4*indent; j++) fputc(' ', f);              fputc(']', f);             if (indent == 0)                 fputc('\n', f);              return;            default:             return;      }  }   2 void json_dump(FILE *f, const json_value_t *value) {      _json_dump(f, value, 0); }   # void json_free(json_value_t *value)  { 
     size_t i;      if (!value) return;      switch (value->type) {         case JSON_PRIMITIVE:         case JSON_STRING: !             free(value->v.value);              break;           case JSON_OBJECT: 8             for (i = 0; i < value->v.object.size; i++) {3                 json_free(value->v.object.names+i); 4                 json_free(value->v.object.values+i);
             } (             free(value->v.object.names);)             free(value->v.object.values);              break;           case JSON_ARRAY:5             for (i = 0; i < value->v.array.size; i++) 3                 json_free(value->v.array.values+i); (             free(value->v.array.values);             break;           default:             break;     }      if (!value->parent)          free(value); }   ; const json_value_t *json_find(const json_value_t *haystack,          const char *needle)  { 3     if (!haystack || haystack->type != JSON_OBJECT)          return NULL;4     for (size_t i=0; i<haystack->v.object.size; i++)E         if (strcmp(haystack->v.object.names[i].v.value, needle) == 0) 1             return haystack->v.object.values + i;      return NULL; }   : const char *json_find_string(const json_value_t *haystack,         const char *needle)  { 3     if (!haystack || haystack->type != JSON_OBJECT)          return NULL;4     for (size_t i=0; i<haystack->v.object.size; i++)?         if (haystack->v.object.values[i].type == JSON_STRING && I                 strcmp(haystack->v.object.names[i].v.value, needle) == 0) 8             return haystack->v.object.values[i].v.value;     return NULL; }   G int json_compare_string(const json_value_t *haystack, const char *name,          const char *value) { 7     const char *tmp = json_find_string(haystack, name);      if (tmp)"         return strcmp(tmp, value);     else         return INT_MIN;  }   ; json_value_t *json_parse(const char *body, size_t body_len)  {      json_value_t *ret = NULL;      jsmn_parser parser;      unsigned int tok_len = 2; 3     jsmntok_t *tok = calloc(tok_len, sizeof(*tok));      if (!tok) { *         warn("json_parse: calloc failed");         return NULL;     }      jsmn_init(&parser);      while (1) { B         int r = jsmn_parse(&parser, body, body_len, tok, tok_len);         if (r < 0) {(             if (r == JSMN_ERROR_NOMEM) {C                 void *p = realloc(tok, sizeof(*tok) * tok_len * 2);                  if (!p) { 7                     warn("json_parse: realloc failed");                      break;                 }                  tok_len *= 2;                  tok = p;             } else {G                 warnx("json_parse: jsmn_parse failed with code %d", r);                  break;
             }          } else {2             ret = calloc(1, sizeof(json_value_t));             if (!ret) { 2                 warn("json_parse: calloc failed");                 break;
             } 7             json_build(body, tok, parser.toknext, ret);              break;	         }      }      free(tok);     return ret;  } 