/*****************************************************************************/
/*
                                (wu)certman.h

VERSION HISTORY
---------------
14-DEC-2019  MGD  initial
*/
/*****************************************************************************/

#ifndef CERTMAN_H_LOADED
#define CERTMAN_H_LOADED 1

#include <openssl/x509v3.h>
#include <openssl/bn.h>
#include <openssl/asn1.h>
#include <openssl/x509.h>
#include <openssl/x509_vfy.h>
#include <openssl/pem.h>
#include <openssl/bio.h>

/* days before expiry when renewal attempt begins */
#define CERTMAN_RENEW_DAYS 30

/* function prototypes */
void CertManAdminCert ();
char* CertManAltNames (X509*, char*);
int CertManAsn1time (ASN1_TIME*, char*, int);
void CertManBegin (void);
void CertManCLI (char*);
int CertManCheck (char*, char**);
int CertManIssue (char*);
void CertManLock (char*);
void CertManLoad (void);

#endif /* CERTMAN_H_LOADED */

/****************************************************************************/

