O /*****************************************************************************/  /*+                                   wuHTTPS.c   K This module is a very basic, single-threaded, HTTP client for TLS services. @ By default it is TLS, it will also operate on cleartext sockets.? All external usage is via httpsGet..() and httpsPost..() calls. I Provides a more easily maintained VMS networking than (uacme) using cURL.     	 COPYRIGHT 	 --------- % Copyright (C) 2020-2025 Mark G.Daniel / This program comes with ABSOLUTELY NO WARRANTY. G This is free software, and you are welcome to redistribute it under the N conditions of the GNU GENERAL PUBLIC LICENSE, version 3, or any later version.# http://www.gnu.org/licenses/gpl.txt      VERSION HISTORY  --------------- F 08-MAR-2025  MGD  V2.1.0, httpsMakeRequest() if Content-Length: absentJ                             calculate response body length on socket closeK 05-JAN-2021  MGD  v1.1.5, HttpsVerifyConnect() less specific, more flexible  06-DEC-2019  MGD  initial  */O /*****************************************************************************/    #include <stdio.h> #include <errno.h> #include <unistd.h>  #include <string.h>  #include <sys/socket.h>  #include <resolv.h>  #include <netdb.h> #include <openssl/ssl.h> #include <openssl/err.h>   #include "wucme.h" #include "read-file.h"   extern int  dbug;    static struct requestStruct  {     int  clength,         errline,         hlength,         hsize,         https,         portnum,
         post,          rcode,         rlength,         socket;     char  *content,          *ctype,          *error,          *header,           *hostname,           *response,           *uri;
    SSL  *ssl;  } requestData;4 static struct requestStruct *request = &requestData;   static SSL_CTX  *httpsCtx;   extern char  lets_issuer[],               lets_subject[],              SoftwareId[];   static int httpsConnect (void); # static int httpsMakeRequest (void); + static int httpsSetError (int, char*, ...); % static void httpsResetRequest (void); % static void httpsSetHostName (char*); " static void httpsSetPortNum (int); static void httpsSetPost (int); " static int httpsSetSSLError (int);  static void httpsSetUri (char*);$ static void httpsSetRequest (char*);0 static void httpsSetContent (char*, char*, int);* static void httpsSetHeader (char*, char*);$ static void httpsShowConnect (void);% static int httpsVerifyConnect (void);   O /*****************************************************************************/  /*& Return the integer response HTTP code. */   int httpsGetResponseCode (void)  {     return (request->rcode);  }   O /*****************************************************************************/  /*9 Return a pointer to the full response (header then body).  */  ! char* httpsGetResponseFull (void)  {     return (request->response); }   O /*****************************************************************************/  /*B Return the integer length of the full response (header then body). */  ! int httpsGetResponseLength (void)  {     return (request->rlength);  }   O /*****************************************************************************/  /*- Return a pointer to the full response header.  */   char* httpsGetHeader (void)  {     char  *cptr; '    cptr = calloc (1, request->hlength); 6    memcpy (cptr, request->response, request->hlength);    return (cptr);  }   O /*****************************************************************************/  /*B Return the integer length of the full response (header then body). */   int httpsGetHeaderLength (void)  {     return (request->hlength);  }   O /*****************************************************************************/  /*0 Return a pointer to the response content (body). */   char* httpsGetContent (void) {     char  *cptr; '    cptr = calloc (1, request->clength); 5    memcpy (cptr, request->content, request->clength);     return (cptr);  }   O /*****************************************************************************/  /*/ Return the integer length of any response body.  */    int httpsGetContentLength (void) {     return (request->clength);  }   O /*****************************************************************************/  /*A Return a pointer to the response content type (e.g. "text/html").  */    char* httpsGetContentType (void) {     return (request->ctype);  }   O /*****************************************************************************/  /*M Return a pointer to a respresentative error string.  Can be NULL if no error.  */   char* httpsGetError (void) {     return (request->error);  }   O /*****************************************************************************/  /* */   static SSL_CTX* InitCTX (void)   {     const SSL_METHOD *method;    SSL_CTX *ctx;      SSL_library_init();     OpenSSL_add_all_algorithms();    SSL_load_error_strings();$    method = TLSv1_2_client_method();    ctx = SSL_CTX_new (method);1    if (ctx == NULL) ERR_print_errors_fp (stderr);     return (ctx); }   O /*****************************************************************************/  /* Explicitly set the port number.  */  ) static void httpsSetPortNum (int portnum)  {     request->portnum = portnum; }   O /*****************************************************************************/  /*A Explicitly set if zero then a GET request otherwise POST request.  */  # static void httpsSetPost (int post)  {     request->post = post; }   O /*****************************************************************************/  /* Set the server host name.  */  - static void httpsSetHostName (char *hostname)  { 8    request->hostname = calloc (1, strlen(hostname) + 1);-    if (!request->hostname) exit (vaxc$errno); (    strcpy (request->hostname, hostname); }   O /*****************************************************************************/  /*# Set the server resource identifier.  */  # static void httpsSetUri (char *uri)  { .    request->uri = calloc (1, strlen(uri) + 1);(    if (!request->uri) exit (vaxc$errno);    strcpy (request->uri, uri); }   O /*****************************************************************************/  /*N Using a <protocol>://<hostname>[:<port]/<uri> string, set all of those requestI properties.  If |post| is zero then a GET request otherwise POST request.  */  ' static void httpsSetRequest (char *url)  {     char  *aptr, *cptr;      cptr = url;    request->https = 1;&    if (!strncmp (cptr, "https://", 8))       cptr += 8;    else %    if (!strncmp (cptr, "http://", 7))     {       cptr += 7;       request->https = 0;     }  D    for (aptr = cptr; *cptr && *cptr != ':' && *cptr != '/'; cptr++);3    request->hostname = calloc (1, cptr - aptr + 1); -    if (!request->hostname) exit (vaxc$errno); 1    memcpy (request->hostname, aptr, cptr - aptr);       if (*cptr == ':')&       request->portnum = atoi(cptr+1);    else     if (request->https)       request->portnum = 443;     else        request->portnum = 80;  (    while (*cptr && *cptr != '/') cptr++;
    if (*cptr)     {'       for (aptr = cptr; *cptr; cptr++); 1       request->uri = calloc (1, cptr - aptr + 1); +       if (!request->uri) exit (vaxc$errno); /       memcpy (request->uri, aptr, cptr - aptr);     }    else     {1       request->uri = calloc (1, cptr - aptr + 1); +       if (!request->uri) exit (vaxc$errno);        *request->uri = '/';    } }   O /*****************************************************************************/  /*7 For a POST request add content (body) and content type.  */  E static void httpsSetContent (char *ctype, char *content, int clength)  { .    if (clength < 0) clength = strlen(content);.    request->content = calloc (1, clength + 1);,    if (!request->content) exit (vaxc$errno);&    strcpy (request->content, content);    request->clength = clength;2    request->ctype = calloc (1, strlen(ctype) + 1);*    if (!request->ctype) exit (vaxc$errno);"    strcpy (request->ctype, ctype); }   O /*****************************************************************************/  /** Add request header field (name and value).O If |value| is NULL then the |name| string contains a fully specified field name K and value including carriage control.  The string can contain multiple such  fields.  */  4 static void httpsSetHeader (char *name, char* value) {  #define HINC 2048       char  *cptr, *sptr, *zptr;     for (;;)     {!       if (!name && !value) break; -       if (request->hlength >= request->hsize)        {            request->hsize += HINC;E          request->header = realloc (request->header, request->hsize); 1          if (!request->header) exit (vaxc$errno); <          /* seems we must zero any additional allocation! */>          memset (request->header + request->hlength, 0, HINC);       } ;       zptr = (sptr = request->header) + request->hsize - 8;        sptr += request->hlength;   ?       if (name) while (*name && sptr < zptr) *sptr++ = *name++; 0       request->hlength = sptr - request->header;!       if (sptr >= zptr) continue; "       if (name && !*name && value)       {           *sptr++ = ':';           *sptr++ = ' ';        }        if (!*name) name = NULL;!       if (!name && !value) break;   B       if (value) while (*value && sptr < zptr) *sptr++ = *value++;0       request->hlength = sptr - request->header;!       if (sptr >= zptr) continue;        if (value && !*value)        {           *sptr++ = '\r';          *sptr++ = '\n';          value = NULL;       } 0       request->hlength = sptr - request->header;    } }   O /*****************************************************************************/  /*& Reset the request data and connection. */   void httpsResetRequest (void)    { -    if (request->ssl) SSL_free (request->ssl); 4    if (request->socket > 0) close (request->socket);  1    if (request->content) free (request->content); -    if (request->ctype) free (request->ctype); -    if (request->error) free (request->error); /    if (request->header) free (request->header); 3    if (request->hostname) free (request->hostname); 3    if (request->response) free (request->response); )    if (request->uri) free (request->uri);   5    memset (request, 0, sizeof(struct requestStruct));  }   O /*****************************************************************************/  /*; Establish a network connection to the server host and port.  */   static int httpsConnect (void)   {     int  sd;     struct hostent *host;    struct sockaddr_in addr;   :    if ((host = gethostbyname (request->hostname)) == NULL)    {M       httpsSetError (__LINE__, "%s %s", request->hostname, strerror(errno));         return (errno);     }  (    sd = socket(PF_INET, SOCK_STREAM, 0);#    memset (&addr, 0, sizeof(addr));     addr.sin_family = AF_INET; +    addr.sin_port = htons(request->portnum); 1    addr.sin_addr.s_addr = *(long*)(host->h_addr);   @    if (connect (sd, (struct sockaddr*)&addr, sizeof(addr)) != 0)    {       close (sd); M       httpsSetError (__LINE__, "%s %s", request->hostname, strerror(errno));         return (errno);     }      request->socket = sd;  #    if (!request->https) return (0);       if (!httpsCtx)     {8       /* once established this context is never freed */       httpsCtx = InitCTX();        if (!httpsCtx)       { &          httpsSetSSLError (__LINE__);           return (errno);       }     }  %    request->ssl = SSL_new (httpsCtx); .    SSL_set_fd (request->ssl, request->socket);  &    if (SSL_connect (request->ssl) < 0)    {#       httpsSetSSLError (__LINE__);         SSL_free (request->ssl);       request->ssl = NULL;    }      if (!httpsVerifyConnect ())    {       SSL_free (request->ssl);       request->ssl = NULL;       return (EPERM);     }   #if 0     httpsShowConnect(); #endif      return (0); }   O /*****************************************************************************/  /*J Compare the known Let's Encrypt common name and issuer values (or relevantM parts thereof) to the server's certificate detail.  Return true if they match  and false if not.  */  $ static int httpsVerifyConnect (void)   {     int  oki = 0,         oks = 0;    char  *cptr;     X509  *cert;   !    if (!request->ssl) return (0); E    if (!(cert = SSL_get_peer_certificate (request->ssl))) return (0);   @    cptr = X509_NAME_oneline (X509_get_subject_name(cert), 0, 0);0    /* e.g. "/CN=acme-v01.api.letsencrypt.org" */)    if (!strncmp (cptr, "/CN=acme-", 9) && 8        strstr (cptr+9, ".api.letsencrypt.org")) oks = 1;L    if (!oks) httpsSetError (__LINE__, "verify subject \"%s\" failed", cptr);    free (cptr);   ?    cptr = X509_NAME_oneline (X509_get_issuer_name(cert), 0, 0); C    /* e.g. "/C=US/O=Let's Encrypt/CN=Let's Encrypt Authority X3" */ A    if (!strncmp (cptr, "/C=US/O=Let's Encrypt/CN=", 25)) oki = 1; L    if (!oki) httpsSetError (__LINE__, "verify issuer \"%s\" failed", cptr);     free (cptr);       X509_free(cert);     return (oki && oks);  }   O /*****************************************************************************/  /*O Once the request data is set up and the server connected make the request, then ! receive and process the response.  */  " static int httpsMakeRequest (void)   {  #define RINC 4096   ,    int  cclose, count, length, retval, size;    char  clength [32],          header [4096];     char  *bptr, *cptr, *czptr;      /****************/     /* make request */     /****************/   !    /* didn't work (by default) */     request->rcode = -1;   0    if (httpsConnect ()) return (request->rcode);      if (request->post)     {       if (request->content)        { 9          httpsSetHeader ("Content-Type", request->ctype); 4          sprintf (clength, "%d", request->clength); 4          httpsSetHeader ("Content-Length", clength);       } 
       else0          httpsSetHeader ("Content-Length", "0");    }      count = sprintf (header,  "%s %s HTTP/1.0\r\n\
 Host: %s\r\n\  User-Agent: %s\r\n\  Connection: close\r\n\ %s\  \r\n",3                     request->post ? "POST" : "GET", !                     request->uri, &                     request->hostname,                     SoftwareId, <                     request->header ? request->header : "");4    if (count >= sizeof(header)) exit (SS$_BUGCHECK);  G    if (dbug) fprintf (stdout, "request %d bytes\n%s\n", count, header);     if (request->https).       SSL_write (request->ssl, header, count);    else -       write (request->socket, header, count);       if (request->post)     {:       if (dbug) fprintf (stdout, "content %d bytes\n%s\n",=                          request->clength, request->content);        if (request->https) F          SSL_write (request->ssl, request->content, request->clength);
       elseE          write (request->socket, request->content, request->clength);     }      /****************/     /* get response */     /****************/       length = size = 0;     bptr = NULL;       for (;;)     {       if (length >= size)        {           size += RINC;%          bptr = realloc (bptr, size); <          /* seems we must zero any additional allocation! */)          memset (bptr + length, 0, RINC);        }        if (request->https) G          count = SSL_read (request->ssl, bptr + length, size - length); 
       elseF          count = read (request->socket, bptr + length, size - length);       if (count <= 0) break;       length += count;E       if (dbug) fprintf (stdout, "part %d bytes\n%s\n", count, bptr);     }G    if (dbug) fprintf (stdout, "response %d bytes\n%s\n", length, bptr);     request->response = bptr;    request->rlength = length;       /******************/     /* parse response */     /******************/   -    /* these may be reused for the response */ +    request->clength = request->hlength = 0; -    if (request->ctype) free (request->ctype);     request->ctype = NULL;     cclose = 0;  "    czptr = (cptr = bptr) + length;8    if (memcmp (cptr, "HTTP/1.", 7) || !isdigit(cptr[7]))    {       request->rcode = 0;        return (request->rcode);    }9    for (cptr += 8; cptr < czptr && *cptr == ' '; cptr++);     request->rcode = atoi(cptr); 0    while (cptr < czptr && *cptr != '\n') cptr++;    if (*cptr == '\n') cptr++;       while (cptr < czptr)     {       bptr = cptr;D       while (cptr < czptr && *cptr != '\r' && *cptr != '\n') cptr++;       if (cptr >= czptr) break; 1       if (!strncasecmp (bptr, "Connection:", 11))        { ?          for (bptr += 11; bptr < cptr && *bptr == ' '; bptr++); :          if (!strncasecmp (bptr, "close", 5)) cclose = 1;;       } 
       else3       if (!strncasecmp (bptr, "Content-Type:", 13))        { ?          for (bptr += 13; bptr < cptr && *bptr == ' '; bptr++); 6          request->ctype = calloc (1, cptr - bptr + 1);4          memcpy (request->ctype, bptr, cptr - bptr);       } 
       else5       if (!strncasecmp (bptr, "Content-Length:", 15))        { ?          for (bptr += 15; bptr < cptr && *bptr == ' '; bptr++); '          request->clength = atoi(bptr);        }         if (*cptr == '\r') cptr++;        if (*cptr == '\n') cptr++;G       if (*cptr == '\n' || (cptr[0] == '\r' && cptr[1] == '\n')) break;     }/    request->hlength = cptr - request->response; 9    if (dbug) fprintf (stdout, "hlength: %d bytes (%d)\n", 6                       request->hlength, czptr - cptr);  G    if (dbug) fprintf (stdout, "clength: %d bytes\n", request->clength);     if (request->clength)    {        if (*cptr == '\r') cptr++;        if (*cptr == '\n') cptr++;       request->content = cptr;    }    else 3    if (!request->clength && cclose && cptr < czptr)     {I       /* no Content-Length: header ... ODD! if closed calculate length */ 0       if (cptr < czptr && *cptr == '\r') cptr++;0       if (cptr < czptr && *cptr == '\n') cptr++;       request->content = cptr;&       request->clength = czptr - cptr;    }    else $       request->content = strdup("");G    if (dbug) fprintf (stdout, "clength: %d bytes\n", request->clength);       return (request->rcode);  }   O /*****************************************************************************/  /*4 Set the error string.  Only the first is maintained. */  6 static int httpsSetError (int lnum, char* format, ...)   {     int  count;      char  *fptr;     va_list ap;  #    if (request->error) return (-1); 5    count = asprintf (&fptr, "%s (%d)", format, lnum); "    if (count <= 0) return (count);    va_start (ap, format); 1    count = vasprintf (&request->error, fptr, ap);     va_end (ap);     free (fptr);     return (count); }   O /*****************************************************************************/  /* */  & static int httpsSetSSLError (int lnum)   {     int  count;      ulong  error;    char  *sptr = NULL;    char  errbuf [256];  #    if (request->error) return (-1); "    while (error = ERR_get_error())    {9       ERR_error_string_n (error, errbuf, sizeof(errbuf));        if (sptr) E          count = asprintf (&request->error, "%s (%d)", errbuf, lnum); 
       elseC          count = asprintf (&request->error, "%s+%s", sptr, errbuf);        sptr = request->error;       if (count <= 0) break;    }    return (count); }   O /*****************************************************************************/  /* */  # static void httpsShowConnect (void)    {      X509 *cert;      char *cptr;        if (!request->ssl) return;?     printf ("Encryption: %s\n", SSL_get_cipher (request->ssl)); 3     cert = SSL_get_peer_certificate (request->ssl);      if ( cert != NULL )      { )         printf("Server certificates:\n"); E         cptr = X509_NAME_oneline (X509_get_subject_name(cert), 0, 0); &         printf("Subject: %s\n", cptr);         free (cptr);D         cptr = X509_NAME_oneline (X509_get_issuer_name(cert), 0, 0);&         printf ("Issuer: %s\n", cptr);         free (cptr);         X509_free(cert);     }      else8         printf ("No server certificates configured.\n"); }   O /*****************************************************************************/  /*" A self-contained HTTP GET request. */   int httpsGetRequest  ( 
 char *url,	 char *hdr  )  {      int  rcode;      httpsResetRequest();     httpsSetRequest (url);(     if (hdr) httpsSetHeader (hdr, NULL);      rcode = httpsMakeRequest ();     return (rcode);  }   O /*****************************************************************************/  /*# A self-contained HTTP POST request.  */   int httpsPostRequest ( 
 char *url, char *ctype, char *content, int clength,	 char *hdr  )  {      int  rcode;      httpsResetRequest();     httpsSetPost (1);      httpsSetRequest (url);.     httpsSetContent (ctype, content, clength);(     if (hdr) httpsSetHeader (hdr, NULL);      rcode = httpsMakeRequest ();     return (rcode);  }   O /*****************************************************************************/  /*K If the URL begins with "^<filename> " then it's a POST test, otherwise GET.  */   void httpsTest (char *param)   {      int  post = 0;     unsigned int  clength;     char  *fname;      void  *content;        printf ("%s\n", param);        httpsResetRequest();       if (*param == '^')     {         httpsSetPost (post = 1);         fname = ++param; /        while (*param && *param != ' ') param++; #        if (*param) *param++ = '\0'; %        while (*param == ' ') param++; -        content = read_file (fname, &clength); "        if (!content) exit (errno);     }        httpsSetRequest (param);M     if (post) httpsSetContent ("application/octet-stream", content, clength);      httpsMakeRequest ();     httpsShowConnect ();:     printf ("\n-----\n%d \"%s\" %d bytes %s\n%s\n-----\n",             request->rcode,              request->ctype,              request->rlength,              request->error,              request->response);      httpsResetRequest ();   
     exit (1);  }   O /*****************************************************************************/ 