 /*E  * Copyright (C) 2019,2020 Nicola Di Lieto <nicola.dilieto@gmail.com>   *  * This file is part of uacme.  *C  * uacme is free software: you can redistribute it and/or modify it D  * under the terms of the GNU General Public License as published byD  * the Free Software Foundation, either version 3 of the License, or&  * (at your option) any later version.  *?  * uacme is distributed in the hope that it will be useful, but =  * WITHOUT ANY WARRANTY; without even the implied warranty of D  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU+  * General Public License for more details.   *D  * You should have received a copy of the GNU General Public License(  * along with this program.  If not, see"  * <http://www.gnu.org/licenses/>.  */   
 #ifndef __VMS  #include "config.h"  #endif   #include <ctype.h> #ifdef __VMS #include "wucme.h" #else  #include <err.h> #endif #include <errno.h> #include <fcntl.h> #ifdef IS_WUCME  #include "getopt.h"  #else  #include <getopt.h>  #endif #include <libgen.h>  #include <locale.h>  #ifndef IS_WUCME #include "regex.h" #endif #include <stdarg.h>  #include <stdbool.h> #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <sys/stat.h>  #include <sys/wait.h>  #include <unistd.h>    #include "base64.h"  #include "curlwrap.h"  #include "crypto.h"  #include "json.h"  #include "msg.h"   #ifdef IS_WUCME  int staging = 0; extern int  dbug;  extern int  wucmeActive; extern char  *argv0; extern char  SoftwareId[]; extern char  UacmeVersion[]; #define SS$_NOSYSPRV 10468 #endif /* IS_WUCME */   G #define PRODUCTION_URL "https://acme-v02.api.letsencrypt.org/directory" L #define STAGING_URL "https://acme-staging-v02.api.letsencrypt.org/directory"/ #define DEFAULT_CONFDIR SYSCONFDIR "/ssl/uacme"    typedef struct acme {      privkey_t key;     privkey_t ckey;      json_value_t *json;      json_value_t *account;     json_value_t *dir;     json_value_t *order;     char *nonce;     char *kid;     char *headers;     char *body;      char *type;      const char *directory;     const char *hook;      const char *email;     const char *ident;     const char * const *names;     const char *confdir;     char *keydir;      char *ckeydir;     char *certdir;	 } acme_t;   8 char *find_header(const char *headers, const char *name) {  #ifdef IS_WUCME -     return (wucmeFindHeader (headers, name));  #else      char *regex = NULL; ;     if (asprintf(&regex, "^%s:[ \t]*(.*)\r\n", name) < 0) { .         warnx("find_header: asprintf failed");         return NULL;     }      char *ret = NULL;      regex_t reg;G     if (regcomp(&reg, regex, REG_EXTENDED | REG_ICASE | REG_NEWLINE)) { -         warnx("find_header: regcomp failed");      } else {         regmatch_t m[2];3         if (regexec(&reg, headers, 2, m, 0) == 0) { I             ret = strndup(headers + m[1].rm_so, m[1].rm_eo - m[1].rm_so);              if (!ret) 4                 warn("find_header: strndup failed");	         }      }      free(regex);     regfree(&reg);     return ret;  #endif /* IS_WUCME */  }   ( int acme_get(acme_t *a, const char *url) {      int ret = 0;       json_free(a->json);      a->json = NULL;      free(a->headers);      a->headers = NULL;     free(a->body);     a->body = NULL;      free(a->type);     a->type = NULL;        if (!url) { '         warnx("acme_get: invalid URL");          goto out;      }      if (g_loglevel > 1) '         warnx("acme_get: url=%s", url); "     curldata_t *c = curl_get(url);
     if (!c) { +         warnx("acme_get: curl_get failed");          goto out;      }      free(a->nonce); 7     a->nonce = find_header(c->headers, "Replay-Nonce"); 6     a->type = find_header(c->headers, "Content-Type");+     if (a->type && strstr(a->type, "json")) 3         a->json = json_parse(c->body, c->body_len);      a->headers = c->headers;     c->headers = NULL;     a->body = c->body;     c->body = NULL;      ret = c->code;     curldata_free(c);  out:     if (g_loglevel > 2) {          if (a->headers) <             warnx("acme_get: HTTP headers\n%s", a->headers);         if (a->body)6             warnx("acme_get: HTTP body\n%s", a->body);     }      if (g_loglevel > 1) {          if (a->json) {:             warnx("acme_get: return code %d, json=", ret);'             json_dump(stderr, a->json);          } else3             warnx("acme_get: return code %d", ret);      }      if (!a->headers)          a->headers = strdup("");     if (!a->body)          a->body = strdup("");      if (!a->type)          a->type = strdup("");      return ret;  }   B int acme_post(acme_t *a, const char *url, const char *format, ...) {      int ret = 0;     char *payload = NULL;      char *protected = NULL;      char *jws = NULL;        if (!url) { (         warnx("acme_post: invalid URL");         return 0;      }        if (!a->nonce) {/         warnx("acme_post: need a nonce first");          return 0;      }        va_list ap;      va_start(ap, format); ,     if (vasprintf(&payload, format, ap) < 0)         payload = NULL;      va_end(ap);      if (!payload) { -         warnx("acme_post: vasprintf failed");          return 0;      }   9     for (int retry = 0; a->nonce && retry < 3; retry++) {          if (retry > 0)A             msg(1, "acme_post: server rejected nonce, retrying");            json_free(a->json);          a->json = NULL;          free(a->headers);          a->headers = NULL;         free(a->body);         a->body = NULL;          free(a->type);         a->type = NULL;   )         protected = (a->kid && *a->kid) ? >             jws_protected_kid(a->nonce, url, a->kid, a->key) :5             jws_protected_jwk(a->nonce, url, a->key);          if (!protected) { 9             warnx("acme_post: jws_protected_xxx failed");              goto out; 	         } 5         jws = jws_encode(protected, payload, a->key);          if (!jws) { 2             warnx("acme_post: jws_encode failed");             goto out; 	         }          if (g_loglevel > 2) E             warnx("acme_post: url=%s payload=%s protected=%s jws=%s", 2                     url, payload, protected, jws);          else if (g_loglevel > 1)@             warnx("acme_post: url=%s payload=%s", url, payload);8         curldata_t *c = curl_post(url, jws, strlen(jws),=                 "Content-Type: application/jose+json", NULL);          if (!c) { 1             warnx("acme_post: curl_post failed");              goto out; 	         }          free(a->nonce); ;         a->nonce = find_header(c->headers, "Replay-Nonce"); :         a->type = find_header(c->headers, "Content-Type");/         if (a->type && strstr(a->type, "json")) 7             a->json = json_parse(c->body, c->body_len);           a->headers = c->headers;         c->headers = NULL;         a->body = c->body;         c->body = NULL;          ret = c->code;         curldata_free(c);          if (g_loglevel > 2) {              if (a->headers) B                 warnx("acme_post: HTTP headers:\n%s", a->headers);             if (a->body)<                 warnx("acme_post: HTTP body:\n%s", a->body);	         }          if (g_loglevel > 1) {              if (a->json) {?                 warnx("acme_post: return code %d, json=", ret); +                 json_dump(stderr, a->json);              } else8                 warnx("acme_post: return code %d", ret);	         } >         if (ret != 400 || !a->type || !a->nonce || !a->json ||B #ifdef IS_WUCME  /* https://github.com/ndilieto/uacme/issues/22 */L                 strncasecmp(a->type, "application/problem+json", 24) != 0 || #else G                 strcasecmp(a->type, "application/problem+json") != 0 ||  #endif4                 json_compare_string(a->json, "type",@                     "urn:ietf:params:acme:error:badNonce") != 0)             break;     }  out:     free(payload);     free(protected);     free(jws);     if (!a->headers)          a->headers = strdup("");     if (!a->body)          a->body = strdup("");      if (!a->type)          a->type = strdup("");      return ret;  }   D int hook_run(const char *prog, const char *method, const char *type,?         const char *ident, const char *token, const char *auth)  {      int ret = -1;  #ifdef IS_WUCME , #define SSFISH 2928  /* value of SS$_FISH */ if (prog[0] == '@')  {     int  idx;    char  cmd [1024];    char  *sptr, *zptr;    const char  *cptr; R    const char  *which [] = { prog, prog, method, type, ident, token, auth, NULL };(    zptr = (sptr = cmd) + sizeof(cmd)-32;*    for (idx = 0; cptr = which[idx]; idx++)    {!       if (idx > 0) *sptr++ = ' '; "       if (idx > 0) *sptr++ = '\"';       while (*cptr)        { :          if (*cptr == '\"' && sptr < zptr) *sptr++ = '\"';,          if (sptr < zptr) *sptr++ = *cptr++;       } "       if (idx > 0) *sptr++ = '\"';    }    *sptr = '\0';     if (sptr >= zptr) return (2);=    /* as returning 0 from system() results in a %X00000001 */ 2    /* return a 9 (WASSET)to return a 0 to uacme */    ret = system (cmd);    if (ret == SSFISH) ret = 0;    return (ret); }      pid_t pid = vfork(); #else /* IS_WUCME */     pid_t pid = fork();  #endif /* IS_WUCME */      if (pid < 0)&         warn("hook_run: fork failed");!     else if (pid > 0) { // parent          int status; )         if (waitpid(pid, &status, 0) < 0) -             warn("hook_run: waitpid failed"); #         else if (WIFEXITED(status)) &             ret = WEXITSTATUS(status);         else>             warnx("hook_run: %s terminated abnormally", prog);     } else { // child ?         if (execl(prog, prog, method, type, ident, token, auth, (                     (char *)NULL) < 0) {9             warn("hook_run: failed to execute %s", prog);              abort();	         }      }  #ifdef IS_WUCME     if (ret == SSFISH) ret = 0; #endif /* IS_WUCME */      return ret;  }   D bool check_or_mkdir(bool allow_create, const char *dir, mode_t mode) {  #ifndef IS_WUCME      if (access(dir, F_OK) < 0) {         if (!allow_create) {.             warnx("failed to access %s", dir);             return false; 	         } #         if (mkdir(dir, mode) < 0) { -             warn("failed to create %s", dir);              return false; 	         } ,         msg(1, "created directory %s", dir);     }      struct stat st;      if (stat(dir, &st) != 0) {'         warn("failed to stat %s", dir);          return false;      }      if (!S_ISDIR(st.st_mode)) { ,         warnx("%s is not a directory", dir);         return false;      }  #endif /* IS_WUCME */ <     /* wucme always deploys to the standard WASD location */     return true; }   , char *identifiers(const char * const *names) {      char *ids = NULL;      char *tmp = NULL; 3     if (asprintf(&tmp, "{\"identifiers\":[") < 0) { .         warnx("identifiers: asprintf failed");         return NULL;     }      while (names && *names) { H         if (asprintf(&ids, "%s{\"type\":\"%s\",\"value\":\"%s\"},", tmp,L                     is_ip(*names, NULL, NULL) ? "ip" : "dns", *names) < 0) {2             warnx("identifiers: asprintf failed");             free(tmp);             return NULL;	         }          free(tmp);         tmp = ids;         ids = NULL;          names++;     }      tmp[strlen(tmp)-1] = 0; *     if (asprintf(&ids, "%s]}", tmp) < 0) {.         warnx("identifiers: asprintf failed");         ids = NULL;      }      free(tmp);     return ids;  }    bool acme_error(acme_t *a) {      if (!a->json) return false;   B #ifdef IS_WUCME  /* https://github.com/ndilieto/uacme/issues/22 */O     if (a->type && strncasecmp(a->type, "application/problem+json", 24) == 0) {  #else J     if (a->type && strcasecmp(a->type, "application/problem+json") == 0) { #endif:         warnx("the server reported the following error:");#         json_dump(stderr, a->json);          return true;     }   8     const json_value_t *e = json_find(a->json, "error");&     if (e && e->type == JSON_OBJECT) {:         warnx("the server reported the following error:");         json_dump(stderr, e);          return true;     }        return false;  }    bool acme_bootstrap(acme_t *a) { 5     msg(1, "fetching directory at %s", a->directory); +     if (acme_get(a, a->directory) != 200) { ?         warnx("failed to fetch directory at %s", a->directory);          acme_error(a);         return false;      } else if (acme_error(a))          return false;        a->dir = a->json;      a->json = NULL;   ;     const char *url = json_find_string(a->dir, "newNonce"); 
     if (!url)      { :         warnx("failed to find newNonce URL in directory");         return false;      }   ,     msg(2, "fetching new nonce at %s", url);"     if (acme_get(a, url) != 204) {6         warnx("failed to fetch new nonce at %s", url);         acme_error(a);         return false;      } else if (acme_error(a))          return false;        return true; }   % bool account_new(acme_t *a, bool yes)  { =     const char *url = json_find_string(a->dir, "newAccount");      if (!url) { <         warnx("failed to find newAccount URL in directory");         return false;      }   .     msg(1, "creating new account at %s", url);A     switch (acme_post(a, url, "{\"onlyReturnExisting\":true}")) {          case 200: @             if (!(a->kid = find_header(a->headers, "Location")))
             { ?                 warnx("account exists but location not found");                  return false; 
             } :             warnx("Account already exists at %s", a->kid);             return false;            case 400: %             if (a->json && a->type && B #ifdef IS_WUCME  /* https://github.com/ndilieto/uacme/issues/22 */P                     strncasecmp(a->type, "application/problem+json", 24) == 0 && #else K                     strcasecmp(a->type, "application/problem+json") == 0 &&  #endif8                     json_compare_string(a->json, "type",O                       "urn:ietf:params:acme:error:accountDoesNotExist") == 0) { E                 const json_value_t *meta = json_find(a->dir, "meta"); M                 const char *terms = json_find_string(meta, "termsOfService");                  if (terms) {                     if (yes)G                         msg(0, "terms at %s autoaccepted (-y)", terms);                      else {#                         char c = 0; L                         msg(0, "type 'y' to accept the terms at %s", terms);I                         if (scanf(" %c", &c) != 1 || tolower(c) != 'y') { B                             warnx("terms not agreed to, aborted");)                             return false;                          }                      }                  }                  int r = 0;1                 if (a->email && strlen(a->email)) J                     r = acme_post(a, url, "{\"termsOfServiceAgreed\":true"L                                 ",\"contact\": [\"mailto:%s\"]}", a->email);                 elseM                     r = acme_post(a, url, "{\"termsOfServiceAgreed\":true}");                  if (r == 201) { &                     if (acme_error(a))%                         return false; J                     if (json_compare_string(a->json, "status", "valid")) {M                         const char *st = json_find_string(a->json, "status"); M                         warnx("account created but status is not valid (%s)", 5                                 st ? st : "unknown"); %                         return false;                      } J                     if (!(a->kid = find_header(a->headers, "Location"))) {H                         warnx("account created but location not found");%                         return false;                      } <                     msg(1, "account created at %s", a->kid);                      return true;                 } 
             } &             // intentional fallthrough         default:9             warnx("failed to create account at %s", url);              acme_error(a);             return false;      }  }     bool account_retrieve(acme_t *a) { =     const char *url = json_find_string(a->dir, "newAccount");      if (!url) { <         warnx("failed to find newAccount URL in directory");         return false;      } ,     msg(1, "retrieving account at %s", url);A     switch (acme_post(a, url, "{\"onlyReturnExisting\":true}")) {          case 200:              if (acme_error(a))                 return false;              break;           case 400: %             if (a->json && a->type && B #ifdef IS_WUCME  /* https://github.com/ndilieto/uacme/issues/22 */P                     strncasecmp(a->type, "application/problem+json", 24) == 0 && #else K                     strcasecmp(a->type, "application/problem+json") == 0 &&  #endif8                     json_compare_string(a->json, "type",O                       "urn:ietf:params:acme:error:accountDoesNotExist") == 0) {  #ifdef IS_WUCME 3                 warnx("no account associated with " <                       "%s/wucme_k_account.pem found at %s. "A                         "Consider trying 'new'", a->keydir, url);  #else K                 warnx("no account associated with %s/key.pem found at %s. " A                         "Consider trying 'new'", a->keydir, url);  #endif                 return false; 
             } &             // intentional fallthrough         default:;             warnx("failed to retrieve account at %s", url);              acme_error(a);             return false;      } =     const char *status = json_find_string(a->json, "status"); ,     if (status && strcmp(status, "valid")) {5         warnx("invalid account status (%s)", status);          return false;      } :     if (!(a->kid = find_header(a->headers, "Location"))) {,         warnx("account location not found");         return false;      } +     msg(1, "account location: %s", a->kid);      a->account = a->json;      a->json = NULL;      return true; }    bool account_update(acme_t *a) {      bool email_update = false;D     const json_value_t *contacts = json_find(a->account, "contact");3     if (contacts && contacts->type != JSON_ARRAY) { 2         warnx("failed to parse account contacts");         return false;      } +     if (a->email && strlen(a->email) > 0) { 5         if (!contacts || contacts->v.array.size == 0)               email_update = true;>         else for (size_t i=0; i<contacts->v.array.size; i++) {B             if (contacts->v.array.values[i].type != JSON_STRING ||C                     strcasestr(contacts->v.array.values[i].v.value, L                         "mailto:") != contacts->v.array.values[i].v.value) {:                 warnx("failed to parse account contacts");                 return false; 
             } >             if (strcasecmp(contacts->v.array.values[i].v.value7                         + strlen("mailto:"), a->email)) $                 email_update = true;	         }      } 4     else if (contacts && contacts->v.array.size > 0)         email_update = true;     if (email_update) {          int ret = 0;/         if (a->email && strlen(a->email) > 0) { K             msg(1, "updating account email to %s at %s", a->email, a->kid); H             ret = acme_post(a, a->kid, "{\"contact\": [\"mailto:%s\"]}",                     a->email);         } else {;             msg(1, "removing account email at %s", a->kid); <             ret = acme_post(a, a->kid, "{\"contact\": []}");	         }          if (ret != 200) { B             warnx("failed to update account email at %s", a->kid);             acme_error(a);             return false; !         } else if (acme_error(a))              return false; 0         msg(1, "account at %s updated", a->kid);     }      elseH         msg(1, "email is already up to date for account at %s", a->kid);     return true; }   G bool account_keychange(acme_t *a, bool never, keytype_t type, int bits)  {      bool success = false;      privkey_t newkey = NULL;     char *newkeyfile = NULL;     char *keyfile = NULL;      char *bakfile = NULL;      char *protected = NULL;      char *payload = NULL;      char *jwk = NULL;      char *jws = NULL; <     const char *url = json_find_string(a->dir, "keyChange");     if (!url) { N         warnx("account_keychange: failed to find keyChange URL in directory");         goto out;      }    #ifdef IS_WUCME 6     if (asprintf(&keyfile, "%s/%swucme_k_account.pem",9                  a->keydir, staging ? "stg_" : "") < 0) {  #else :     if (asprintf(&keyfile, "%s/key.pem", a->keydir) < 0) { #endif4         warnx("account_keychange: asprintf failed");         keyfile = NULL;          goto out;      }    #ifdef IS_WUCME 3     if (asprintf(&bakfile, "%s/%swucme_key.pem_%s", H                  a->keydir, staging ? "stg_" : "", tstamp2(NULL)) < 0) { #else 8     if (asprintf(&bakfile, "%s/key-%llu.pem", a->keydir,6                 (unsigned long long)time(NULL)) < 0) { #endif4         warnx("account_keychange: asprintf failed");         bakfile = NULL;          goto out;      }    #ifdef IS_WUCME 8     if (asprintf(&newkeyfile, "%s/%swucme_k_newkey.pem",9                  a->keydir, staging ? "stg_" : "") < 0) {  #else @     if (asprintf(&newkeyfile, "%s/newkey.pem", a->keydir) < 0) { #endif4         warnx("account_keychange: asprintf failed");         newkeyfile = NULL;         goto out;      }   @     newkey = key_load(never ? PK_NONE : type, bits, newkeyfile);     if (!newkey)         goto out;   5     protected = jws_protected_jwk(NULL, url, newkey);      if (!protected) { =         warnx("account_keychange: jws_protected_jwk failed");          goto out;      }   &     jwk = jws_jwk(a->key, NULL, NULL);     if (!jwk) { 3         warnx("account_keychange: jws_jwk failed");          goto out;      }   @     if (asprintf(&payload, "{\"account\":\"%s\",\"oldKey\":%s}",#                 a->kid, jwk) < 0) { 4         warnx("account_keychange: asprintf failed");         payload = NULL;          goto out;      }   1     jws = jws_encode(protected, payload, newkey);      if (!jws) { 6         warnx("account_keychange: jws_encode failed");         goto out;      }        if (g_loglevel > 2) I         warnx("account_keychange: url=%s payload=%s protected=%s jws=%s", .                 url, payload, protected, jws);     else if (g_loglevel > 1)D         warnx("account_keychange: url=%s payload=%s", url, payload);  .     msg(1, "changing account key at %s", url);(     if (acme_post(a, url, jws) != 200) {9         warnx("failed to change account key at %s", url);          acme_error(a);         goto out;      } else if (acme_error(a))          goto out;   4     msg(1, "backing up %s as %s", keyfile, bakfile);#     if (link(keyfile, bakfile) < 0) :         warn("failed to link %s to %s", bakfile, keyfile);
     else {9         msg(1, "renaming %s to %s", newkeyfile, keyfile); .         if (rename(newkeyfile, keyfile) < 0) {C             warn("failed to rename %s to %s", newkeyfile, keyfile);              unlink(bakfile);         } else {*             msg(1, "account key changed");             success = true; 	         }      }      if (!success) { G         warnx("WARNING: account key changed but %s NOT replaced by %s", %                 keyfile, newkeyfile);          goto out;      }  out:     if (newkey)          privkey_deinit(newkey);      free(newkeyfile);      free(keyfile);     free(bakfile);     free(protected);     free(payload);     free(jwk);     free(jws);     return success;  }   " bool account_deactivate(acme_t *a) { 1     msg(1, "deactivating account at %s", a->kid); G     if (acme_post(a, a->kid, "{\"status\": \"deactivated\"}") != 200) { <         warnx("failed to deactivate account at %s", a->kid);         acme_error(a);         return false;      } else if (acme_error(a))          return false; 0     msg(1, "account at %s deactivated", a->kid);     return true; }    bool authorize(acme_t *a)  {  #ifdef IS_WUCME      int waiting = 5; #endif     bool success = false;      char *thumbprint = NULL;     json_value_t *auth = NULL;F     const json_value_t *auths = json_find(a->order, "authorizations");.     if (!auths || auths->type != JSON_ARRAY) {4         warnx("failed to parse authorizations URL");         goto out;      }   (     thumbprint = jws_thumbprint(a->key);     if (!thumbprint)         goto out;   2     for (size_t i=0; i<auths->v.array.size; i++) {;         if (auths->v.array.values[i].type != JSON_STRING) { 8             warnx("failed to parse authorizations URL");             goto out; 	         } 0         msg(1, "retrieving authorization at %s",2                 auths->v.array.values[i].v.value);H         if (acme_post(a, auths->v.array.values[i].v.value, "") != 200) {/             warnx("failed to retrieve auth %s", 6                     auths->v.array.values[i].v.value);             acme_error(a);             goto out; 	         } A         const char *status = json_find_string(a->json, "status"); 3         if (status && strcmp(status, "valid") == 0)              continue; 8         if (!status || strcmp(status, "pending") != 0) {6             warnx("unexpected auth status (%s) at %s",,                 status ? status : "unknown",2                 auths->v.array.values[i].v.value);             acme_error(a);             goto out; 	         } E         const json_value_t *ident = json_find(a->json, "identifier"); A         const char *ident_type = json_find_string(ident, "type"); =         if (!ident_type || (strcmp(ident_type, "dns") != 0 && 1                 strcmp(ident_type, "ip") != 0)) { 3             warnx("no valid identifier in auth %s", 6                     auths->v.array.values[i].v.value);             goto out; 	         } C         const char *ident_value = json_find_string(ident, "value");  #ifdef IS_WUCME 3         if (!ident_value || !strlen(ident_value)) {  #else 7         if (!ident_value || strlen(ident_value) <= 0) {  #endif3             warnx("no valid identifier in auth %s", 6                     auths->v.array.values[i].v.value);             goto out; 	         } E         const json_value_t *chlgs = json_find(a->json, "challenges"); 2         if (!chlgs || chlgs->type != JSON_ARRAY) {-             warnx("no challenges in auth %s", 6                     auths->v.array.values[i].v.value);             goto out; 	         }          json_free(auth);         auth = a->json;          a->json = NULL;            bool chlg_done = false; D         for (size_t j=0; j<chlgs->v.array.size && !chlg_done; j++) {2             const char *status = json_find_string(7                     chlgs->v.array.values+j, "status"); 9             if (status && (strcmp(status, "pending") == 0 @                         || strcmp(status, "processing") == 0)) {3                 const char *url = json_find_string( 8                         chlgs->v.array.values+j, "url");4                 const char *type = json_find_string(9                         chlgs->v.array.values+j, "type"); 5                 const char *token = json_find_string( :                         chlgs->v.array.values+j, "token");&                 char *key_auth = NULL;.                 if (!type || !url || !token) {7                     warnx("failed to parse challenge");                      goto out;                  } 2                 if (strcmp(type, "dns-01") == 0 ||9                         strcmp(type, "tls-alpn-01") == 0) O                     key_auth = sha2_base64url(256, "%s.%s", token, thumbprint); M                 else if (asprintf(&key_auth, "%s.%s", token, thumbprint) < 0) $                     key_auth = NULL;                  if (!key_auth) {B                     warnx("failed to generate authorization key");                     goto out;                  } 5                 if (a->hook && strlen(a->hook) > 0) { ,                     msg(2, "type=%s", type);4                     msg(2, "ident=%s", ident_value);.                     msg(2, "token=%s", token);4                     msg(2, "key_auth=%s", key_auth);I                     msg(1, "running %s %s %s %s %s %s", a->hook, "begin", @                             type, ident_value, token, key_auth);P                     int r = hook_run(a->hook, "begin", type, ident_value, token,&                             key_auth);2                     msg(2, "hook returned %d", r);                      if (r < 0) {'                         free(key_auth); !                         goto out; '                     } else if (r > 0) { >                         msg(1, "challenge %s declined", type);'                         free(key_auth); !                         continue;                      }                  } else {                     char c = 0;  #ifdef IS_WUCME H                     msg(1, "challenge=%s ident=%s token=%s key_auth=%s",<                         type, ident_value, token, key_auth);B                     char  *cptr = UtilSysTrnLnm (WUCME_CHALLENGE);                     if (cptr)                      { >                        /* preferred challenge is configured */>                        msg(1, "WUCME_CHALLENGE \"%s\"", cptr);/                        if (strcmp (cptr, type))                         {?                           /* discard non-preferred challenge */ )                           free(key_auth); #                           continue;                         }                     }                      else                     { 3                        /* no preferred challenge */ .                        if (wucmeMode(IS_WASD))                        {>                           if (wucmeServerSoftware() >= 120300)                           { =                              /* for WASD v12.3.0 and later */ >                              if (strcmp (type, "tls-alpn-01"))                              {E                                 /* discard non-preferred challenge */ /                                 free(key_auth); )                                 continue;                               }                           }                         }H                        /* for WASD v12.2.0 and earlier AND for Apache */4                        if (strcmp (type, "http-01"))                        {=                           /* discard unsupported challenge */ )                           free(key_auth); #                           continue;                         }                     }   2                     msg (0, "challenge=%s", type);  <                     wucmeChallenge ((char*)token, key_auth);  2                     if (!strcmp (type, "http-01"))                     { ?                        /* ensure there is a port 80 listener */ 3                        wucmeChallenge80 (a->ident);                      }  #else H                     msg(0, "challenge=%s ident=%s token=%s key_auth=%s",<                         type, ident_value, token, key_auth);O                     msg(0, "type 'y' followed by a newline to accept challenge" 7                             ", anything else to skip"); E                     if (scanf(" %c", &c) != 1 || tolower(c) != 'y') { '                         free(key_auth); !                         continue;                      }  #endif /* IS_WUCME */                  }   8                 msg(1, "starting challenge at %s", url);5                 if (acme_post(a, url, "{}") != 200) { B                     warnx("failed to start challenge at %s", url);"                     acme_error(a);+                 } else while (!chlg_done) { B                     msg(1, "polling challenge status at %s", url);7                     if (acme_post(a, url, "") != 200) { L                         warnx("failed to poll challenge status at %s", url);&                         acme_error(a);                         break;                     } M                     const char *status = json_find_string(a->json, "status"); ?                     if (status && strcmp(status, "valid") == 0) )                         chlg_done = true; M                     else if (!status || (strcmp(status, "processing") != 0 && >                             strcmp(status, "pending") != 0)) {C                         warnx("challenge %s failed with status %s", B                                 url, status ? status : "unknown");&                         acme_error(a);                         break;                     } else { #ifdef IS_WUCME T                         msg(2, "challenge %s, waiting %d seconds", status, waiting);'                         sleep(waiting);a%                         waiting += 5;i #elseoJ                         msg(2, "challenge %s, waiting 5 seconds", status);!                         sleep(5);N #endif                     }l                 }e5                 if (a->hook && strlen(a->hook) > 0) { G                     const char *method = chlg_done ? "done" : "failed";nH                     msg(1, "running %s %s %s %s %s %s", a->hook, method,@                             type, ident_value, token, key_auth);G                     hook_run(a->hook, method, type, ident_value, token,i&                             key_auth);                 }e                 free(key_auth);                  if (!chlg_done)t                     goto out;*
             }_	         }u         if (!chlg_done) {i,             warnx("no challenge completed");             goto out;<	         }d     }c       success = true;e   out:     json_free(auth);     free(thumbprint);e     return success;t }   + bool cert_issue(acme_t *a, bool status_req)e {  #ifdef IS_WUCMEE     int  waiting = 5;e #endif     bool success = false;e     char *csr = NULL;<     char *orderurl = NULL;     char *certfile = NULL;     char *bakfile = NULL;u     char *tmpfile = NULL;<     time_t t = time(NULL);     int fd = -1;&     char *ids = identifiers(a->names);     if (!ids) {i3         warnx("failed to process alternate names");          goto out;      }i  ;     const char *url = json_find_string(a->dir, "newOrder");[     if (!url) {U:         warnx("failed to find newOrder URL in directory");         goto out;R     }N  =     msg(1, "creating new order for %s at %s", a->ident, url);T&     if (acme_post(a, url, ids) != 201)     {r7         warnx("failed to create new order at %s", url);s         acme_error(a);         goto out;r     } =     const char *status = json_find_string(a->json, "status");vL     if (!status || (strcmp(status, "pending") && strcmp(status, "ready"))) {H         warnx("invalid order status (%s)", status ? status : "unknown");         acme_error(a);         goto out;      }o3     orderurl = find_header(a->headers, "Location");      if (!orderurl) {*         warnx("order location not found");         goto out;r     }i&     msg(1, "order URL: %s", orderurl);     a->order = a->json;r     a->json = NULL;   '     if (strcmp(status, "ready") != 0) {u         if (!authorize(a)) {?             warnx("failed to authorize order at %s", orderurl);%             goto out;)	         }          while (1) {d;             msg(1, "polling order status at %s", orderurl);r4             if (acme_post(a, orderurl, "") != 200) {E                 warnx("failed to poll order status at %s", orderurl);n                 acme_error(a);                 goto out;h
             } 9             status = json_find_string(a->json, "status"); 9             if (status && strcmp(status, "ready") == 0) {)$                 json_free(a->order);#                 a->order = a->json;e                 a->json = NULL;e                 break;
             }nA             else if (!status || strcmp(status, "pending") != 0) { ;                 warnx("unexpected order status (%s) at %s", ?                         status ? status : "unknown", orderurl);L                 acme_error(a);                 goto out;y             } else { #ifdef IS_WUCMEuE                 msg(2, "order pending, waiting %d seconds", waiting);                  sleep(waiting);                  waiting += 5;  #else ;                 msg(2, "order pending, waiting 5 seconds");a                 sleep(5);l #endif
             }t	         }      }e  -     msg(1, "generating certificate request");r1     csr = csr_gen(a->names, status_req, a->ckey);h     if (!csr) {T@         warnx("failed to generate certificate signing request");         goto out;>     }-  B     const char *finalize = json_find_string(a->order, "finalize");     if (!finalize) {-         warnx("failed to find finalize URL");u         goto out;u     }   /     msg(1, "finalizing order at %s", finalize); B     if (acme_post(a, finalize, "{\"csr\": \"%s\"}", csr) != 200) {:         warnx("failed to finalize order at %s", finalize);         acme_error(a);         goto out;      } else if (acme_error(a))          goto out;e   #ifdef IS_WUCMEj     waiting = 5; #endif       while (1) {-7         msg(1, "polling order status at %s", orderurl);t0         if (acme_post(a, orderurl, "") != 200) {A             warnx("failed to poll order status at %s", orderurl);b             acme_error(a);             goto out;t	         }p5         status = json_find_string(a->json, "status");,5         if (status && strcmp(status, "valid") == 0) {               json_free(a->order);             a->order = a->json;              a->json = NULL;              break;B         } else if (!status || strcmp(status, "processing") != 0) {7             warnx("unexpected order status (%s) at %s",e;                     status ? status : "unknown", orderurl);              acme_error(a);             goto out;d         } else { #ifdef IS_WUCME D             msg(2, "order processing, waiting %d seconds", waiting);             sleep(waiting);              waiting += 5;  #else :             msg(2, "order processing, waiting 5 seconds");             sleep(5);  #endif	         }s     }e  D     const char *certurl = json_find_string(a->order, "certificate");     if (!certurl) { 1         warnx("failed to parse certificate url");          goto out;y     }   4     msg(1, "retrieving certificate at %s", certurl);+     if (acme_post(a, certurl, "") != 200) { ?         warnx("failed to retrieve certificate at %s", certurl);i         acme_error(a);         goto out;(     } else if (acme_error(a)) {          goto out;      }    #ifdef IS_WUCMEt2     if (asprintf(&certfile, "%s/%swucme_c_%s.pem",D                  a->certdir, staging ? "stg_" : "", a->ident) < 0) { #else =     if (asprintf(&certfile, "%s/cert.pem", a->certdir) < 0) {" #endif         certfile = NULL;-         warnx("cert_issue: asprintf failed");          goto out;r     }y   #ifdef IS_WUCMEs5     if (asprintf(&tmpfile, "%s/%swucme_c_%s.pem_tmp",,N                            a->certdir, staging ? "stg_" : "", a->ident) < 0) { #else%@     if (asprintf(&tmpfile, "%s/cert.pem.tmp", a->certdir) < 0) { #endif         tmpfile = NULL;e-         warnx("cert_issue: asprintf failed");          goto out;      }a   #ifdef IS_WUCMEl4     if (asprintf(&bakfile, "%s/%swucme_c_%s.pem_%s",=                  a->certdir, staging ? "stg_" : "", a->ident,d%                 tstamp2(NULL)) < 0) {  #elseh:     if (asprintf(&bakfile, "%s/cert-%llu.pem", a->certdir,-                 (unsigned long long)t) < 0) {  #endif         bakfile = NULL; -         warnx("cert_issue: asprintf failed");h         goto out;      }b   #ifdef IS_WUCME      wucme2Ods2 (certfile);     wucme2Ods2 (bakfile);u     wucme2Ods2 (tmpfile);f0     msg(1, "saving certificate to %s", tmpfile);7     fd = open(tmpfile, O_WRONLY|O_CREAT|O_TRUNC, 0777);- #elses0     msg(1, "saving certificate to %s", tmpfile);J     fd = open(tmpfile, O_WRONLY|O_CREAT|O_TRUNC, S_IRUSR|S_IRGRP|S_IROTH); #endif /* IS_WUCME */f     if (fd < 0) { -         warn("failed to create %s", tmpfile);n         goto out;      }   J     if (write(fd, a->body, strlen(a->body)) != (ssize_t)strlen(a->body)) {/         warn("failed to write to %s", tmpfile);          goto out;a     }|   #ifdef IS_WUCMEj {       /* append the private key */     uint  pklen;     char  *fname, *pkey;+     char* read_file (const char*, size_t*);r  /     if (asprintf(&fname, "%s/%swucme_k_%s.pem",tD                  a->confdir, staging ? "stg_" : "", a->ident) < 0) {!         warnx("asprintf failed");o         goto out;      }      wucme2Ods2 (fname);:+     warnx("reading private key %s", fname); .     if (!(pkey = read_file (fname, &pklen))) {/         warn("append private key read failed");          free (fname);"         goto out;y     }      write(fd, "\n", 1); *     if (write(fd, pkey, pklen) != pklen) {<         warn("failed to append private key to %s", tmpfile);         free (fname);c         free (pkey);         goto out;n     }t     free (fname);      free (pkey); }  #endif /* IS_WUCME */I       if (close(fd) < 0) {,         warn("failed to close %s", tmpfile);         goto out;;
     } else         fd = -1;   #ifdef IS_WUCME (     if (rename(certfile, bakfile) < 0) {         if (errno != ENOENT) {J             warn("failed to rename (backup) %s to %s", certfile, bakfile);             goto out;h	         }d
     } else #elsef&     if (link(certfile, bakfile) < 0) {         if (errno != ENOENT) {?             warn("failed to link %s to %s", bakfile, certfile);)             goto out; 	         } 
     } else #endif /* IS_WUCME */ 8         msg(1, "backed up %s as %s", certfile, bakfile);  3     msg(1, "renaming %s to %s", tmpfile, certfile);g(     if (rename(tmpfile, certfile) < 0) {=         warn("failed to rename %s to %s", tmpfile, certfile);= #ifdef IS_WUCME (     if (rename(certfile, bakfile) < 0) {         if (errno != ENOENT)	         { J             warn("failed to rename (backup) %s to %s", certfile, bakfile);             goto out;o	         }k     }" #else          unlink(bakfile); #endif  /* IS_WUCME */         goto out;t     },       success = true;  out:     if (fd >= 0)         close(fd);     free(bakfile);     free(tmpfile);     free(certfile);S     free(csr);     free(ids);     free(orderurl);_     return success;n }a  B bool cert_revoke(acme_t *a, const char *certfile, int reason_code) {d     bool success = false;      char *certfiledup = NULL;U     char *revokedfile = NULL;o     const char *url = NULL;,-     char *crt = cert_der_base64url(certfile);      if (!crt) {M-         warnx("failed to load %s", certfile);S         goto out;u     }   1     url = json_find_string(a->dir, "revokeCert");c     if (!url) {m<         warnx("failed to find revokeCert URL in directory");         goto out;c     }{  /     msg(1, "revoking %s at %s", certfile, url); H     if (acme_post(a, url, "{\"certificate\":\"%s\",\"reason\":%d}", crt,"             reason_code) != 200) {:         warnx("failed to revoke %s at %s", certfile, url);         acme_error(a);         goto out;      } else if (acme_error(a))f         goto out;   #     msg(1, "revoked %s", certfile); #     certfiledup = strdup(certfile);      if (!certfiledup) {m         warnx("strdup failed");t         certfiledup = NULL;          goto out;      }d #ifdef IS_WUCME O     if (asprintf(&revokedfile, "%s_revoked_%s", certfile, tstamp2(NULL)) < 0) {  #elsehK     if (asprintf(&revokedfile, "%s/revoked-%llu.pem", dirname(certfiledup),h6                 (unsigned long long)time(NULL)) < 0) { #endif!         warnx("asprintf failed");          revokedfile = NULL;e         goto out;      }l7     msg(1, "renaming %s to %s", certfile, revokedfile);t*     if (rename(certfile, revokedfile) < 0)A         warn("failed to rename %s to %s", certfile, revokedfile);        success = true;( out:     free(crt);     free(revokedfile);     free(certfiledup);     return success;  }   + bool validate_identifier_str(const char *s)  {      size_t len = 0;e     if (is_ip(s, 0, 0))l         return true;,     for (size_t j = 0; j < strlen(s); j++) {         switch (s[j]) {r             case '.':                  if (j == 0) {tC                     warnx("'.' not allowed at beginning in %s", s);(!                     return false;I                 }/*                 // intentional fallthrough             case '_':c             case '-':n                 len++;                 continue;p             case '*':,,                 if (j != 0 || s[1] != '.') {E                     warnx("'*.' only allowed at beginning in %s", s);n!                     return false;e                 }                  break;             default:I                 if (!isupper(s[j]) && !islower(s[j]) && !isdigit(s[j])) {rC                     warnx("invalid character '%c' in %s", s[j], s); !                     return false;                  }                  len++;	         }      }s     if (len == 0) {o1         warnx("empty identifier is not allowed");d         return false;      }a     return true; }d    void usage(const char *progname) {      fprintf(stderr, M         "usage: %s [-a|--acme-url URL] [-b|--bits BITS] [-c|--confdir DIR]\n" R         "\t[-d|--days DAYS] [-f|--force] [-h|--hook PROGRAM] [-m|--must-staple]\n"T         "\t[-n|--never-create] [-o|--no-ocsp] [-s|--staging] [-t|--type RSA | EC]\n"F         "\t[-v|--verbose ...] [-V|--version] [-y|--yes] [-?|--help]\n"B         "\tnew [EMAIL] | update [EMAIL] | deactivate | newkey |\n"K         "\tissue IDENTIFIER [ALTNAME ...]] | revoke CERTFILE\n", progname);  }    #ifdef IS_WUCME    int wucmeVerbose (int);)    int main (int argc, char **argv) {n     argv0 = argv[0];       wucmeVerbose (0);y       wucmeGetSyi ();r  >     if (argc > 1 && strstr (argv[1], "/begin")) wucmeBegin ();  C     if (argc > 1 && strstr (argv[1], "--acme_tls_1")) acme_tls_1();   9     wucmeActive = (UtilSysTrnLnm (WUCME_ACTIVE) != NULL);        if (wucmeMode (IS_PROCTOR)),        wucmeBegin ();s     else     if (wucmeMode (IS_ROOT))        wucmeBegin ();d     else3     if (wucmeMode(IS_WASD) || wucmeMode(IS_APACHE))          ScriptBegin (argc, argv);     else     if (!wucmeMode (IS_CLI))        exit (SS$_BUGCHECK);   C     /* any use other than the script account must possess SYSPRV */ /     if (!UtilHaveSysPrv()) exit (SS$_NOSYSPRV);      UtilAdjustPriv();y  $     int ret = mainline (argc, argv);     if (ret != 2)m        ret = SS$_NORMAL;     else        ret = SS$_BADPARAM;     exit (ret);n }2  1 /* will be called from the certificate manager */>$ int mainline (int argc, char **argv) #elsee int main(int argc, char **argv)m #endif /* IS_WUCME */y {,$     static struct option options[] =     {:7         {"acme-url",     required_argument, NULL, 'a'},s7         {"bits",         required_argument, NULL, 'b'}, 7         {"confdir",      required_argument, NULL, 'c'},m7         {"days",         required_argument, NULL, 'd'}, 7         {"force",        no_argument,       NULL, 'f'},t7         {"help",         no_argument,       NULL, '?'},e7         {"hook",         required_argument, NULL, 'h'}, 7         {"must-staple",  no_argument,       NULL, 'm'},s7         {"never-create", no_argument,       NULL, 'n'},t7         {"no-ocsp",      no_argument,       NULL, 'o'},t7         {"staging",      no_argument,       NULL, 's'}, 7         {"type",         required_argument, NULL, 't'},  #ifdef IS_WUCME 7         {"uacme",        no_argument,       NULL, 'U'},  #endif7         {"verbose",      no_argument,       NULL, 'v'},p7         {"version",      no_argument,       NULL, 'V'}, 7         {"yes",          no_argument,       NULL, 'y'},e4         {NULL,           0,                 NULL, 0}     };       int ret = 2;     bool never = false;      bool force = false;=     bool version = false;      bool yes = false;  #ifndef IS_WUCME     bool staging = false;  #endif"     bool custom_directory = false;     bool status_req = false;     bool status_check = true;t     int days = 30;     int bits = 0;      keytype_t type = PK_RSA;      const char *filename = NULL;
     acme_t a;      memset(&a, 0, sizeof(a)); !     a.directory = PRODUCTION_URL;  #ifndef IS_WUCME      a.confdir = DEFAULT_CONFDIR; #endif   #ifdef IS_WUCME(5     /* belt and braces (due to reuse via mainline) */      char *cptr;      optind = 0;e     optreset = 1;o       if (argc < 2)      {          usage(basename(argv[0]));        return ret;     }        a.confdir = wucmeDir();%  &     if (UtilSysTrnLnm (WUCME_STAGING))     { <        /* during development the default will be STAGING! */        staging = true;!        a.directory = STAGING_URL;c     }c  *     if (cptr = UtilSysTrnLnm (WUCME_HOOK))     {         a.hook = strdup(cptr);      }o #else /* IS_WUCME */  " #if LIBCURL_VERSION_NUM < 0x0726002 #error libcurl version 7.38.0 or later is required #endifL     const curl_version_info_data *cvid = curl_version_info(CURLVERSION_NOW);0     if (!cvid || cvid->version_num < 0x072600) {=         warnx("libcurl version 7.38.0 or later is required");"         return ret;      }0  <     if (curl_global_init(CURL_GLOBAL_DEFAULT) != CURLE_OK) {.         warnx("failed to initialize libcurl");         return ret;      }y #endif /* IS_WUCME */        if (!crypto_init()) {t5         warnx("failed to initialize crypto library");- #ifndef IS_WUCME         curl_global_cleanup(); #endif         return ret;c     }a   #ifdef IS_WUCMEn<     if (strcmp (argv[1], "--uacme")) wucmeCli (argc, argv);  #endif       while (1) {,         char *endptr;          int option_index;:@         int c = getopt_long(argc, argv, "a:b:c:d:f?h:mnost:vVy",(                 options, &option_index);         if (c == -1) break;_         switch (c) {             case 'a':                  if (staging) {M                     warnx("-a,--acme-url is incompatible with -s,--staging");k                     goto out;                  }n(                 custom_directory = true;%                 a.directory = optarg;                  break;               case 'b':u3                 bits = strtol(optarg, &endptr, 10);t0                 if (*endptr != 0 || bits <= 0) {=                     warnx("BITS must be a positive integer");t                     goto out;"                 }(                 break;               case 'c':n#                 a.confdir = optarg;u                 break;               case 'd':-3                 days = strtol(optarg, &endptr, 10); 0                 if (*endptr != 0 || days <= 0) {=                     warnx("DAYS must be a positive integer");)                     goto out;                  }                  break;               case 'f':e                 force = true;t                 break;               case 'h':o                  a.hook = optarg;                 break;               case 'm': "                 status_req = true;                 break;               case 'n':                  never = true;m                 break;               case 'o':v%                 status_check = false;p                 break;               case 'v':t                 g_loglevel++;                  break;               case 's':S'                 if (custom_directory) {sM                     warnx("-s,--staging is incompatible with -a,--acme-url");                      goto out;a                 }                  staging = true;t*                 a.directory = STAGING_URL;                 break;               case 't':a3                 if (strcasecmp(optarg, "RSA") == 0) "                     type = PK_RSA;7                 else if (strcasecmp(optarg, "EC") == 0) !                     type = PK_EC;v                 else {;                     warnx("type must be either RSA or EC");                      goto out;&                 }>                 break;   #ifdef IS_WUCMEt             case 'U':>                 break; #endif              case 'V':                 version = true;,                 break;               case 'y':{                 yes = true;g                 break;               default:)                 usage(basename(argv[0]));"                 goto out;(	         }      }        if (version) { #ifdef IS_WUCME ,         msg(0, "version %s (%d) (%s) (%s)", =             SoftwareId, wucmeServerSoftware(), UacmeVersion, (/             OpenSSL_version (OPENSSL_VERSION));" #else +         msg(0, "version " PACKAGE_VERSION);  #endif         goto out;a     }o       switch (type) {"         case PK_RSA:             if (bits == 0)                 bits = 2048;2             else if (bits < 2048 || bits > 8192) {I                 warnx("BITS must be between 2048 and 8192 for RSA keys");h                 goto out;h
             }U              else if (bits & 7) {C                 warnx("BITS must be a multiple of 8 for RSA keys");                  goto out; 
             }i             break;           case PK_EC:              switch (bits) {n                 case 0:n                     bits = 256;o                     break;                   case 256:e                 case 384:t                     break;                   default:H                     warnx("BITS must be either 256 or 384 for EC keys");                     goto out;c
             }              break;           default:7             warnx("key type must be either RSA or EC");              goto out;"     }c       if (optind == argc) { !         usage(basename(argv[0]));"         goto out;      }e  (     const char *action = argv[optind++];F     if (strcmp(action, "new") == 0 || strcmp(action, "update") == 0) {         if (optind < argc)%             a.email = argv[optind++];          if (optind < argc) {%             usage(basename(argv[0]));              goto out;k	         }/,     } else if (strcmp(action, "newkey") == 03             || strcmp(action, "deactivate") == 0) {(         if (optind < argc)	         {a%             usage(basename(argv[0]));(             goto out;r	         }".     } else if (strcmp(action, "issue") == 0) {         if (optind == argc) {l%             usage(basename(argv[0]));y             goto out;)	         }o6         a.names = (const char * const *)argv + optind;?         for (const char * const *name = a.names; *name; name++)n0             if (!validate_identifier_str(*name))                 goto out;_           a.ident = a.names[0];(3         if (a.ident[0] == '*' && a.ident[1] == '.')a             a.ident += 2; /     } else if (strcmp(action, "revoke") == 0) {t         if (optind == argc) { %             usage(basename(argv[0]));              goto out;n	         }f"         filename = argv[optind++];         if (optind < argc) {%             usage(basename(argv[0]));a             goto out;j	         } %         if (access(filename, R_OK)) {e0             warn("failed to read %s", filename);             goto out; 	         }c #ifdef IS_WUCMEr-     } else if (strcmp(action, "ping") != 0) {  #else      } else { #endif!         usage(basename(argv[0]));          goto out;a     }k       time_t now = time(NULL);     char buf[0x100];     setlocale(LC_TIME, "C");L     strftime(buf, sizeof(buf), "%a, %d %b %Y %H:%M:%S %z", localtime(&now)); #ifdef IS_WUCMEe0     msg(1, "version %s (%d) (%s) (%s) starting",8         SoftwareId, wucmeServerSoftware(), UacmeVersion,+         OpenSSL_version (OPENSSL_VERSION));f #elsek>     msg(1, "version " PACKAGE_VERSION " starting on %s", buf); #endif   #ifdef IS_WUCMElR     if (a.hook && access(a.hook[0] == '@' ? a.hook+1 : a.hook, R_OK | X_OK) < 0) { #else 4     if (a.hook && access(a.hook, R_OK | X_OK) < 0) { #endif         warn("%s", a.hook);k         goto out;      }    #ifdef IS_WUCME;3     if (asprintf(&a.keydir, "%s", a.confdir) < 0) {h #else;;     if (asprintf(&a.keydir, "%s/private", a.confdir) < 0) {s #endif         a.keydir = NULL;!         warnx("asprintf failed");p         goto out;      }        if (a.ident) { #ifdef IS_WUCMEo9         if (asprintf(&a.ckeydir, "%s", wucmeDir()) < 0) {n #elseeL         if (asprintf(&a.ckeydir, "%s/private/%s", a.confdir, a.ident) < 0) { #endif             a.ckeydir = NULL;r%             warnx("asprintf failed");c             goto out;u	         }t   #ifdef IS_WUCME 9         if (asprintf(&a.certdir, "%s", wucmeDir()) < 0) {c #else(D         if (asprintf(&a.certdir, "%s/%s", a.confdir, a.ident) < 0) { #endif             a.certdir = NULL;-%             warnx("asprintf failed");              goto out;l	         }_     })  -     bool is_new = strcmp(action, "new") == 0;t4     if (!check_or_mkdir(is_new && !never, a.confdir,9                 S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH))t         goto out;   =     if (!check_or_mkdir(is_new && !never, a.keydir, S_IRWXU))v         goto out;;   #ifdef IS_WUCMEl?     if (!(a.key = key_load((!is_new || never) ? PK_NONE : type,t?                     bits, "%s/wucme_k_account.pem", a.keydir)))e #elsei?     if (!(a.key = key_load((!is_new || never) ? PK_NONE : type,s3                     bits, "%s/key.pem", a.keydir)))o #endif         goto out;   %     if (strcmp(action, "new") == 0) { 7         if (acme_bootstrap(&a) && account_new(&a, yes))              ret = 0;/     } else if (strcmp(action, "update") == 0) {oM         if (acme_bootstrap(&a) && account_retrieve(&a) && account_update(&a))              ret = 0;/     } else if (strcmp(action, "newkey") == 0) {s6         if (acme_bootstrap(&a) && account_retrieve(&a)<                 && account_keychange(&a, never, type, bits))             ret = 0;3     } else if (strcmp(action, "deactivate") == 0) {o6         if (acme_bootstrap(&a) && account_retrieve(&a)*                 && account_deactivate(&a))             ret = 0;.     } else if (strcmp(action, "issue") == 0) {8         if (!check_or_mkdir(!never, a.ckeydir, S_IRWXU))             goto out;e  .         if (!check_or_mkdir(!never, a.certdir,=                     S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH))]             goto out;    #ifdef IS_WUCME  {          char  *fname; 3         if (asprintf(&fname, "%s/%swucme_k_%s.pem",jD                      a.ckeydir, staging ? "stg_" : "", a.ident) < 0)	         {y%             warnx("asprintf failed");c             goto out;=	         }          wucme2Ods2 (fname);,F         if (!(a.ckey = key_load(never ? PK_NONE : type, bits, fname)))	         {              goto out;v	         }v3         if (asprintf(&fname, "%s/%swucme_c_%s.pem",oD                      a.ckeydir, staging ? "stg_" : "", a.ident) < 0)	         { %             warnx("asprintf failed");a             goto out; 	         }t         wucme2Ods2 (fname); A         msg(1, "checking existence and expiration of %s", fname);";         if (cert_valid(fname, a.names, days, status_check)) 	         {o             if (force)
             {n7                 msg(1, "forcing reissue of %s", fname); 
             }|             else
             { -                 msg(1, "skipping %s", fname);                  ret = 1;                 goto out; 
             }o	         }          free (fname);e }u #else 7         if (!(a.ckey = key_load(never ? PK_NONE : type, 8                         bits, "%s/key.pem", a.ckeydir)))             goto out;l  N         msg(1, "checking existence and expiration of %s/cert.pem", a.certdir);A         if (cert_valid(a.certdir, a.names, days, status_check)) {&             if (force)D                 msg(1, "forcing reissue of %s/cert.pem", a.certdir);             else {:                 msg(1, "skipping %s/cert.pem", a.certdir);                 ret = 1;                 goto out; 
             }y	         }i #endif /* IS_WUCME */   6         if (acme_bootstrap(&a) && account_retrieve(&a).                 && cert_issue(&a, status_req))             ret = 0;/     } else if (strcmp(action, "revoke") == 0) { 9         if (acme_bootstrap(&a) && account_retrieve(&a) && -                 cert_revoke(&a, filename, 0))              ret = 0;     }  #ifdef IS_WUCMEo+     else if (strcmp(action, "ping") == 0) {f)        warnx("fetching %s", a.directory); ,        if (200 == acme_get(&a, a.directory))#            printf ("%s\n", a.body);a        else5            warnx("FAILED");)        fflush(stdout);        ret = 0;y     }" #endif /* IS_WUCME */n   out:     if (a.key)         privkey_deinit(a.key);     if (a.ckey)a         privkey_deinit(a.ckey);(     json_free(a.json);     json_free(a.account);      json_free(a.dir);      json_free(a.order);      free(a.nonce);     free(a.kid);     free(a.headers);     free(a.body);e     free(a.type);      free(a.keydir);"     free(a.ckeydir);     free(a.certdir);     crypto_deinit(); #ifdef IS_WUCME       wucmeChallenge (NULL, NULL);     Http01Spawn (0);     return(ret); #elses     curl_global_cleanup();     exit(ret); #endif }   