$!-----------------------------------------------------------------'f$verify(0)
$! SSL_DETECT.COM
$!
$! Copyright (C) 1996-2026 Mark G.Daniel.
$!
$! Licensed under the Apache License, Version 2.0 (the "License");
$! you may not use this file except in compliance with the License.
$! You may obtain a copy of the License at
$!
$!    http://www.apache.org/licenses/LICENSE-2.0
$!
$! Unless required by applicable law or agreed to in writing, software
$! distributed under the License is distributed on an "AS IS" BASIS,
$! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
$! See the License for the specific language governing permissions and
$! limitations under the License.
$!
$! Checks for and determines which OpenSSL toolkit will be built against.
$!
$! The latest VSI OpenSSL kits should be fine for pre-V8.4 systems.
$! Prompt VSI attention to OpenSSL releases reduces the need for
$! WASD-specific OpenSSL builds so these will no longer be released.
$!
$!   https://wasd.vsm.com.au/info-WASD/2022/0070
$!
$! 08-DEC-2025  MGD  allow for local OpenSSL libraries OSSL_INCLUDE.TLB,
$!                     SSL$LIBSSL32.OLB and OSSL$LIBCRYPTO32.OLB as SSL0
$!                   remove (obsolete) SSL111
$! 14-DEC-2024  MGD  restrict OpenSSL versions by listing them in P1
$! 07-JAN-2024  MGD  VSI OpenSSL kits should be fine for pre-V8.4 systems
$!                   remove WASD SSL packages (obsolete)
$! 22-FEB-2022  MGD  refactor TLS/SSL build
$!                   VSI SSL3
$! 19-JAN-2020  MGD  VSI SSL111
$! 18-SEP-2018  MGD  detect OpenSSL v1.1 in WASD package
$! 03-AUG-2017  MGD  bugfix; BUILD_HTTPD_SSL
$! 13-AUG-2016  MGD  OpenSSL 1.1.0 (new VMS build environment)
$!                   HP SSL (OpenSSL v0.9.8n based) no longer supported
$!                   remove (specific) support for Polarhome OpenSSL kit
$! 24-APR-2016  MGD  HPE SSL1
$! 06-DEC-2014  MGD  remove support for JFP's OpenSSL package
$! 28-APR-2012  MGD  Polarhome OpenSSL (http://www.polarhome.com/openssl/)
$! 07-NOV-2009  MGD  WASD v10 logical naming schema
$! 22-SEP-2006  MGD  upper-case result from f$search() for SSL directory
$! 19-JUN-2005  MGD  Jean-Franois Pironne's OpenSSL package
$! 07-DEC-2002  MGD  initial (completely reworked for v8.1)
$!-----------------------------------------------------------------------------
$!
$ if f$trnlnm("INSTALL$DBUG") .nes. "" then set verify
$!
$ ss$_abort = 44
$ ss$_bugcheck = 676
$ p1 = f$edit(p1,"upcase")
$ if f$search("WASD_ROOT:[INSTALL]SSL_DETECT.COM") .nes. ""
$    then procedures = "WASD_ROOT:[INSTALL]"
$    else procedures = "[]"
$ endif
$ @'procedures'ARCHER.COM
$ say = "write sys$command"
$ on controly then exit ss$_abort
$ if f$environment("depth") .le. 1 then say ""
$!
$!
$ type sys$input
                             ******************
                             *  OpenSSL Kits  *
                             *****************

As of late 2022 VSI OpenSSL kits should be fine for pre- VMS V8.4 systems.
Just ignore and continue after any warning regarding minimum VMS version.

In the absence of VSI OpenSSL, WASD SSL kits containing OSSL_INCLUDE.TLB,
SSL$LIBSSL32.OLB and OSSL$LIBCRYPTO32.OLB can be used as SSL0.

$ vmsSSL3dir = ""
$ if p1 .eqs. "" .or. f$locate("+SSL3+",p1) .lt. f$length(p1)
$ then
$!   (SSL3 toolkit for OpenVMS - from the logical or look for it's directory)
$    vmsSSL3root = f$trnlnm("SSL3$ROOT")
$    if vmsSSL3root
$       then vmsSSL3dir = f$search("SSL3$ROOT:[000000]*.DIR")
$       else vmsSSL3dir = f$search("SYS$COMMON:[000000]SSL3.DIR")
$    endif
$    if vmsSSL3dir .nes. "" then WASD_SSLROOT = vmsSSL3dir
$ endif
$!
$ vmsSSL0dir = ""
$ ssl0_dir = "wasd_root:[src.httpd]"
$ ssl0_dir = f$parse(ssl0_dir,,,"device") +-
             f$parse(ssl0_dir,,,"directory") --
             "]" + ".obj_" + wasd_arch_name + "]"
$ if f$search("''ssl0_dir'OSSL$LIBSSL32.OLB") .nes. "" .and. -
     f$search("''ssl0_dir'OSSL$LIBCRYPTO32.OLB") .nes. "" .and. -
     f$search("''ssl0_dir'OSSL_INCLUDE.DSK") .nes. ""
$ then
$    vmsSSL0dir = f$search("''ssl0_dir'OSSL$LIBSSL32.OLB")
$ endif
$ if vmsSSL0dir .nes. "" then WASD_SSLROOT = vmsSSL0dir
$!
$ if vmsSSL0dir .eqs. "" .and. vmsSSL3dir .eqs. ""
$ then
$    type sys$input
                   **************************************
                   *  NO SSL TOOLKIT COULD BE LOCATED!  *
                   **************************************

None of the following SSL toolkits could be located.

  o  VMS SSL3 product (VSI)
  o  WASD SSL0 libraries

$    if p1 .eqs. "SSL"
$    then
$       type sys$input
As an "SSL" build was specifically requested this cannot continue.

$       exit ss$_abort
$    else
$       type sys$input
A non-SSL version of the server will be built.

$       read sys$command response /prompt="Press RETURN to continue: "
$       say ""
$       exit
$    endif
$ endif
$!
$ if p1 .eqs. "SSL"
$ then
$!   (an SSL build as specifically requested, if there's only one toolkit)
$!
$    vmsSSL3dir .nes. ""
$    then
$!      (only the VMS SSL3 product was found)
$       say "The VMS SSL3 product will be used."
$       say ""
$       exit
$    endif
$!
$    type sys$input
                    ************************************
                    *  MULTIPLE SSL TOOLKITS DETECTED  *
                    ************************************

Multiple supported Secure Sockets Layer (SSL) toolkits have been detected.
$!
$ else
$!
$    type sys$input
                         **************************
                         *  SSL TOOLKIT DETECTED  *
                         **************************

A supported Secure Sockets Layer (SSL) toolkit has been detected.
$!
$ endif
$!
$ option0 = 0
$ if p1 .eqs. "" .or. f$locate("+ZERO+",p1) .lt. f$length(p1) -
     then option0 = 1
$!
$ type sys$input
Those with item numbers are available for building, 'x's are not available.

$ if option0
$    then say "  0. do not build an SSL version"
$    else say "  x. do not build an SSL version"
$ endif
$ count = 0
$!
$ if vmsSSL3dir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = vmsSSL3dir
$    say "  ''count'. OpenVMS SSL3 product (VSI)"
$    count = count + 1
$    toolkit'count' = vmsSSL3dir + "SHR"
$    say "  ''count'. OpenVMS SSL3 product (VSI) SHAREABLE IMAGE link"
$ else
$    say "  x. OpenVMS SSL3 product (VSI)"
$ endif
$!
$ if vmsSSL0dir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = vmsSSL0dir
$    say "  ''count'. WASD SSL0 libraries"
$ else
$    say "  x. WASD SSL0 object libraries"
$ endif
$!
$! SELECT TOOLKIT
$!
$ toolkitLoop:
$    response = ""
$    say ""
$    read sys$command response /prompt="Select item number [0]: "
$    say ""
$    if response .eqs. "" then response = "0"
$    number = f$integer(response)
$    if number .lt. 0 .or. number .gt. count
$    then
$       say "RESPONSE ERROR! (enter a single digit 0 to ''count')"
$       goto toolkitLoop
$    endif
$ toolkitLoopEnd:
$!
$! SELECTION MADE
$!
$ if number .eq. 0
$ then
$   say "A non-SSL version of the application will be built."
$   say ""
$   define /job /nolog WASD_SSLROOT "!"
$   exit
$ endif
$!
$ if toolkit'number' .eqs. vmsSSL3dir
$ then
$    type sys$input
The VMS SSL3 (VSI) product has been selected.
$    product show product ssl3
$    read sys$command response /prompt="Press RETURN to continue: "
$    wasd_ssl_opt = "WASD_ROOT:[INSTALL]SSL3_LIB.OPT"
$    if f$search(wasd_ssl_opt) .eqs. "" then exit ss$_abort
$    say ""
$    define /job /nolog WASD_SSLROOT "''f$trnlnm("SSL3$ROOT")'"
$    define /job /nolog WASD_OPENSSL "SSL3$ROOT:[INCLUDE]"
$    define /job /nolog WASD_SSL_OPT "''wasd_ssl_opt'"
$    define /job /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ if toolkit'number' .eqs. (vmsSSL3dir + "SHR")
$ then
$    type sys$input
The VMS SSL3 product (VSI) SHAREABLE IMAGE has been selected.
$    product show product ssl3
$    read sys$command response /prompt="Press RETURN to continue: "
$    wasd_ssl_opt = "WASD_ROOT:[INSTALL]SSL3_SHR.OPT"
$    if f$search(wasd_ssl_opt) .eqs. "" then exit ss$_abort
$    say ""
$    define /job /nolog WASD_SSLROOT "''f$trnlnm("SSL3$ROOT")'"
$    define /job /nolog WASD_OPENSSL "SSL3$ROOT:[INCLUDE]"
$    define /job /nolog WASD_SSL_OPT "''wasd_ssl_opt'"
$    define /job /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ if toolkit'number' .eqs. vmsSSL0dir
$ then
$    type sys$input
The WASD SSL0 libraries have been selected.

$    say f$search("''ssl0_dir'OSSL$LIBSSL32.OLB")
$    say f$search("''ssl0_dir'OSSL$LIBCRYPTO32.OLB")
$    say f$search("''ssl0_dir'OSSL_INCLUDE.DSK")
$    say ""
$    read sys$command response /prompt="Press RETURN to continue: "
$    wasd_ssl_opt = "''ssl0_dir'OSSL_LIB.OPT"
$    if f$search(wasd_ssl_opt) .eqs. "" then exit ss$_abort
$    say ""
$    define /job /nolog WASD_SSLROOT "SSL0$ROOT"
$    define /job /nolog WASD_OPENSSL "''ssl0_dir'OSSL_INCLUDE"
$    define /job /nolog WASD_SSL_OPT "''wasd_ssl_opt'"
$    define /job /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ exit ss$_bugcheck
$!-----------------------------------------------------------------------------
