 /*E  * Copyright (C) 2019,2020 Nicola Di Lieto <nicola.dilieto@gmail.com>   *  * This file is part of uacme.  *C  * uacme is free software: you can redistribute it and/or modify it D  * under the terms of the GNU General Public License as published byD  * the Free Software Foundation, either version 3 of the License, or&  * (at your option) any later version.  *?  * uacme is distributed in the hope that it will be useful, but =  * WITHOUT ANY WARRANTY; without even the implied warranty of D  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU+  * General Public License for more details.   *D  * You should have received a copy of the GNU General Public License(  * along with this program.  If not, see"  * <http://www.gnu.org/licenses/>.  */   1 /***********************************************/ 1 /*  HEAVILY MODIFIED for wuCME implementation  */ 1 /***********************************************/    #include "wucme.h"   #ifndef IS_WUCME #include "config.h"  #include <err.h> #endif #include <stdarg.h>  #include <stdlib.h>  #include <string.h>  #include <unistd.h>    #include "curlwrap.h"    #ifdef IS_WUCME   % curldata_t *curl_get(const char *url)  {      int  rcode;      char  *cptr;     curldata_t *c = NULL;   +     for (int retry = 0; retry < 3; retry++)      {          c = curldata_calloc();         if (!c) 	         { 6             warnx("curl_get: curldata_calloc failed");             curldata_free(c);              return NULL;	         }   3         rcode = httpsGetRequest ((char*)url, NULL);          if (rcode <= 0) 	         { H             warnx("curl_post: GET %s failed: %s", url, httpsGetError());             curldata_free(c);              c = NULL; 	         }          else	         {              long code = -1;              c->code = rcode;*             c->headers = httpsGetHeader();4             c->headers_len = httpsGetHeaderLength();(             c->body = httpsGetContent();2             c->body_len = httpsGetContentLength();	         }            if (c)            break;          else         if (retry < 6)	         { A             warnx("curl_get: waiting 5 seconds before retrying");              sleep(5); 	         }      } 
     return c;  }   I curldata_t *curl_post(const char *url, void *post_data, size_t post_size,           const char *header, ...) {       int  rcode;    curldata_t *c = NULL;*    for (int retry = 0; retry < 3; retry++)    {       c = curldata_calloc();
       if (!c)        { 4          warnx("curl_post: curldata_calloc failed");          return NULL;        }   D       rcode = httpsPostRequest ((char*)url, "application/jose+json",C                                 (char*)post_data, post_size, NULL);        if (rcode <= 0)        { F          warnx("curl_post: POST %s failed: %s", url, httpsGetError());          curldata_free(c);          c = NULL;       } 
       else       {           long code = -1;          c->code = rcode; '          c->headers = httpsGetHeader(); 1          c->headers_len = httpsGetHeaderLength(); %          c->body = httpsGetContent(); /          c->body_len = httpsGetContentLength();        }          if (c)          break; 
       else       if (retry < 6)       { ?          warnx("curl_post: waiting 5 seconds before retrying");           sleep(5);       }     }    return c; }   ! curldata_t *curldata_calloc(void)  { 2     curldata_t *c = calloc(1, sizeof(curldata_t));
     if (!c) { /         warn("curldata_calloc: calloc failed");          return NULL;     }      c->body = strdup("");      if (!c->body) { /         warn("curldata_calloc: strdup failed");          free(c);         return NULL;     }      c->headers = strdup("");     if (!c->headers) {/         warn("curldata_calloc: strdup failed");          free(c->body);         free(c);         return NULL;     } 
     return c;  }   ! void curldata_free(curldata_t *c)  {      if (!c)          return;      free(c->body);     free(c->headers);      free(c); }   H static size_t curl_hcb(char *buf, size_t size, size_t n, void *userdata) { +     curldata_t *c = (curldata_t *)userdata; A     void *p = realloc(c->headers, c->headers_len + size * n + 1); 
     if (!p) { )         warn("curl_hcb: realloc failed");          return 0;      }      c->headers = p; 7     memcpy(c->headers + c->headers_len, buf, size * n);      c->headers_len += size * n; #     c->headers[c->headers_len] = 0;      return size * n; }   H static size_t curl_wcb(void *ptr, size_t size, size_t n, void *userdata) { +     curldata_t *c = (curldata_t *)userdata; ;     void *p = realloc(c->body, c->body_len + size * n + 1); 
     if (!p) { )         warn("curl_wcb: realloc failed");          return 0;      }      c->body = p;1     memcpy(c->body + c->body_len, ptr, size * n);      c->body_len += size * n;     c->body[c->body_len] = 0;      return size * n; }    #else /* IS_WCME */   % curldata_t *curl_get(const char *url)  {      curldata_t *c = NULL; -     for (int retry = 0; retry < 3; retry++) {          CURL *curl;          CURLcode res;           curl = curl_easy_init();         if (!curl) {5             warnx("curl_get: curl_easy_init failed");              return NULL;	         }          c = curldata_calloc();         if (!c) { 6             warnx("curl_get: curldata_calloc failed");$             curl_easy_cleanup(curl);             return NULL;	         } 1         curl_easy_setopt(curl, CURLOPT_URL, url); @         curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, curl_wcb);5         curl_easy_setopt(curl, CURLOPT_WRITEDATA, c); A         curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, curl_hcb); 6         curl_easy_setopt(curl, CURLOPT_HEADERDATA, c);1         curl_easy_setopt(curl, CURLOPT_USERAGENT, I                 "uacme/" VERSION " (https://github.com/ndilieto/uacme)"); &         res = curl_easy_perform(curl);         if (res != CURLE_OK) {5             warnx("curl_get: GET %s failed: %s", url, -                     curl_easy_strerror(res));              curldata_free(c);              c = NULL;          } else {             long code = -1; C             curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &code);              c->code = code; 	         }           curl_easy_cleanup(curl);         if (c)             break;         else if (retry < 6) { A             warnx("curl_get: waiting 5 seconds before retrying");              sleep(5); 	         }      } 
     return c;  }   I curldata_t *curl_post(const char *url, void *post_data, size_t post_size,           const char *header, ...) {      va_list ap;      curldata_t *c = NULL; -     for (int retry = 0; retry < 3; retry++) {          CURL *curl;          CURLcode res; '         struct curl_slist *list = NULL;           curl = curl_easy_init();         if (!curl) {6             warnx("curl_post: curl_easy_init failed");             return NULL;	         }          c = curldata_calloc();         if (!c) { 7             warnx("curl_post: curldata_calloc failed"); $             curl_easy_cleanup(curl);             return NULL;	         } 1         curl_easy_setopt(curl, CURLOPT_URL, url); @         curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, curl_wcb);5         curl_easy_setopt(curl, CURLOPT_WRITEDATA, c); A         curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, curl_hcb); 6         curl_easy_setopt(curl, CURLOPT_HEADERDATA, c);1         curl_easy_setopt(curl, CURLOPT_USERAGENT, I                 "uacme/" VERSION " (https://github.com/ndilieto/uacme)"); >         curl_easy_setopt(curl, CURLOPT_POSTFIELDS, post_data);A         curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, post_size);          va_start(ap, header);          while (header) {3             list = curl_slist_append(list, header); .             header = va_arg(ap, const char *);	         }          va_end(ap); 9         curl_easy_setopt(curl, CURLOPT_HTTPHEADER, list); &         res = curl_easy_perform(curl);"         curl_slist_free_all(list);         if (res != CURLE_OK) {7             warnx("curl_post: POST %s failed: %s", url, -                     curl_easy_strerror(res));              curldata_free(c);              c = NULL;          } else {             long code = -1; C             curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &code);              c->code = code; 	         }           curl_easy_cleanup(curl);         if (c)             break;         else if (retry < 6) { B             warnx("curl_post: waiting 5 seconds before retrying");             sleep(5); 	         }      } 
     return c;  }    #endif /* IS_WUCME */ 