#define module_name LOGFILE
#define module_ident "V1.0"

#include "local.h"

#include <stdio.h>
#include <ctype.h>
#include <descrip.h>
#include <psldef.h>
#include <prvdef.h>
#include <rms.h>
#include <ssdef.h>
#include <stdarg.h>
#include <string.h>
#include <starlet.h>

static struct FAB log_fab;			/* log file rms stuff */
static struct RAB log_rab;
static int logfile = -1;			/* log file flag */

/*
 *	w r i t e _ l o g _ f i l e
 *
 * 	Write line to log file.
 */
int 
write_log_file (int buflen, char *buffer)
{
  int status;

  if (logfile != -1) {			/* if no log file */
    sys$setast (0);
    logfile++;				/* bump flag */
    log_rab.rab$l_rbf = buffer;
    log_rab.rab$w_rsz = buflen;
    status = sys$put (&log_rab, 0, 0);
    sys$flush (&log_rab, 0, 0);		/* Keep log file up-to-date */
    sys$setast (1);
  }
  return (status);
}

/*
 *	l o g _ p r i n t f
 *
 *	Issue a printf-like string to the log file
 *
 *	Returns:	status
 */
int
log_printf (char *fmt,...)
{
  int len;
  static char tmp[L_tmpnam];
  va_list argp;

  if (logfile == -1)
    return (0);			/* if no log file, don't even bother */
  va_start (argp, fmt);
  len = vsprintf (tmp, fmt, argp);
  write_log_file (len, tmp);
  return (len);
}

/*
 *	w r i t e _ d e s c _ l o g _ f i l e
 */
int
write_desc_log_file (struct dsc$descriptor * str)
{
  return (write_log_file (str->dsc$w_length, str->dsc$a_pointer));
}

/*
 *	c l o s e _ l o g _ f i l e
 */
int 
close_log_file (int *err)
{
  if (logfile != -1) {
    if (logfile == 0)
      log_fab.fab$l_fop |= FAB$M_DLT;
    sys$close (&log_fab);		/* Don't care */
    logfile = -1;			/* Log file is gone, ok */
  }
  return SS$_NORMAL;			/* Always return normal */
}

/*
 *	o p e n _ l o g _ f i l e
 */
void 
open_log_file (char *log_file)
{
  int status;
  quadword privilege = { PRV$M_SYSPRV, 0 };
  static int exit_block[5] = { 0,
			       (int) close_log_file,
			       1,
			       (int) &exit_block[4],
			       0 };

  logfile = -1;				/* flag not opened yet */
  log_fab = cc$rms_fab;			/* init fab */
  log_fab.fab$l_fna = log_file;
  log_fab.fab$b_fns = strlen (log_fab.fab$l_fna);
  log_fab.fab$b_rfm = FAB$C_VAR;
  log_fab.fab$b_rat = FAB$M_CR;
  log_fab.fab$w_mrs = 512;
  log_fab.fab$b_shr = FAB$M_SHRGET;
  log_fab.fab$b_fac = FAB$M_GET | FAB$M_PUT;
  log_fab.fab$b_org = FAB$C_SEQ;
  log_fab.fab$l_fop = FAB$M_CIF;	/* create if non-existent */
  log_fab.fab$b_acmodes = PSL$C_EXEC << FAB$V_LNM_MODE;
  sys$setprv (1, privilege, 0, 0);	/* Enable SYSPRV */
  status = sys$create (&log_fab);
  sys$setprv (0, privilege, 0, 0);  	/* Disable SYSPRV */
  if (!(status & 1)) {
    return;
  }
  log_rab = cc$rms_rab;			/* initialize rab */
  log_rab.rab$l_fab = &log_fab;
  log_rab.rab$l_rop = RAB$M_EOF;	/* position at EOF */
  if (!(sys$connect (&log_rab) & 1))
    return;
  logfile = 0;				/* flag open, no records */
  sys$dclexh (exit_block);		/* Declare exit handler */
}
