$ /*	@(#)dirent.h 1.4 89/06/16 SMI 	*/   /*0  * Filesystem-independent directory information.5  * Directory entry structures are of variable length. J  * Each directory entry is a struct dirent containing its file number, theG  * offset of the next entry (a cookie interpretable only the filesystem J  * type that generated it), the length of the entry, and the length of theD  * name contained in the entry.  These are followed by the name. TheI  * entire entry is padded with null bytes to a 4 byte boundary. All names D  * are guaranteed null terminated. The maximum length of a name in a,  * directory is MAXNAMLEN, plus a null byte.  */    #ifndef	__sys_dirent_h #define	__sys_dirent_h   struct	dirent { 2 	long		d_off;		/* offset of next disk dir entry */3 	unsigned long	d_fileno;	/* file number of entry */ 5 	unsigned short	d_reclen;	/* length of this record */ : 	unsigned short	d_namlen;	/* length of string in d_name */6 	char		d_name[255+1];	/* name (up to MAXNAMLEN + 1) */ };   #ifndef	_POSIX_SOURCE  /*E  * It's unlikely to change, but make sure that sizeof d_name above is :  * at least MAXNAMLEN + 1 (more may be added for padding).  */  #define	MAXNAMLEN	255  /*O  * The macro DIRSIZ(dp) gives the minimum amount of space required to represent J  * a directory entry.  For any directory entry dp->d_reclen >= DIRSIZ(dp).F  * Specific filesystem types may use this macro to construct the value  * for d_reclen.  */ 
 #undef	DIRSIZ  #define	DIRSIZ(dp) \I 	(((sizeof(struct dirent) - (MAXNAMLEN+1) + ((dp)->d_namlen+1)) +3) & ~3)    #endif	/* !_POSIX_SOURCE */  #endif	/* !__sys_dirent_h */