
/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/
 
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>

#include "local.h"
#include "extern.h"

Pixmap ZoomPixmap;
Widget ZoomDA;
int ZoomExists = FALSE;
static Widget ZoomShell;
static GC TheGC;

void ZoomClose()
{
  if (ZoomExists)
  {
    XFreeGC(TheDisplay, TheGC); 
    XFreePixmap(TheDisplay, ZoomPixmap);
    XtDestroyWidget(ZoomShell);
    ZoomExists = FALSE;
  }
}

void Rectangles(XRectangle *rects, int length)
{
  if (length <= MaxRequests)
  {
    XFillRectangles(TheDisplay, ZoomPixmap, TheGC, rects, length);
    XFillRectangles(TheDisplay, XtWindow(ZoomDA), TheGC, rects, length);
  }
  else
  {
    XFillRectangles(TheDisplay, ZoomPixmap, TheGC, rects, MaxRequests);
    XFillRectangles(TheDisplay, XtWindow(ZoomDA), TheGC, rects, MaxRequests);
    Rectangles(rects+MaxRequests, length-MaxRequests);
  }
  XFlush(TheDisplay);
}

void Zoom()
{
  Widget bb;
  int i, j, n;
  Arg warg[5];
  XRectangle *rects, *rectPtr;
  int count;
  int zoomX, zoomY;
  char zoomString[50];

  zoomX = GetXZoom();
  zoomY = GetYZoom();
  
  ZoomClose();

  sprintf(zoomString,"Zoom -- %d X %d", zoomX, zoomY);
  UpdateStatus("Zooming image by %d x %d.", zoomX, zoomY);
  n = 0;
  XtSetArg(warg[n], XmNx, 10); n++;
  XtSetArg(warg[n], XmNy, 10); n++;
  ZoomShell = XtCreatePopupShell(zoomString, transientShellWidgetClass, TopLevel, 
	warg, n);

  n = 0;
  XtSetArg(warg[n], XmNwidth, zoomX*Xdimension+20); n++;
  XtSetArg(warg[n], XmNheight, zoomY*Ydimension+20); n++;
  XtSetArg(warg[n], XmNforeground, NumColors); n++;
  XtSetArg(warg[n], XmNbackground, NumColors); n++;
  bb = XtCreateManagedWidget("bb", xmBulletinBoardWidgetClass, ZoomShell,
	warg, n); 

  n = 0;
  XtSetArg(warg[n], XmNx, 10); n++;
  XtSetArg(warg[n], XmNy, 10); n++;
  XtSetArg(warg[n], XmNwidth, zoomX*Xdimension); n++;
  XtSetArg(warg[n], XmNheight, zoomY*Ydimension); n++;
  ZoomDA = XtCreateManagedWidget("ZoomImage", xmDrawingAreaWidgetClass, bb, warg, n);

  XtPopup(ZoomShell, XtGrabNone);
  ZoomPixmap = XCreatePixmap(TheDisplay, XtWindow(ZoomDA), zoomX*Xdimension,
        zoomY*Ydimension, DefaultDepth(TheDisplay, DefaultScreen(TheDisplay)));


  TheGC = XCreateGC(TheDisplay, XtWindow(ZoomDA), NULL, 0);
  XtAddEventHandler(ZoomDA, ButtonPressMask, FALSE, ZoomClose, NULL);

  XSetWindowColormap(TheDisplay, XtWindow(ZoomShell), TheColormap);

  for(i=0;i<NumColors;i++)
  {
    if (PS[i].length)
    {
      rects = (XRectangle *)XtMalloc(sizeof(XRectangle)*PS[i].length);
      rectPtr = rects;
      for(j=0;j<PS[i].length;j++)
      {
        rectPtr->x = PS[i].points[j].x*zoomX;
        rectPtr->y = PS[i].points[j].y*zoomY;
        rectPtr->width = zoomX;
	rectPtr->height = zoomY;   
        rectPtr++;
      }
      XSetForeground(TheDisplay, TheGC, i);
      Rectangles(rects, PS[i].length);
      XtFree(rects);
    }
  }
  if (TheWindow == ROOT)
  {
    XSetWindowBackgroundPixmap(TheDisplay, TheRootWindow, ZoomPixmap);
    XClearWindow(TheDisplay, TheRootWindow);
  }

  XSetWindowBackgroundPixmap(TheDisplay, XtWindow(ZoomDA), ZoomPixmap); 
  XClearWindow(TheDisplay, XtWindow(ZoomDA));
  ZoomExists = TRUE;
}
  
