
/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/
 
#include <X11/Intrinsic.h>
#include <stdio.h>

#include "local.h"
#include "extern.h"

#define PAGEMINOR 520.0
#define PAGEMAJOR 648.0
#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (b) : (a))
#endif

void PostScript(Widget w)
{
  FILE *fid;
  int i, j, element;
  Widget widPrompt;
  String filename;
  int r, g, b;
  XColor color;
  float scale;

  filename = GetOutputFileName();
  if ( (fid = fopen(filename, "w")) == NULL)
  {
    PopUpError("Can't open file %s", filename);
    UpdateStatus("Can't open file %s", filename);
    if (filename)
      XtFree(filename);
    CursorNormal();
    return;
  }

  fprintf(fid, "%%%%!PS-Adobe-1.0\n");
  fprintf(fid, "%%%%Creator: %s using XThing by John L. Cwikla, MRLCFC, 1991\n", cuserid(NULL));
  fprintf(fid, "%%%%Title: %s\n", filename);
  fprintf(fid, "%%%%CreationDate: Today\n");
  fprintf(fid, "%%%%Pages: 1\n");
  fprintf(fid, "%%%%EndProlog\n");
  fprintf(fid, "%%%%Page: 1 1\n");
  fprintf(fid, "gsave\n");
  if (Xdimension > Ydimension)
  {
    fprintf(fid, "612 0 translate\n");
    fprintf(fid, "90 rotate\n");
    fprintf(fid, "72 36 translate\n"); /* half inch margin */
    scale = MIN (PAGEMINOR/((float)Ydimension), PAGEMAJOR/((float)Xdimension));
    UpdateStatus("Xdimension greater than Ydimension, rotated on page for better fit.\n");
  }
  else
  {
    fprintf(fid, "36 72 translate\n");
    scale = MIN (PAGEMINOR/((float)Xdimension), PAGEMAJOR/((float)Ydimension));
  }

  fprintf(fid, "%.5f %.5f scale\n", Xdimension*scale, Ydimension*scale);

  if (ColorMode == COLOR)
    fprintf(fid, "/picstr %d string def\n", Xdimension*3);
  else
    fprintf(fid, "/picstr %d string def\n", Xdimension);

  fprintf(fid, "%d %d 8\n", Xdimension, Ydimension);
  fprintf(fid, "[%d 0 0 -%d 0 %d]\n\n", Xdimension, Ydimension, Ydimension);
  fprintf(fid, "{currentfile\n");
  fprintf(fid, " picstr readhexstring pop}\n");

  if (ColorMode == COLOR)
  {
    fprintf(fid, "false 3\n");

    fprintf(fid, "colorimage\n\n");
  }
  else
    fprintf(fid, "image\n\n");

  element = 0;
  for(j=0;j<Ydimension;j++)
  {
    for(i=0;i<Xdimension;i++)
    {
      if (!(element % 40))
        fprintf(fid, "\n");
      color.pixel = IValues[element];
      XQueryColor(TheDisplay, TheColormap, &color);

      if (ColorMode == COLOR)
        fprintf(fid, "%02x%02x%02x", color.red/(65535/NumColors),
                color.green/(65535/NumColors),
          color.blue/(65535/NumColors));
      else
        fprintf(fid, "%02x", color.red/(65535/NumColors));
      element++;
    }
  }

  fprintf(fid, "\ngrestore\n");
  fprintf(fid, "showpage\n");
  fprintf(fid, "%%%%Have a nice day. -- JLC\n");
  fprintf(fid, "%%%%Trailer\n");

  close(fid);
  XtFree(filename);
  UpdateStatus("Successfully wrote file %s", filename);
  CursorNormal();
}


