/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/

#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include "local.h"
#include "extern.h"

static int wait_cursor, norm_cursor;
static Widget wid;

void CreateCursors()
{
  wait_cursor = XCreateFontCursor(TheDisplay, XC_watch);
  norm_cursor = XCreateFontCursor(TheDisplay, XC_top_left_arrow);
}

void CursorNormal()
{
  XDefineCursor(TheDisplay, XtWindow(XThing), norm_cursor);
}

void CursorWait()
{
  XDefineCursor(TheDisplay, XtWindow(XThing), wait_cursor);
}


 
