
/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/
 
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/BulletinB.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/List.h>
#include <Xm/LabelG.h>
#include <Xm/Scale.h>

#include <stdarg.h>

#include "local.h"
#include "extern.h"
static Widget XZoomWidget, YZoomWidget, ZoomButton;
static Widget XPeriodWidget, YPeriodWidget, PeriodButton;
static Widget InputShell, OutputShell;
static Widget InputFileWidget, OutputFileWidget, OutputButton;
static Widget PostScaleWidget, ColorModeWidget, GrayModeWidget;
static Widget BGRWidget, BGBWidget, BGGWidget;
static Widget XthingStatus;
static Widget LinearModeWidget;

void Sensitize()
{
  XtSetSensitive(ZoomButton, TRUE);

  XtSetSensitive(PeriodButton, TRUE);
}

void Desensitize()
{
  XtSetSensitive(ZoomButton, FALSE);

  XtSetSensitive(PeriodButton, FALSE);
}

void UpdateStatus(char *string, ...)
{
  va_list parms;
  char dest[255];
  XmString xmstr;
  Arg warg[2];
  int n;
  int count;

  va_start(parms, string);
  vsprintf(dest, string, parms);
  va_end(parms);

  xmstr = XmStringLtoRCreate(dest, XmSTRING_DEFAULT_CHARSET); 
  n = 0;
  XtSetArg(warg[n], XmNitemCount, &count); n++;
  XtGetValues(XthingStatus, warg, n);
  XmListAddItemUnselected(XthingStatus, xmstr, 0); /* Last position */

  if (count > 50)
    XmListDeletePos(XthingStatus, 1);

  XmStringFree(xmstr);
}

void CreateStatus(Widget parent)
{
  Widget frame, rc;
  Arg warg[5];
  int n;
  XmString xmstr;

  frame = XtCreateManagedWidget("Frame", xmFrameWidgetClass, parent, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, frame, warg, n);

  XtCreateManagedWidget("XThing Status", xmLabelGadgetClass, rc, NULL, 0);
  XtCreateManagedWidget("Separator", xmSeparatorGadgetClass, rc, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNitems, 0); n++;
  XtSetArg(warg[n], XmNvisibleItemCount, 10); n++;
  XthingStatus = XmCreateScrolledList(rc, "List", warg, n);
  XtManageChild(XthingStatus);
  XmListDeselectAllItems(XthingStatus);
  XtSetSensitive(XthingStatus, FALSE);
}


void ColorModeChanged(Widget _w, int _random, XmToggleButtonCallbackStruct *tbcs)
{
  int set;   
  set = XmToggleButtonGadgetGetState(ColorModeWidget);
  if (set)
    ColorMode = COLOR;
  else
    ColorMode = GRAY;
 
  FillColormap(NumColors, ColorMode, _random);
} 

void TypeModeChanged(Widget _w, caddr_t nothing, XmToggleButtonCallbackStruct *tbcs)
{
  int set;
  set = XmToggleButtonGadgetGetState(LinearModeWidget);
  if (set)
    PlotType = LINEAR;
  else
    PlotType = LOG;
}

void BackgroundColorChange()
{
  XColor color;
  int r, g, b;
  XmScaleGetValue(BGRWidget, &r);
  XmScaleGetValue(BGGWidget, &g);
  XmScaleGetValue(BGBWidget, &b);
  color.red = r;
  color.blue = b;
  color.green = g;
  color.pixel = NumColors;
  color.flags= DoRed|DoBlue|DoGreen;

  XStoreColor(TheDisplay, TheColormap, &color);
}

void CreateBackgroundColorWidget(Widget _parent)
{
  Widget frame, rc;
  Arg warg[9];
  int n;
  XmString xmstr;

  frame = XtCreateManagedWidget("Frame", xmFrameWidgetClass, _parent, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, frame, warg, n);

  XtCreateManagedWidget("Background Color", xmLabelGadgetClass, rc, NULL, 0);
  XtCreateManagedWidget("Separator", xmSeparatorGadgetClass, rc, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(warg[n], XmNprocessingDirection, XmMAX_ON_BOTTOM); n++;
  XtSetArg(warg[n], XmNmaximum, 65535); n++;
  XtSetArg(warg[n], XmNvalue, 65535); n++;
  XtSetArg(warg[n], XmNshowValue, TRUE); n++;
  XtSetArg(warg[n], XmNminimum, 0); n++;

  xmstr = XmStringLtoRCreate("Red", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(warg[n], XmNtitleString, xmstr); n++;
  BGRWidget = XtCreateManagedWidget("Red", xmScaleWidgetClass, rc, warg, n);
  XmStringFree(xmstr);
  xmstr = XmStringLtoRCreate("Green", XmSTRING_DEFAULT_CHARSET); 
  XtSetArg(warg[n-1], XmNtitleString, xmstr); 
  BGGWidget = XtCreateManagedWidget("Green", xmScaleWidgetClass, rc, warg, n);
  XmStringFree(xmstr);
  xmstr = XmStringLtoRCreate("Blue", XmSTRING_DEFAULT_CHARSET); 
  XtSetArg(warg[n-1], XmNtitleString, xmstr); 
  BGBWidget = XtCreateManagedWidget("Blue", xmScaleWidgetClass, rc, warg, n);

  XtAddCallback(BGRWidget, XmNvalueChangedCallback, BackgroundColorChange, NULL);
  XtAddCallback(BGGWidget, XmNvalueChangedCallback, BackgroundColorChange, NULL);
  XtAddCallback(BGBWidget, XmNvalueChangedCallback, BackgroundColorChange, NULL);
}


int GetXPeriod()
{
  int value;
  XmScaleGetValue(XPeriodWidget, &value);
  return value;
}

void SetXPeriod(int _periodValue)
{
  XmScaleSetValue(XPeriodWidget, _periodValue);
}

int GetYPeriod()
{
  int value;
  XmScaleGetValue(YPeriodWidget, &value);
  return value;
}

void SetYPeriod(int _periodValue)
{
  XmScaleSetValue(YPeriodWidget, _periodValue);
}

int GetXZoom()
{
  int value;
  XmScaleGetValue(XZoomWidget, &value);
  return value;
}

void SetXZoom(int _zoomValue)
{ 
  XmScaleSetValue(XZoomWidget, _zoomValue);
}

int GetYZoom()
{ 
  int value;
  XmScaleGetValue(YZoomWidget, &value);
  return value;
}

void SetYZoom(int _zoomValue)
{
  XmScaleSetValue(YZoomWidget, _zoomValue);
}

void CreatePeriodWidgets(Widget _parent)
{
  Widget frame, rc;
  Arg warg[9];
  int n;
  XmString xmstr;

  frame = XtCreateManagedWidget("Frame", xmFrameWidgetClass, _parent, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, frame, warg, n);

  XtCreateManagedWidget("Repeat Period", xmLabelGadgetClass, rc, NULL, 0);
  XtCreateManagedWidget("Separator", xmSeparatorGadgetClass, rc, NULL, 0);

  xmstr = XmStringLtoRCreate("X Period", XmSTRING_DEFAULT_CHARSET);
  n = 0;
  XtSetArg(warg[n], XmNminimum, 1); n++;
  XtSetArg(warg[n], XmNmaximum, 100); n++;
  XtSetArg(warg[n], XmNshowValue, TRUE); n++;
  XtSetArg(warg[n], XmNprocessingDirection, XmMAX_ON_BOTTOM); n++;
  XtSetArg(warg[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(warg[n], XmNvalue, 1); n++;
  XtSetArg(warg[n], XmNtitleString, xmstr); n++;
  XPeriodWidget = XtCreateManagedWidget("X Period", xmScaleWidgetClass, rc, warg, n);
  XmStringFree(xmstr);

  xmstr = XmStringLtoRCreate("Y Period", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(warg[n-1], XmNtitleString, xmstr);
  YPeriodWidget = XtCreateManagedWidget("Y Period", xmScaleWidgetClass, rc, warg, n);
  XmStringFree(xmstr);
  PeriodButton = XtCreateManagedWidget("Repeat", xmPushButtonGadgetClass, rc, NULL, 0);
  XtAddCallback(PeriodButton, XmNactivateCallback, Period, NULL);
}

void CreateZoomWidgets(Widget _parent)
{
  Widget frame, rc;
  Arg warg[9];
  int n;
  XmString xmstr;

  frame = XtCreateManagedWidget("Frame", xmFrameWidgetClass, _parent, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, frame, warg, n);

  XtCreateManagedWidget("Zoom Magnification", xmLabelGadgetClass, rc, NULL, 0);
  XtCreateManagedWidget("Separator", xmSeparatorGadgetClass, rc, NULL, 0);

  xmstr = XmStringLtoRCreate("X Magnification", XmSTRING_DEFAULT_CHARSET);
  n = 0; 
  XtSetArg(warg[n], XmNminimum, 1); n++;
  XtSetArg(warg[n], XmNmaximum, 100); n++;
  XtSetArg(warg[n], XmNshowValue, TRUE); n++;
  XtSetArg(warg[n], XmNprocessingDirection, XmMAX_ON_BOTTOM); n++;
  XtSetArg(warg[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(warg[n], XmNvalue, 1); n++;
  XtSetArg(warg[n], XmNtitleString, xmstr); n++; 
  XZoomWidget = XtCreateManagedWidget("X Zoom", xmScaleWidgetClass, rc, warg, n);
  XmStringFree(xmstr);

  xmstr = XmStringLtoRCreate("Y Magnification", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(warg[n-1], XmNtitleString, xmstr); 
  YZoomWidget = XtCreateManagedWidget("Y Zoom", xmScaleWidgetClass, rc, warg, n);
  XmStringFree(xmstr); 
  ZoomButton = XtCreateManagedWidget("Zoom", xmPushButtonGadgetClass, rc, NULL, 0);
  XtAddCallback(ZoomButton, XmNactivateCallback, Zoom, NULL);
}

void SetInputFileName(char *filename)
{
  XmTextSetString(InputFileWidget, filename);
}

char *GetInputFileName()
{
  return XmTextGetString(InputFileWidget);
}

void FileOK()
{
  Release();
  DoIt();
}

void PopupInputShell(Widget w, Widget shell)
{
  XtPopup(InputShell, XtGrabNone);
}

void PopdownInputShell(Widget w, Widget shell)
{
  XtPopdown(InputShell);
}

void CreateInputFileWidget(Widget _parent)
{
  Widget bb, fsb, rc;
  Arg warg[5];
  int n = 0;

  InputShell = XtCreatePopupShell("Input", transientShellWidgetClass, _parent, NULL, 0);
  bb = XtCreateManagedWidget("BB", xmBulletinBoardWidgetClass, InputShell, NULL, 0);
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc = XtCreateManagedWidget("RC", xmRowColumnWidgetClass, bb, warg, n);

  fsb = XtCreateManagedWidget("Input File", xmFileSelectionBoxWidgetClass, rc, NULL, 0);
  XtUnmanageChild(XmFileSelectionBoxGetChild(fsb, XmDIALOG_HELP_BUTTON));
  XtAddCallback(XmFileSelectionBoxGetChild(fsb, XmDIALOG_OK_BUTTON), XmNactivateCallback,
	FileOK, NULL);
  XtAddCallback(XmFileSelectionBoxGetChild(fsb, XmDIALOG_CANCEL_BUTTON), XmNactivateCallback,
	PopdownInputShell, NULL);

  InputFileWidget = XmFileSelectionBoxGetChild(fsb, XmDIALOG_TEXT);

}

void SetOutputFileName(char *filename)
{
  XmTextSetString(OutputFileWidget, filename);
}

char *GetOutputFileName()
{
  return XmTextGetString(OutputFileWidget);
}

int IsPostScaleSet()
{
  return XmToggleButtonGadgetGetState(PostScaleWidget);
}

void PopupOutputShell()
{
  XtPopup(OutputShell, XtGrabNone);
}

void PopdownOutputShell()
{
  XtPopdown(OutputShell);
}

void CreateOutputFileWidget(Widget _parent)
{
  Widget bb, rc, closeButton;
  Arg warg[4];
  int n;

  OutputShell = XtCreatePopupShell("Output", transientShellWidgetClass, _parent, NULL, 0);
  bb = XtCreateManagedWidget("BB", xmBulletinBoardWidgetClass, OutputShell, NULL, 0);
  n = 0;
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, bb, warg, n);
  XtCreateManagedWidget("File Name", xmLabelGadgetClass, rc, NULL, 0);

  n = 0;
  XtSetArg(warg[n], XmNeditMode, XmSINGLE_LINE_EDIT); n++;
  OutputFileWidget = XtCreateManagedWidget("OutputFileName", xmTextWidgetClass, rc, warg, n);

/* 
  n = 0;
  XtSetArg(warg[n], XmNset, FALSE); n++;
  PostScaleWidget = XtCreateManagedWidget("Output at Current Zoom", xmToggleButtonGadgetClass, rc, 
	warg, n);
*/
  OutputButton = XtCreateManagedWidget("Create PostScript File", xmPushButtonGadgetClass, rc, NULL, 0);
  closeButton = XtCreateManagedWidget("Cancel", xmPushButtonGadgetClass, rc, NULL, 0);
  XtAddCallback(OutputButton, XmNactivateCallback, CursorWait, NULL);
  XtAddCallback(OutputButton, XmNactivateCallback, PostScript, NULL);
  XtAddCallback(closeButton, XmNactivateCallback, PopdownOutputShell, NULL);

}

int GetColorMode()
{
  return XmToggleButtonGadgetGetState(ColorModeWidget);
}

void SetColorMode(int _colorMode)
{
  XmToggleButtonGadgetSetState(ColorModeWidget, _colorMode, FALSE);
  XmToggleButtonGadgetSetState(GrayModeWidget, !_colorMode, FALSE);
}

ExitCallback()
{
  Release();
  XFreeColormap(TheDisplay, TheColormap);
  printf("Have a nice day. -- JLC\n");
  exit(0);
}

void CreateMenu(Widget parent)
{
  Widget menu, file, color, type;
  Widget cascade, radio;
  Widget exitMe, inputFile, outputFile;
  Widget invertWidget;
  Widget randomWidget;
  Arg warg[2];
  int n = 0;

  menu = XmCreateMenuBar(parent, "XThing MenuBar", NULL, 0);
  file = XmCreatePulldownMenu(menu, "File", NULL, 0);
  n = 0;
  XtSetArg(warg[n], XmNsubMenuId, file); n++;
  cascade = XmCreateCascadeButton(menu, "File", warg, n);
  XtManageChild(cascade);

  inputFile = XtCreateManagedWidget("Read File...", xmPushButtonGadgetClass, file, NULL, 0);
  XtAddCallback(inputFile, XmNactivateCallback, PopupInputShell, NULL);
  outputFile = XtCreateManagedWidget("Save Image...", xmPushButtonGadgetClass, file, NULL, 0);
  XtAddCallback(outputFile, XmNactivateCallback, PopupOutputShell, NULL);
  exitMe = XtCreateManagedWidget("Exit XThing", xmPushButtonGadgetClass, file, NULL, 0);
  XtAddCallback(exitMe, XmNactivateCallback, ExitCallback, NULL);

  n = 0;
  XtSetArg(warg[n], XmNradioAlwaysOne, TRUE); n++;
  XtSetArg(warg[n], XmNradioBehavior, TRUE); n++;
  color = XmCreatePulldownMenu(menu, "Color", warg, n);
  n = 0;
  XtSetArg(warg[n], XmNsubMenuId, color); n++;
  cascade = XmCreateCascadeButton(menu, "Color", warg, n);
  XtManageChild(cascade);

  n = 0;
  XtSetArg(warg[n], XmNset, ColorMode); n++;
  ColorModeWidget = XtCreateManagedWidget("Color", xmToggleButtonGadgetClass,
        color, warg, n);
  n = 0;
  XtSetArg(warg[n], XmNset, (!ColorMode)); n++;
  GrayModeWidget = XtCreateManagedWidget("GrayScale", xmToggleButtonGadgetClass,
        color, warg, n);
  XtAddCallback(ColorModeWidget, XmNvalueChangedCallback, ColorModeChanged, NULL);

  n = 0;
  invertWidget = XtCreateManagedWidget("Invert", xmPushButtonGadgetClass, color, 
	warg, n);
  XtAddCallback(invertWidget, XmNactivateCallback, InvertColormap, NULL);

  n = 0;
  XtSetArg(warg[n], XmNradioAlwaysOne, TRUE); n++;
  XtSetArg(warg[n], XmNradioBehavior, TRUE); n++;
  type = XmCreatePulldownMenu(menu, "type", warg, n);
  n = 0;
  XtSetArg(warg[n], XmNsubMenuId, type); n++;
  cascade = XmCreateCascadeButton(menu, "Plot Type", warg, n); 
  XtManageChild(cascade);

  n = 0;
  XtSetArg(warg[n], XmNset, PlotType == LINEAR); n++;
  LinearModeWidget = XtCreateManagedWidget("Linear",  xmToggleButtonGadgetClass,
	type, warg, n);
  XtSetArg(warg[n], XmNset, PlotType == LOG); n++;
  XtCreateManagedWidget("Log", xmToggleButtonGadgetClass,
	type, warg, n); 
  XtAddCallback(LinearModeWidget, XmNvalueChangedCallback, TypeModeChanged, NULL);
 
  XtManageChild(menu);
}

Widget MakeControls(Widget parent)
{
  Widget bb, rc, rc1, rc2, rc3, exitMe, helpMe;
  Arg warg[5];
  int n;

  bb = XtCreateManagedWidget("BB", xmBulletinBoardWidgetClass, parent, NULL , 0);

  n = 0;
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNorientation, XmVERTICAL); n++;
  XtSetArg(warg[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  rc = XtCreateManagedWidget("RC", xmRowColumnWidgetClass, bb, warg, n);
  CreateMenu(rc);

  n = 0;
  XtSetArg(warg[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(warg[n], XmNnumColumns, 3); n++;
  rc1 = XtCreateManagedWidget("RC1", xmRowColumnWidgetClass, rc, warg, n);
  n = 0;
  XtSetArg(warg[n], XmNpacking, XmPACK_TIGHT); n++;
  XtSetArg(warg[n], XmNorientation, XmHORIZONTAL); n++;
  rc2 = XtCreateManagedWidget("RC2", xmRowColumnWidgetClass, rc, warg, n);

  CreateZoomWidgets(rc1);
  CreatePeriodWidgets(rc1);
  CreateBackgroundColorWidget(rc1);
  CreateInputFileWidget(rc2);
  CreateOutputFileWidget(rc2);
  CreateStatus(rc);

  return bb;
}
