/* XTHING -- a visualization tool for 2Dimensional
 * representations of 3Dimensional data.
 *
 * Copyright 1991 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
*/
 
#include <X11/Intrinsic.h>

#include <math.h>
#include "local.h"
#include "extern.h"

double Value(double _n1, double _n2, double _hue)
{
  double val;

  if (_hue > 360.0) _hue -= 360.0;
  if (_hue < 0.0) _hue += 360.0;
  
  if (_hue < 60.0)
    val = _n1+(_n2 - _n1) * _hue/ 60.0;
  else
  if (_hue < 180.0)
    val = _n2;
  else
  if (_hue < 240.0)
    val = _n1 + (_n2 - _n1)*(240.0 - _hue)/60.0;
  else
    val = _n1;

  return val;
}


void HLS_to_RGB(double *_h, double *_l, double *_s, double *_r, double *_g, 
	double *_b)
{
  double m1, m2;

  m2 = ((*_l < 0.5) ? (*_l) * (1 + *_s) : *_l + *_s - (*_l)*(*_s));

  m1 = 2 * (*_l) - m2;
  
  if  (*_s == 0)
    { (*_r) = (*_g) = (*_b) = (*_l); }
  else
    {
      *_r = Value(m1, m2, (double)(*_h + 120.0));
      *_g = Value(m1, m2, (double)(*_h));
      *_b = Value(m1, m2, (double)(*_h - 120.0));
    }

}

#define RANDOM(lower, upper) ((upper - lower) * ((float)rand()/32760.0)) + lower

void RandomizeColormap()
{
  XColor *colors;
  Pixel temp;
  int i;
  int index;

  colors = (XColor *)XtMalloc(sizeof(XColor)*NumColors);
  for (i=0;i<NumColors;i++)
  {
    colors[i].pixel = i;
    colors[i].flags = DoRed|DoBlue|DoGreen;
  }
  XQueryColors(TheDisplay, TheColormap, colors, NumColors);
  for (i=0;i<NumColors;i++)
  {
    while(( (index = RANDOM(0, NumColors)) < 0) || (index >= NumColors));
    temp = colors[i].pixel;
    colors[i].pixel = colors[index].pixel;
    colors[index].pixel = temp;
  }
  XStoreColors(TheDisplay, TheColormap, colors, NumColors);
  XtFree(colors);
}


void InvertColormap()
{
  XColor *colors;
  Pixel temp;
  int i;

  colors = (XColor *)XtMalloc(sizeof(XColor)*NumColors);
  for (i=0;i<NumColors;i++)
  {
    colors[i].pixel = i;
    colors[i].flags = DoRed|DoBlue|DoGreen;
  }
  XQueryColors(TheDisplay, TheColormap, colors, NumColors);
  for (i=0;i<NumColors/2;i++)
  {
    temp = colors[i].pixel;
    colors[i].pixel = colors[NumColors-i-1].pixel;
    colors[NumColors-i-1].pixel = temp;
  }
  XStoreColors(TheDisplay, TheColormap, colors, NumColors);
  XtFree(colors);
}

void FillColormap(int _numColors, int _mode)
{
  XColor *colors;
  int i;
  double h, r, g, b, l = 0.5, s = 0.5;
  Visual *visual;

  visual = DefaultVisual(TheDisplay, DefaultScreen(TheDisplay));

   if ( (visual->class == StaticGray) ||
         (visual->class == StaticColor) ||
         (visual->class == TrueColor) )
     return;

  colors = (XColor *)XtMalloc(sizeof(XColor)*(_numColors+1));

  if (_mode == COLOR)
  {
    for(i=0;i<_numColors;i++)
    {
      h = (double)i*360.0/((double)_numColors+1);
      HLS_to_RGB(&h, &l, &s, &r, &g, &b);
      colors[i].pixel = i;
      colors[i].flags = DoRed|DoBlue|DoGreen;
      colors[i].red = r * 65535.0;
      colors[i].green = g * 65535.0;
      colors[i].blue = b * 65535.0;
    }
  }
  else
  if (_mode == GRAY)
  {
    for(i=0;i<_numColors;i++)
    {
      colors[i].pixel = i;
      colors[i].flags = DoRed|DoBlue|DoGreen;
      colors[i].red = 
      colors[i].green = 
      colors[i].blue = (float)i * (65535.0/(float)_numColors);
    }
  }

  colors[i].pixel = NumColors;
  colors[i].flags = DoRed|DoBlue|DoGreen;
  colors[i].red = 
  colors[i].green = 
  colors[i].blue = 65535;

  XStoreColors(TheDisplay, TheColormap, colors, _numColors);
  XtFree(colors);

}

/* AssignColors -- Grab as many colors as we can for our program */

int AssignColors(Widget _w, int _numColors)
{
  Colormap def_colormap;
  XColor *colors, *colors_ptr;
  int i,j;
  int num_colors;
  double h, r, g, b, l = 0.5, s = 0.5;
  Pixel *pixels;
  Visual *visual;
  int screen_no;

  screen_no = DefaultScreen(XtDisplay(_w));
  num_colors = DisplayCells(XtDisplay(_w), screen_no);
  visual = DefaultVisual(XtDisplay(_w), screen_no);
  def_colormap = DefaultColormap(XtDisplay(_w), screen_no);

  if (_numColors == 0)
    _numColors = num_colors;
  else
    if (_numColors < num_colors)
	_numColors++;

  num_colors = MIN(num_colors, _numColors);

#ifdef DDEBUG
  printf("num_colors is %d\n", num_colors);
#endif
  if (num_colors == 2){
    TheColormap = def_colormap;
    return 2;
  }

  if (  (visual->class == StaticGray) ||
	(visual->class == StaticColor) ||
	(visual->class == TrueColor) ){
    if (! (TheColormap = XCreateColormap(XtDisplay(_w), XtWindow(_w),
						visual, AllocNone) ) )
	TheColormap = XCopyColormapAndFree(XtDisplay(_w), def_colormap);
  }

  if (! (TheColormap = XCreateColormap(XtDisplay(_w), XtWindow(_w),
						visual, AllocNone) ) )
      TheColormap = XCopyColormapAndFree(XtDisplay(_w), def_colormap);
    
/* Malloc space for them  -- I like to do things dynamic-wise. */

  colors = (XColor *)XtMalloc(sizeof(XColor)*(num_colors+1));

  colors_ptr = colors;
  for(i=0;i<num_colors;i++){
    ((XColor *)colors_ptr)->pixel = i;
    ((XColor *)colors_ptr++)->flags = DoRed|DoBlue|DoGreen;
  }

  colors_ptr = colors;
  for(j=0;j<num_colors;j++){
    if ( (visual->class == StaticGray) ||
	 (visual->class == StaticColor) ||
	 (visual->class == TrueColor) ){
      if (!XAllocColor(XtDisplay(_w), TheColormap, colors_ptr)) break;
    }
    else
      if (!XAllocColorCells(XtDisplay(_w), TheColormap, FALSE, NULL, 0,
		colors_ptr, 1)) break;
    colors_ptr++;
  }
  
  XtFree(colors);

  return j-1;
}
