	 /*  vms.c   *M  * This module contains the VMS version of the routine SPAWN (from the module >  * MAIN.C) and the routines that do IO to the pseudo terminal.  *  * Modification History:.  * Stephan Jansen 1-Mar-1990  Original versionB  * Hal R. Brand   5-Sep-1990  Added code to propagate DECW$DISPLAY;  * Aaron Leonard 11-Sep-1990  Fix string descriptor lengths G  * Stephan Jansen 2-Dec-1991  Modify to use new Pseudo terminal drivers L  *                            (patterned after photo.c by Forrest A. Kenney)H  * Patrick Mahan  7-Jan-1991  Removed reference to <dvidef.h> from VMS.C7  *			      Forced device type to be VT102 since that is !  *			      what we are emulating.   */     #include <libdef.h>  #include <lnmdef.h>     #include <stdio.h> #include <string.h>    #include "ptyx.h"  #include "vms.h"  A #define PTD$C_SEND_XON		0	/* Pseudo Terminal Driver event      */  #define PTD$C_SEND_BELL		1 #define PTD$C_SEND_XOFF 	2 #define PTD$C_STOP_OUTPUT	3  #define PTD$C_RESUME_OUTPUT 	4 #define PTD$C_CHAR_CHANGED 	5  #define PTD$C_ABORT_OUTPUT 	6  #define PTD$C_START_READ 	7  #define PTD$C_MIDDLE_READ 	8 #define PTD$C_END_READ 		9 #define PTD$C_ENABLE_READ 	10  #define PTD$C_DISABLE_READ 	11 #define PTD$C_MAX_EVENTS 	12     #define	BUFFERS		        6 #define	PAGE			512 #define BUFFER_SIZE		500    ' int trnlnm(char *in,int id,char *out);   void spawn (void);  5 static void tt_echo_ast(struct tt_buffer *buff_addr); * int tt_write(char *tt_write_buf,int size);5 static void tt_read_ast(struct tt_buffer *buff_addr);   static void tt_start_read(void); int tt_read(char *buffer); static void send_xon(void);  static void send_xoff(void); static void send_bell(void); static void char_change(void);3 static void freeBuff (struct tt_buffer *buff_addr);   struct tt_buffer *getBuff(void);' static void CloseDown(int exit_status);  static void mbx_read_ast(void);  static void mbx_read(void);      struct	tt_buffer {  unsigned int	flink;  unsigned int	blink;  short	int	status;  short	int	length;  char		data[BUFFER_SIZE]; };  
 struct	q_head  {  int			flink; int			blink; };   struct	tt_buffer	 *tt_w_buff; 6 struct	q_head		 _align(QUADWORD)	buffer_queue = (0,0);4 struct	q_head		 _align(QUADWORD)	read_queue = (0,0);   ! static char          tt_name[64]; . static $DESCRIPTOR   (tt_name_desc, &tt_name);   ! static char          ws_name[64]; . static $DESCRIPTOR   (ws_name_desc, &ws_name);    static struct        tt_char {    char        class;     char        type;    short int   page_width;"    char        characteristics[3];    char        length;    int         extended;"  } tt_mode,tt_chars,orig_tt_chars;   struct mem_region  {    struct tt_buffer *start;   struct tt_buffer *end;
 } ret_addr;      int read_stopped = FALSE;  int write_stopped = FALSE;   extern int tt_width; extern int tt_length;  extern int tt_changed;    @ #define DESCRIPTOR(name,string) struct dsc$descriptor_s name = \8 { strlen(string), DSC$K_DTYPE_T, DSC$K_CLASS_S, string }    int trnlnm(in,id,out)       int id;      char *in,*out;  { :   int status, num, len, attr = LNM$M_CASE_BLIND, foo = id;   short outlen;    struct itemlist      {        short buffer_length;       short item_code;       char  *buffer_addr;        int   *return_length;      } itmlst[] =       {  	4  , LNM$_INDEX    , &foo, 0,$ 	255, LNM$_STRING   , out , &outlen,! 	4  , LNM$_MAX_INDEX, &num, &len,  	0  , 0  	};    DESCRIPTOR(lognam,in);'   DESCRIPTOR(tabnam,"LNM$DCL_LOGICAL");    6   status = sys$trnlnm(&attr,&tabnam,&lognam,0,itmlst);;   if(status != SS$_NORMAL) return(-1);   /* error status */ <   out[outlen] = 0;         /* terminate the output string */<   return(++num);         /* return number of translations */ }       
 void spawn ()  {    int                  status;0   static $DESCRIPTOR   (dtime, "0 00:00:00.01");    static int           delta[2];    extern int           pty_mask;#   extern int           Select_mask;    extern int           X_mask;   extern int           pty;    extern int           Xsocket;    extern XtermWidget   term;/   register TScreen     *screen = &term->screen; !   extern TekWidget     tekWidget;    static struct IOSB   iosb;   static unsigned int  flags;    static unsigned int  uic; %   static char          imagename[64];    static int           privs; &   static $DESCRIPTOR(device, "FTA0:");   static int           type;   static int           class; !   static int           devdepend;     static int           mem_size;   int                  i;    F   /* if pid and mbx_chan are nonzero then close them in CloseDown() */   pid = 0;     mbx_chan = 0;    1   status = SYS$EXPREG (BUFFERS, &ret_addr, 0, 0); 0   if(!(status & SS$_NORMAL)) lib$signal(status);   .   tt_w_buff = (char *)ret_addr.end - PAGE + 1;  I   /* use one buffer for writing, the reset go in the free buffer queue */    for(i=0; i < BUFFERS-1; i++)     { /       freeBuff((char *)ret_addr.start +i*PAGE);      }    >   /* avoid double MapWindow requests, for wm's that care... */@   XtSetMappedWhenManaged( screen->TekEmu ? XtParent(tekWidget) : 			 XtParent(term), False );D   /* Realize the Tek or VT widget, depending on which mode we're in.D      If VT mode, this calls VTRealize (the widget's Realize proc) */9   XtRealizeWidget (screen->TekEmu ? XtParent(tekWidget) :  		   XtParent(term));    E   /* get the default device characteristics of the pseudo terminal */      itemlist[0].buflen      = 4;)   itemlist[0].code        = DVI$_DEVTYPE; "   itemlist[0].buffer      = &type;7   itemlist[0].return_addr = &tt_name_desc.dsc$w_length;    #   itemlist[1].buflen      = 4;      *   itemlist[1].code        = DVI$_DEVCLASS;#   itemlist[1].buffer      = &class; 7   itemlist[1].return_addr = &tt_name_desc.dsc$w_length;    #   itemlist[2].buflen      = 4;      +   itemlist[2].code        = DVI$_DEVDEPEND; '   itemlist[2].buffer      = &devdepend; 7   itemlist[2].return_addr = &tt_name_desc.dsc$w_length;      itemlist[3].buflen      = 4;,   itemlist[3].code        = DVI$_DEVDEPEND2;/   itemlist[3].buffer      = &tt_chars.extended; 7   itemlist[3].return_addr = &tt_name_desc.dsc$w_length;       itemlist[4].buflen      = 0;   itemlist[4].code        = 0;    :   status = sys$getdviw(0,0,&device,&itemlist,&iosb,0,0,0);0   if(!(status & SS$_NORMAL)) lib$signal(status);:   if(!(iosb.status & SS$_NORMAL)) lib$signal(iosb.status);  C   tt_chars.type        = DT$_VT102; /* XTerm supports VT102 mode */    tt_chars.class       = class; +   tt_chars.page_width  = screen->max_col+1; +   tt_chars.length      = screen->max_row+1;   B   /* copy the default char's along with the created window size */  2   bcopy(&devdepend, &tt_chars.characteristics, 3);     @   tt_chars.extended |= TT2$M_ANSICRT | TT2$M_AVO | TT2$M_DECCRT;    9   /* create the pseudo terminal with the proper char's */ ?   status = ptd$create(&tt_chan,0,&tt_chars,12,0,0,0,&ret_addr); 0   if(!(status & SS$_NORMAL)) lib$signal(status);     2   /* get the device name of the Pseudo Terminal */   $   itemlist[0].buflen      = 64;     (   itemlist[0].code        = DVI$_DEVNAM;%   itemlist[0].buffer      = &tt_name; 7   itemlist[0].return_addr = &tt_name_desc.dsc$w_length;      /* terminate the list */#   itemlist[1].buflen      = 0;         itemlist[1].code        = 0;   :   status = sys$getdviw(0,tt_chan,0,&itemlist,&iosb,0,0,0);/   if(!(status & SS$_NORMAL)) CloseDown(status); 9   if(!(iosb.status & SS$_NORMAL)) CloseDown(iosb.status);       /*A    * set up AST's for XON, XOFF, BELL and characteristics change.     */   L   status = ptd$set_event_notification(tt_chan,&send_xon,0,0,PTD$C_SEND_XON);/   if(!(status & SS$_NORMAL)) CloseDown(status);   N   status = ptd$set_event_notification(tt_chan,&send_xoff,0,0,PTD$C_SEND_XOFF);/   if(!(status & SS$_NORMAL)) CloseDown(status);   N   status = ptd$set_event_notification(tt_chan,&send_bell,0,0,PTD$C_SEND_BELL);/   if(!(status & SS$_NORMAL)) CloseDown(status);   S   status = ptd$set_event_notification(tt_chan,&char_change,0,0,PTD$C_CHAR_CHANGED); /   if(!(status & SS$_NORMAL)) CloseDown(status);   B   /* create a mailbox for the detached process to detect hangup */   ;   status = sys$crembx(0,&mbx_chan,ACC$K_TERMLEN,0,255,0,0); /   if(!(status & SS$_NORMAL)) CloseDown(status);          /*>    * get the device unit number for created process completion    * status to be sent to.    */       itemlist[0].buflen      = 4;&   itemlist[0].code        = DVI$_UNIT;%   itemlist[0].buffer      = &mbxunit;    itemlist[0].return_addr = 0;      /* terminate the list */#   itemlist[1].buflen      = 0;         itemlist[1].code        = 0;   ;   status = sys$getdviw(0,mbx_chan,0,&itemlist,&iosb,0,0,0); /   if(!(status & SS$_NORMAL)) CloseDown(status); 9   if(!(iosb.status & SS$_NORMAL)) CloseDown(iosb.status);         tt_start_read();         /*A    * find the current process's UIC so that it can be used in the     * call to sys$creprc     */    itemlist[0].buflen = 4;    itemlist[0].code = JPI$_UIC;   itemlist[0].buffer = &uic;   itemlist[0].return_addr = 0;      /* terminate the list */#   itemlist[1].buflen      = 0;         itemlist[1].code        = 0;   .   status = sys$getjpiw(0,0,0,&itemlist,0,0,0);/   if(!(status & SS$_NORMAL)) CloseDown(status);    >   /* Complete a descriptor for the WS (DECW$DISPLAY) device */   #   trnlnm("DECW$DISPLAY",0,ws_name); .   ws_name_desc.dsc$w_length = strlen(ws_name);      /* create the process */D   /*  Set sys$error to be the WS (DECW$DISPLAY) device. LOGINOUT  */D   /*  has special code for DECWINDOWS that will:                  */D   /*    1) do a DEFINE/JOB DECW$DISPLAY 'f$trnlnm(sys$error)'     */D   /*    2) then redefine SYS$ERROR to match SYS$OUTPUT!           */D   /*  This will propogate DECW$DISPLAY to the XTERM process!!!    */D   /*  Thanks go to Joel M Snyder who posted this info to INFO-VAX */   8   flags = PRC$M_INTER | PRC$M_NOPASSWORD | PRC$M_DETACH;>   status = sys$creprc(&pid,&image,&tt_name_desc,&tt_name_desc,1 		      &ws_name_desc,0,0,0,4,uic,mbxunit,flags); /   if(!(status & SS$_NORMAL)) CloseDown(status);       9   /* hang a read on the mailbox waiting for completion */ 
   mbx_read();       J /* set time value and schedule a periodic wakeup (every 1/100 of a second)H  * this is used to prevent the controlling process from using up all theF  * CPU.  The controlling process will hibernate at strategic points in1  * the program when it is just waiting for input.   */    %   status = sys$bintim(&dtime,&delta); 0   if (!(status & SS$_NORMAL)) CloseDown(status);   )   status = sys$schdwk(0,0,&delta,&delta); 0   if (!(status & SS$_NORMAL)) CloseDown(status);         /*A    * This is rather funky, but it saves me from having to totally H    * rewrite some parts of the code (namely in_put in module CHARPROC.C)    */ 
   pty = 1;   screen->respond = pty;   pty_mask = 1 << pty;   Select_mask = pty_mask;    X_mask = 1 << Xsocket;   }      /*D  * This routine handles completion of write with echo.  It takes theH  * echo buffer and puts it on the read queue.  It will then be processedG  * by the routine tt_read.  If the echo buffer is empty, it is put back   * on the free buffer queue.  */   " static void tt_echo_ast(buff_addr)!      struct tt_buffer *buff_addr;    { 
   int status;      if (buff_addr->length != 0)      { 2       status = LIB$INSQTI(buff_addr, &read_queue);>       if((status != SS$_NORMAL) && (status != LIB$_ONEENTQUE)) 	{	    	  CloseDown(status);  	}           }    else     {        freeBuff(buff_addr);     }  }      /*B  * This routine writes to the pseudo terminal.  If there is a freeG  * buffer then write with an echo buffer completing asyncronously, else H  * write syncronously using the buffer reserved for writing.  All errorsJ  *  are fatal, except DATAOVERUN and DATALOST,these errors can be ignored.  */     int tt_write(tt_write_buf,size)       char *tt_write_buf;      int size; { 
   int status;    struct tt_buffer *echoBuff;   .   /* if writing stopped, return 0 until Xon */   if(write_stopped) return (0);   0   memmove(&tt_w_buff->data,tt_write_buf,size);        echoBuff = getBuff(); !   if (echoBuff != LIB$_QUEWASEMP)      { :       status = PTD$WRITE (tt_chan, &tt_echo_ast, echoBuff, 			  &tt_w_buff->status, size,  % 			  &echoBuff->status, BUFFER_SIZE);      }    else     { I       status = PTD$WRITE (tt_chan, 0, 0, &tt_w_buff->status, size, 0, 0);      }    if (status & SS$_NORMAL)       { .       if ((tt_w_buff->status != SS$_NORMAL) &&+ 	  (tt_w_buff->status != SS$_DATAOVERUN) && ' 	  (tt_w_buff->status != SS$_DATALOST))  	{! 	  CloseDown(tt_w_buff->status);   	}           }    else     {        CloseDown(status);	        }      return(size);  }       /*G  * This routine is called when a read to the pseudo terminal completes. G  * Put the newly read buffer onto the read queue.  It will be processed $  * and freed in the routine tt_read.  */    " static void tt_read_ast(buff_addr)"      struct tt_buffer  *buff_addr; { 
   int status;   %   if (buff_addr->status & SS$_NORMAL)      { 2       status = LIB$INSQTI(buff_addr, &read_queue);?       if ((status != SS$_NORMAL) && (status != LIB$_ONEENTQUE))  	{	    	  CloseDown(status);  	}           }    else!     CloseDown(buff_addr->status);      tt_start_read();   sys$wake(0,0);	   return;  }       /*H  * If there is a free buffer on the buffer queue then Start a read from K  * the pseudo terminal, otherwise set a flag, the reading will be restarted 2  * in the routine freeBuff when a buffer is freed.  */    static void tt_start_read(void)  { 
   int status;    static int size;     struct tt_buffer *buff_addr;        buff_addr = getBuff();"   if (buff_addr != LIB$_QUEWASEMP)     { =       status = PTD$READ (0, tt_chan, &tt_read_ast, buff_addr, % 			 &buff_addr->status, BUFFER_SIZE); .       if ((status & SS$_NORMAL) != SS$_NORMAL) 	{ 	  CloseDown(status);	 	}     }    else     {        read_stopped = TRUE;     } 	   return;  }      /*J  * Get data from the pseudo terminal.  Return the data from the first itemJ  * on the read queue, and put that buffer back onto the free buffer queue.8  * Return the length or zero if the read queue is empty.  */    int tt_read(buffer)    char *buffer;  {    struct tt_buffer *read_buff;
   int status; 
   int len;  0    status = LIB$REMQHI(&read_queue, &read_buff);    if(status == LIB$_QUEWASEMP)       return(0);      else if (status & SS$_NORMAL)      {        len = read_buff->length; ,        memmove(buffer,&read_buff->data,len);!        freeBuff(read_buff);             }    else       CloseDown(status);        return(len);  }      /*1  * if xon then it is safe to start writing again.   */    static void send_xon(void) {    write_stopped = FALSE;     }      /*F  * If Xoff then stop writing to the pseudo terminal until you get Xon.  */  static void send_xoff(void)  {    write_stopped = TRUE;  }        /*C  * Beep the terminal to let the user know data will be lost because   * of too much data.  */    static void send_bell(void)  {   
    Bell(); }    /*  G  * if the pseudo terminal's characteristics change, check to see if the F  * page size changed.  If it did, resize the widget, otherwise, ignoreF  * it!  This routine just gets the new term dimensions and sets a flagG  * to indicate the term chars have changed.  The widget gets resized in D  * the routine in_put in the module CHARPROC.C.  You cant resize theI  * widget in this routine because this is an AST and X is not reenterent.   */    static void char_change(void)  { 
   int status;    extern XtermWidget   term;     /*%    * Dont do anything if in Tek mode      */      if(!(term->screen.TekEmu))     { J       status = sys$qiow(0,tt_chan,IO$_SENSEMODE,0,0,0,&tt_mode,8,0,0,0,0);3       if(!(status & SS$_NORMAL)) CloseDown(status);        5       if((term->screen.max_row != tt_mode.length) ||  / 	 (term->screen.max_col != tt_mode.page_width))  	{ 	  tt_length = tt_mode.length;" 	  tt_width =  tt_mode.page_width; 	    	  tt_changed = TRUE;  	    	}     }  }      /*  @  * Put a free buffer back onto the buffer queue.  If reading was9  * stopped for lack of free buffers, start reading again.   */*    static void freeBuff (buff_addr)!      struct tt_buffer *buff_addr;d {    int ast_stat;t
   int status;t     ast_stat = SYS$SETAST(0);    if (!read_stopped)     { +       LIB$INSQHI(buff_addr, &buffer_queue);n     }l   else     {e=       status = PTD$READ (0, tt_chan, &tt_read_ast, buff_addr,1% 			 &buff_addr->status, BUFFER_SIZE);h       if (status & SS$_NORMAL)   	{ 	  read_stopped = FALSE; 	}
       else 	{ 	  CloseDown(status);	   	}     }t:   if (ast_stat == SS$_WASSET) ast_stat = SYS$SETAST(1);	   }      /*.  * return a free buffer from the buffer queue.  */    struct tt_buffer *getBuff(void)i { 
   int status;    struct tt_buffer *buff_addr;  1   status = LIB$REMQHI(&buffer_queue, &buff_addr);e   if (status & SS$_NORMAL)     {        return(buff_addr);     }.   else     {T       return(status);d     }n }D  e   /*?  * Close down and exit.  Kill the detached process (if it still2@  * exists), deassign mailbox channell (if assigned), cancel any A  * waiting IO to the pseudo terminal and delete it, exit with anyn  * status information.  */n  " static void CloseDown(exit_status)      int exit_status;T {_
   int status;   1   /* if process has not terminated, do so now! */V   if(pid != 0) f     {       $       status = sys$forcex(&pid,0,0);4       if(!(status & SS$_NORMAL)) lib$signal(status);     }    ,   /* if mbx_chan is assigned, deassign it */   if(mbx_chan != 0)a     {        sys$dassgn(mbx_chan);u     }i   *   /* cancel pseudo terminal IO requests */   status = ptd$cancel(tt_chan);t0   if(!(status & SS$_NORMAL)) lib$signal(status);     /* delete pseudo terminal */   status = ptd$delete(tt_chan);d0   if(!(status & SS$_NORMAL)) lib$signal(status);   :   if(!(exit_status & SS$_NORMAL)) lib$signal(exit_status);  
   exit(1);   }      /*E  * This routine gets called when the detached process terminates (fortF  * whatever reason).  The mailbox buffer has final exit status.  Close  * down and exit.k  */h   static void mbx_read_ast(void) { 
   int status;E      pid = 0;         status = mbx_read_iosb.status;0   if (!(status & SS$_NORMAL)) CloseDown(status);  q6   status = (unsigned long int) mbx_buf.acc$l_finalsts;0   if (!(status & SS$_NORMAL)) CloseDown(status);     CloseDown(1);   _ }e  ]   /*I  * This routine starts a read on the mailbox associated with the detachedaN  * process.  The AST routine gets called when the detached process terminates.  */_   static void mbx_read(void) {  int status;t static int size;  p    size = ACC$K_TERMLEN;    status = sys$qio(0,mbx_chan,            IO$_READVBLK,            &mbx_read_iosb,h           &mbx_read_ast,           0,           &mbx_buf,f           size,0,0,0,0);  1    if (!(status & SS$_NORMAL)) CloseDown(status);E   
    return; }e            