/* Constants */

/* Fudge factors
 *
 * The higher FV is, the slower the system runs, but the more accurately it
 * runs.  If you see stars shooting off very quickly when they get close
 * together, then that is a sign that FV is way too small.  If you notice that
 * the star system gains energy over time (stars are moving further out),
 * then that is a sign that FV is not large enough.  In general, the larger
 * FV, the longer the star system will continue to have "interesting" 
 * interactions because all of the stars will stay on the screen.
 *
 * If you see the user falling a sleep because things are running too
 * slowly, then that is a sign that FV is too large.  If you see both
 * things happening, that that is a sign that you need a faster
 * computer.
 *
 *
 * The higher FM is, the more massive the star systems will be and the more
 * the stars will tend to fall in toward the center.  This fudge factor may
 * need to be changed if you don't use the default of 15 stars.  Either that,
 * or you could fix up the formulas in init_stars() to handle a larger range.
 *
 * Care has been taken to only apply these fudge factors to constants so that
 * the compiler can fold the constants together and thus you don't incur
 * any extra overhead.  
 *
 *
 * Note:  Changing these fudge factors will probably cause other parts of
 *        the system to become unbalanced.  Especially things related to
 *	  how fast the computer is.
 */

#ifdef VMS
#define SIGSTOP  22
#define SIGTSTP  23
#define SIGXCPU 999
#define random rand
#define srandom srand
#define lrand48 rand
#define srand48 srand
unsigned long int statvms;
unsigned long int LIB$WAIT();     /* VMS timer routine */
float seconds;
#endif

#ifndef FV
#define FV	(1.6)			/* larger values => slower movement */
#endif
#define FG	(16.0)			/* don't change			*/
#ifndef FM
#define FM	(1.0/(30*FG*FV))	/* larger values => move atraction */
#endif

/* #define G ((FG*FG)/256.) */
#define G	(1.0)


#ifndef NUM_COLORS
#define NUM_COLORS 48	  /* numbers of colors to rotate through	*/
#endif


/* How much momentum is not absorbed in a collision (i.e. converted to heat) */
#define BUMPERS 0.95


#define TRUE 1
#define FALSE 0
#define STD_STR 100
#define STARS   15        /* number of stars */
#define DELAY   0	  /* microsecond delay between updates */
#define STARAREA 9362.3   /* how crowded stars should be */
#define COLLAPSAR (50.0)	  /* mass of a collapsar		*/
#define WINWIDTH 512      /* default window width */
#define WINHEIGHT 512     /* default window height */
#define ALIVE_MASK      (SubstructureNotifyMask | KeyPressMask | PointerMotionMask)
#define MAX_CVAL	65535		/* maximum value of a color	*/
#define POLL_SKIP	64		/* keep a power of 2		*/
#define MAX_COLLAPSAR	5		/* max number of initial collapsars */

/* define these to enable the experimental code.  Does not work correctly */
#if 0
#define bounce_stars
#define bounce_debug
#endif


/* Error Codes */
#define FATAL   -1
#define WARNING -2

/* Macros */
#define RAND(v) ((lrand48() % v) - (v/2)) /* random number around 0 */
#define array_elem(x)	(sizeof(x)/sizeof(x[0]))

/* Type Definitions */
typedef struct _disp
{
        Window  win;
        Display *dpy;
        int     screen;
        Window  root;
        char    *dname;
        long    star, bg; /* colors */
        XColor  bg_xcolor;
        GC      star_gc;
        GC      erase_gc;
        Atom    kill_atom, protocol_atom;
        Colormap cmap;
} disp;

typedef struct
{
    double	x, y;
} point_2d;




/*--------------------------- Function Prototypes ---------------------------*/

void
Quit(
#ifdef __STDC__
int signal
#endif
);

void    Initialize();

void
Parse_Arguments(
#ifdef __STDC__
int  argc,
char **argv,
char **geometry
#endif
);

void
Change_Screen_Saver(
#ifdef __STDC__
int
#endif
);

void
Traverse_Tree(
#ifdef __STDC__
Display *,
Window
#endif
);

void Wait_For_Idleness();

Bool
Dummy_Predicate(
#ifdef __STDC__
Display *,
XEvent *,
char *
#endif
);

void Create_Big_Window();

void
Create_Window(
#ifdef __STDC__
char *
#endif
);

void init_stars( point_2d *cur, point_2d *prev, point_2d *v,
		double *m, point_2d *a, point_2d *a_prev,
		XPoint *last_disp,
		int stars, int max_stars, int *min_stars,
		time_t *tstamp, int *live_stars,
		int *live_erase, int *erase_disps,
		XPoint *points, int *points_used );

void init_colors( XColor *star_colors, int num_elem );

void Animate();

void
HandleEvent(
#ifdef __STDC__
XEvent *
#endif
);

#ifndef HP_UX
void    nap();
#else

static void alarmhandler();

sleepms(
#ifdef __STDC__
int msec
#endif
);

usleep(
#ifdef __STDC__
int us
#endif
);

#endif

void    Usage(
#ifdef __STDC__
char *program
#endif
);

void    HandleError(
#ifdef __STDC__
char    *description,
int     degree
#endif
);

long
GetColor(
#ifdef __STDC__
disp            *display,
char            *color,
XColor          *final_color
#endif
);

void *
Safe_Malloc(
#ifdef __STDC__
int bytes
#endif
);

void *
Safe_Realloc(
#ifdef __STDC__
void *ptr,
int bytes
#endif
);


/*----------------------------- Global Variables ----------------------------*/

/* X related */
int             winX, winY;
double          root_xoff, root_yoff;
unsigned int    winW, winH;
int		half_winW, half_winH;
int		winW_20, winH_20;
unsigned int	far_dist;
disp            display;

/* animation related */
int     stars = STARS;          /* number of stars */
int     max_stars = STARS+5;    /* maximum number of stars */
        /* max_disp_skip is really MFLOPS dependent, but this hack will do */
int     max_disp_skip = (STARS*STARS)/2;    /* max num of displays to skip */
int     delay = DELAY * 1000;   /* delay between updates, in microseconds */
int     timeout = 0;            /* time in seconds before screen saving */
char    *star_color = NULL;
char    *bg_color = NULL;
XColor	star_colors[NUM_COLORS];
int	verbose = 0;
int	rotate_colors = 0;
int	init_colors_done = 0;
int	multi_colors = 0;
int     stop = FALSE;
int     add  = FALSE;           /* flag to add a collapsar */
int     add_star  = FALSE;      /* flag to add a star */
int     del_star  = FALSE;      /* flag to delete a star */
int     erase = FALSE;          /* flag to erase trails */
int     new_start = FALSE;      /* flag to start a new system trails */
int	pause_updt = FALSE;	/* flag to pause the updates	*/
int     root = FALSE;           /* display in root window */
double	collapsar = (FM*COLLAPSAR);
double	fv = FV;
double	fm = FM;

