/* yacc makeedge.y */
#line 1 "makeedge.y"

int	score;
extern int	position;
typedef union {
	struct {
		int	width;
		int	position;
		int	base;
	} field;
	int	ival;
} YYSTYPE;
#define WHITE	257
#define BLACK	258
#define EMPTY	259
#define IGNORE	260
#define NL	261
extern int yychar, yyerrflag;
extern YYSTYPE yyval;
extern YYSTYPE yylval;
#line 384 "makeedge.y"
# include	<stdio.h>

int	verbose;

main (argc, argv)
	int	argc;
	char	**argv;
{
	int	ret;

	if (argc > 1 && argv[1][0] == 'v')
		verbose = 1;
	ret = yyparse ();
	flush_output ();
	return ret;
}

char	line[80];
char	*lp = line;

yyerror (s)
char *s;
{
	fprintf (stderr, "%s in %s\n", s, line);
}

yywrap ()
{
	return 1;
}

int position = 1;

int base[] = { 0, 20, -30, 15, -5, -5, 15, -30, 20, 0 };

yylex ()
{
	char *gets();

	if (*lp == '\0')
		if (fgets (line, 80, stdin) == 0)
			return -1;
		else
			lp = line;
	for (;;) {
		switch (*lp++) {
		case ' ':
		case '\t':
			break;
		case '\n':
			lp[-1] = '\0';
			position = 1;
			return NL;
		case 'O':
			yylval.field.base = -
				base[yylval.field.position = position++];
			yylval.field.width = 1;
			return BLACK;
		case '*':
			yylval.field.base =
				base[yylval.field.position = position++];
			yylval.field.width = 1;
			return WHITE;
		case '-':
			yylval.field.base = 0;
			yylval.field.position = position++;
			yylval.field.width = 1;
			return EMPTY;
		case '?':
			return IGNORE;
		}
	}
}

#define	MAX_COLUMNS	8

int	column;

output (score, comment)
int	score;
char	*comment;
{
	if (verbose)
		printf ("\t%5d,\t/*%s */\n", score, comment);
	else
	{
		printf ("%d,", score);
		if (++column == MAX_COLUMNS) {
			printf ("\n");
			column = 0;
		}
	}
}

flush_output ()
{
	if (!verbose && column)
		printf ("\n");
}
static short yydef[] = {
	  -1,   -5,   -9,   10,    9,  -13,  -17,    5,  -21,    3, 
	  30,  -25,  -29,   30,  -33,  -37,   12,   11,  -41,  -45, 
	 -49,  -53,  -57,   10,    9,  -63,   30,  -69,  -73,   30, 
	 -79,  -83,  -89,  -93,  -97,   13, -101, -105, -111, -115, 
	-121, -125, -129
};
static short yyex[] = {
	   0,    0,   -1,    1,  261,    6,   -1,    1,  261,    4, 
	  -1,    1,  261,    7,   -1,    1,  261,    7,   -1,    1, 
	 261,    7,   -1,    1,  261,    8,   -1,    1,  261,    4, 
	  -1,    1,  261,    8,   -1,    1,  261,    6,   -1,    1, 
	 261,    7,   -1,    1,  261,    6,   -1,    1,  261,    7, 
	  -1,    1,  261,    4,   -1,    1,  257,   14,  261,   14, 
	  -1,    1,  258,   14,  261,   14,   -1,    1,  261,    7, 
	  -1,    1,  258,   14,  261,   14,   -1,    1,  261,    7, 
	  -1,    1,  257,   14,  261,   14,   -1,    1,  261,    7, 
	  -1,    1,  261,    7,   -1,    1,  261,    8,   -1,    1, 
	 261,    8,   -1,    1,  257,   14,  261,   14,   -1,    1, 
	 261,    7,   -1,    1,  258,   14,  261,   14,   -1,    1, 
	 261,    7,   -1,    1,  261,    7,   -1,    1,  261,    7, 
	  -1,    1
};
static short yyact[] = {
	 -69,  -67,  -49,  -48,  260,  259,  258,  257,  -69,  -67, 
	 -65,  259,  258,  257,  -69,  -68,  -65,  259,  258,  257, 
	 -70,  -67,  -65,  259,  258,  257,  -87,  261,  -69,  -68, 
	 -11,  259,  258,  257,  -70,  -67,  -14,  259,  258,  257, 
	 -69,  -67,  -66,  259,  258,  257,  -81,  261,  -82,  261, 
	 -83,  261,  -67,  258,  -69,  257,  -69,  -68,  -27,  259, 
	 258,  257,  -70,  -67,  -30,  259,  258,  257,  -80,  261, 
	 -68,  -65,  259,  258,  -70,  -65,  259,  257,  -69,  -67, 
	 258,  257,  -66,  259,   -1
};
static short yypact[] = {
	   4,   17,   23,   31,   37,   43,   43,   23,   43,   17, 
	  53,   43,   23,   55,   43,   17,   59,   65,   43,   17, 
	  43,   23,   72,   17,   23,   76,   53,   43,   76,   55, 
	  43,   72,   43,   43,   80,   83,   80,   72,   80,   76, 
	  80,   80,   80,   69,   51,   49,   47,   27,   11
};
static short yygo[] = {
	 -85,   -3,   -8,  -13,  -22,  -25,  -26,  -25,   -8,  -29, 
	  -8,  -13,  -40,  -25,  -25,   -5,  -18,   48,   36,   34, 
	  29,   23,   19,   16,   15,   14,   13,   11,    9,    3, 
	   1,    0,   -2,  -10,  -16,  -20,  -23,  -24,  -10,  -24, 
	 -32,  -10,  -16,  -38,  -24,  -24,   -4,  -17,   48,   36, 
	  34,   26,   24,   21,   17,   14,   12,   11,   10,    7, 
	   4,    2,    0,   -7,   -9,  -12,  -15,  -19,  -21,   -9, 
	  -7,  -28,  -31,  -33,  -34,  -12,  -15,   -6,  -36,   48, 
	  24,   23,   21,   19,   17,   16,   15,   12,    9,    7, 
	   4,    3,    2,    1,  -37,  -39,  -41,  -42,  -43,  -35, 
	  39,   37,   31,   28,   25,  -60,  -78,  -45,   21,   12, 
	 -61,  -74,  -46,   19,   15,  -59,  -62,  -63,  -58,   36, 
	  34,   14,  -88,  -64,   48,  -47,  -72,  -76,  -73,  -77, 
	 -54,  -56,  -75,  -79,  -50,  -51,  -55,  -57,  -44,   42, 
	  41,   40,   38,   33,   32,   30,   27,   20,   18,    8, 
	   6,  -71,  -53,  -52,   -1,  -84,   -1
};
static short yypgo[] = {
	   0,    0,    0,  107,  107,  112,  112,  138,  118,  123, 
	 123,  151,  151,   99,   99,  153,  152,  151,  151,  151, 
	 151,  151,  151,  123,  123,  123,  123,  125,  125,  118, 
	  78,   78,   47,   47,   16,   16,  138,  112,  112,  112, 
	 112,  107,  107,  107,  107,    0,    0,    0,    0,  154, 
	 154,  154,  155,  125,    0
};
static short yyrlen[] = {
	   0,    0,    0,    1,    0,    1,    0,    0,    0,    1, 
	   1,    1,    1,    1,    0,    4,    4,    1,    1,    3, 
	   5,    3,    5,    3,    3,    3,    3,    5,    5,    1, 
	   1,    2,    1,    2,    1,    2,    1,    2,    3,    3, 
	   4,    2,    3,    3,    4,    4,    3,    3,    3,    2, 
	   2,    0,    2,    1,    2
};
#define YYS0	85
#define YYDELTA	34
#define YYNPACT	49
#define YYNDEF	43

#define YYr52	0
#define YYr53	1
#define YYr54	2
#define YYr12	3
#define YYr14	4
#define YYr18	5
#define YYr20	6
#define YYr22	7
#define YYr30	8
#define YYr38	9
#define YYr39	10
#define YYr44	11
#define YYr45	12
#define YYr50	13
#define YYr51	14
#define YYr49	15
#define YYr48	16
#define YYr47	17
#define YYr46	18
#define YYr43	19
#define YYr42	20
#define YYr41	21
#define YYr40	22
#define YYr37	23
#define YYr36	24
#define YYr35	25
#define YYr34	26
#define YYr32	27
#define YYr31	28
#define YYr29	29
#define YYr28	30
#define YYr27	31
#define YYr26	32
#define YYr25	33
#define YYr24	34
#define YYr23	35
#define YYr21	36
#define YYr19	37
#define YYr17	38
#define YYr16	39
#define YYr15	40
#define YYr13	41
#define YYr11	42
#define YYr10	43
#define YYr9	44
#define YYr8	45
#define YYr7	46
#define YYr6	47
#define YYr5	48
#define YYr2	49
#define YYr1	50
#define YYrACCEPT	YYr52
#define YYrERROR	YYr53
#define YYrLR2	YYr54
#line 2 "/etc/yyparse.c"

/*
*****************************************************************************
**									    *
**  Copyright  Digital Equipment Corporation, 1990, 1991, 1992, 1993	    *
**  All Rights Reserved.  Unpublished rights reserved under  the  copyright *
**  laws of the United States.						    *
**									    *
**  The software contained on this media is proprietary to and embodies the *
**  confidential  technology of Digital Equipment Corporation.  Possession, *
**  use,  duplication  or  dissemination  of  the  software  and  media  is *
**  authorized  only  pursuant  to  a  valid  written  license from Digital *
**  Equipment Corporation.						    *
**									    *
**  RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the  U.S. *
**  Government  is  subject  to  restrictions  as set forth in Subparagraph *
**  (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.   *
**									    *
*****************************************************************************
*/

/*
 * Copyright 1985, 1990 by Mortice Kern Systems Inc.  All rights reserved.
 *
 * This Software is unpublished, valuable, confidential property of
 * Mortice Kern Systems Inc.  Use is authorized only in accordance
 * with the terms and conditions of the source licence agreement
 * protecting this Software.  Any unauthorized use or disclosure of
 * this Software is strictly prohibited and will result in the
 * termination of the licence agreement.
 *
 * If you have any questions, please consult your supervisor.
 * 
 * Automaton to interpret LALR(1) tables.
 *
 *	Macros:
 *		yyclearin - clear the lookahead token.
 *		yyerrok - forgive a pending error
 *		YYERROR - simulate an error
 *		YYACCEPT - halt and return 0
 *		YYABORT - halt and return 1
 *		YYRETURN(value) - halt and return value.  You should use this
 *			instead of return(value).
 *		YYREAD - ensure yychar contains a lookahead token by reading
 *			one if it does not.  See also YYSYNC.
 *		YYRECOVERING - 1 if syntax error detected and not recovered
 *			yet; otherwise, 0.
 *
 *	Preprocessor flags:
 *		YYDEBUG - includes debug code.  The parser will print
 *			 a travelogue of the parse if this is defined
 *			 and yydebug is non-zero.
 *		YYSSIZE - size of state and value stacks (default 150).
 *		YYSTATIC - By default, the state stack is an automatic array.
 *			If this is defined, the stack will be static.
 *			In either case, the value stack is static.
 *		YYALLOC - Dynamically allocate both the state and value stacks
 *			by calling malloc() and free().
 *		YYLR2 - defined if lookahead is needed to resolve R/R or S/R conflicts
 *		YYSYNC - if defined, yacc guarantees to fetch a lookahead token
 *			before any action, even if it doesnt need it for a decision.
 *			If YYSYNC is defined, YYREAD will never be necessary unless
 *			the user explicitly sets yychar = -1
 *
 *	Copyright (c) 1983, by the University of Waterloo
 */

/* GENTEXT: yyerror */
#ifndef I18N
#define	gettext(x)	x 
#else
#define	gettext(x)	x             /* <<< modified! */
#endif

#ifndef YYSSIZE
# define YYSSIZE	150
#endif
#ifndef	YYDEBUG
#define	YYDEBUG	0
#endif
#define YYERROR		goto yyerrlabel
#define yyerrok		yyerrflag = 0
#define yyclearin	yychar = -1
#define YYACCEPT	YYRETURN(0)
#define YYABORT		YYRETURN(1)
#define YYRECOVERING()	(yyerrflag != 0)
#ifdef YYALLOC
# define YYRETURN(val)	{ retval = (val); goto yyReturn; }
#else
# define YYRETURN(val)	return(val)
#endif
#if YYDEBUG
/* The if..else makes this macro behave exactly like a statement */
# define YYREAD	if (yychar < 0) {					\
			if ((yychar = yylex()) < 0)			\
				yychar = 0;				\
			if (yydebug)					\
				printf(gettext("read %s (%d)\n"), 	\
				yyptok(yychar),				\
				yychar);				\
		} else
#else
# define YYREAD	if (yychar < 0) {					\
			if ((yychar = yylex()) < 0)			\
				yychar = 0;				\
		} else
#endif
#define YYERRCODE	256		/* value of `error' */
#if 0 && defined(__TURBOC__) && __SMALL__
	/* THIS ONLY WORKS ON TURBO C 1.5 !!! */
#define	YYQYYP	*(int *)((int)yyq + ((int)yyq-(int)yyp))
#else
#define	YYQYYP	yyq[yyq-yyp]
#endif

YYSTYPE	yyval;				/* $$ */
YYSTYPE	*yypvt;				/* $n */
YYSTYPE	yylval;				/* yylex() sets this */

int	yychar,				/* current token */
	yyerrflag,			/* error flag */
	yynerrs;			/* error count */

#if YYDEBUG
int yydebug = 0;		/* debug flag & tables */
extern char	*yysvar[], *yystoken[], *yyptok();
extern short	yyrmap[], yysmap[];
extern int	yynstate, yynvar, yyntoken, yynrule;
# define yyassert(condition, msg, arg) \
	if (!(condition)) { printf(gettext("\nyacc bug: ")); printf(msg, arg); YYABORT; }
#else /* !YYDEBUG */
# define yyassert(condition, msg, arg)
#endif

yyparse()
{

	register short		yyi, *yyp;	/* for table lookup */
	register short		*yyps;		/* top of state stack */
	register short		yystate;	/* current state */
	register YYSTYPE	*yypv;		/* top of value stack */
	register short		*yyq;
	register int		yyj;

#ifdef YYSTATIC
	static short	yys[YYSSIZE + 1];
	static YYSTYPE	yyv[YYSSIZE + 1];
#else
#ifdef YYALLOC
	YYSTYPE *yyv;
	short	*yys;
	YYSTYPE save_yylval;
	YYSTYPE save_yyval;
	YYSTYPE *save_yypvt;
	int save_yychar, save_yyerrflag, save_yynerrs;
	int retval;
#if 0	/* defined in <stdlib.h>*/
	extern char	*malloc();
#endif
#else
	short		yys[YYSSIZE + 1];
	static YYSTYPE	yyv[YYSSIZE + 1];	/* historically static */
#endif
#endif

#ifdef YYALLOC
	yys = (short *) malloc((YYSSIZE + 1) * sizeof(short));
	yyv = (YYSTYPE *) malloc((YYSSIZE + 1) * sizeof(YYSTYPE));
	if (yys == (short *)0 || yyv == (YYSTYPE *)0) {
		yyerror("Not enough space for parser stacks");
		return 1;
	}
	save_yylval = yylval;
	save_yyval = yyval;
	save_yypvt = yypvt;
	save_yychar = yychar;
	save_yyerrflag = yyerrflag;
	save_yynerrs = yynerrs;
#endif

	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;
	yyps = yys;
	yypv = yyv;
	yystate = YYS0;		/* start state */

yyStack:
	yyassert((unsigned)yystate < yynstate, gettext("state %d\n"), yystate);
	if (++yyps > &yys[YYSSIZE]) {
		yyerror("Parser stack overflow");
		YYABORT;
	}
	*yyps = yystate;	/* stack current state */
	*++yypv = yyval;	/* ... and value */

#if YYDEBUG
	if (yydebug)
		printf(gettext("state %d (%d), char %s (%d)\n"),yysmap[yystate],
			yystate, yyptok(yychar), yychar);
#endif

	/*
	 *	Look up next action in action table.
	 */
yyEncore:
#ifdef YYSYNC
	YYREAD;
#endif
	if (yystate >= sizeof yypact/sizeof yypact[0]) 	/* simple state */
		yyi = yystate - YYDELTA;	/* reduce in any case */
	else {
		if(*(yyp = &yyact[yypact[yystate]]) >= 0) {
			/* Look for a shift on yychar */
#ifndef YYSYNC
			YYREAD;
#endif
			yyq = yyp;
			yyi = yychar;
#if 0 && defined(__TURBOC__) && __SMALL__
	/* THIS ONLY WORKS ON TURBO C 1.5 !!! */
			/* yyi is in di, yyp is in si */
		L01:
			asm lodsw	/* ax = *yyp++; */
			asm cmp yyi, ax
			asm jl L01
#else
			while (yyi < *yyp++)
				;
#endif
			if (yyi == yyp[-1]) {
				yystate = ~YYQYYP;
#if YYDEBUG
				if (yydebug)
					printf(gettext("shift %d (%d)\n"),
						yysmap[yystate], yystate);
#endif
				yyval = yylval;		/* stack what yylex() set */
				yychar = -1;		/* clear token */
				if (yyerrflag)
					yyerrflag--;	/* successful shift */
				goto yyStack;
			}
		}

		/*
	 	 *	Fell through - take default action
	 	 */

		if (yystate >= sizeof yydef /sizeof yydef[0])
			goto yyError;
		if ((yyi = yydef[yystate]) < 0)	 { /* default == reduce? */
											/* Search exception table */
			yyassert((unsigned)~yyi < sizeof yyex/sizeof yyex[0],
				gettext("exception %d\n"), yystate);
			yyp = &yyex[~yyi];
#ifndef YYSYNC
			YYREAD;
#endif
			while((yyi = *yyp) >= 0 && yyi != yychar)
				yyp += 2;
			yyi = yyp[1];
			yyassert(yyi >= 0,
				 gettext("Ex table not reduce %d\n"), yyi);
		}
	}

#ifdef YYLR2
yyReduce:	/* reduce yyi */
#endif
	yyassert((unsigned)yyi < yynrule, gettext("reduce %d\n"), yyi);
	yyj = yyrlen[yyi];
#if YYDEBUG
	if (yydebug) printf(gettext("reduce %d (%d), pops %d (%d)\n"), 
		yyrmap[yyi], yyi, yysmap[yyps[-yyj]], yyps[-yyj]);
#endif
	yyps -= yyj;		/* pop stacks */
	yypvt = yypv;		/* save top */
	yypv -= yyj;
	yyval = yypv[1];	/* default action $$ = $1 */
	switch (yyi) {		/* perform semantic action */
		
case YYr1: {	/* lines :  lines line */
#line 19 "makeedge.y"
 output (yypvt[0].field.base, line); 
} break;

case YYr2: {	/* lines :  lines ignore */
#line 21 "makeedge.y"
 output (0, "ignore"); 
} break;

case YYr5: {	/* line :  whites type1 NL */
#line 27 "makeedge.y"
 yyval.field.base = 20 * yypvt[-2].field.width + yypvt[-1].field.base; 
} break;

case YYr6: {	/* line :  blacks type2 NL */
#line 29 "makeedge.y"
 yyval.field.base = -20 * yypvt[-2].field.width + yypvt[-1].field.base; 
} break;

case YYr7: {	/* line :  EMPTY type3 NL */
#line 31 "makeedge.y"
 yyval.field.base = yypvt[-1].field.base; 
} break;

case YYr8: {	/* line :  EMPTY empties otype4 NL */
#line 33 "makeedge.y"
 yyval.field.base = yypvt[-1].field.base; 
} break;

case YYr9: {	/* type1 :  blacks whites empties otype4 */
#line 36 "makeedge.y"

				yyval.field.base = yypvt[0].field.base;
				switch (yypvt[-2].field.position) {
				case 7:
					yyval.field.base -= (yypvt[-2].field.width + yypvt[-3].field.width+1) * 15;
					break;
				default:
					if (yypvt[-1].field.width == 1)
						yyval.field.base -=
						(yypvt[-3].field.width + yypvt[-2].field.width+1) * 15;
					else
						yyval.field.base +=
						(yypvt[-2].field.width - yypvt[-3].field.width) * 20;
					break;
				}
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-3].field.width + yypvt[-2].field.width + yypvt[-1].field.width;
			
} break;

case YYr10: {	/* type1 :  blacks whites type1 */
#line 55 "makeedge.y"

				yyval.field.base = yypvt[0].field.base;
				yyval.field.base -= (yypvt[-2].field.width - yypvt[-1].field.width) * 20;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
			
} break;

case YYr11: {	/* type1 :  blacks empties otype4 */
#line 62 "makeedge.y"

				yyval.field.base = (yypvt[-2].field.width + 1) * 15 + yypvt[0].field.base;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
			
} break;

case YYr12: {	/* type1 :  blacks */
#line 68 "makeedge.y"

				yyval.field = yypvt[0].field;
				yyval.field.base = - yypvt[0].field.width * 20;
			
} break;

case YYr13: {	/* type1 :  empties otype4 */
#line 73 "makeedge.y"

				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-1].field.width+yypvt[0].field.width;
				yyval.field.base = yypvt[0].field.base;
			
} break;

case YYr14: {	/* type1 :  */
#line 79 "makeedge.y"
 yyval.field.position = position; yyval.field.width = 0; yyval.field.base = 0; 
} break;

case YYr15: {	/* type2 :  whites blacks empties otype4 */
#line 82 "makeedge.y"

				yyval.field.base = yypvt[0].field.base;
				switch (yypvt[-2].field.position) {
				case 7:
					yyval.field.base += (yypvt[-2].field.width + yypvt[-3].field.width+1) * 15;
					break;
				default:
					if (yypvt[-1].field.width == 1)
						yyval.field.base +=
						(yypvt[-3].field.width + yypvt[-2].field.width+1) * 15;
					else
						yyval.field.base -=
						(yypvt[-2].field.width - yypvt[-3].field.width) * 20;
					break;
				}
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-3].field.width + yypvt[-2].field.width + yypvt[-1].field.width
					 + yypvt[0].field.width;
			
} break;

case YYr16: {	/* type2 :  whites blacks type2 */
#line 102 "makeedge.y"

				yyval.field.base = yypvt[0].field.base;
				yyval.field.base += (yypvt[-2].field.width - yypvt[-1].field.width) * 20;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
			
} break;

case YYr17: {	/* type2 :  whites empties otype4 */
#line 109 "makeedge.y"

				yyval.field.base = - (yypvt[-2].field.width + 1) * 15 + yypvt[0].field.base;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
			
} break;

case YYr18: {	/* type2 :  whites */
#line 115 "makeedge.y"

				yyval.field = yypvt[0].field;
				yyval.field.base = yypvt[0].field.width * 20;
			
} break;

case YYr19: {	/* type2 :  empties otype4 */
#line 120 "makeedge.y"

				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-1].field.width+yypvt[0].field.width;
				yyval.field.base = yypvt[0].field.base;
			
} break;

case YYr20: {	/* type2 :  */
#line 126 "makeedge.y"
 yyval.field.position = 0; yyval.field.width = 0; yyval.field.base = 0; 
} break;

case YYr21: {	/* otype4 :  type4 */
#line 129 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr22: {	/* otype4 :  */
#line 131 "makeedge.y"
 yyval.field.position = position; yyval.field.width = 0; yyval.field.base = 0; 
} break;

case YYr23: {	/* whites :  whites WHITE */
#line 134 "makeedge.y"

				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.base = yypvt[-1].field.base + yypvt[0].field.base;
			
} break;

case YYr24: {	/* whites :  WHITE */
#line 140 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr25: {	/* blacks :  blacks BLACK */
#line 143 "makeedge.y"

				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.base = yypvt[-1].field.base + yypvt[0].field.base;
			
} break;

case YYr26: {	/* blacks :  BLACK */
#line 149 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr27: {	/* empties :  empties EMPTY */
#line 152 "makeedge.y"

				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.base = yypvt[-1].field.base + yypvt[0].field.base;
			
} break;

case YYr28: {	/* empties :  EMPTY */
#line 158 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr29: {	/* otype3e :  type3e */
#line 161 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr30: {	/* otype3e :  */
#line 163 "makeedge.y"
 yyval.field.position = position; yyval.field.width = 0; yyval.field.base = 0; 
} break;

case YYr31: {	/* type3 :  whites EMPTY whites oempties otype3e */
#line 166 "makeedge.y"

				yyval.field.base = -(yypvt[-4].field.width + yypvt[-2].field.width + 2) * 15 +
					yypvt[0].field.base;
				yyval.field.width = yypvt[-4].field.width + yypvt[-3].field.width + yypvt[-2].field.width 
					 + yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
			
} break;

case YYr32: {	/* type3 :  blacks EMPTY blacks oempties otype3e */
#line 174 "makeedge.y"

				yyval.field.base = (yypvt[-4].field.width + yypvt[-2].field.width + 2) * 15 +
					yypvt[0].field.base;
				yyval.field.width = yypvt[-4].field.width + yypvt[-3].field.width + yypvt[-2].field.width 
					 + yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
			
} break;

case YYr34: {	/* type3e :  whites blacks type2 */
#line 184 "makeedge.y"

				yyval.field.base = -15 * (yypvt[-2].field.width + yypvt[-1].field.width + 1);
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
			
} break;

case YYr35: {	/* type3e :  blacks whites type1 */
#line 190 "makeedge.y"

				yyval.field.base = 15 * (yypvt[-2].field.width + yypvt[-1].field.width + 1);
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
			
} break;

case YYr36: {	/* type3e :  whites empties otype3e */
#line 196 "makeedge.y"

				if (yypvt[-2].field.position - yypvt[-2].field.width == 1) {
					switch (yypvt[-2].field.width) {
					case 1:
						yyval.field.base = -30;
						break;
					case 6:
						yyval.field.base = -20;
						break;
					case 2:
						yyval.field.base = -15;
						break;
					case 3:
						yyval.field.base = -10;
						break;
					case 4:
						yyval.field.base = -5;
						break;
					case 5:
						yyval.field.base = 10;
						break;
					default:
						yyerror ("weirdo");
						break;
					}
				} else {
					yyval.field.base = yypvt[-2].field.base;
				}
				yyval.field.base += yypvt[0].field.base;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
			
} break;

case YYr37: {	/* type3e :  blacks empties otype3e */
#line 229 "makeedge.y"

				if (yypvt[-2].field.position - yypvt[-2].field.width == 1) {
					switch (yypvt[-2].field.width) {
					case 1:
						yyval.field.base = 30;
						break;
					case 6:
						yyval.field.base = 20;
					break;
					case 2:
						yyval.field.base = 15;
						break;
					case 3:
						yyval.field.base = 10;
						break;
					case 4:
						yyval.field.base = 5;
						break;
					case 5:
						yyval.field.base = -10;
						break;
					default:
						yyerror ("weirdo");
						break;
					}
				} else {
					yyval.field.base = yypvt[-2].field.base;
				}
				yyval.field.base += yypvt[0].field.base;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
			
} break;

case YYr38: {	/* type3e :  whites */
#line 262 "makeedge.y"

				yyval.field.base = 20 * yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[0].field.width;
			
} break;

case YYr39: {	/* type3e :  blacks */
#line 268 "makeedge.y"

				yyval.field.base = -20 * yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[0].field.width;
			
} break;

case YYr40: {	/* type4 :  whites EMPTY whites oempties otype4 */
#line 275 "makeedge.y"

			if (yypvt[-1].field.position == 8) {
				yyval.field.base = -(yypvt[-4].field.width + yypvt[-2].field.width + 2) * 15;
			} else {
				yyval.field.base = 0;
				if (yypvt[-4].field.position - yypvt[-4].field.width + 1 == 3)
					yyval.field.base = yypvt[-4].field.width * 15;
				else
					yyval.field.base = yypvt[-4].field.base;
				if (yypvt[-2].field.position == 6)
					yyval.field.base += yypvt[-2].field.width * 15;
				else
					yyval.field.base += yypvt[-2].field.base;
				yyval.field.base += yypvt[0].field.base;
			}
			yyval.field.width = yypvt[-4].field.width + yypvt[-3].field.width + yypvt[-2].field.width
				 + yypvt[-1].field.width + yypvt[0].field.width;
			yyval.field.position = yypvt[0].field.position;
		
} break;

case YYr41: {	/* type4 :  whites empties otype4 */
#line 295 "makeedge.y"

				if (yypvt[-2].field.position - yypvt[-2].field.width + 1 == 3)
					yyval.field.base = yypvt[-2].field.width * 15 + yypvt[0].field.base;
				else if (yypvt[-2].field.position == 6)
					yyval.field.base = yypvt[-2].field.width * 15 + yypvt[0].field.base;
				else
					yyval.field.base = yypvt[-2].field.base + yypvt[0].field.base;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
			
} break;

case YYr42: {	/* type4 :  blacks EMPTY blacks oempties otype4 */
#line 306 "makeedge.y"

			if (yypvt[-1].field.position == 8) {
				yyval.field.base = (yypvt[-4].field.width + yypvt[-2].field.width + 2) * 15;
			} else {
				yyval.field.base = 0;
				if (yypvt[-4].field.position - yypvt[-4].field.width + 1 == 3)
					yyval.field.base = -yypvt[-4].field.width * 15;
				else
					yyval.field.base = yypvt[-4].field.base;
				if (yypvt[-2].field.position == 6)
					yyval.field.base +=  -yypvt[-2].field.width * 15;
				else
					yyval.field.base += yypvt[-2].field.base;
				yyval.field.base += yypvt[0].field.base;
			}
			yyval.field.width = yypvt[-4].field.width + yypvt[-3].field.width + yypvt[-2].field.width
				 + yypvt[-1].field.width + yypvt[0].field.width;
			yyval.field.position = yypvt[0].field.position;
		
} break;

case YYr43: {	/* type4 :  blacks empties otype4 */
#line 326 "makeedge.y"

				if (yypvt[-2].field.position - yypvt[-2].field.width + 1 == 3)
					yyval.field.base = -yypvt[-2].field.width * 15 + yypvt[0].field.base;
				else if (yypvt[-2].field.position == 6)
					yyval.field.base = -yypvt[-2].field.width * 15 + yypvt[0].field.base;
				else
					yyval.field.base = yypvt[-2].field.base + yypvt[0].field.base;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
			
} break;

case YYr44: {	/* type4 :  whites */
#line 337 "makeedge.y"

				yyval.field.base = 20 * yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[0].field.width;
			
} break;

case YYr45: {	/* type4 :  blacks */
#line 343 "makeedge.y"

				yyval.field.base = -20 * yypvt[0].field.width;
				yyval.field.position = yypvt[0].field.position;
				yyval.field.width = yypvt[0].field.width;
			
} break;

case YYr46: {	/* type4 :  type4.w */
#line 349 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr47: {	/* type4 :  type4.b */
#line 351 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr48: {	/* type4.w :  whites blacks oempties otype4 */
#line 354 "makeedge.y"

			if (yypvt[-2].field.position == 8)
				yyval.field.base = - (yypvt[-3].field.width + yypvt[-2].field.width + 1) * 15;
			else if (yypvt[-1].field.position == 8 && yypvt[-1].field.width == 1)
				yyval.field.base = (yypvt[-3].field.width + yypvt[-2].field.width + 1) * 10;
			else
				yyval.field.base = yypvt[-3].field.base + yypvt[-2].field.base + yypvt[0].field.base;
			yyval.field.position = yypvt[0].field.position;
			yyval.field.width = yypvt[-3].field.width + yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
		
} break;

case YYr49: {	/* type4.b :  blacks whites oempties otype4 */
#line 366 "makeedge.y"

			if (yypvt[-2].field.position == 8)
				yyval.field.base = (yypvt[-3].field.width + yypvt[-2].field.width + 1) * 15;
			else if (yypvt[-1].field.position == 8 && yypvt[-1].field.width == 1)
				yyval.field.base = - (yypvt[-3].field.width + yypvt[-2].field.width + 1) * 10;
			else
				yyval.field.base = yypvt[-3].field.base + yypvt[-2].field.base + yypvt[0].field.base;
			yyval.field.position = yypvt[0].field.position;
			yyval.field.width = yypvt[-3].field.width + yypvt[-2].field.width + yypvt[-1].field.width + yypvt[0].field.width;
		
} break;

case YYr50: {	/* oempties :  empties */
#line 378 "makeedge.y"
 yyval.field = yypvt[0].field; 
} break;

case YYr51: {	/* oempties :  */
#line 380 "makeedge.y"
 yyval.field.position = position; yyval.field.width = 0; yyval.field.base = 0; 
} break;
#line 237 "/etc/yyparse.c"
	case YYrACCEPT:
		YYACCEPT;
	case YYrERROR:
		goto yyError;
#ifdef YYLR2
	case YYrLR2:
#ifndef YYSYNC
		YYREAD;
#endif
		yyj = 0;
		while(yylr2[yyj] >= 0) {
			if(yylr2[yyj] == yystate && yylr2[yyj+1] == yychar
			&& yylook(yys+1,yyps,yystate,yychar,yy2lex(),yylr2[yyj+2]))
					break;
			yyj += 3;
		}
		if(yylr2[yyj] < 0)
			goto yyError;
		if(yylr2[yyj+2] < 0) {
			yystate = ~ yylr2[yyj+2];
			goto yyStack;
		}
		yyi = yylr2[yyj+2];
		goto yyReduce;
#endif
	}

	/*
	 *	Look up next state in goto table.
	 */

	yyp = &yygo[yypgo[yyi]];
	yyq = yyp++;
	yyi = *yyps;
#if	0 && defined(__TURBOC__) && __SMALL__
	/* THIS ONLY WORKS ON TURBO C 1.5 !!! */
	/* yyi is in di, yyp is in si */
L02:
	asm lodsw		/* ax = *yyp++; */
	asm cmp yyi, ax
	asm jl L02
#else
	while (yyi < *yyp++)
		;
#endif
	yystate = ~(yyi == *--yyp? YYQYYP: *yyq);
	goto yyStack;

yyerrlabel:	;		/* come here from YYERROR	*/
/*
#pragma used yyerrlabel
 */
	yyerrflag = 1;
	if (yyi == YYrERROR)
		yyps--, yypv--;
	
yyError:
	switch (yyerrflag) {

	case 0:		/* new error */
		yynerrs++;
		yyi = yychar;
		yyerror("Syntax error");
		if (yyi != yychar) {
			/* user has changed the current token */
			/* try again */
			yyerrflag++;	/* avoid loops */
			goto yyEncore;
		}

	case 1:		/* partially recovered */
	case 2:
		yyerrflag = 3;	/* need 3 valid shifts to recover */
			
		/*
		 *	Pop states, looking for a
		 *	shift on `error'.
		 */

		for ( ; yyps > yys; yyps--, yypv--) {
			if (*yyps >= sizeof yypact/sizeof yypact[0])
				continue;
			yyp = &yyact[yypact[*yyps]];
			yyq = yyp;
			do
				;
			while (YYERRCODE < *yyp++);
			if (YYERRCODE == yyp[-1]) {
				yystate = ~YYQYYP;
				goto yyStack;
			}
				
			/* no shift in this state */
#if YYDEBUG
			if (yydebug && yyps > yys+1)
				printf(
	gettext("Error recovery pops state %d (%d), uncovers %d (%d)\n"),
					yysmap[yyps[0]], yyps[0],
					yysmap[yyps[-1]], yyps[-1]);
#endif
			/* pop stacks; try again */
		}
		/* no shift on error - abort */
		break;

	case 3:
		/*
		 *	Erroneous token after
		 *	an error - discard it.
		 */

		if (yychar == 0)  /* but not EOF */
			break;
#if YYDEBUG
		if (yydebug)
			printf(gettext("Error recovery discards %s (%d), "),
				yyptok(yychar), yychar);
#endif
		yyclearin;
		goto yyEncore;	/* try again in same state */
	}
	YYABORT;

#ifdef YYALLOC
yyReturn:
	yylval = save_yylval;
	yyval = save_yyval;
	yypvt = save_yypvt;
	yychar = save_yychar;
	yyerrflag = save_yyerrflag;
	yynerrs = save_yynerrs;
	free((char *)yys);
	free((char *)yyv);
	return(retval);
#endif
}

#ifdef YYLR2
yylook(s,rsp,state,c1,c2,i)
short *s;		/* stack		*/
short *rsp;		/* real top of stack	*/
int state;		/* current state	*/
int c1;			/* current char		*/
int c2;			/* next char		*/
int i;			/* action S < 0, R >= 0	*/
{
	int j;
	short *p,*q;
	short *sb,*st;
#if YYDEBUG
	if(yydebug) {
	printf(gettext("LR2 state %d (%d) char %s (%d) lookahead %s (%d)"),
			yysmap[state],state,yyptok(c1),c1,yyptok(c2),c2);
		if(i > 0)
			printf(gettext("reduce %d (%d)\n"), yyrmap[i], i);
		else
			printf(gettext("shift %d (%d)\n"), yysmap[i], i);
	}
#endif
	st = sb = rsp+1;
	if(i >= 0)
		goto reduce;
  shift:
	state = ~i;
	c1 = c2;
	if(c1 < 0)
		return 1;
	c2 = -1;

  stack:
  	if(++st >= &s[YYSSIZE]) {
		yyerror("Parser Stack Overflow");
		return 0;
	}
	*st = state;
	if(state >= sizeof yypact/sizeof yypact[0])
		i = state- YYDELTA;
	else {
		p = &yyact[yypact[state]];
		q = p;
		i = c1;
		while(i < *p++)
			;
		if(i == p[-1]) {
			state = ~q[q-p];
			c1 = c2;
			if(c1 < 0)
				return 1;
			c2 = -1;
			goto stack;
		}
		if(state >= sizeof yydef/sizeof yydef[0])
			return 0;
		if((i = yydef[state]) < 0) {
			p = &yyex[~i];
			while((i = *p) >= 0 && i != c1)
				p += 2;
			i = p[1];
		}
	}
  reduce:
  	j = yyrlen[i];
	if(st-sb >= j)
		st -= j;
	else {
		rsp -= j+st-sb;
		st = sb;
	}
	switch(i) {
	case YYrERROR:
		return 0;
	case YYrACCEPT:
		return 1;
	case YYrLR2:
		j = 0;
		while(yylr2[j] >= 0) {
			if(yylr2[j] == state && yylr2[j+1] == c1)
				if((i = yylr2[j+2]) < 0)
					goto shift;
				else
					goto reduce;
		}
		return 0;
	}
	p = &yygo[yypgo[i]];
	q = p++;
	i = st==sb ? *rsp : *st;
	while(i < *p++);
	state = ~(i == *--p? q[q-p]: *q);
	goto stack;
}
#endif
		
#if YYDEBUG
	
/*
 *	Print a token legibly.
 *	This won't work if you roll your own token numbers,
 *	but I've found it useful.
 */
char *
yyptok(i)
{
	static char	buf[10];

	if (i >= YYERRCODE)
		return yystoken[i-YYERRCODE];
	if (i < 0)
		return "";
	if (i == 0)
		return "$end";
	if (i < ' ')
		sprintf(buf, "'^%c'", i+'@');
	else
		sprintf(buf, "'%c'", i);
	return buf;
}
#endif
#if YYDEBUG
char * yystoken[] = {
	"error",
	"WHITE",
	"BLACK",
	"EMPTY",
	"IGNORE",
	"NL",
	0
};
char * yysvar[] = {	"$accept",
	"line",
	"whites",
	"blacks",
	"empties",
	"oempties",
	"type1",
	"type2",
	"otype3e",
	"type3e",
	"type3",
	"otype4",
	"type4",
	"type4.w",
	"type4.b",
	"lines",
	"ignore",
	0
};
short yyrmap[] = {
	  52,   53,   54,   12,   14,   18,   20,   22,   30,   38, 
	  39,   44,   45,   50,   51,   49,   48,   47,   46,   43, 
	  42,   41,   40,   37,   36,   35,   34,   32,   31,   29, 
	  28,   27,   26,   25,   24,   23,   21,   19,   17,   16, 
	  15,   13,   11,   10,    9,    8,    7,    6,    5,    2, 
	   1,    3,    4,   33,    0
};
short yysmap[] = {
	   1,    5,    6,   12,   13,   14,   17,   18,   21,   22, 
	  25,   26,   27,   28,   29,   30,   34,   35,   40,   41, 
	  44,   45,   47,   50,   51,   53,   56,   57,   58,   59, 
	  60,   61,   65,   68,   69,   70,   71,   72,   74,   75, 
	  77,   82,   84,   37,   23,   19,   15,    7,    4,   83, 
	  85,   31,   32,   73,   86,   76,   87,   48,   54,   52, 
	  55,   80,   81,   49,   11,   33,    2,   16,    3,   20, 
	  36,   39,   63,   64,   78,   43,   66,   67,   79,   62, 
	  38,   42,   46,    8,    9,    0,   24,   10
};
int yyntoken = 7;
int yynvar = 17;
int yynstate = 88;
int yynrule = 55;
#endif
