"#BEGIN introduction \"Introduction\" \"$Id: Help.txt,v 1.14 1999/01/31 10:41:18 torsten Exp $\"",
"Welcome to the latest version of XPaint.",
"XPaint is a color image-editing tool that features most standard paint",
"program options.",
"It allows for the editing of multiple images simultaneously and supports",
"various formats, including PPM, XBM, TIFF, etc.",
"The functionality of XPaint is divided into a toolbox area for selecting",
"the current paint operation and paint windows for modifying/creating",
"images.  Each paint window has access to its own color palette and set",
"of patterns, although the paint operation in use is globally selected",
"for all windows.",
"XPaint runs on a variety of displays.  Saving",
"images will adapt them to the current display type (e.g., a color image",
"loaded on a greyscale screen will be saved as a grey image).  This can",
"result in the loss of data; see the Possible Data Loss section for details.",
"More information is available under the specific topics.  Enjoy!",
"#BEGIN data_loss	\"Possible Data Loss\"",
"XPaint uses the native display format for storing image info while editing;",
"the original image information is thrown away.  This means that, in general,",
"color information is irretrievably lost when using any display depth",
"less than 24 bits.",
"More specifically, for depths less than 8 bits, both",
"24-bit (true-color) and 8-bit (palette) images will be reduced to the display",
"depth; for 8-bit displays, standard color-mapped images are safe but 12-bit",
"color-mapped and 24-bit true-color images will lose color information;",
"for 15- and 16-bit displays (typically RGB 555 and 565, respectively), in",
"general both 8-bit and 24-bit images will suffer data loss; and for 24- or",
"32-bit displays, only very deep images such as 16-bit grayscale or 48-bit",
"true-color will lose data.",
"Also note that any ancillary information associated with the original",
"image (embedded comments, time stamp, copyright, etc.) will always be lost.",
"#BEGIN command	\"Command Line Options\"",
"xpaint [-popped] [-nowarn] [-size WIDTHxHEIGHT] [-rcFile FILE] ",
"#NL",
"       [-8 | -12 | -24 | -visual VISUAL] [<files>...]",
"#NL",
"	-size		default width and height for new images",
"#NL",
"	-8			use an 8-bit PseudoColor visual",
"#NL",
"	-12			use a 12-bit PseudoColor visual",
"#NL",
"	-24			use a 24-bit TrueColor visual",
"#NL",
"	-popped		pop up an empty canvas on startup",
"#NL",
"	-nowarn		skip data-loss warnings",
"#NL",
"	-rcFile		use FILE instead of default .XPaintrc",
"#NL",
"	-visual		use VISUAL instead of default.  Choices are",
"#NL                  ",
"				TrueColor, PseudoColor, DirectColor, StaticColor,",
"#NL",
"				StaticGray, GrayScale, or the decimal visual ",
"#NL",
"				number (from xdpyinfo).",
"#NL",
"	<files>		image filenames to open",
"#NL",
"#BEGIN toolbox \"Toolbox\"",
"The toolbox is used to set those options that are applicable to all",
"XPaint canvases.",
"#PUSH",
"#BEGIN tool_file \"File Menu\"",
"The file menu is used to create a new canvas or load an image from a file.",
"New Canvas",
"#NL",
"	Create a new blank canvas (default size:",
"#NL",
"	640x480).  See \"Command Line Options\" for",
"#NL",
"	changing the default size.",
"New with Size...",
"#NL",
"	Create a new canvas with the specified",
"#NL",
"	dimensions.",
"Open...",
"#NL",
"	Open an image file for painting.  Images can",
"#NL",
"	be opened in a variety of formats.  If none",
"#NL",
"	of the specific formats is selected, XPaint",
"#NL",
"	will attempt to perform a \"Best Guess\" as to",
"#NL",
"	the image format.  Unknown formats will result",
"#NL",
"	in an error message.",
"Load Clipboard...",
"#NL",
"	Open an image file into the XPaint clipboard",
"#NL",
"	for pasting.  Images that have been saved in",
"#NL",
"	a format supporting odd-shaped regions will be",
"#NL",
"	loaded as they were selected, otherwise all",
"#NL",
"	images are rectangular.  See \"Paste\" and",
"#NL",
"	\"Save Region...\" under the Edit and File menus",
"#NL",
"	of the Painting Window for more information.",
"Quit",
"#NL",
"	Exit XPaint, closing all windows.",
"#BEGIN tool_line \"Line Menu\"",
"The line menu sets the value of the line width.  This value is used by all",
"operations that paint any type of line, including the borders of boxes,",
"ovals and polygons.",
"#BEGIN tool_font \"Font Menu\"",
"This menu selects the current font to use for the text operation.  There are",
"a few specific fonts choices listed, but all fonts are available through",
"the font browser.",
"Note:  Changing a font while inserting will not allow backspacing over text",
"in a previous font.",
"See \"Font Browser\" for more information on its use.",
"#PUSH",
"#BEGIN font_browser \"Font Browser\"",
"The font browser is designed to allow any available font to be used for",
"painting with the text operation.  A font is selected by choosing an item",
"from each of the given lists until the font is displayed in the \"selection\"",
"area.  As items are selected, all lists will adjust to reflect existing",
"fonts with the selected characteristics.  Clicking in the blank area",
"of a item list will reset that list to all available options (i.e., unselect",
"the current one).",
"If the X server supports variable sized fonts, the point size list will",
"contain a \"0\" entry, which will use the value specified in the",
"\"Point Size\" field.",
"#POP",
"#BEGIN tools \"Painting Tools\"",
"The painting tool icons set the current painting operation for all canvases.",
"Operations are selected with mouse button one.  Pressing mouse button three",
"while over any of the icons will bring up a menu of options available for",
"that tool.  Some icons also allow double-clicking as a faster method of",
"bringing up style options.",
"See the specific paint operation for more information.",
"#PUSH",
"#BEGIN arc \"Arc\"",
"The arc operation paints an arc between two selected points in the primary",
"color/pattern, using the current line width.  Arcs are generally a",
"quarter of an ellipse, but may be restricted to a circular shape by",
"pressing the shift key while painting.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN box \"Boxes\"",
"The box operations paint either rectangles or squares using the current line",
"width. Pressing shift while moving the mouse after selecting the first point",
"will constrain the box to a square.",
"Selecting the 'center' option from the menu found by pressing button three on",
"the icon will define the first point as the center of the square with",
"the second point being on the perimeter.",
"Filled boxes are painted in the primary color/pattern and filled",
"with the secondary color/pattern for the canvas.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN brush \"Brush\"",
"The brush operation uses the current brush to paint on the canvas(es).",
"Painting is accomplished by holding down the mouse button and",
"moving the mouse in the canvas area.  Button one paints in the selected primary",
"color/pattern, while button two uses the secondary one.",
"If the 'transparent' option is selected from the menu found by pressing button",
"three on the icon, the selected color is blended with the color already on the",
"canvas. You can change the opacity of the brush using the 'Parameters..'",
"option. Zero percent means that the canvas is not changed at all, while 100",
"percent gives the same result as using a non-transparent brush.",
"The current brush style may be changed through the brush chooser available",
"on the button three menu for either the brush or erase operation icons.",
"#BEGIN cline \"Connected Line\"",
"The connected line operation paints a series of straight lines connected at",
"selected vertices.  Each new vertex is selected using the first mouse button.",
"The second mouse button ends this operation, without forming a new vertex.",
"All painting is done in the primary color/pattern using the currently defined",
"line width.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN dotPencil \"Dot Pencil\"",
"The dot pencil operation paints a series of dots on the canvas, following the",
"cursor while the mouse button is pressed.",
"Button one paints in the primary color/pattern, button two the secondary",
"color/pattern.",
"See \"Pencil\" for painting connected lines.",
"#BEGIN erase \"Erase\"",
"The erase operation is designed to either erase a section of the painting to",
"the set background color for the canvas or to revert the erased area to",
"the originally loaded image.  (Note:  This is not the last saved image!)",
"The eraser is the style of the current brush, and the brush selection",
"window is accessible through the menu found by clicking mouse button",
"three on either the erase or brush icons.",
"See help on the \"Brush\" or on \"Change Background...\" under the Image menu of",
"the Painting Window for more information.",
"#BEGIN fill \"Fill\"",
"The fill operation will paint an area around a selected pixel the current",
"primary or secondary color/pattern (based on which mouse button used).  The",
"area is determined by matching adjacent pixel values until a variation is",
"found.  Diagonal pixels are not considered adjacent.",
"Selecting the 'Change' option from the menu found by pressing button three on",
"the icon will enter Change Mode. In this mode, all pixels in the image that",
"have the same color as the selected one will be changed to the primary or",
"secondary color.",
"Selecting the 'Fill Range' option causes XPaint to consider not only pixels of",
"the exact same color as the selected one, but also pixels within the variance",
"(delta) set from the color selector found under the 'Select Range...' popup",
"menu item.",
"#BEGIN tfill \"Gradient Fill\"",
"The gradient fill operation will paint an area around a selected pixel with a",
"range of colors obtained by mixing the primary and secondary colors.",
"The area is determined by matching adjacent pixel values until a variation is",
"found.  Diagonal pixels are not considered adjacent.",
"The 'Fill', 'Change' and 'Fill Range' options in the popup menu work the same",
"as for the ordinary fill operation.",
"Linear, Radial, Conical or Square gradient fill can be selected by clicking",
"mouse button three on the Gradient Fill icon. Also, several parameters can be",
"adjusted using the 'Parameters' item here:",
"Angle",
"#NL",
"	Defines the tilting of the pattern. Valid range is",
"#NL",
"	-360 to 360 degrees.",
"Pad	If this value is positive, the area where one color",
"#NL",
"	blends into the other will be compressed, yielding",
"#NL",
"	a sharper transition. If negative, the transition",
"#NL",
"	will be smoother. Valid range is -49 % to 49 %.",
"Horizontal/Vertical offset",
"#NL",
"	Defines the center of the pattern. Valid range is",
"#NL",
"	-100 % to 100 %.",
"#NL",
"	This parameter has no effect for the Linear pattern.",
"Steps ",
"#NL",
"	The maximum number of colors that will be used",
"#NL",
"	for the transition from one color to the other.",
"#NL",
"	For non-TrueColor displays, it can be useful to",
"#NL",
"	limit the number of colors used to avoid running",
"#NL",
"	out of palette entries.  Very small numbers can",
"#NL",
"	also be used to get a 'blocky' effect. Valid range",
"#NL",
"	is 1 trough 300.",
"#BEGIN ffill \"Fractal Fill\"",
"The fractal fill operation will paint an area around a selected pixel with a",
"range of colors obtained by mixing the primary and secondary colors.",
"The area is determined by matching adjacent pixel values until a variation is",
"found.  Diagonal pixels are not considered adjacent.",
"The 'Fill', 'Change' and 'Fill Range' options in the popup menu work the same",
"as for the ordinary fill operation.",
"Several different fractal patterns can be selected by clicking",
"mouse button three on the Fractal Fill icon.",
"#BEGIN smear \"Smear\"",
"The smear operation paints each pixel under the brush the average color",
"of all the pixels.",
"Smearing is done by holding down the mouse button and",
"moving the mouse in the canvas area.",
"The current brush style may be changed through the brush chooser available",
"on the button three menu.",
"#BEGIN line \"Line\"",
"The line operation paints a straight line in the primary color/pattern",
"between two selected points on the canvas, using the global line width.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"Lines may also be restricted to increments of 45 degrees (i.e.,",
"horizontal, vertical, or diagonal) by holding down the shift key while",
"painting.",
"#BEGIN oval \"Ovals\"",
"The oval operations paint either circles or ovals using the current line width.",
"Ovals/circles are painted by selecting two points that inherently define",
"a box around the area for the oval.  Pressing shift while moving the mouse will",
"constrain the oval to a circle.",
"Selecting the 'center' option from the menu found by pressing button three on",
"the icon will define the first point as the center of the circle with the",
"second point being the radius.",
"Filled ovals and circles are painted in the primary color/pattern and filled",
"with the secondary color/pattern for the canvas.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN pencil \"Pencil\"",
"The pencil operation paints a connected line on the canvas, following the",
"cursor while the mouse button is pressed.  The global line width is used",
"to determine the width of this line.",
"Button one paints in the primary color/pattern, button two the secondary",
"color/pattern.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN dynpencil \"DynPencil\" ",
"The dynamic pencil operation paints calligraphic stroke-like curves",
"on the canvas, following the cursor while the mouse button is pressed.",
"It mimics pulling a variable-width pencil with a rubber string. The",
"width of the pen gets smaller the faster it moves. The pencil has a",
"settable mass. Depending on its mass, it follows the cursor more or",
"less tightly as you accelerate and turn the cursor. A heavy pencil has",
"large inertia.",
"The \"mass\", steady-state width and \"drag\" can be set with the dialog ",
"you get if you press button three on the icon.",
"Button one paints in the primary color/pattern, button two the secondary",
"color/pattern.",
"#BEGIN poly \"Polygons\"",
"Polygon operations paint polygons as defined by a series of straight lines",
"between selected vertices.  Each new vertex is selected using the first mouse",
"button.  Ending this operation (done through pressing the second mouse",
"button) does not create a new vertex and results in the last created",
"vertex being joined to the first.",
"All painting is done in the primary color/pattern using the currently defined",
"line width.  Filled polygons are filled in the secondary color/pattern.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN ray \"Ray\"",
"The ray operation paints rays from the first selected point to all",
"subsequent points in the primary color/pattern.  Button two ends this",
"operation without selecting a new ray point.  Rays may also be restricted",
"to slopes based on a 45 degree increment (i.e., horizontal, vertical,",
"or diagonals) by pressing the shift key while painting.",
"The width of the rays is determined by the global value for the line",
"width, set via the \"Line\" menu.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN select \"Select Regions\"",
"There are three operations for selecting regions:  Select Box, Lasso and",
"Select Polygon.",
"\"Select Box\" will select a rectangular or ellipse-shaped region (holding down",
"shift while pressing the mouse button with constrain the region to a",
"square or a circle, respectively).  \"Lasso\" selects an arbitrary region.",
"\"Select Polygon\" selects a region bounded by straight lines.",
"The three possible modes used by these operations are set by the options on",
"the button three menu for either icon:",
"All Colors 	        Select the entire region.",
"#NL",
"Omit Color Range	Select the region, excluding the",
"#NL",
"				specified range of colors.",
"#NL",
"Only Color Range	Select only the specified color range",
"#NL",
"				in the region.",
"#NL",
"See \"Range Selection\" for more information on choosing a range of colors",
"for these operations.",
"Operations that may be performed on selected regions include the ability",
"to move and resize them.  Holding shift down during resizing will constrain",
"the region to its original aspect ratio.  Holding shift down during moving",
"will constrain movement to horizontal or vertical.  ",
"Note that moving a region will result in the original location being painted",
"in the current background color. See \"Background Color...\" under the Image",
"menu of the Paint Window for more information.",
"You can also use the cursor keys to move the region one pixel at a time (hold",
"down the Control key to move in larger steps).",
"#PUSH",
"#BEGIN range_select \"Range Selection\"",
"This window, which pops up when you click the \"Select Color Range\" button",
"next to the palettes, is designed for selecting a range of colors for use with",
"the select region operations.  The color range is determined by setting a",
"base color and the amount of variance in each of the RGB values around",
"this color.  Colors are considered in this range if they match a value based",
"on the base color +/- the given variance.   Default base color is white.",
"The \"Pixel Delta\" button allows the user to choose another color that will",
"be used to calculate the variance from the base color.",
"More information on colors and the use of the color wheel may be found",
"under the \"Pattern Editor\" on the \"Painting Window\".",
"#POP",
"#BEGIN blob \"Shape\"",
"Shape operations allow the user to draw closed objects with a ",
"pencil-like operation.  When the mouse button is released, the last drawn ",
"point is connected to the starting point. ",
"Painting can either be done in the primary color/pattern with button one or",
"in the secondary color/pattern with button two.  Filled shapes are filled in",
"the other palette color/pattern.  Border width is determined by the current",
"setting for line width.",
"See \"Line Menu\" under the toolbox for more information about line width.",
"#BEGIN spray \"Spray\"",
"The spray operation is designed to emulate a spray can.  It will paint",
"a random set of dots within a given radius.",
"It is possible to change the attributes of the spray operation to",
"achieve the desired effect.   There are three parameters that will",
"modify the configuration of the spray tool:",
"#NL",
"	radius	how large of a circle to fill",
"#NL",
"	density	number of dots in the given area",
"#NL",
"	rate		speed to fill the area in tenths of a second",
"Additionally, it is possible to change the distribution of the dots to",
"be either even or gaussian (usually only noticeable at large radii).",
"These options are found in the menu brought up by clicking button three",
"on the spray icon.",
"As with many other operations, the spray operation can make use of either",
"the primary or secondary color/pattern based on which button (one or two,",
"respectively) is held down while painting on the canvas.",
"#BEGIN text \"Text\"",
"The text operation allows for typing in the currently selected font.",
"Pressing mouse button two in the canvas area while inserting text",
"will paste text from the X clipboard at the current insertion point.",
"See the \"Font Menu\" for information on changing the selected font.",
"Note:  Changing a font while inserting will not allow backspacing over text",
"in a previous font.",
"#POP",
"#POP",
"#BEGIN canvas \"Painting Window\"",
"The painting window holds a canvas area for painting the displayed image,",
"menus for performing operations on this image, and primary and secondary",
"color/pattern palettes along with buttons for adding to these.",
"Painting on the image is accomplished by selecting a operation from",
"the global toolbox and applying it in the canvas area.  See help on the",
"specific paint operation for its use.",
"#PUSH",
"#BEGIN fileMenu \"File Menu\"",
"The file menu on the painting window is for saving information associated",
"with the image displayed on the current paint canvas. ",
"XPaint runs on a variety of displays.  Saving",
"images will adapt them to the current display type (i.e., a color image ",
"loaded on a greyscale screen will be saved as a grey image).",
"See \"Image Formats\" for a description of the image formats usable",
"by XPaint.",
"Save",
"#NL",
"	Save the current image with the original",
"#NL",
"	filename and format.  If this is a new",
"#NL",
"	image, perform the \"Save As\" operation.",
"Save As",
"#NL",
"	Save the current image with the specified",
"#NL",
"	filename and format (default is TIFF).",
"Save Region...",
"#NL",
"	Save the selected region, in the original",
"#NL",
"	form that it was selected (width, height and",
"#NL",
"	rotation).  Odd-shaped regions will be saved",
"#NL",
"	as rectangles filled with the background",
"#NL",
"	color.  If the output format supports image",
"#NL",
"	masks (e.g., TIFF, PNG, XPM), then this",
"#NL",
"	information will also be saved.  See \"Load",
"#NL",
"	Clipboard...\" under the toolbox file menu",
"#NL",
"	for more information about odd-shaped",
"#NL",
"	images.",
"Save Palette...",
"#NL",
"	Save the current palette. See \"Palette",
"#NL",
"	Area\" for more information on how",
"#NL",
"	patterns are loaded.",
"Revert...",
"#NL",
"	Reloads the last saved image. This is",
"#NL",
"	equivalent to closing without saving",
"#NL",
"	and then opening the original file.",
"#NL",
"	You are asked for confirmation. If",
"#NL",
"	the image has not been changed since",
"#NL",
"	the last save, this operation does",
"#NL",
"	nothing.",
"Close",
"#NL",
"	Close the current painting window, saving",
"#NL",
"	the image if desired.",
"#BEGIN editMenu \"Edit Menu\"",
"The edit menu provides for a set of operations that interact with the",
"current selection and the paint clipboard.  The six first items in this menu",
"is also accessible through button three on the painting canvas.  ",
"The clipboard is an off-screen image that is loaded either from a selected",
"region via these operations or from a file.",
"See \"Load Clipboard...\" on the toolbox \"File Menu\" for more information",
"about loading images from a file and \"Change Background...\" under the",
"\"Image Menu\" for more information on the background color.",
"Undo",
"#NL",
"	Reverse the last performed operation.",
"#NL",
"	Multiple undos are possible; see 'Undo Levels..'",
"#NL",
"	in the 'Image' menu.",
"#NL",
"	If a region is selected, and you have not moved",
"#NL",
"	or resized it, the last region operation is undone.",
"#NL",
"Redo",
"#NL",
"	Cancel the effect of the last undo.",
"#NL",
"	This must be done immediately after an undo or",
"#NL",
"	redo (before drawing anything new on the canvas).",
"#NL",
"Cut",
"#NL",
"	Load the originally selected region into both ",
"#NL",
"	the XPaint and X server clipboards and",
"#NL",
"	change the area on the screen to the background",
"#NL",
"	color.",
"Copy",
"#NL",
"	Load the originally selected region into the",
"#NL",
"	XPaint and X server clipboards.",
"Paste",
"#NL",
"	Place the image in the clipboard onto the",
"#NL",
"	canvas at the last position where button one",
"#NL",
"	or two was pressed.  Images are first searched",
"#NL",
"	for in the X server clipboard and then the",
"#NL",
"	internal XPaint clipboard.",
"Clear",
"#NL",
"	Remove the current selection from the paint	",
"#NL",
"	canvas.",
"Duplicate",
"#NL",
"	Perform both the copy and paste operations in one.",
"	",
"Select All",
"#NL",
"	Select the entire image on the canvas.",
"#NL",
"	(Note:  This does not use the color range options",
"#NL",
"	that the select-area operators from the toolbox do!)",
"#NL",
"	",
"#BEGIN regionMenu \"Region Menu\"",
"This menu provides operations that can be applied to the currently",
"selected region.  See the \"Select Regions\" item under the toolbox",
"Painting tools for information on how to select regions.",
"Note:  The 'undo' operation found under the Edit menu does not work",
"on these operations!",
"Flip X Axis",
"#NL",
"	Flip the current region horizontally.",
"Flip Y Axis",
"#NL",
"	Flip the current region vertically.",
"Rotate By",
"#NL",
"Rotate...",
"#NL",
"	Both of these operations allow for rotating",
"#NL",
"	the current image by a specified number of",
"#NL",
"	degrees.  Rotation may also be done",
"#NL",
"	by pressing button two on the selection.",
"#NL",
"	Pressing the Shift button while doing this",
"#NL",
"	constrains the rotation to multiples of",
"#NL",
"	15 degrees.",
"Crop to region...",
"#NL",
"	Discard all portions of the image outside the region.",
"#NL",
"	This operation cannot be undone; therefore, you are",
"#NL",
"	required to confirm it.",
"Reset",
"#NL",
"	Return the current image to its original",
"#NL",
"	size and orientation.  Note:  None of the",
"#NL",
"	image processing operations will be undone.",
"	",
"#BEGIN filterMenu  \"Filter Menu\"",
"The filter menu provides a set of image processing operations",
"that can be applied to the currently selected region.  See",
"the \"Select Regions\" item under the toolbox Painting tools",
"for information on how to select regions.",
"Repeat Last",
"#NL",
"	This applies the last filter you used again, without",
"#NL",
"	querying for any parameters.",
"Invert",
"#NL",
"	Inverts the colors of the selected region",
"#NL",
"	(e.g., black to white).",
"Sharpen",
"#NL",
"	Applies an image processing algorithm in an",
"#NL",
"	attempt to increase the detail on the",
"#NL",
"	selected region.",
"Smooth",
"#NL",
"	Attempts to blend the colors of the region",
"#NL",
"	by averaging the pixel's color values with",
"#NL",
"	those of its neighbors.",
"Directional Smooth",
"#NL",
"	Similar to Smooth, but avoids smearing edges",
"#NL",
"	by applying a more sophisticated algorithm.",
"#NL",
"	The effect is less pronounced than for Smooth.",
"Despeckle...",
"#NL",
"	Tries to remove scanning artifacts etc. by replacing ",
"#NL",
"	each pixel by the median of the pixels inside the",
"#NL	",
"	n x n mask centered around that pixel. You are",
"#NL	",
"	queried for the mask size; this must be odd and",
"#NL",
"	larger than 1.",
"Edge Detect",
"#NL",
"	Performs an image processing edge",
"#NL",
"	detection.",
"Emboss",
"#NL",
"	Converts the selected region to a grey image",
"#NL",
"	that is highlighted such that the details",
"#NL",
"	appear to stand out from the screen.",
"Oil paint...",
"#NL",
"	Does an effect similar to an oil painting.",
"#NL",
"	You are queried for the mask size, which must",
"#NL",
"	be an odd integer. Recommended values range",
"#NL",
"	from 3 to 15. Higher values result in a more",
"#NL",
"	pronounced effect.",
"Add Noise...",
"#NL",
"	Add random noise to the image, giving a 'grainy'",
"#NL",
"	appearance. You are queried for the maximum",
"#NL",
"	noise value. Recommended values range from ",
"#NL",
"	5 to 50. Higher values result in a more",
"#NL",
"	pronounced effect.",
"Spread...",
"#NL",
"	This operation swaps each pixel in the region with",
"#NL",
"	a random pixel near it, giving an effect similar to",
"#NL",
"	frosted glass. You are queried for the maximum",
"#NL",
"	distance. Good values range from 1 to 10.",
"#NL",
"	You can also specify how many iterations you want",
"#NL",
"	performed. This is equivalent to manually selecting",
"#NL",
"	the operation that many times.",
"Pixelize...",
"#NL",
"	Makes the image look low resolution. This works by",
"#NL",
"	replacing each 'megapixel' with the average color ",
"#NL",
"	within that region. You are queried for the megapixel",
"#NL",
"	size; this can be specified as square (e.g., '5') or ",
"#NL",
"	rectangular (e.g., '2x4').",
"Blend",
"#NL",
"	This operation colors each pixel in the region",
"#NL",
"	with a weighted average of the center color and",
"#NL",
"	the color on the edge that intersects a line drawn",
"#NL",
"	from the center to the pixel in question.",
"#NL",
"	The result is to 'blend the region out of existence'.",
"Solarize...",
"#NL",
"	Inverts pixels with a value larger than the ",
"#NL",
"	specified threshold. This simulates what happens",
"#NL",
"	to a photographic film that is exposed to light",
"#NL",
"	during development. Works best for greyscale",
"#NL",
"	images. You are queried for the threshold (1-99 %).",
"Normalize Contrast",
"#NL",
"	Normalizes the contrast by forcing the lightest pixels",
"#NL",
"	to white, the darkest pixels to black, and linearly",
"#NL",
"	rescaling the ones in between.",
"#NL",
"	You are queried for Black and White levels in %.",
"#NL",
"	Pixels darker than the Black level will become black,",
"#NL",
"	and pixels brighter than the White level will become",
"#NL",
"	white. The pixels in between will be rescaled linearly.",
"#NL",
"	'100 %' refers to the brightest pixel in the image.",
"Quantize Colors...",
"#NL",
"	Reduces the number of colors in the image. The",
"#NL",
"	algorithm selects the set of colors that gives",
"#NL",
"	the best result and then replaces the original",
"#NL",
"	colors with the best match in the new color set.",
"#NL",
"	You can choose the number of colors to use,",
"#NL",
"	from 2 to 256.",
"Turn into Greyscale",
"#NL",
"	Converts all colors in the image to greyscale.",
"#BEGIN imageMenu  \"Image Menu\"",
"The image menu provides a set of operations that are applied to",
"the current image/paint canvas. ",
"Fat Bits",
"#NL",
"	Brings up the Fat Bits editor, which allows",
"#NL",
"	for editing an enlarged area of the current",
"#NL",
"	image without having to enlarge the entire",
"#NL",
"	image.",
"Visible Grid",
"#NL",
"	Turns on and off a visible black grid",
"#NL",
"	between the original pixels on images with a",
"#NL",
"	scale greater than 1 (i.e., zoomed).  This",
"#NL",
"	grid is only for painting purposes.  It does",
"#NL",
"	not affect the actual image.",
"Snap",
"#NL",
"	Turns on/off restriction of the current x",
"#NL",
"	and y position for most operations to an",
"#NL",
"	invisible grid.",
"Snap Spacing...",
"#NL",
"	Sets the distance between points on the",
"#NL",
"	invisible snap grid.",
"Change Background...",
"#NL",
"	This operation changes the background color",
"#NL",
"	for the current image (default color is",
"#NL",
"	white).  This is only used when a region is",
"#NL",
"	erased or cut from the current image and",
"#NL",
"	when odd-shaped regions are saved. See",
"#NL",
"	\"Color Wheel\" under the \"Pattern Editor\" for",
"#NL",
"	more information on selecting a color.",
"Change Size...",
"#NL",
"	Changes the size of the current canvas by",
"#NL",
"	cutting away or adding area on the right and",
"#NL",
"	lower sides.  This operation is not",
"#NL",
"	reversible (except by 'Revert') and affects",
"#NL",
"	the actual image size.",
"Undo Levels...",
"#NL",
"	Changes the number of consecutive changes",
"#NL",
"	that can be undone or redone. Note that each",
"#NL",
"	undo level uses as much memory as the image",
"#NL",
"	itself, so large numbers can use up a lot of",
"#NL",
"	memory.",
"Autocrop...",
"#NL",
"	Changes the size of the current canvas by",
"#NL",
"	cutting away any borders. The border color",
"#NL",
"	is defined as the color common to at least",
"#NL",
"	two corners. If no two corners have the same",
"#NL",
"	color, nothing is done.",
"#NL",
"	This operation is not reversible and ",
"#NL",
"	affects the actual image size.",
"#NL",
"Change Zoom...",
"#NL",
"	Enlarges the working image by the specified",
"#NL",
"	scale.  This does not affect the size of the",
"#NL",
"	image for saving, etc.",
"	",
"#BEGIN patBox   \"Palette Area\"",
"There are two palette areas found on the painting window to",
"select the primary and secondary colors or patterns. These two",
"selections are accessible by many of the painting tools through",
"use of either mouse button one or button two, respectively.   See the",
"specific tool for more information.  All filled objects (i.e., boxes,",
"ovals, and polygons) are always filled in the secondary color/pattern,",
"with a border of the primary color/pattern.",
"Colors or patterns may be modified by double-clicking on the icon.",
"On a colormapped display (i.e., using less than 24-bit colors), changes",
"to a selected color will change that color in all locations on the",
"paint canvas as well.  Color selection is done through a color",
"wheel similar to that used under the \"Pattern Editor\".  See help on",
"the \"Pattern Editor\" for more details as well as for information",
"on editing patterns.",
"Colors and patterns are loaded from information merged",
"from the following files each time a canvas is created:",
"#NL",
"	.XPaintrc in the user's home directory",
"#NL",
"	.XPaintrc in the current directory",
"A quick method for adding a new color is found by using the \"Lookup\"",
"button.  This button allows the user to select any color available",
"on the screen and will either locate it in the current palette or",
"add it.   Once the color is found in the palette, it is selected.",
"Note:  Color/pattern changes affect both primary and secondary palettes.",
"All of the patterns and colors can be saved with the \"Save Palette...\"",
"item in the file menu.",
"#PUSH",
"#BEGIN pattern \"Pattern Editor\"",
"The pattern editor creates new patterns or modifies existing ones",
"for use on the painting canvas.",
"The window contains the current pattern and (depending on display",
"type) the current colormap and a color selection area.",
"Patterns are by default 24x24 in size, but may be set to any size",
"through the \"Size\" menu.  The other menus available provide",
"similar functionality to those in the paint window and pattern",
"editing uses the normal paint operations.",
"Patterns may be individually saved through the \"Save As\" option in",
"the \"File\" menu or saved with the palette.  See \"Save Palette...\"",
"under the Paint Window.  When loading an individual pattern, only",
"the portion of the pattern that fits in the pattern area will be",
"included.",
"The \"Grab\" button allows the user to select a portion of the current",
"screen to fill the pattern area. ",
"#PUSH",
"#BEGIN colormap \"Colormap Area\"",
"When using a colormapped display, selecting a colormap entry will",
"allow the user to change the value of that entry.  This will change",
"all pixels on the canvas that share this colormap index.",
"The \"Lookup\" button allows the user to select any color available on",
"the screen and will locate the colormap entry for this color value.",
"Note:  Manipulating colormap entries effects the canvas immediately",
"and does not revert when \"Cancel\" is chosen.",
"#BEGIN colorwheel \"Color Wheel\"",
"The XPaint color selection allows access to both the HSV or RGB color",
"space models.  The color wheel along with the value",
"slider represents HSV, while the red, green, and blue sliders are for",
"manipulating the color in an RGB space.  Modifications in either of",
"these color spaces will effect the other.",
"Colors can be selected on the color wheel by using the mouse to drag",
"the selection circle or to click on a desired color.   Changes",
"to value will determine the brightness of the chosen color.  Colors",
"can also be modified through the red, green, or blue sliders or by",
"entering values in the text fields.",
"The \"Match\" button will set the current color by allowing the user to",
"select any color on the screen.  The exact color will be determined",
"using the colormap of the selected window.",
"#POP",
"#POP",
"#POP",
"#BEGIN fileformat	\"Image Formats\"",
"XPaint can support a variety of image file formats, based on",
"library availability at compile time.  Some of these formats may not",
"be accessible in the current running version.",
"The table below provides a short summary of the features of each image",
"format and support provided by XPaint.  Note that not all formats are",
"supported for both read and write operations.",
"Color depth is given in terms of the number of bits used to store the",
"colors in the image.  This means that a color depth of 1-bit can only",
"store black/white images, while 24-bit color formats can store images",
"containing up to 2**24 (or approx. 16 million) colors.  Regardless of",
"the image format, saved images always reflect the ability of current ",
"display type (i.e., a color image loaded on a greyscale screen will be ",
"saved as a grey image).  See the Possible Data Loss section for more",
"details.",
"The image mask feature of an image format provides the ability to",
"save/load odd-shaped regions (i.e., regions are not required to be ",
"rectangular and may have \"holes\" in them).   See \"Save Region\" and ",
"\"Load Clipboard...\" for more information.",
"Detailed information about each format is at the end of this section.",
"						Color		Image",
"#NL",
"		Read	Write	depth		mask",
"#NL",
"GIF		yes		yes		8-bit			no",
"#NL",
"JPEG	yes		yes		24-bit		no",
"#NL",
"PNG		yes		yes		8, 24-bit		yes",
"#NL",
"PPM		yes		yes		24-bit		no",
"#NL",
"PS		no		yes		24-bit		no",
"#NL",
"SGI		yes		yes		24-bit		no",
"#NL",
"TIFF	yes		yes		8, 24-bit		yes",
"#NL",
"XBM	yes		yes		1-bit			no",
"#NL",
"XPM	yes		yes		8-bit			yes",
"#NL",
"XWD	yes		yes		24-bit		no",
"GIF - Graphics Interchange Format",
"#NL",
"	A popular image format used across a variety",
"#NL",
"	of platforms, including PCs.",
"JPEG - Joint Photographic Experts Group Format",
"#NL",
"	A standardized, lossy format for storing",
"#NL",
"	compressed color and greyscale images",
"#NL",
"	of natural scenes.",
"PNG - Portable Network Graphics Format",
"#NL",
"	A new format designed to replace GIF and,",
"#NL",
"	to some extent, TIFF.  It has a better",
"#NL",
"	compression engine than either GIF or TIFF",
"#NL",
"	and is a lossless format (unlike JPEG).",
"PPM - Portable PixMap Format",
"#NL",
"	Image format provided by the PBMPlus/NetPBM",
"#NL",
"	toolkit that allows for converting to a wide variety",
"#NL",
"	of other formats.",
"PS - PostScript Format",
"#NL",
"	PostScript images are normally used by most",
"#NL",
"	printers and text-processing packages.",
"SGI - Silicon Graphics, Inc., Format",
"#NL",
"	An SGI-specific image format, supported by the",
"#NL",
"	libraries on SGI machines.  This format is not",
"#NL",
"	available on other platforms.",
"TIFF - Tagged Image File Format",
"#NL",
"	A large, complex image format used by XPaint",
"#NL",
"	as its default format.",
"XBM - X Window BitMap",
"#NL",
"	A black and white image format used by the",
"#NL",
"	X Window System.",
"XPM - X Window PixMap",
"#NL",
"	XPM images are stored in an ASCII text",
"#NL",
"	format that can be included in programs.",
"XWD - X Window Dump",
"#NL",
"	Used for screen dumps by the X Window",
"#NL",
"	System.",
"#BEGIN about		\"About XPaint\"",
"NOTE: This version of XPaint is released and maintained by Torsten",
"Martinsen (torsten@image.dk), except for the PNG code, which is",
"written and maintained by Greg Roelofs (newt@uchicago.edu).  It is",
"based on XPaint 2.1.1, which was written by David Koblas.  Please do NOT",
"send bug reports, etc., to David Koblas.",
"The message below is the original 'About' message from version 2.1.1.",
"               ----------------------------",
"Hopefully, you find this software useful. If you find any bugs or have",
"any comments, feel free to contact me.",
"This software is created as DonateWare. If you enjoy using XPaint,",
"it would be appreciated if you would make a donation to the",
"author in the form of cookies, money, employment, or whatever.",
"If you or your firm is looking to hire a skilled consultant, contact",
"me for more details.",
"David Koblas (koblas@netcom.com)",
"#NL",
"Extra Mile Consulting",
"#NL",
"PO Box 1352",
"#NL",
"Mountain View, CA 94042-1352 USA",
"#BEGIN copyright	\"Copyright Information\"",
"Copyright (C) 1993, David Koblas",
"Copyright (C) 1995, 1996, 1997, 1998, Torsten Martinsen",
"#NL",
"Copyright (C) 1996, Greg Roelofs",
"#NL",
"Copyright (C) 1997, Scott D. Nelson",
"Permission to use, copy, modify, and to distribute this software and",
"its documentation for any purpose is hereby granted without fee,",
"provided that the above copyright notice appear in all copies and that",
"both that copyright notice and this permission notice appear in",
"supporting documentation.  There are no representations about the",
"suitability of this software for any purpose.  This software is",
"provided \"as is\" without express or implied warranty.",
