! MMS description file for xmosaic
! Bjorn S. Nilsson, Aleph, CERN, 14-Feb-1993
! xmosaic version 1.2 on 4-Jul-1993
!
! Usage:
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
!       $ MMS/MACRO=(UCX=1)             for DEC/UCX
! Add DEBUG=1 in MACRO when debugging. You may have to use the /IGNORE=WARNING
! qualifier to make MMS run all the way through also.
!
! Add AXP=1 when compiling on AXP platforms.
!

! If your server does not have 17 pt fonts or Lucida fonts, keep the next line.
VMS_DEFS = NO_17_PT,NO_LUCIDA,

NAME = XMOSAIC
CC = CC

.IFDEF AXP
CFLAGSAXP=/Standard=VAXC
.ELSE
CFLAGSAXP=
.ENDIF

.IFDEF DEBUG
CC_OPTIONS =/NoOpt/Debug$(CFLAGSAXP)
LINK_OPTIONS =/Debug
.ELSE
CC_OPTIONS =$(CFLAGSAXP)
LINK_OPTIONS =/NoDebug/NoTrace
.ENDIF

.IFDEF UCX
.IFDEF DEBUG
CFLAGS =/Define=($(VMS_DEFS)UCX,DEBUGVMS)
.ELSE
CFLAGS =/Define=($(VMS_DEFS)UCX)
.ENDIF
OPTION_FILE = UCX.Opt
LIBS = UCX.Opt/Opt
TCP=UCX
.ENDIF
.IFDEF MULTINET
.IFDEF DEBUG
CFLAGS =/Define=($(VMS_DEFS)MULTINET,DEBUGVMS)
.ELSE
CFLAGS =/Define=($(VMS_DEFS)MULTINET)
.ENDIF
LIBS = Multinet.Opt/Opt
OPTION_FILE = Multinet.Opt
TCP=MULTINET
.ENDIF

.FIRST
	Define Sys SYS$Library
	Topdir = F$Environment("Default")-"SRC]"
	Define LIBHTMLW 'Topdir'LIBHTMLW]
	Define LIBWWW   'Topdir'LIBWWW]
.IFDEF AXP
	Define DECC$User_Include 'F$Environment("Default")',LIBWWW,SYS$Library
	Define DECC$System_Include 'F$Environment("Default")',LIBWWW,SYS$Library
.ELSE
	Define VAXC$Include 'F$Environment("Default")',SYS$Library
.ENDIF

PROG_LIBS = [-.LIBHTMLW]LIBHTMLW.OLB, [-.LIBWWW]LIBWWW.OLB
PROG_LIBSQ = [-.LIBHTMLW]LIBHTMLW.OLB/LIB, [-.LIBWWW]LIBWWW.OLB/LIB

CFILES = main.c gui.c gui2.c mo-www.c mo-dtm.c hotlist.c whine.c history.c -
  annotate.c pan.c grpan.c grpan-www.c audan.c mo-dmf.c globalhist.c img.c -
  instrument.c startup.c

OBJECTS = main.obj,gui.obj,gui2.obj,mo-www.obj,mo-dtm.obj,hotlist.obj,whine.obj,-
  history.obj,-
  annotate.obj,pan.obj,grpan.obj,grpan-www.obj,audan.obj,mo-dmf.obj,-
  globalhist.obj,img.obj,-
  instrument.obj,startup.obj

AUXCFILES = Xmx.c Xmx2.c picread.c gifread.c medcut.c
AUXOBJS = Xmx.obj,Xmx2.obj,picread.obj,gifread.obj,medcut.obj

HFILES = mosaic.h

xmosaic.exe : $(OBJECTS) $(AUXOBJS) $(PROG_LIBS)
	LINK$(LINK_OPTIONS)/Exe=$(NAME).exe $(OBJECTS),$(AUXOBJS),$(PROG_LIBSQ),[]$(LIBS)
	Write SYS$Output "Linking done."

$(OBJECTS) : $(HFILES)

gui.obj : xresources.h

.c.obj :
	$(CC)$(CC_OPTIONS)$(CFLAGS) $*.C

clean :
	Delete/Log *.OBJ;*

