! MMS description file for LIBWWW
! Bjorn S. Nilsson, Aleph, CERN, 14-Feb-1993
! (xmosaic version 1.2 4-Jul-1993)
!
! Usage:
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
!       $ MMS/MACRO=(UCX=1)             for DEC/UCX
! Add DEBUG=1 in MACRO when debugging. You may have to use the /IGNORE=WARNING
! qualifier to make MMS run all the way through also.
! Add AXP=1 when compiling on AXP platforms.
!

CC = CC
.IFDEF AXP
CFLAGSAXP=/Standard=VAXC
.ELSE
CFLAGSAXP=
.ENDIF

LIBTARGET = libwww.olb
.IFDEF DEBUG
CFLAGS = /NoOpt/Debug$(CFLAGSAXP)
.ELSE
CFLAGS = $(CFLAGSAXP)
.ENDIF

.IFDEF UCX
COPT = /Define=UCX
.ELSE
.IFDEF MULTINET
COPT = /Define=MULTINET
.ELSE
COPT =
.ENDIF
.ENDIF

MODULES = HTAccess, HTAnchor, HTAtom, HTChunk, HTFTP, -
	HTFile, HTFormat, HTGopher, HTHistory, HTList, -
	HTML, HTNews, HTParse, HTString, HTStyle, -
	HTTCP, HTTP, SGML

CFILES = $(MODULES:=.c)

OBJECTS = $(CFILES:.c=.obj)

$(LIBTARGET) : $(LIBTARGET)($(MODULES)) $(OBJECTS)
	Write SYS$Output "Library actions done."

.c.obj :
	$(CC)$(CFLAGS)$(COPT) $*.C

clean :
	Delete/Log *.OBJ;*
	Delete/Log $(LIBTARGET);*

