/* hash.h: TCL hash table routines
**
** Written and copyright (C) 1996 by Michael J. Gourlay
**
** PROVIDED AS IS.  NO WARRENTIES, EXPRESS OR IMPLIED.
*/

#include <tcl.h>

/* HASH_FIND: look up hash table entry
** This macro relies on the existence of a token named similarly to the
** table name which indicates whether the table has been initialized.
** Look at the use of the "tbl" actual argument.
**
** e.g. if there is a table named "hash_table" then HASH_FIND also
** assumes that there is an integer variables named "hash_table_initF"
** which is set to zero if the table is not yet initialized, or nonzero
** if the table is initialized.
*/

#define HASH_FIND(tbl,tag,dataP,DataT,proc)  \
{  \
  Tcl_HashEntry *entryP;  \
  if( ! (tbl ## _initF)) {  \
    sprintf(interp->result, "%s: hash table %s is not initialized\n", (proc), (#tbl)); \
    return TCL_ERROR;  \
  }  \
  /* Find the pointer to the rgba image */  \
  if((entryP = Tcl_FindHashEntry(&(tbl), (tag))) == NULL)  \
  {  \
    sprintf(interp->result, "%s: could not find tag for %s in %s\n", (proc), (tag), (#tbl)); \
    return TCL_ERROR;  \
  }  \
  (dataP) = (DataT*)Tcl_GetHashValue(entryP);  \
}



void createTag(const void *dataP, char *tag, const char *template, int *initP, Tcl_HashTable *tableP);
