/*************************************************************************
 * File: xmvarargs.c
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/12/03 04:05:19 $
 * Version: $Revision: 1.6 $
 * Purpose: varargs interface to Motif, supplying varargs version
 *          of all the XmCreate<widget> () functions
 *
 * Revision history:
 *      3 Nov 92      lint-ed
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdio.h>
#ifdef UseFunctionPrototypes
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/ArrowB.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Command.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>

/*************************************************************************
 * Local includes
 ************************************************************************/ 

#include "xmvararg.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
/* exported if not defined by Xt (i.e. X11R3) */
extern	Widget	XtVaCreateManagedWidget(
#ifdef UseFunctionPrototypes
	const char *, WidgetClass, Widget, ...
#endif
);
extern	void	XtVaGetValues(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern	void	XtVaSetValues(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);

/* exported anyway */
extern  Widget XmVaCreateArrowButton (
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);  /* etc */

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 
extern	Widget	XtVaCreateManagedWidget(
#ifdef UseFunctionPrototypes
	const char *, WidgetClass, Widget, ...
#endif
);
extern	void	XtVaGetValues(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern	void	XtVaSetValues(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern 	Widget 	XmVaCreateLabel(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 
#define		NXARGS	100

static va_list		args;
static Arg		xargs[NXARGS];
static Widget		parent;
static String		name;

/*************************************************************************
 * Function: SetArgs
 * Purpose: store args in array
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
static int
SetArgs
#ifdef UseFunctionPrototypes
	(void)
#else
	()

#endif
{	register int n;

	for (n = 0; n < NXARGS; ++n)
	{
		xargs[n].name = va_arg(args, String);
		if (xargs[n].name == NULL) 
			break;
		xargs[n].value = va_arg(args, XtArgVal);
	}
	return (n);
}

/*************************************************************************
 * Function: SetNameArgs
 * Purpose: peel off first 2 params (fixed), then loop through rest
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
static int
SetNameArgs
#ifdef UseFunctionPrototypes
	(void)
#else
	()

#endif
{	register int n;

#ifndef UseFunctionPrototypes
	parent = va_arg(args, Widget);
#endif
	name = va_arg(args, String);

	for (n = 0; n < NXARGS; ++n)
	{
		xargs[n].name = va_arg(args, String);
		if (xargs[n].name == NULL) 
			break;
		xargs[n].value = va_arg(args, XtArgVal);
	}
	return (n);
}


/*
**      varargs interface for Xt not defined for Motif 1.0
**      because it is based on X11 R3. In this case, define
**      equivalents to the Xt functions
*/
#if XmVersion == 1000

/*
 *	Variable arg list version of XtCreateManagedWidget
 */
/* VARARGS */
/*************************************************************************
 * Function: XtVaCreatemanagedWidget
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
Widget
XtVaCreateManagedWidget(va_alist)
va_dcl
{
	String		name;
	String		class;
	Widget		parent;

	register int	n;

	Va_start (args, parent);
	name = va_arg(args, String);
	class = va_arg(args, String);
	parent = va_arg(args, Widget);

	n = SetArgs();

	va_end(args);
	return (XtCreateManagedWidget(name, class, parent, xargs, n));
}

/*************************************************************************
 * Function: XtVaSetvalues
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
void
XtVaSetValues(va_alist)
va_dcl
{
	Widget		w;
	register int	n;

	Va_start (args, parent);
	w = va_arg(args, Widget);

	n = SetArgs();

	va_end(args);
	XtSetValues(w, xargs, n);
}

/*************************************************************************
 * Function: XtVaGetValues
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
void
XtVaGetValues(va_alist)
va_dcl
{
	register int 	n;
	Widget		w;

	Va_start (args, parent);
	w = va_arg(args, Widget);

	n = SetArgs();

	va_end(args);
	XtGetValues(w, xargs, n);
}
#endif /* Xmversion == 1000 */

/**********************************************************************
**	Variable arg list versions of widgets
**
*/

/*
**	Variable arg list version of XmCreateArrowButton
*/
/*************************************************************************
 * Function: XmVACreateArrowButton
 * Purpose: varargs interface to XmCreateArrowButton
 * In parameters: parent, name, args...
 * Out parameters:
 * Precondition;
 * Postcondition: arrow button created with resources set as in args
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateArrowButton
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmArrowButtonWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateBulletinBoard
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateBulletinBoard
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmBulletinBoardWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateCascadeButton
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateCascadeButton
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmCascadeButtonWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateCommand
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateCommand
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmCommandWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateDialogShell
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateDialogShell
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmDialogShellWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateDrawingArea
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateDrawingArea
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmDrawingAreaWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateDrawnButton
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateDrawnButton
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmDrawnButtonWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateFileSelectionBox
*/
/* VARARGS */
Widget
XmVaCreateFileSelectionBox
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmFileSelectionBoxWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateForm
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateForm
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmFormWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateFrame
*/
/* VARARGS */
Widget
XmVaCreateFrame
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmFrameWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateLabel
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateLabel
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmLabelWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateList
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateList
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmListWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateMainWindow
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateMainWindow
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmMainWindowWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateMessageBox
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateMessageBox
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmMessageBoxWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreatePanedWindow
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreatePanedWindow
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmPanedWindowWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreatePushButton
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreatePushButton
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmPushButtonWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateRowColumn
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateRowColumn
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmRowColumnWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateScale
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateScale
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmScaleWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateScrollBar
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateScrollBar
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmScrollBarWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateSelectionBox
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateSelectionBox
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmSelectionBoxWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateSeparator
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateSeparator
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmSeparatorWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateText
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateText
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmTextWidgetClass, 
				parent, xargs, n));
}

/*
**	Variable arg list version of XmCreateToggleButton
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateToggleButton
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XtCreateWidget(name, xmToggleButtonWidgetClass, 
				parent, xargs, n));
}

/**********************************************************************
**	Variable arg list versions of dialogs
**
*/

/*
**	Variable arg list version of XmCreateErrorDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateErrorDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateErrorDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateFileSelectionDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateFileSelectionDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateFileSelectionDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateFormDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateFormDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateFormDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateInformationDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateInformationDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateInformationDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateMessageDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateMessageDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateMessageDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreatePromptDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreatePromptDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreatePromptDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateQuestionDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateQuestionDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateQuestionDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateSelectionDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateSelectionDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateSelectionDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateWarningDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateWarningDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateWarningDialog(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateWorkingDialog
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateWorkingDialog
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
        register int    n;

        Va_start (args, parent);

        n = SetNameArgs();

        va_end(args);
        return (XmCreateWorkingDialog(parent, name, xargs, n));
}

/**********************************************************************
**	Variable arg list versions of RowColumn convenience routines
**
*/

/*
**	Variable arg list version of XmCreateMenuBar
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateMenuBar
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreateMenuBar(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateOptionMenu
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateOptionMenu
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreateOptionMenu(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreatePopupMenu
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreatePopupMenu
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreatePopupMenu(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreatePulldownMenu
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreatePulldownMenu
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreatePulldownMenu(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateRadioBox
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateRadioBox
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreateRadioBox(parent, name, xargs, n));
}


/**********************************************************************
**	Variable arg list versions of ScrollBar convenience routines
**
*/

/*
**	Variable arg list version of XmCreateScrolledList
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateScrolledList
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreateScrolledList(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateScrolledText
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateScrolledText
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreateScrolledText(parent, name, xargs, n));
}

/*
**	Variable arg list version of XmCreateScrolledWindow
*/
/*************************************************************************
 * Function:
 * Purpose:
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
/* VARARGS */
Widget
XmVaCreateScrolledWindow
#ifdef UseFunctionPrototypes
	(Widget parent, ...)
#else
	(va_alist)
va_dcl

#endif
{
	register int	n;

	Va_start (args, parent);

	n = SetNameArgs();

	va_end(args);
	return (XmCreateScrolledWindow(parent, name, xargs, n));
}

