.\"
.\" xmfm : X11/Motif file manager
.\"
.\" Jan Newmarch, jan@pandonia.ise.edu.au, 16 Oct 1992.
.\"
.TH XMFM 1 "16 Oct 1992"
.SH NAME
xmfm \- X11/Motif file manager
.SH SYNOPSIS
.na
.in +8n
.ti -8n
.I xmfm
[-configFile
.I configFile
]
[X\ Toolkit\ options]
.in -8n
.ad
.SH DESCRIPTION
.PP
.I Xmfm
is an X11/Motif file manager.
It allows users to manipulate files and directories in a visual
way using icons to represent them.
The icons are shown in three pane areas, representing executable files
(programs), ordinary files and directories.
These areas can be resized by dragging on the pane buttons (using
the left mouse button).
If the list of icons is too large to show in a pane,
a scroll bar appears to the right of the pane, and the
different parts of the pane can be shown by dragging or clicking
(with the left button)
in the scroll bar.
.PP
Files, programs and directories can be selected by clicking on them.
At most one can be selected at any time.
When one is selected, a list of possible actions associated with
that file is shown in a set of buttons to the left of the panes.
By then clicking on one of these buttons, the action is carried
out on the selected file.
If the left button is double-clicked on a file, program or directory,
the default action is carried out on the selection.
The default action is the first action shown in the action buttons.
.PP
A further set of buttons below these ones shows a general set of actions
that can be applied in many cases (such as showing information on the
selection).
A click on one of these buttons applies the action to the selected
file, program or directory.
.PP
Menu actions are used to perform file manipulation actions
such as copy, and running other Unix programs from within 
.I xmfm.
.SH OPTIONS
.PP
.I xmfm
accepts the normal Xt and Motif toolkit options.
For example:
.IP "\fB-display\fP display"
Uses the display specified in the argument.
Note that the display must give permission to be used.
.IP "\fB-foreground\fP colour"
Set the foreground colour.
.IP "\fB-background\fP colour"
Set the background colour.
.PP
In addition the
.I configFile
option allows the user to choose a configuration file to replace the
.I .xmfmrc
file.
This can be used (for example) to test local changes to 
.I .xmfmrc
before installing it.
.SH "CUSTOMIZING XMFM"
.PP
.I Xmfm
uses a number of files to control behaviour.
It uses the normal Xt resource database to control such things as
foreground and background colours, server, and size.
Indidual components can also be configured using this database
and the widget hierarchy.
See any book on Motif for this.
.PP
In addition,
.I xmfm
uses a configuration file to control the actions corresponding
to different file types.
A system default is set in the file
.I /usr/lib/X11/app-defaults/xmfmrc.
The user can copy and modify this file as
.I $HOME/.xmfmrc.
The syntax used in this file is described in the
.I "Xmfm Users Guide.
.PP
The user can choose the icons to be shown for each file type.
These icons must be in directories accessible from the
.I XmGetPixmap()
function call.
See the next section on bitmaps.

.SH "Bitmaps
.PP
The location of the bitmaps used in 
.I xmfm
is controlled by the environment variables \fBXBMLANGPATH\fP and
\fBXAPPLRESDIR\fP. If the variable \fBXBMLANGPATH\fP is set to a
path-name followed by %B, bitmaps will be searched for in that path.
For example (using the C shell syntax)

.ta 8,12,16,20,24,28,32,36,40
.na
.nf
	setenv XBMLANGPATH /usr/usrs/jan/bitmaps/%B
.fi
.ad

If this is not set but the environment variable \fBXAPPLRESDIR\fP is set,
the following paths are searched:
.ta 1i
.na
.nf
        $XAPPLRESDIR/%L/bitmaps/XmFm
        $XAPPLRESDIR/%l/bitmaps/XmFm
        $XAPPLRESDIR/bitmaps/XmFm
        $XAPPLRESDIR/%L/bitmaps
        $XAPPLRESDIR/%l/bitmaps
        $XAPPLRESDIR/bitmaps
        $HOME/bitmaps
        $HOME
        /usr/lib/X11/%L/bitmaps/XmFm
        /usr/lib/X11/%l/bitmaps/XmFm
        /usr/lib/X11/bitmaps/XmFm
        /usr/lib/X11/%L/bitmaps
        /usr/lib/X11/%l/bitmaps
        /usr/lib/X11/bitmaps
.fi
.ad
If neither is set, the following paths are searched
.ta 1i
.na
.nf
        $HOME/%L/bitmaps/XmFm
        $HOME/%l/bitmaps/XmFm
        $HOME/bitmaps/XmFm
        $HOME/%L/bitmaps
        $HOME/%l/bitmaps
        $HOME/bitmaps
        $HOME
        /usr/lib/X11/%L/bitmaps/XmFm
        /usr/lib/X11/%l/bitmaps/XmFm
        /usr/lib/X11/bitmaps/XmFm
        /usr/lib/X11/%L/bitmaps
        /usr/lib/X11/%l/bitmaps
        /usr/lib/X11/bitmaps
        /usr/include/X11/bitmaps
.fi
.ad
These paths are defaults that a vendor may have changed.
Here %L is the display's language string, and %l is the language
component of the display's language string.

.SH "Widget Hierarchy"
.PP
.I Xmfm
uses standard Motif widgets that can be customized as usual.
The widget hierarchy
is as follows:

.ta 8,12,16,20,24,28,32,36,40
.na
.nf
	TopLevelShell xmfm
		MainWindow main
			Form form
				Label directory_label
				RowColumn files_toolbar
					PushButton file_button
				RowColumn dirs_toolbar
					PushButton dir_button
				PanedWindow pane
					PanedWindow rc1
						Label executable_filter_label
						ScrolledWindow sw1
							RowColumn executables_pane
								DrawnButton ?
					PanedWindow rc2
						Label file_filter_label
						ScrolledWindow sw2
							RowColumn files_pane
								DrawnButton ?
					PanedWindow rc3
						Label dir_filter_label
						ScrolledWindow sw3
							RowColumn dirs_pane
								DrawnButton ?
.fi
.ad
.SH BUGS
.PP
If 
.I xmfm
uses a display other than that in the environment variable
$DISPLAY, 
.IR xterm 's
invoked from within
.I xmfm
will appear on the wrong display, the one in $DISPLAY.
Some parts of 
.I xmfm
do not perform ~ substitution or environment variable
expansion.
.SH "SEE ALSO"
.PP
X(1),
.I "Motif Style Guide.
Any good Motif book, such as J.D Newmarch,
.I "The X Window System and Motif - A Fast Track Approach
.SH AUTHOR
.PP
Jan Newmarch, University of Canberra
.br
(jan@ise.canberra.edu.au)
