/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/types.h,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/17 00:35:57 $
 * Version: $Revision: 1.6 $
 * Purpose:
 *
 * Revision history:
 *	11 Aug 92	added description field to file_action
 *      22 Ayg 92       added run_dialog and info_dialog as per pane stuff
 ************************************************************************/ 

#include "copyright.h"

#ifndef _XMFM_TYPES_H
#define _XMFM_TYPES_H

#include <Xm/Xm.h>

/*
 *	These definitions are usually in <sys/types.h> under Unix
 */
#ifdef vax11c
typedef unsigned char	u_char;
typedef unsigned short	u_short;
typedef unsigned int	u_int;
typedef unsigned long	u_long;
typedef unsigned short	ushort;
typedef unsigned int	uint;
typedef int		pid_t;
#endif /* vax11c */

#include "DirMgr.h"

#define FSM_LENGTH 1024

/*****************************************************************
 * Data type:
 * Used by:
 * Purpose:
 * Description:
 *****************************************************************/

/*****************************************************************
 * Data type: action_pair
 * Used by: do_command(), FileToolbarButtonPressed()
 * Purpose: define a possible action that can be taken on a file
 * Description: It contains a label to be displayed in an action button,
 *		the action itself,
 *		Booleans to control the exection environment of the command,
 *		and a pointer to another action_pair record
 *****************************************************************/

typedef struct _action_pair
{
	char			*action_label;
	char			*action;
	char			*prompt;
#ifdef vax11c
	Bool			refresh_dir;
#endif /* vax11c */
	Bool			run_in_xterm;
	Bool			pause_after_exec;
	Bool			has_prompt;
	struct action_pair	*next;
}	action_pair;


typedef struct _file_action
{
	char			file_type;
	char			*name_pattern;
#ifdef vax11c
	char			*fsm_ptr;
#else
	char			fsm_ptr[FSM_LENGTH];
#endif /* vax11c */
	char			*pixmap;
	char			*description;
	action_pair		*actions;
	struct file_action	*next;
}	file_action;

typedef struct _aWidgetList
{
	Widget			widget;
	struct _aWidgetList	*next;
} aWidgetList;

typedef struct info_dialog_widgets
{  Widget	form,
                filename_label,
		filename,
                separator,
		size_label,
		size,
		owner_label,
		owner,
		description_label,
		description,
		perms_label,
		perms_rowcol,
		empty_label,
		read_label,
		write_label,
                exec_label,
		user_label,
		group_label,
		other_label,
		ur_toggle,
		uw_toggle,
		ux_toggle,
		gr_toggle,
		gw_toggle,
		gx_toggle,
		or_toggle,
		ow_toggle,
		ox_toggle;
}      info_dialog_widgets;


/*****************************************************************
 * Data type: dir_pane-info
 * Used by: almost everything.
 * Purpose: it carries around "global" data to all callbacks that need
 *	it.  It is placed in the user data of most widgets (except file
 *	buttons, which use pane_button_info, and toolbar buttons which
 *	use tool_button_info). Most callbacks get this structure from
 *	their userData first off. There is one of these per directory
 *	showing.
 * Description:
 *****************************************************************/
typedef struct dir_pane_info
{	
	/* label at top showing current dir */
	Widget		directory_label;

	/* two sets of toolbar buttons */
	Widget		*files_toolbar;
	Widget		*dirs_toolbar;

	/* three lists of file/dir/exec buttons in the panes */
	aWidgetList	*files_buttons;
	aWidgetList	*executables_buttons;
	aWidgetList	*dirs_buttons;

	/* and the panes they are in */
	Widget		files_pane;
	Widget		dirs_pane;
	Widget		executables_pane;

	/* list of all files in current dir matching selection pattern */
	DirectoryMgr	*directory_manager;

	/* currently selected file/dir/exec button */
	char		*file_selected;		/* name */
	Widget		file_button_selected;	/* widget button */
	char		*description;		/* what sort of file */

	char		*executable_selected;	/* unused */
	char		*dir_selected;		/* unused */

	/* top of this widget tree */
	Widget		toplevel;

	/* filters used in file matching */
	char		*file_filter;
#ifdef vax11c
	char		*file_filter_regexp;
#else
	char		file_filter_regexp[FSM_LENGTH];
#endif /* vax11c */
	char		*dir_filter;
#ifdef vax11c
	char		*dir_filter_regexp;
#else
	char		dir_filter_regexp[FSM_LENGTH];
#endif /* vax11c */
	char		*executable_filter;
#ifdef vax11c
	char		*executable_filter_regexp;
#else
	char		executable_filter_regexp[FSM_LENGTH];
#endif /* vax11c */
	char		all_filter;

	/* widgets showing the filter info */
	Widget		file_filter_label;
	Widget		dir_filter_label;
	Widget		executable_filter_label;

        /* dialogs that are non-transient, must be kept on a per pane basis */
        Widget          run_dialog;
        Widget          info_dialog;
        info_dialog_widgets *idw;
}	dir_pane_info;

typedef struct pane_button_info
{	char		*name;
	char		file_type;
	dir_pane_info	*dpi;
	Pixmap		pixmap;
	Pixmap		pixmap_reversed;
	GC		gc;
	GC		gc_reversed;
}	pane_button_info;

typedef struct tool_button_info
{	char		*action;
	dir_pane_info	*dpi;
#ifdef vax11c
	Bool		refresh_dir;
#endif /* vax11c */
	Bool		run_in_xterm;
	Bool		pause_after_exec;
        Bool            has_prompt;
        char            *prompt;
}	tool_button_info;

#ifndef S_ISDIR
#define S_ISDIR(m)	((m) & S_IFDIR)
#endif

#endif /* _XMFM_TYPES_H */
