/****************************************************************************

	RegExp.c

	This file contains the C code for the regular expression
	matching code.

	The routines supported act as a more friendly, user level
	interface to the regexp regular expression matching system.

 ****************************************************************************/

#include "RegExp.h"
#ifndef NO_REGEXP
#ifdef vax11c
#include "vms_regex.h"
#else
#include <regexp.h>
#endif /* vax11c */
#endif

#ifdef vax11c
char *
#else
void 
#endif /* vax11c */
RegExpCompile
#ifdef UseFunctionPrototypes
	(char *regexp, char *fsm_ptr, int fsm_length)
#else
	(regexp,fsm_ptr,fsm_length)
char *regexp,*fsm_ptr;
int fsm_length;

#endif
{
#ifndef NO_REGEXP
#ifdef vax11c
	fsm_ptr = re_comp(regexp, fsm_ptr);
	return fsm_ptr;
#else
	compile(regexp,fsm_ptr,&(fsm_ptr[fsm_length]),'\0');
#endif /* vax11c */
#endif
} /* End RegExpCompile */


int RegExpMatch
#ifdef UseFunctionPrototypes
	(char *string, char *fsm_ptr)
#else
	(string,fsm_ptr)
char *string,*fsm_ptr;

#endif
{
#ifndef NO_REGEXP
#ifdef vax11c
	if (re_exec(string, fsm_ptr) > 0)
		return(TRUE);
	else 
		return(FALSE);
#else
	if (advance(string,fsm_ptr) != 0)
		return(TRUE);
	    else
		return(FALSE);
#endif /* vax11c */
#else
	return(TRUE);
#endif
} /* End RegExpMatch */


void _RegExpError
#ifdef UseFunctionPrototypes
	(int val)
#else
	(val)
int val;

#endif
{
	fprintf(stderr,"Regular Expression Error %d\n",val);
	exit(-1);
} /* End _RegExpError */


void RegExpPatternToRegExp
#ifdef UseFunctionPrototypes
	(char *pattern, char *reg_exp)
#else
	(pattern,reg_exp)
char *pattern,*reg_exp;

#endif
{
	int in_bracket;

	in_bracket = 0;
	while (*pattern != '\0')
	{
		if (in_bracket)
		{
			if (*pattern == ']') in_bracket = 0;
			*reg_exp++ = *pattern++;
		}
		    else
		{
			switch (*pattern)
			{
			    case '[':
				in_bracket = 1;
				*reg_exp++ = '[';
				break;
			    case '?':
				*reg_exp++ = '.';
				break;
			    case '*':
				*reg_exp++ = '.';
				*reg_exp++ = '*';
				break;
			    case '.':
				*reg_exp++ = '\\';
				*reg_exp++ = '.';
				break;
			    default:
				*reg_exp++ = *pattern;
				break;
			}
			++ pattern;
		}
	}
	*reg_exp++ = '$';
	*reg_exp++ = '\0';
} /* End RegExpPatternToRegExp */
