/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/info.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/17 00:35:47 $
 * Version: $Revision: 1.2 $
 * Purpose:
 *
 * Revision history:
 *      22 Aug 92      made info dialog a per pane object, accessible via dpi
 *	8  Sep 92      fixed bug that used run dialog instead of info dialog
 *       3 Nov 92      lint-ed
 *	11 Nov 92      follow symbolic links to actual info, ignore link file
 *	12 Nov 92      file permissions can now be edited
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdio.h>
#ifdef vax11c
#include "pwd.h"
#else
#include <pwd.h>
#endif /* vax11c */
#include <string.h>
#include <Xm/SelectioB.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <sys/types.h>
#include <sys/stat.h>

/*************************************************************************
 * Local includes
 ************************************************************************/ 
#include "const.h"
#include "types.h"
#include "xmvararg.h"
#include "DirMgr.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
void builtin_info (
#ifdef UseFunctionPrototypes
	dir_pane_info *dpi
#endif
);

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 
extern void WarningDialog (
#ifdef UseFunctionPrototypes
	Widget parent, char *prompt, int modal, int *answer
#endif
);

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 
#define EXECUTABLE(m)	((m) & (S_IXUSR | S_IXGRP | S_IXOTH))
static Widget	dialog = NULL;

/* its a bit gross having these all as static, but we have to keep them
   around somewhere if we are going to reuse the dialog instead of 
   recreating it each time
*/
static	Widget	form,
                filename_label,
		filename,
                separator,
		size_label,
		size,
		owner_label,
		owner,
		description_label,
		description,
		perms_label,
		perms_rowcol,
		empty_label,
		read_label,
		write_label,
                exec_label,
		user_label,
		group_label,
		other_label,
		ur_toggle,
		uw_toggle,
		ux_toggle,
		gr_toggle,
		gw_toggle,
		gx_toggle,
		or_toggle,
		ow_toggle,
		ox_toggle;

static Bool mode_changed;	/* has the user changed file mode? */

/*************************************************************************
 * Function	   : OkCB ()
 * Purpose         : change file mode if needed when ok button pressed
 * In parameters   : w, client_data, call_data
 * Out parameters  :
 * Side effects    : 
 * Function returns:
 * Precondition    : 
 * Postcondition   :
 ************************************************************************/ 
static void
OkCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;

#endif
{
	dir_pane_info *dpi;
	DirEntry *de;
	Boolean button_set;
	Arg args[1];
	char *file_selected;
#ifdef vax11c
	u_short new_mode, old_mode;
#else
	mode_t new_mode, old_mode;
#endif /* vax11c */

#ifdef DEBUG
	fprintf ("mode_changed: %d\n", mode_changed);
#endif
	if ( !mode_changed)
		return;
		
	new_mode = 0;
	/* build the new mode from the state of the mode buttons */
	XtSetArg (args[0], XmNset, &button_set);
	XtGetValues (ur_toggle, args, 1);
	if (button_set)
		new_mode |= S_IRUSR;
	XtGetValues (uw_toggle, args, 1);
	if (button_set)
		new_mode |= S_IWUSR;
	XtGetValues (ux_toggle, args, 1);
	if (button_set)
		new_mode |= S_IXUSR;
	XtGetValues (gr_toggle, args, 1);
	if (button_set)
		new_mode |= S_IRGRP;
	XtGetValues (gw_toggle, args, 1);
	if (button_set)
		new_mode |= S_IWGRP;
	XtGetValues (gx_toggle, args, 1);
	if (button_set)
		new_mode |= S_IXGRP;
	XtGetValues (or_toggle, args, 1);
	if (button_set)
		new_mode |= S_IROTH;
	XtGetValues (ow_toggle, args, 1);
	if (button_set)
		new_mode |= S_IWOTH;
	XtGetValues (ox_toggle, args, 1);
	if (button_set)
		new_mode |= S_IXOTH;

	XtVaGetValues (w,
		XmNuserData, (XtArgVal) &dpi,
		NULL);

	file_selected = dpi -> file_selected;
	DirectoryMgrGotoNamedItem (dpi -> directory_manager,
					file_selected);
	de = DirectoryMgrCurrentEntry (dpi -> directory_manager);

	/* has the user really made it different? */
	if (new_mode == FileInfoProt (DirEntryActualInfo (de)))
		return;		/* no they didn't */

	/* actually change the mode */
	if (chmod (file_selected, new_mode) == -1)
		return; 	/* oh well, couldn't change it */

	/* reset our stored info */
	old_mode = FileInfoProt (DirEntryActualInfo (de));
	FileInfoProt (DirEntryActualInfo (de)) = new_mode;

	/* if it is a dir, nothing left to do.
	   if it is now executable but wasn't before, or vice
	   versa, need to refresh panes
	*/
	if (DirEntryIsDir (de) ||
		DirEntryIsSymLink (de) &&
			S_ISDIR (FileInfoOrigMode (DirEntryActualInfo (de))))
		return;
	if ((EXECUTABLE (old_mode) && ! EXECUTABLE (new_mode)) ||
	    ( ! EXECUTABLE (old_mode) && EXECUTABLE (new_mode)))
		ResetPanesAndSelectFile (dpi, dpi -> file_selected);
}

/*************************************************************************
 * Function	   : toggleCB ()
 * Purpose         : set mode_changed to true
 * In parameters   : w, client_data, call_data
 * Out parameters  :
 * Side effects    : 
 * Function returns:
 * Precondition    : 
 * Postcondition   :
 ************************************************************************/ 
void
toggleCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;

#endif
{
	mode_changed = True;
}

/*************************************************************************
 * Function	   : builtin_info ()
 * Purpose         : display info on a file, such as size, permissions, etc
 * In parameters   : dpi
 * Out parameters  :
 * Side effects    : creates and shows a file display dialog
 * Function returns:
 * Precondition    : 
 * Postcondition   :
 ************************************************************************/ 
void
builtin_info 
#ifdef UseFunctionPrototypes
	(dir_pane_info *dpi)
#else
	(dpi)
	dir_pane_info *dpi;

#endif
{	
	DirEntry	*de;
	long		long_size;
	char		str_size[1024];
	XmString	xm_size;
	int		uid;
	struct passwd	*pw_entry;
	XmString	xm_pw_name;
	XmString	xm_file_selected;
        XmString        xm_description;
        static XmString	xm_empty;
	static short		permissions;
	static Bool		state;
	int		dummy;
	

	if (dpi -> file_selected == NULL)
	{	WarningDialog (dpi -> toplevel,
			"Can only show information on a selected file",
			True, &dummy);
		return;
	}
        dialog = dpi -> info_dialog;

	if (dialog == NULL)
	{
		xm_empty = XmStringCreateSimple ("");
		/* create a "prompt" dialog with the prompt bits left out */
		dialog = XmVaCreatePromptDialog (dpi -> file_button_selected,
					"information",
					NULL);
                dpi -> info_dialog = dialog;
		XtUnmanageChild ( 
			XmSelectionBoxGetChild (dialog, XmDIALOG_TEXT));
		XtUnmanageChild ( 
			XmSelectionBoxGetChild (dialog, XmDIALOG_SELECTION_LABEL));
		XtUnmanageChild ( 
			XmSelectionBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));

		XtAddCallback (dialog, XmNokCallback, OkCB, NULL);
	
		/* add the widget we want as the work area */
		form = XmVaCreateForm (dialog, "form",
				NULL);
		
		/* put stuff in the form */
		filename_label = XmVaCreateLabel (form, "Filename",
				NULL);
#ifdef  FILENAME_IS_EDITABLE
		/* uses text string - in case we want to change filename.
		   but it makes geometry harder */
		filename = XmVaCreateText (form, "filename",
                                XmNeditable, (XtArgVal) False,
				NULL);
#else
		filename = XmVaCreateLabel (form, "filename",
				NULL);
#endif /* FILENAME_IS_EDITABLE */
                separator = XmVaCreateSeparator (form, "separator",
                                XmNseparatorType, (XtArgVal) XmNO_LINE,
                                NULL);
		size_label = XmVaCreateLabel (form, "Size",
				NULL);
		size = XmVaCreateLabel (form, "size",
				NULL);
		owner_label = XmVaCreateLabel (form, "Owner",
				NULL);
		owner = XmVaCreateLabel (form, "owner",
				NULL);
		description_label = XmVaCreateLabel (form, "Description",
				NULL);
		description = XmVaCreateLabel (form, "description",
                                XmNalignment, (XtArgVal) XmALIGNMENT_BEGINNING,
				NULL);
		perms_label = XmVaCreateLabel (form, "Permissions",
				NULL);
		perms_rowcol = XmVaCreateForm (form, "perms_rowcol",
/*				XmNpacking,     (XtArgVal) XmPACK_COLUMN,
				XmNnumColumns,  (XtArgVal) 4,
				XmNborderWidth, (XtArgVal) 1,
                                XmNisAligned,   (XtArgVal) False,
*/
				NULL);
		
		/* put stuff in the row col */
		empty_label = XmVaCreateLabel (perms_rowcol, "empty",
				NULL);
		read_label = XmVaCreateLabel (perms_rowcol, "read",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 25,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 0,
                                XmNrightAttachment,(XtArgVal) XmATTACH_POSITION,
                                XmNrightPosition,  (XtArgVal) 25,
				NULL);
		write_label = XmVaCreateLabel (perms_rowcol, "write",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 50,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 0,
                                XmNrightAttachment,(XtArgVal) XmATTACH_POSITION,
                                XmNrightPosition,  (XtArgVal) 25,
				NULL);
		exec_label = XmVaCreateLabel (perms_rowcol, "execute",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                 XmNtopAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 75,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 0,
                                XmNrightAttachment,(XtArgVal) XmATTACH_POSITION,
                                XmNrightPosition,  (XtArgVal) 25,
				NULL);
	
		user_label = XmVaCreateLabel (perms_rowcol, "user",
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 0,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 25,
				NULL);
		ur_toggle = XmVaCreateToggleButton (perms_rowcol, "ur",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 25,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 28,
				NULL);
		uw_toggle = XmVaCreateToggleButton (perms_rowcol, "uw",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 50,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 28,
				NULL);
		ux_toggle = XmVaCreateToggleButton (perms_rowcol, "ux",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 75,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 28,
				NULL);

		group_label = XmVaCreateLabel (perms_rowcol, "group",
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 0,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 50,
				NULL);
		gr_toggle = XmVaCreateToggleButton (perms_rowcol, "gr",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 25,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 53,
				NULL);
		gw_toggle = XmVaCreateToggleButton (perms_rowcol, "gw",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 50,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 53,
				NULL);
		gx_toggle = XmVaCreateToggleButton (perms_rowcol, "gx",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 75,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 53,
				NULL);

		other_label = XmVaCreateLabel (perms_rowcol, "other",
                                XmNalignment, (XtArgVal) XmALIGNMENT_BEGINNING,
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 0,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 75,
				NULL);
		or_toggle = XmVaCreateToggleButton (perms_rowcol, "or",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 25,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 78,
				NULL);
		ow_toggle = XmVaCreateToggleButton (perms_rowcol, "ow",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 50,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 78,
				NULL);
		ox_toggle = XmVaCreateToggleButton (perms_rowcol, "ox",
                                XmNalignment, (XtArgVal) XmALIGNMENT_END,
                                XmNtopAttachment,  (XtArgVal) XmATTACH_POSITION,
                                XmNtopPosition,    (XtArgVal) 75,
                                XmNleftAttachment, (XtArgVal) XmATTACH_POSITION,
                                XmNleftPosition,   (XtArgVal) 78,
				NULL);

                /* make all these buttons insensitive */
/*
                XtSetSensitive (ur_toggle, False);
                XtSetSensitive (uw_toggle, False);
                XtSetSensitive (ux_toggle, False);
                XtSetSensitive (gr_toggle, False);
                XtSetSensitive (gw_toggle, False);
                XtSetSensitive (gx_toggle, False);
                XtSetSensitive (or_toggle, False);
                XtSetSensitive (ow_toggle, False);
                XtSetSensitive (ox_toggle, False);
*/
		/* callbacks */
		XtAddCallback (ur_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (uw_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (ux_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (gr_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (gw_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (gx_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (or_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (ow_toggle, XmNarmCallback, toggleCB, NULL);
		XtAddCallback (ox_toggle, XmNarmCallback, toggleCB, NULL);
	
	
		/* manage the lot */
		XtManageChild (filename_label);
		XtManageChild (filename);
                XtManageChild (separator);
		XtManageChild (size_label);
		XtManageChild (size);
		XtManageChild (owner_label);
		XtManageChild (owner);
		XtManageChild (description_label);
		XtManageChild (description);
		XtManageChild (perms_label);
		XtManageChild (empty_label);
		XtManageChild (read_label);
		XtManageChild (write_label);
                XtManageChild (exec_label);
		XtManageChild (user_label);
		XtManageChild (group_label);
		XtManageChild (other_label);
		XtManageChild (ur_toggle);
		XtManageChild (uw_toggle);
		XtManageChild (ux_toggle);
		XtManageChild (gr_toggle);
		XtManageChild (gw_toggle);
		XtManageChild (gx_toggle);
		XtManageChild (or_toggle);
		XtManageChild (ow_toggle);
		XtManageChild (ox_toggle);
		XtManageChild (perms_rowcol);
		XtManageChild (form);
	
		/* the geometry for this mess */
		XtVaSetValues (filename_label,
			XmNtopAttachment,	(XtArgVal) XmATTACH_FORM,
			XmNrightAttachment,	(XtArgVal) XmATTACH_POSITION,
			XmNrightPosition,	(XtArgVal) 40,
			NULL);
		XtVaSetValues (filename,
			XmNtopAttachment,	(XtArgVal) XmATTACH_FORM,
			XmNleftAttachment,	(XtArgVal) XmATTACH_POSITION,
			XmNleftPosition,        (XtArgVal) 41,
                        NULL);
		XtVaSetValues (separator,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,	        (XtArgVal) filename,
			NULL);
		XtVaSetValues (size_label,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) separator,
			XmNleftAttachment,	(XtArgVal) XmATTACH_FORM,
			NULL);
		XtVaSetValues (size,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) separator,
			XmNleftAttachment,	(XtArgVal) XmATTACH_WIDGET,
                        XmNleftWidget,          (XtArgVal) size_label,
 			XmNrightAttachment,	(XtArgVal) XmATTACH_POSITION,
			XmNrightPosition,	(XtArgVal) 48,
			NULL);
		XtVaSetValues (owner_label,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) separator,
			XmNleftAttachment,	(XtArgVal) XmATTACH_POSITION,
			XmNleftPosition,		(XtArgVal) 50,
			NULL);
		XtVaSetValues (owner,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) separator,
			XmNleftAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNleftWidget,		(XtArgVal) owner_label,
			NULL);
		XtVaSetValues (description_label,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) size_label,
			XmNleftAttachment,	(XtArgVal) XmATTACH_FORM,
			NULL);
		XtVaSetValues (description,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) size_label,
			XmNleftAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNleftWidget,		(XtArgVal) description_label,
			XmNrightAttachment,	(XtArgVal) XmATTACH_FORM,
			NULL);
		XtVaSetValues (perms_label,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) description_label,
			XmNleftAttachment,	(XtArgVal) XmATTACH_FORM,
			NULL);
		XtVaSetValues (perms_rowcol,
			XmNtopAttachment,	(XtArgVal) XmATTACH_WIDGET,
			XmNtopWidget,		(XtArgVal) perms_label,
			XmNleftAttachment,	(XtArgVal) XmATTACH_FORM,
			XmNrightAttachment,	(XtArgVal) XmATTACH_FORM,
                        XmNbottomAttachment,    (XtArgVal) XmATTACH_FORM,
			NULL);

               /* save all these component widgets in info_dialog_widgets */
               dpi -> idw = (info_dialog_widgets *) XtMalloc (sizeof (info_dialog_widgets));
               dpi -> idw -> filename = filename;
               dpi -> idw -> size = size;
               dpi -> idw -> owner = owner;
               dpi -> idw -> description = description;
               dpi -> idw -> empty_label = empty_label;
               dpi -> idw -> ur_toggle = ur_toggle;
               dpi -> idw -> uw_toggle = uw_toggle;
               dpi -> idw -> ux_toggle = ux_toggle;
               dpi -> idw -> gr_toggle = gr_toggle;
               dpi -> idw -> gw_toggle = gw_toggle;
               dpi -> idw -> gx_toggle = gx_toggle;
               dpi -> idw -> or_toggle = or_toggle;
               dpi -> idw -> ow_toggle = ow_toggle;
               dpi -> idw -> ox_toggle = ox_toggle;
	}
        else
        {   /* get all these widgets back out of dpi */
               filename = dpi -> idw -> filename;
               size = dpi -> idw -> size;
               owner = dpi -> idw -> owner;
               description = dpi -> idw -> description;
               empty_label = dpi -> idw -> empty_label;
               ur_toggle = dpi -> idw -> ur_toggle;
               uw_toggle = dpi -> idw -> uw_toggle;
               ux_toggle = dpi -> idw -> ux_toggle;
               gr_toggle = dpi -> idw -> gr_toggle;
               gw_toggle = dpi -> idw -> gw_toggle;
               gx_toggle = dpi -> idw -> gx_toggle;
               or_toggle = dpi -> idw -> or_toggle;
               ow_toggle = dpi -> idw -> ow_toggle;
               ox_toggle = dpi -> idw -> ox_toggle;
        }

	/* whether just created or new, need to set all the following */
	mode_changed = False;

	XtVaSetValues (dialog, XmNuserData, dpi, NULL);

	/* set file name */
#ifdef  FILENAME_IS_EDITABLE
	XmTextSetString (filename, dpi -> file_selected);
#else
	xm_file_selected = XmStringCreateSimple (dpi -> file_selected);
	XtVaSetValues (filename, XmNlabelString, xm_file_selected, NULL);
	XmStringFree (xm_file_selected);
#endif /* FILENAME_IS_EDITABLE */

	/* find the file in the DirMgr */
	DirectoryMgrGotoNamedItem (dpi -> directory_manager, 
				    dpi -> file_selected);
	de = DirectoryMgrCurrentEntry (dpi -> directory_manager);
	
	/* set size */
/*
	long_size = DirEntryFileSize (de);
*/
	long_size = FIFileSize (DirEntryActualInfo (de));
	sprintf (str_size, "%ld", long_size);
	xm_size = XmStringCreateSimple (str_size);
	XtVaSetValues (size, XmNlabelString, xm_size, NULL);
	XmStringFree (xm_size);

	/* set owner */
/*
	uid = DirEntryUserID (de);
*/
#ifdef NYRPT
	uid = FIUserID (DirEntryActualInfo (de));
	pw_entry = getpwuid (uid);
	xm_pw_name = XmStringCreateSimple (pw_entry -> pw_name);
	XtVaSetValues (owner, XmNlabelString, xm_pw_name, NULL);
	XmStringFree (xm_pw_name);
#endif

	/* set description */
	/* stub - will set description of file type from xmfmrc
	   e.g. "C source file"
	*/
        xm_description = XmStringCreateSimple (dpi -> description);
	XtVaSetValues (description, XmNlabelString, xm_description, NULL);
        XmStringFree (xm_description);

	/* set permissions */
/*
	permissions = DirEntryProt (de);
*/
	permissions = FIProt (DirEntryActualInfo (de));
        XtVaSetValues (empty_label, XmNlabelString, xm_empty, NULL);

	state = (permissions & S_IRUSR) ? True : False;
        XtVaSetValues (ur_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IWUSR) ? True : False;
        XtVaSetValues (uw_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IXUSR) ? True : False;
        XtVaSetValues (ux_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IRGRP) ? True : False;
        XtVaSetValues (gr_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IWGRP) ? True : False;
        XtVaSetValues (gw_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IXGRP) ? True : False;
        XtVaSetValues (gx_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IROTH) ? True : False;
        XtVaSetValues (or_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IWOTH) ? True : False;
        XtVaSetValues (ow_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

	state = (permissions & S_IXOTH) ? True : False;
        XtVaSetValues (ox_toggle,
                        XmNlabelString, xm_empty,
			XmNset, 	(XtArgVal) state,
                        NULL);

        XtManageChild (dialog);
}

