/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/help_mes.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/17 00:35:46 $
 * Version: $Revision: 1.7 $
 * Purpose: file of help messages
 *
 * Revision history:
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 

/*************************************************************************
 * Local includes
 ************************************************************************/ 

/*************************************************************************
 * Functions exported
 ************************************************************************/ 

/*************************************************************************
 * Variables exported
 ************************************************************************/ 
extern char help_applic_text[]; 
extern char help_menu_text[];
extern char help_mouse_text[];  
extern char help_keyboard_text[];
extern char help_about_text[];
extern char help_filter_text[];
extern char help_bugs_text[];

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 
/*	This is the text for the application help button in the main menu
*/
char help_applic_text[] = 
"xmfm is a file manager that displays files in a directory.\n\
The screen is divided into buttons on the left signalling\n\
actions that you can perform on files, and three panes on\n\
the right containing executable files, ordinary files and\n\
directories resepectively. By selecting a file, you can choose\n\
an action on it from the buttons on the left. Double clicking\n\
on a file performs the default (first) action.\n\
";

/*	This is the text for the menu help button in the main menu
*/
char help_menu_text[] = 
"The menu buttons are \n\
File \n\
 - New file: create a new file in the directory\n\
 - New directory: create a new directory\n\
 - Close: close the current directory pane\n\
 - Exit: terminate xmfm\n\
\n\
Goto\n\
 - Chdir Home: change to home directory\n\
 - Chdir directory...: change to a new directry\n\
 - Open Home: open a new pane in the home directory\n\
 - Open directory...: open a new pane in a new directory\n\
";
            

/*	This is the text for the mouse help button in the main menu
*/
char help_mouse_text[] =  
"Select a file by clicking on it.\n\
Select an action by clicking on it.\n\
Double click on a file to get the\n\
default action (the first one).\n\
Resize the panes by dragging the sash\n\
to the right at the top of each pane.\n\
";

/*      This is the text for the filter help button in the main menu
*/
char help_filter_text[] =
"Filters control which files and directories are displayed.\n\
They use shell pattern matches. Common filters are\n\
   *      matches any string (including the empty string)\n\
   ?      matches any single character\n\
   [...]  matches any one of the characters ...\n\
   [^...] matches anything except one of the characters ...\n\
Examples:\n\
   *      all files are matched\n\
   *.c    all files ending in .c are matched\n\
   *.[ch] all files ending in .c or in .h are matched\n\
   [^.]*  all files except those beginning with . are matched\n\
";
  
/*	This is the text for the keyboard help button in the main menu
*/
#ifdef vax11c
char help_keyboard_text[] =
"The Meta key is the `Alt Function' key either\n\
side of the space bar for LK401 keyboards. For\n\
LK201 Keyboards it is the `Compose Character' key.\n\
Press this in conjunction with ordinary keys to get\n\
hot-key menu actions.  For example, Meta+H moves to \n\
you Home directory.\n\
\n\
Press F1 to get context sensitive help\n\
on any part of xmfm (not implemented)\n\
";
#else
char help_keyboard_text[] =
"The Meta key is the `diamond' key either\n\
side of the space bar. Press this in conjunction\n\
with ordinary keys to get hot-key menu actions.\n\
For example, Meta+H moves to you Home directory.\n\
\n\
Press F1 to get context sensitive help\n\
on any part of xmfm (not implemented)\n\
";
#endif /* vax11c */

#ifdef vax11c
char help_about_text[] = "\
  xmfm (X/Motif file manager)\n\
         Version 1.7\n\
 Copyright 1992 J.D. Newmarch\n\
email: jan@ise.canberra.edu.au\n\
\n\
OpenVMS version by Patrick L. Mahan\n\
email: mahan@tgv.com";
#else
char help_about_text[] = "\
  xmfm (X/Motif file manager)\n\
         Version 1.7\n\
 Copyright 1992 J.D. Newmarch\n\
email: jan@ise.canberra.edu.au";
#endif /* vax11c */

#ifdef vax11c
char help_bugs_text[] = "\
If you find any new bugs in xmfm, please use email\n\
to send them to\n\
        jan@pandonia\n\
or\n\
        jan@ise.canberra.edu.au\n\
\n\
Send bugs with the OpenVMS version of xmfm to\n\
        mahan@tgv.com\n\
\n\
Currently known bugs/problems include:\n\
 - drag and drop does not work.\n\
 - when xmfm is resized horizontally, the number of\n\
   columns of files shown does not change to use\n\
   the new width.\n\
 - when run across a network, a \"Run xterm\" does\n\
   not pick up the server you are using unless \n\
   the DISPLAY variable is set.\n\
 - context sensitive help does not work.\n\
 - $n patterns are not dealt with in Run commands\n\
 - The shell used in Run is the Bourne shell only\n\
";
#else
char help_bugs_text[] = "\
If you find any new bugs in xmfm, please use email\n\
to send them to\n\
        jan@pandonia\n\
or\n\
        jan@ise.canberra.edu.au\n\
\n\
Currently known bugs/problems include:\n\
 - drag and drop does not work.\n\
 - when xmfm is resized horizontally, the number of\n\
   columns of files shown does not change to use\n\
   the new width.\n\
 - when run across a network, a \"Run xterm\" does\n\
   not pick up the server you are using unless \n\
   the DISPLAY variable is set.\n\
 - context sensitive help does not work.\n\
 - $n patterns are not dealt with in Run commands\n\
 - The shell used in Run is the Bourne shell only\n\
";
#endif /* vax11c */
