/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/filtercb.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/10 05:12:31 $
 * Version: $Revision: 1.2 $
 * Purpose: This file handles the directory goto requests from the Goto
 *	menu, through callbacks attached to each button
 *
 * Revision history:
 *	16 Oct 92	caddr_t changed to XtPointer
 *       3 Nov 92       lint-ed
 *	21 Nov 92	fixed crash on cancelling filter dialog
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdlib.h>
#include <stdio.h> 

#include <Xm/CascadeB.h>     
#include <Xm/FileSB.h>      
#include <Xm/Label.h>
#include <Xm/PushB.h>    
#include <Xm/RowColumn.h>    
#include <Xm/SelectioB.h>    

/*************************************************************************
 * Local includes
 ************************************************************************/ 
#include "filecb.h"
#include "types.h"
#include "RegExp.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
extern void FilterFileCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FilterDirCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FilterExecutableCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void SetFiltersInLabels (
#ifdef UseFunctionPrototypes
	dir_pane_info *dpi
#endif
);

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 
extern void GotoCurrentDir (
#ifdef UseFunctionPrototypes
	Widget w
#endif
);
extern void ResetFilesInPanes (
#ifdef UseFunctionPrototypes
	dir_pane_info *dpi
#endif
);
extern void PromptDialog (
#ifdef UseFunctionPrototypes
	Widget parent, char *prompt, int modal, char **answer
#endif
);
extern void invert_colours (
#ifdef UseFunctionPrototypes
	Widget w
#endif
);
extern void ClearToolbar (
#ifdef UseFunctionPrototypes
	Widget *toolbar
#endif
);

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 
/*************************************************************************
 * Function: SetFiltersInLabels ()
 * Purpose: set the filters in the three labels
 * In parameters:
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 
void
SetFiltersInLabels 
#ifdef UseFunctionPrototypes
	(dir_pane_info *dpi)
#else
	(dpi)
        dir_pane_info *dpi;

#endif
{       char filter[2048];
        XmString xmfilter;

        strcpy (filter, "Files - filter is ");
        strcat (filter, dpi -> file_filter);
        xmfilter = XmStringCreateSimple (filter);
        XtVaSetValues (dpi -> file_filter_label,
                        XmNlabelString, xmfilter,
                        NULL);
        XmStringFree (xmfilter);

        strcpy (filter, "Executables - filter is ");
        strcat (filter, dpi -> executable_filter);
        xmfilter = XmStringCreateSimple (filter);
        XtVaSetValues (dpi -> executable_filter_label,
                        XmNlabelString, xmfilter,
                        NULL);
        XmStringFree (xmfilter);

        strcpy (filter, "Directories - filter is ");
        strcat (filter, dpi -> dir_filter);
        xmfilter = XmStringCreateSimple (filter);
        XtVaSetValues (dpi -> dir_filter_label,
                        XmNlabelString, xmfilter,
                        NULL);
        XmStringFree (xmfilter);
}
/*************************************************************************
 * Function: FilterFileCB ()
 * Purpose: set the filter for ordinary files
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition;
 * Postcondition:
 ************************************************************************/ 

/* ARGSUSED */
void
FilterFileCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
Widget		w;		/*  widget id		*/ 
XtPointer		client_data;	/*  data from applicaiton   */ 
XtPointer		call_data;	/*  data from widget class  */ 

#endif
{	dir_pane_info *dpi;
        char regexp[FSM_LENGTH]; 
	char *filter;

	XtVaGetValues (w, XmNuserData, &dpi, NULL);

/*
	XtFree (dpi -> file_filter);
	XtFree (dpi -> file_filter_regexp);
*/

	PromptDialog (w, "File filter", True, &filter);
	if (filter == NULL)
		return;		/* dialog cancelled */
	dpi -> file_filter = filter;

	RegExpPatternToRegExp (dpi -> file_filter, regexp);
#ifdef vax11c
	dpi->file_filter_regexp = 
		RegExpCompile (regexp, dpi -> file_filter_regexp, FSM_LENGTH);
#else
	RegExpCompile (regexp, dpi -> file_filter_regexp, FSM_LENGTH);
#endif /* vax11c */

	/* empty out current selection, in case it is no longer visible */
	if (dpi -> file_selected != NULL)
	{	invert_colours (dpi -> file_button_selected);
		dpi -> file_selected = NULL;
		ClearToolbar (dpi -> files_toolbar);
	}
        SetFiltersInLabels (dpi);
        ResetFilesInPanes (dpi);
}
 
/*************************************************************************
 * Function: FilterDirCB ()
 * Purpose: set the filter on ditectory names
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition;
 * Postcondition: 
 ************************************************************************/ 

/* ARGSUSED */
void
FilterDirCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
Widget		w;		/*  widget id		*/ 
XtPointer		client_data;	/*  data from applicaiton   */ 
XtPointer		call_data;

#endif
{	dir_pane_info *dpi;
        char regexp[FSM_LENGTH]; 
	char *filter;

	XtVaGetValues (w, XmNuserData, &dpi, NULL);

/*
	XtFree (dpi -> dir_filter);
	XtFree (dpi -> dir_filter_regexp);
*/

	PromptDialog (w, "Directory filter", True, &filter);
	if (filter == NULL)
		return;		/* dialog cancelled */
	dpi -> dir_filter = filter;

	RegExpPatternToRegExp (dpi -> dir_filter, regexp);
#ifdef vax11c
	dpi->dir_filter_regexp = 
		RegExpCompile (regexp, dpi -> dir_filter_regexp, FSM_LENGTH);
#else
	RegExpCompile (regexp, dpi -> dir_filter_regexp, FSM_LENGTH);
#endif /* vax11c */

	/* empty out current selection, in case it is no longer visible */
	if (dpi -> file_selected != NULL)
	{	invert_colours (dpi -> file_button_selected);
		dpi -> file_selected = NULL;
		ClearToolbar (dpi -> files_toolbar);
	}        SetFiltersInLabels (dpi);

        SetFiltersInLabels (dpi);

        ResetFilesInPanes (dpi);
}

/*************************************************************************
 * Function: FilterExecutbaleCb ()
 * Purpose: set file filter on executbale files
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition; 
 * Postcondition: 
 ************************************************************************/ 

/* ARGSUSED */
void
FilterExecutableCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
Widget		w;		/*  widget id		*/ 
XtPointer		client_data;	/*  data from applicaiton   */ 
XtPointer		call_data;	/*  data from widget class  */ 

#endif
{	dir_pane_info *dpi;
        char regexp[FSM_LENGTH]; 
	char *filter;

	XtVaGetValues (w, XmNuserData, &dpi, NULL);

	/* memory leak? clean up old data? 
	XtFree (dpi -> executable_filter);
	XtFree (dpi -> executable_filter_regexp);
        */

	PromptDialog (w, "Executable filter", True,
			&filter);
	if (filter == NULL)
		return;		/* dialog cancelled */
	dpi -> executable_filter = filter;

	RegExpPatternToRegExp (dpi -> executable_filter, regexp);
#ifdef vax11c
	dpi->executable_filter_regexp = 
		RegExpCompile (regexp, dpi -> executable_filter_regexp, FSM_LENGTH);
#else
	RegExpCompile (regexp, dpi -> executable_filter_regexp, FSM_LENGTH);
#endif /* vax11c */

	/* empty out current selection, in case it is no longer visible */
	if (dpi -> file_selected != NULL)
	{	invert_colours (dpi -> file_button_selected);
		dpi -> file_selected = NULL;
		ClearToolbar (dpi -> files_toolbar);
	}

        SetFiltersInLabels (dpi);

        ResetFilesInPanes (dpi);
}
