
#include "copyright.h"

/*	xmvarargs.h
**	External definitions of varargs funcs
*/

/* 
**	need Xm.h to find the current version number
*/
#ifndef _XMVARARGS_H
#define _XMVARARGS_H

#include <Xm/Xm.h>

#ifdef UseFunctionPrototypes
#include <stdarg.h>
#define Va_start(a, b) va_start (a, b)
#else
#define Va_start(a, b) va_start (a)
#endif

/*
**	varargs interface for Xt not defined for Motif 1.0
**	because it is based on X11 R3. In this case, define
**	equivalents to the Xt functions
*/
#if XmVersion == 1000
extern Widget 	XtVaCreateManagedWidget();
extern void	XtVaSetValues();
extern void	XtVaGetValues();
#endif

/* 
** widgets
*/
extern Widget	XmVaCreateArrowButton(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateBulletinBoard(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateCascadeButton(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateCommand(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateDialogShell(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateDrawingArea(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateDrawnButton(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateFileSelectionBox(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateForm(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateFrame(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateLabel(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateList(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateMainWindow(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateMessageBox(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreatePanedWindow(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreatePushButton(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateRowColumn(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateScale(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateScrollBar(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateSelectionBox(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateSeparator(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateText(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateToggleButton(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);

/*
** dialogs
*/
extern Widget	XmVaCreateErrorDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateFileSelectionDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateFormDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateInformationDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateMessageDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreatePromptDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateQuestionDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateSelectionDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateWarningDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateWorkingDialog(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);

/*
** rowcolumn convenience routines
*/
extern Widget	XmVaCreateMenuBar(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateOptionMenu(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreatePopupMenu(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreatePulldownMenu(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateRadioBox(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);

/*
** scrollbar convenience routines
*/
extern Widget	XmVaCreateScrolledList(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateScrolledText(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);
extern Widget	XmVaCreateScrolledWindow(
#ifdef UseFunctionPrototypes
	Widget, ...
#endif
);


#endif /* _XMVARARGS_H */
