/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/warning.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/17 00:35:58 $
 * Version: $Revision: 1.5 $
 * Purpose: display a modal warning dialog
 *
 * Revision history:
 *      3 Nov 92      lint-ed
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdio.h> 
#include <string.h> 
#include <sys/types.h> 
#include <sys/stat.h> 
#include <Xm/MainW.h> 
#include <Xm/MessageB.h> 
#include <Xm/SelectioB.h>

/*************************************************************************
 * Local includes
 ************************************************************************/ 
#include "const.h"
#include "types.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
extern void WarningDialog (
#ifdef UseFunctionPrototypes
	Widget parent, char *prompt, int modal, int *answer
#endif
);

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 
extern XtAppContext app_context;

/*************************************************************************
 * Extern functions
 ************************************************************************/ 

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 
static Bool dialog_over;
 

/*************************************************************************
 * Function: modal_dialog_loop ()
 * Purpose: force user to acknowledge dialog
 * In parameters: w
 * Out parameters:
 * Side effects: modifies dialog_over
 * Precondition: 
 * Postcondition: dialog_over = True
 ************************************************************************/ 
static void
modal_dialog_loop 
#ifdef UseFunctionPrototypes
	(Widget w)
#else
	(w)
	Widget w;

#endif
{
	dialog_over = False;
	XtVaSetValues (w,
			XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			NULL);
	XtManageChild (w);
	while (dialog_over == False)
		XtAppProcessEvent (app_context, XtIMAll);
}


/*-------------------------------------------------------------
**	Destroy a Dialog
*/

/*************************************************************************
 * Function: OkDialogCB ()
 * Purpose: handle the dialog OK button
 * In parameters: w, call_data
 * Out parameters: answer
 * Precondition: w is a child of a popup shell
 * Postcondition: parent on down all destroyed, text field first copied
 ************************************************************************/ 
static void
OkDialogCB
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)
	Widget w;
	XtPointer client_data;
	XtPointer call_data;

#endif
{
	int *answer = (int *) client_data;
	XmAnyCallbackStruct * c_data = (XmAnyCallbackStruct *) call_data;

	dialog_over = True;

	if (c_data -> reason == (int) XmCR_OK)
		*answer = OK_ANSWER;
	else	*answer = CANCEL_ANSWER;

	XtUnmanageChild (w);
	XtDestroyWidget (XtParent (w));
}

/*************************************************************************
 * Function: WarningDialog ()
 * Purpose: show a warning dialog
 * In parameters: parent, prompt, modal
 * Out parameters: answer 
 * Precondition: 
 * Postcondition: 
 ************************************************************************/ 
void
WarningDialog
#ifdef UseFunctionPrototypes
	(Widget parent, char *prompt, int modal, int *answer)
#else
	(parent, prompt, modal, answer)
	Widget parent;
	char * prompt;
	Bool modal;
	int *answer;

#endif
{	int n;
	Arg	args[MAX_ARGS];
	Widget  help, dialog;
	XmString xmstr;

	n = 0;
	xmstr = XmStringCreateSimple (prompt);
	XtSetArg (args[n], XmNmessageString, xmstr); n++;
	dialog = XmCreateWarningDialog(parent, prompt, args, n);
	XmStringFree(xmstr);
	XtAddCallback(dialog, XmNokCallback, OkDialogCB, (XtPointer) answer);
	XtAddCallback(dialog, XmNcancelCallback, OkDialogCB, (XtPointer) answer);

	help = XmMessageBoxGetChild(dialog, 
			XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(help);

	if (modal)
		modal_dialog_loop(dialog);
}
