/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/prompt.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/17 00:35:51 $
 * Version: $Revision: 1.6 $
 * Purpose:
 *          and calls the Xt main loop.
 *
 * Revision history:
 *	16 Oct 92	caddr_t changed to XtPointer
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdio.h> 
#include <string.h> 
#include <sys/types.h> 
#include <sys/stat.h> 
#include <Xm/MainW.h> 
#include <Xm/MessageB.h> 
#include <Xm/SelectioB.h>

/*************************************************************************
 * Local includes
 ************************************************************************/ 
#include "const.h"
#include "types.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
extern void PromptDialog (
#ifdef UseFunctionPrototypes
	Widget parent, char *prompt, int modal, char **answer
#endif
);

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 
extern XtAppContext app_context;

/*************************************************************************
 * Extern functions
 ************************************************************************/ 

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 
static Bool dialog_over;
 

/*************************************************************************
 * Function: modal_dialog_loop ()
 * Purpose: 
 * In parameters:
 * Out parameters:
 * Side effects: modifies dialog_over
 * Precondition: 
 * Postcondition:
 ************************************************************************/ 
static void
modal_dialog_loop 
#ifdef UseFunctionPrototypes
	(Widget w)
#else
	(w)
	Widget w;

#endif
{
	dialog_over = False;
	XtVaSetValues (w,
			XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			NULL);
	XtManageChild (w);
	while (dialog_over == False)
		XtAppProcessEvent (app_context, XtIMAll);
}

/*************************************************************************
 * Function: OkDialogCB ()
 * Purpose: handle the dialog OK button
 * In parameters: w, c2
 * Out parameters: answer
 * Precondition: w is a child of a popup shell
 * Postcondition: parent on down all destroyed, text field first copied
 ************************************************************************/ 

/* ARGSUSED */
static void
OkDialogCB
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer c2)
#else
	(w, client_data, c2)
	Widget w;
	XtPointer client_data;
	XtPointer  c2;

#endif
{
	char ** answer = (char **) client_data;
	XmString xmstr;

	XtVaGetValues (w, XmNtextString, &xmstr, NULL);
	/* decode the xmstr */
	/* this should be replaced by code that does not use obsoleted
	   XmSTRING_DEFAULT_CHARSET */
	XmStringGetLtoR (xmstr, XmSTRING_DEFAULT_CHARSET, answer);
	XmStringFree (xmstr);

	dialog_over = True;

	XtUnmanageChild (w);
	XtDestroyWidget (XtParent (w));
}

/*************************************************************************
 * Function: CancelDialogCB ()
 * Purpose: handle the dialog Cancel button
 * In parameters: w, c2
 * Out parameters: answer
 * Precondition: w is a child of a popup shell
 * Postcondition: parent on down all destroyed, anser set to NULL
 ************************************************************************/ 

/* ARGSUSED */
static void
CancelDialogCB
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer c2)
#else
	(w, client_data, c2)
	Widget w;
	XtPointer client_data;
	XtPointer  c2;

#endif
{
	char ** answer = (char **) client_data;

	*answer = NULL;

	dialog_over = True;

	XtUnmanageChild (w);
	XtDestroyWidget (XtParent (w));
}

/*************************************************************************
 * Function: PromptDialog ()
 * Purpose: show a prompt dialog, and find the prompted string
 * In parameters: parent, prompt, modal
 * Out parameters: answer 
 * Precondition: 
 * Postcondition: 
 ************************************************************************/ 
void
PromptDialog
#ifdef UseFunctionPrototypes
	(Widget parent, char *prompt, int modal, char **answer)
#else
	(parent, prompt, modal, answer)
	Widget parent;
	char * prompt;
	Bool modal;
	char ** answer;

#endif
{	int n;
	Arg	args[MAX_ARGS];
	Widget help, dialog;
	XmString xmstr;

	n = 0;
	xmstr = XmStringCreateSimple (prompt);
	XtSetArg (args[n], XmNselectionLabelString, xmstr); n++;
	dialog = XmCreatePromptDialog(parent, prompt, args, n);
	XmStringFree(xmstr);

	XtAddCallback(dialog, XmNokCallback, OkDialogCB, (XtPointer) answer);
	XtAddCallback(dialog, XmNcancelCallback, CancelDialogCB, (XtPointer) answer);

	help = XmSelectionBoxGetChild(dialog, 
			XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(help);

	/* set keyboard focus to text field */
	XmProcessTraversal (XmSelectionBoxGetChild (dialog,
						XmDIALOG_TEXT),
				XmTRAVERSE_CURRENT);
	XmProcessTraversal (XmSelectionBoxGetChild (dialog,
						XmDIALOG_TEXT),
				XmTRAVERSE_CURRENT);
	XmProcessTraversal (XmSelectionBoxGetChild (dialog,
						XmDIALOG_TEXT),
				XmTRAVERSE_CURRENT);

	if (modal)
		modal_dialog_loop(dialog);
}
