/*------------------------------------------------------------- 
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/menu.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/10 05:12:37 $
 * Version: $Revision: 1.7 $
 * Purpose:
 *   This file sets up the menu structure.
 *   The appearance is (approximately)
 *
 *    ~File    ~Goto      ~Help
 *    ~New file Goto Home ~Application
 *    ~New dir  Goto dir   Men~u
 *    ~Close    Open Home ~Keyboard
 *    ~Exit     Open dir   Mous~e
 *
 *   where the ~ gives some clue about the mnemonic
 *
 * Revision history:
 *	4 Aug 92	filter menu added
 *      25 Aug 92       fixed menonmics clash in Goto menu
 *	16 Oct 92	caddr_t changed to XtPointer
 *       3 Nov 92       lint-ed
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdio.h> 
#include <string.h> 
#include <Xm/CascadeB.h> 
#include <Xm/PushB.h> 
#include <Xm/RowColumn.h> 

/*************************************************************************
 * Local includes
 ************************************************************************/ 

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
extern	Widget CreateMenu (
#ifdef UseFunctionPrototypes
	Widget parent, XtPointer user_data
#endif
);

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 
extern	char  help_applic_text[];
extern	char  help_menu_text[];
extern	char  help_mouse_text[];
extern	char  help_keyboard_text[];
extern  char  help_filter_text[];
extern  char  help_bugs_text[];
extern	char  help_about_text[];

/*************************************************************************
 * Extern functions
 ************************************************************************/ 
/* File menu callbacks */
extern void FileNewFileCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FileNewDirCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FileCopyCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FileMoveCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FileCloseCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FileExitCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);

/* help menu callbacks */
extern void HelpCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);

/* goto menu callbacks */
extern void GotoHomeCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void GotoDirCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void GotoOpenHomeCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void GotoOpenDirCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);

/* run menu callbacks */
extern void RunCommandCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void RunXtermCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);

/* filter menu callbacks */
extern void FilterFileCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FilterDirCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void FilterExecutableCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);

/*************************************************************************
 * Forward functions
 ************************************************************************/ 
static void	CreateFileSubMenu (
#ifdef UseFunctionPrototypes
	Widget menu_bar, XtPointer user_data
#endif
);
static void	CreateRunSubMenu (
#ifdef UseFunctionPrototypes
	Widget menu_bar, XtPointer user_data
#endif
);
static void	CreateHelpSubMenu (
#ifdef UseFunctionPrototypes
	Widget parent, XtPointer user_data
#endif
);
static void	CreateGotoSubMenu (
#ifdef UseFunctionPrototypes
	Widget menu_bar, XtPointer user_data
#endif
);
static void    CreateFilterSubMenu (
#ifdef UseFunctionPrototypes
	Widget menu_bar, XtPointer user_data
#endif
);

/*************************************************************************
 * Local variables
 ************************************************************************/ 
#define MAX_ARGS	128

/*************************************************************************
 * Function:  CreatePulldownMenuButton ()
 * Purpose:
 *     creates a single button in a pulldown 
 *     menu system
 * In parameters: parent, name, label, accel_text, accelerator,
                  mnemonic, callback_func, client_data
 * Function return: button in menu
 * Precondition: parent is non-null, other fields null or valid args
 * Postcondition: button created with fileds set if non-null
 ************************************************************************/ 
static Widget
CreatePulldownMenuButton 
#ifdef UseFunctionPrototypes
	(Widget parent, String name, String label, String accel_text, String accelerator, char mnemonic, void (*callback_func) (/* ??? */), XtPointer client_data, XtPointer user_data)
#else
	(parent, name, label,
		accel_text, accelerator, mnemonic,
		callback_func, client_data,
		user_data)
	Widget	parent;
	String	name;
	String	label;
	String	accel_text;
	String	accelerator;
	char	mnemonic;
	void	(*callback_func) ();
	XtPointer	client_data;
	XtPointer user_data;

#endif
{
	Arg	args[MAX_ARGS];
	int	n;
	XmString	xm_accel_text = NULL;
	XmString	xm_label = NULL;
	Widget	button;

	n = 0; 
	if (label != NULL)
	{
		xm_label = XmStringCreateLtoR(label, XmSTRING_DEFAULT_CHARSET);
		XtSetArg (args[n], XmNlabelString, xm_label); n++;
	}
	button = XmCreatePushButton (parent, name, args, n); 
	XtManageChild (button); 
	XtAddCallback (button, XmNactivateCallback, 
			callback_func, client_data); 

	/* if accelerator non-NULL and resource db hasn't set it, set it */
	if (accel_text != NULL)
	{
		n = 0;
		XtSetArg (args[n], XmNacceleratorText, &xm_accel_text); n++;
		XtGetValues (button, args, n);
		if (xm_accel_text == NULL)
		{
			xm_accel_text = XmStringCreateLtoR(accel_text, 
						XmSTRING_DEFAULT_CHARSET);
			n = 0;
			XtSetArg (args[n], XmNacceleratorText, 
						xm_accel_text); n++;
			XtSetArg (args[n], XmNaccelerator, accelerator); n++;
			XtSetValues (button, args, n);
		}
	}
	/* if mnemonic non-NULL and resource db hasn't set it, set it */
	if (mnemonic != 0)
	{	KeySym	mnemonic_sym;

		n = 0;
		XtSetArg (args[n], XmNmnemonic, &mnemonic_sym); n++;
		XtGetValues (button, args, n);
		if (mnemonic_sym == 0)
		{
			n = 0;
			XtSetArg (args[n], XmNmnemonic, mnemonic); n++;
			XtSetValues (button, args, n);
		}
	}

	if (user_data != NULL)
		XtVaSetValues (button,
				XmNuserData, (XtArgVal) user_data,
				NULL);

	/* reclaim used string space */
	if (xm_accel_text != NULL)
		XmStringFree (xm_accel_text);
	if (xm_label != NULL)
		XmStringFree (xm_label);

	return (button);
}

 
/*------------------------------------------------------------- 
**	CreateMenu	- create menu structure
**
**	Return the menu bar
**
**	What this lot creates is the following menu:
**
*/ 

/*************************************************************************
 * Function: CreateMenu ()
 * Purpose: create the menu bar
 * In parameters: parent
 * Function return: menu bar widget unmanaged
 * Precondition: parent non-null widget
 * Postcondition: menu bar creted in unmanaged state, with all submenus
 *                with associated callbacks created
 ************************************************************************/ 
Widget
CreateMenu 
#ifdef UseFunctionPrototypes
	(Widget parent, XtPointer user_data)
#else
	(parent, user_data)  
	Widget	parent;		/*  parent widget	*/ 
	XtPointer user_data;

#endif
{ 
	Widget		menu_bar;	/*  MenuBar		*/ 
	Arg	args[MAX_ARGS];
 
	register int	n;		/*  arg count		*/ 
 
	/*	Create MenuBar in MainWindow. 
	*/ 
	n = 0; 
	menu_bar = XmCreateMenuBar (parent, "menu_bar", args, n);  
	XtManageChild (menu_bar); 
 
#       ifdef DEBUG_MENU
                fprintf(stderr, "Created menu bar\n");
#       endif


	/*	Create "File" PulldownMenu. 
	*/ 
	CreateFileSubMenu(menu_bar, user_data);

#       ifdef DEBUG_MENU
                fprintf(stderr, "Created file menu\n");
#       endif

	/*	Create "Goto" menu. 
	*/ 
	CreateGotoSubMenu(menu_bar, user_data);
 
#       ifdef DEBUG_MENU
                fprintf(stderr, "Created goto menu\n");
#       endif

	/*	Create "Run" menu. 
	*/ 
	CreateRunSubMenu(menu_bar, user_data);

	/*	Create "Filter" menu. 
	*/ 
	CreateFilterSubMenu(menu_bar, user_data);
 
#       ifdef DEBUG_MENU
                fprintf(stderr, "Created run menu\n");
#       endif

	/*	Create "Help" menu. 
	*/ 
	CreateHelpSubMenu(menu_bar, user_data);

 
#       ifdef DEBUG_MENU
                fprintf(stderr, "Created help menu\n");
#       endif

	return (menu_bar);
} 


/*************************************************************************
 * Function: CreateFileSubMenu ()
 * Purpose:
 *	Create SubMenu to handle File Actions
 * In parameters: menu_bar, user_data
 * Out parameters:
 * Precondition: menu_bar is non-null widget
 * Postcondition: file menu added to menu_bar
 ************************************************************************/ 
static void
CreateFileSubMenu 
#ifdef UseFunctionPrototypes
	(Widget menu_bar, XtPointer user_data)
#else
	(menu_bar, user_data)  
	Widget	menu_bar;		/*  parent widget	*/ 
	XtPointer user_data;

#endif
{ 
	Widget		menu_pane;	/*  MenuPane		*/ 
	Widget		cascade;	/*  CascadeButton	*/ 
 
	Arg	args[MAX_ARGS];
	int	n;		/*  arg count		*/ 
 
	/*	Create "File" PulldownMenu. 
	**	Names, accelerators and mnemonics are all set
	**	in the resource database before we get here.
	*/ 
	n = 0; 
	menu_pane = XmCreatePulldownMenu (menu_bar, "menu_pane", args, n); 
 
#	ifdef DEBUG_FILE
		fprintf (stderr, "Created file menu bar\n");
#	endif

	CreatePulldownMenuButton (menu_pane, "New file...", NULL,
			NULL, NULL, 'f',
			FileNewFileCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "New dir", NULL,
			NULL, NULL, 'd',
			FileNewDirCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Copy...", NULL,
			NULL, NULL, 'C',
			FileCopyCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Move...", NULL,
			NULL, NULL, 'M',
			FileMoveCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Close", NULL,
			"Ctrl+F4", "Ctrl<Key>F4", 'l',
			FileCloseCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Exit", NULL,
			"Meta+F4", "Meta<Key>F4", 'x',
			FileExitCB, NULL, user_data);
 
	n = 0; 
	XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++; 
        XtSetArg (args[n], XmNmnemonic, 'F'); n++;
	cascade = XmCreateCascadeButton (menu_bar, "File", args, n); 
	XtManageChild (cascade); 
}

/*************************************************************************
 * Function: CreateGotoSubMenu ()
 * Purpose:
 *	Create SubMenu to handle Goto Actions
 * In parameters: menu_bar
 * Out parameters:
 * Precondition: menu_bar is non-null widget
 * Postcondition: file menu added to menu_bar
 ************************************************************************/ 
static void
CreateGotoSubMenu 
#ifdef UseFunctionPrototypes
	(Widget menu_bar, XtPointer user_data)
#else
	(menu_bar, user_data)  
	Widget	menu_bar;		/*  parent widget	*/ 
	XtPointer user_data;

#endif
{ 
	Widget		menu_pane;	/*  MenuPane		*/ 
	Widget		cascade;	/*  CascadeButton	*/ 
	Arg	args[MAX_ARGS];
	int	n;		/*  arg count		*/ 
 
	/*	Create "Goto" PulldownMenu. 
	**	Names, accelerators and mnemonics are all set
	**	in the resource database before we get here.
	*/ 
	n = 0; 
	menu_pane = XmCreatePulldownMenu (menu_bar, "menu_pane", args, n); 
 
#	ifdef DEBUG_FILE
		fprintf (stderr, "Created Goto menu bar\n");
#	endif

	CreatePulldownMenuButton (menu_pane, "Chdir Home", NULL,
			"Meta+H", "Meta<Key>H", 'H',
			GotoHomeCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Chdir Directory...", NULL,
			"Meta+D", "Meta<Key>D", 'D',
			GotoDirCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Open Home", NULL,
			"Ctrl+H", "Ctrl<Key>H", 'o',
			GotoOpenHomeCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Open Directory...", NULL,
			"Ctrl+D", "Ctrl<Key>D", 'i',
			GotoOpenDirCB, NULL, user_data);
	n = 0; 
	XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++; 
        XtSetArg (args[n], XmNmnemonic, 'G'); n++;
	cascade = XmCreateCascadeButton (menu_bar, "Goto", args, n); 
	XtManageChild (cascade); 
}


/*************************************************************************
 * Function: CreateFilterSubMenu ()
 * Purpose:
 *	Create SubMenu to handle Filter Actions
 * In parameters: menu_bar
 * Out parameters:
 * Precondition: menu_bar is non-null widget
 * Postcondition: filter menu added to menu_bar
 ************************************************************************/ 
static void
CreateFilterSubMenu 
#ifdef UseFunctionPrototypes
	(Widget menu_bar, XtPointer user_data)
#else
	(menu_bar, user_data)  
	Widget	menu_bar;		/*  parent widget	*/ 
	XtPointer user_data;

#endif
{ 
	Widget		menu_pane;	/*  MenuPane		*/ 
	Widget		cascade;	/*  CascadeButton	*/ 
	Arg	args[MAX_ARGS];
	int	n;		/*  arg count		*/ 
 
	/*	Create "Filter" PulldownMenu. 
	**	Names, accelerators and mnemonics are all set
	**	in the resource database before we get here.
	*/ 
	n = 0; 
	menu_pane = XmCreatePulldownMenu (menu_bar, "menu_pane", args, n); 
 
#	ifdef DEBUG_FILE
		fprintf (stderr, "Created Filter menu bar\n");
#	endif

	CreatePulldownMenuButton (menu_pane, "Files", NULL,
			NULL, NULL, 'F',
			FilterFileCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Executables", NULL,
			NULL, NULL, 'E',
			FilterExecutableCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Directories", NULL,
			NULL, NULL, 'D',
			FilterDirCB, NULL, user_data);
	n = 0; 
	XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++; 
        XtSetArg (args[n], XmNmnemonic, 'i'); n++;
	cascade = XmCreateCascadeButton (menu_bar, "Filter", args, n); 
	XtManageChild (cascade); 
}


/*************************************************************************
 * Function: CreateRunSubMenu ()
 * Purpose:
 *	Create SubMenu to handle Run Actions
 * In parameters: menu_bar
 * Out parameters:
 * Precondition: menu_bar is non-null widget
 * Postcondition: run menu added to menu_bar
 ************************************************************************/ 
static void
CreateRunSubMenu 
#ifdef UseFunctionPrototypes
	(Widget menu_bar, XtPointer user_data)
#else
	(menu_bar, user_data)  
	Widget	menu_bar;		/*  parent widget	*/ 
	XtPointer user_data;

#endif
{ 
	Widget		menu_pane;	/*  MenuPane		*/ 
	Widget		cascade;	/*  CascadeButton	*/ 
	Arg	args[MAX_ARGS];
	int	n;		/*  arg count		*/ 
 
	/*	Create "Goto" PulldownMenu. 
	**	Names, accelerators and mnemonics are all set
	**	in the resource database before we get here.
	*/ 
	n = 0; 
	menu_pane = XmCreatePulldownMenu (menu_bar, "menu_pane", args, n); 
 
#	ifdef DEBUG_FILE
		fprintf (stderr, "Created Run menu bar\n");
#	endif

	CreatePulldownMenuButton (menu_pane, "Command...", NULL,
			"Meta+C", "Meta<Key>C", 'C',
			RunCommandCB, NULL, user_data);

	CreatePulldownMenuButton (menu_pane, "Xterm", NULL,
			"Meta+X", "Meta<Key>X", 'X',
			RunXtermCB, NULL, user_data);
	n = 0; 
	XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++; 
        XtSetArg (args[n], XmNmnemonic, 'R'); n++;
	cascade = XmCreateCascadeButton (menu_bar, "Run", args, n); 
	XtManageChild (cascade); 
}

/*************************************************************************
 * Function: CreateHelpSubMenu ()
 * Purpose: create the help pulldown menu
 * In parameters: parent
 * Out parameters:
 * Precondition: parent is non-null widget
 * Postcondition: help pulldown menu added to parent,
 *                with all callbacks in place
 ************************************************************************/ 
static void
CreateHelpSubMenu 
#ifdef UseFunctionPrototypes
	(Widget parent, XtPointer user_data)
#else
	(parent, user_data)
	Widget	parent;
	XtPointer user_data;

#endif
{
	Widget	menu_pane;
	Widget	cascade;
	Arg	args[MAX_ARGS];
	int	n;
	
	n = 0;
	menu_pane = XmCreatePulldownMenu (parent, "menu_pane", args, n); 
 
	CreatePulldownMenuButton (menu_pane, "XmFm", NULL,
			NULL, NULL, 'X',
			HelpCB, help_applic_text, user_data);

	CreatePulldownMenuButton (menu_pane, "Mouse", NULL,
			NULL, NULL, 'M',
			HelpCB, help_mouse_text, user_data);

	CreatePulldownMenuButton (menu_pane, "Keyboard", NULL,
			NULL, NULL, 'K',
			HelpCB, help_keyboard_text, user_data);

	CreatePulldownMenuButton (menu_pane, "Filters", NULL,
			NULL, NULL, 'F',
			HelpCB, help_filter_text, user_data);

	CreatePulldownMenuButton (menu_pane, "Bugs", NULL,
			NULL, NULL, 'B',
			HelpCB, help_bugs_text, user_data);

	CreatePulldownMenuButton (menu_pane, "About", NULL,
			NULL, NULL, 'A',
			HelpCB, help_about_text, user_data);
 
	n = 0; 
	XtSetArg (args[n], XmNsubMenuId, menu_pane);  n++; 
	XtSetArg (args[n], XmNmnemonic, 'p'); n++;
	cascade = XmCreateCascadeButton (parent, "Help", args, n); 
	XtManageChild (cascade); 
 
	n = 0; 
	XtSetArg (args[n], XmNmenuHelpWidget, cascade);  n++; 
	XtSetValues (parent, args, n); 
}
