/*************************************************************************
 * File: help.c
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/17 00:35:45 $
 * Version: $Revision: 1.7 $
 * Purpose: Handle the help buttons in the application menu
 *
 * Revision history:
 *	16 Oct 92	caddr_t changed to XtPointer
 *      3 Nov 92        lint-ed
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdio.h> 
#include <string.h> 
#include <X11/Intrinsic.h> 
#include <Xm/Xm.h> 
#include <Xm/MessageB.h> 

/*************************************************************************
 * Local includes
 ************************************************************************/ 
#include "const.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
extern void HelpCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 

/*************************************************************************
 * Forward functions
 ************************************************************************/ 
static Widget CreateHelp(
#ifdef UseFunctionPrototypes
	Widget parent, char *message
#endif
);  

/*************************************************************************
 * Local variables
 ************************************************************************/ 
 

/*-------------------------------------------------------
**	Help menu callbacks
*/


/*************************************************************************
 * Function: HelpCB ()
 * Purpose: bring up a help dialog
 * In parameters: w, help_msg, call_data
 * Out parameters:
 * Precondition: button in a help menu has been pressed
 * Postcondition: help dialog with close button showing
 ************************************************************************/ 

/* ARGSUSED */
void HelpCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
Widget		w;		/*  widget id		*/ 
XtPointer	client_data;	/*  data from applicaiton   */ 
XtPointer	call_data;	/*  data from widget class  */ 

#endif
{
	Widget	message_box;		/*  MessageBox		*/ 
	char *	help_msg = (char *) client_data; /*  data from applicaiton   */ 

 
	/*	Create help window. 
	*/ 
	message_box = CreateHelp (w, help_msg); 
 
	/*	Display help window. 
	*/ 
	XtManageChild (message_box); 
}
 
/*************************************************************************
 * Function: CloseCB()
 * Purpose: destroy a dialog
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition; Close button pressed in dialog
 * Postcondition: dialog destroyed
 ************************************************************************/ 

/* ARGSUSED */
static void
CloseCB  
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
	Widget		w;		/*  widget id		*/ 
	XtPointer		client_data;	/*  font pointer	*/ 
	XtPointer		call_data;	/*  data from widget class  */ 

#endif
{ 
	Widget		shell	= XtParent (w); 
 
	/*	Unmanage and destroy widgets. 
	*/ 
	XtUnmanageChild (w); 
	XtDestroyWidget (shell); 
} 
 

/*------------------------------------------------------------- 
**		CreateHelp		- create help window 
*/ 
/*************************************************************************
 * Function: CreateHelp ()
 * Purpose: create an unmanaged help dialog
 * In parameters: parent, message
 * Out parameters:
 * Precondition: parent is non-null widget, message is non-null help string
 * Postcondition: popup dialog showing help string exists 
 *                in unmanaged state
 ************************************************************************/ 

static Widget
CreateHelp 
#ifdef UseFunctionPrototypes
	(Widget parent, char *message)
#else
	(parent, message)  
	Widget	parent;		/*  parent widget	*/ 
	char *	message;	/* help message */

#endif
{ 
	Widget		button; 
	Widget		message_box;	/*  Message Dialog 	*/ 
	Arg		args[MAX_ARGS];	/*  arg list		*/ 
	register int	n;		/*  arg count		*/ 
 
	XmString	title_string; 
	XmString	message_string; 
	XmString	button_string; 
 
	/*	Set up strings
	*/
	message_string = XmStringCreateLtoR (message, XmSTRING_DEFAULT_CHARSET); 
	button_string = XmStringCreateLtoR ("Close", XmSTRING_DEFAULT_CHARSET); 
	title_string = XmStringCreateLtoR ("xmfm help", XmSTRING_DEFAULT_CHARSET); 
 

	/*	Create MessageBox dialog. 
	*/ 
	n = 0; 
	XtSetArg (args[n], XmNdialogTitle, title_string);  n++; 
	XtSetArg (args[n], XmNokLabelString, button_string);  n++; 
	XtSetArg (args[n], XmNmessageString, message_string);  n++; 
	message_box = XmCreateMessageDialog (parent, "helpbox", args, n); 

	XtAddCallback(message_box, XmNokCallback, CloseCB, NULL);

 	/* lose unwanted buttons 
	*/
	button = XmMessageBoxGetChild (message_box, 
			XmDIALOG_CANCEL_BUTTON); 
	XtUnmanageChild (button); 
	button = XmMessageBoxGetChild (message_box, 
			XmDIALOG_HELP_BUTTON); 
	XtUnmanageChild (button); 
 
	/*	Free strings and return MessageBox. 
	*/ 
	if (title_string) XtFree (title_string); 
	if (message_string) XtFree (message_string); 
	if (button_string) XtFree (button_string); 
	return (message_box); 
}

