/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/gotocb.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/10 05:12:32 $
 * Version: $Revision: 1.5 $
 * Purpose: This file handles the directory goto requests from the Goto
 *	menu, through callbacks attached to each button
 *
 * Revision history:
 *	16 Oct 92	caddr_t changed to XtPointer
 *       3 Nov 92       lint-ed
 *	24 Nov 92	removed core-dumping XtFree (home_dir)
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#include <stdlib.h>
#include <stdio.h> 

#include <Xm/CascadeB.h>     
#include <Xm/FileSB.h>      
#include <Xm/Label.h>
#include <Xm/PushB.h>    
#include <Xm/RowColumn.h>    
#include <Xm/SelectioB.h>    

/*************************************************************************
 * Local includes
 ************************************************************************/ 
#include "filecb.h"
#include "types.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 
extern void GotoHomeCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void GotoDirCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void GotoOpenHomeCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);
extern void GotoOpenDirCB (
#ifdef UseFunctionPrototypes
	Widget w, XtPointer client_data, XtPointer call_data
#endif
);

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 
extern void GotoCurrentDir (
#ifdef UseFunctionPrototypes
	Widget w
#endif
);
extern void builtin_chdir (
#ifdef UseFunctionPrototypes
	char *dir, dir_pane_info *dpi
#endif
);
extern void PromptDialog (
#ifdef UseFunctionPrototypes
	Widget parent, char *prompt, int modal, char **answer
#endif
);

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

/*************************************************************************
 * Local variables
 ************************************************************************/ 

/*************************************************************************
 * Function: GotoHomeCb ()
 * Purpose: change current pane to home directory
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition; Goto Home button pressed
 * Postcondition: Home dir showing in panes
 ************************************************************************/ 

/* ARGSUSED */
void
GotoHomeCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
   Widget		w;		/*  widget id		*/ 
   XtPointer		client_data;	/*  data from applicaiton   */ 
   XtPointer		call_data;	/*  data from widget class  */ 

#endif
{ 
	char *home_dir;
	dir_pane_info *dpi;

	home_dir = getenv ("HOME");
	XtVaGetValues (w,
			XmNuserData, (XtArgVal) &dpi,
			NULL);
	builtin_chdir (home_dir, dpi);
}
 
/*************************************************************************
 * Function: GotoDirCB ()
 * Purpose: handle a Goto Dir... request to reset pane to new dir
 *	prompts for new dir name
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition; Got Dir button pressed from Goto menu
 * Postcondition: new prompted dir showing in panes
 ************************************************************************/ 

/* ARGSUSED */
void GotoDirCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)
Widget		w;		/*  widget id		*/ 
XtPointer		client_data;	/*  data from applicaiton   */ 
XtPointer		call_data;

#endif
{
	char *goto_dir;
	dir_pane_info *dpi;

	GotoCurrentDir (w);

	PromptDialog (w, "Goto what directory?", True, &goto_dir);
	if (goto_dir == NULL)
		return;
	XtVaGetValues (w,
			XmNuserData, (XtArgVal) &dpi,
			NULL);
	builtin_chdir (goto_dir, dpi);
	XtFree (goto_dir);
}

/*************************************************************************
 * Function: GotoOpenHomeCb ()
 * Purpose: create a new pane on the Home directory
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition; Opne Home button pressed in Goto menu
 * Postcondition: new pane showing Home dir
 ************************************************************************/ 

/* ARGSUSED */
void
GotoOpenHomeCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
Widget		w;		/*  widget id		*/ 
XtPointer		client_data;	/*  data from applicaiton   */ 
XtPointer		call_data;	/*  data from widget class  */ 

#endif
{ 
	char *home_dir;
	dir_pane_info *dpi;

	home_dir = getenv ("HOME");
	XtVaGetValues (w,
			XmNuserData, (XtArgVal) &dpi,
			NULL);
	builtin_opendir (home_dir, dpi);
}
 
/*************************************************************************
 * Function: GotoOpenDirCB()
 * Purpose: create a new pane on a prompted directory
 * In parameters: w, client_data, call_data
 * Out parameters:
 * Precondition; Open Dir button pressed in Goto menu
 * Postcondition: new pane showing asked for directory
 ************************************************************************/ 

/* ARGSUSED */
void GotoOpenDirCB 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XtPointer call_data)
#else
	(w, client_data, call_data)  
Widget		w;		/*  widget id		*/ 
XtPointer		client_data;	/*  data from applicaiton   */ 
XtPointer		call_data;

#endif
{
	char *goto_dir;
	dir_pane_info *dpi;

	GotoCurrentDir (w);

	PromptDialog (w, "Open what directory?", True, &goto_dir);
	if (goto_dir == NULL)
		return;
	XtVaGetValues (w,
			XmNuserData, (XtArgVal) &dpi,
			NULL);
	builtin_opendir (goto_dir, dpi);
	XtFree (goto_dir);
}
