/*************************************************************************
 * File: $Source: /usr/usrs/xsource/xmfm/RCS/drag.c,v $
 * Author: Jan Newmarch
 * Last modified: $Date: 1992/11/17 00:35:40 $
 * Version: $Revision: 1.2 $
 * Purpose:
 *
 * Revision history:
 *         3 Nov 92        lint-ed
 *	  11 Nov 92	   moved Rogers drag'n drop to here
 ************************************************************************/ 

#include "copyright.h"

/*************************************************************************
 * System includes
 ************************************************************************/ 
#ifdef vax11c
#include "param.h"
#else
#include <sys/param.h>
#endif /* vax11c */

#ifdef MOTIF_DD
#include <Xm/DragIcon.h>
#include <Xm/DragDrop.h>
#include <Xm/AtomMgr.h>
#include <X11/Xatom.h>
#endif

#ifdef RDD
#include "rdd.h"
#endif

/*************************************************************************
 * Local includes
 ************************************************************************/ 
#include "types.h"

/*************************************************************************
 * Functions exported
 ************************************************************************/ 

/*************************************************************************
 * Variables exported
 ************************************************************************/ 

/*************************************************************************
 * Extern variables
 ************************************************************************/ 

/*************************************************************************
 * Extern functions
 ************************************************************************/ 
extern void FileToolButtonPressed ();
extern void FileButtonPressed ();

/*************************************************************************
 * Forward functions
 ************************************************************************/ 

#ifdef MOTIF_DD
extern void MotifDDStartAction (
#ifdef UseFunctionPrototypes
	Widget w, XButtonEvent *event
#endif
);
#endif

/*************************************************************************
 * Local variables
 ************************************************************************/ 
#ifdef MOTIF_DD
XtTranslations trans_table;
Atom TEXT;
static pane_button_info *pbi;
static Widget drag_icon = NULL;

String myTranslations =
		"#override\n\
		<Btn2Down>:	Arm() MotifDDStartAction()\n\
		<Btn2Up>:	Activate() Disarm()";
XtActionsRec dragActions [] =
                 { {"MotifDDStartAction", (XtActionProc) MotifDDStartAction} };
#endif /* MOTIF_DD */


#ifdef RDD
/*************************************************************************
 * Function: DirDrop ()
 * Purpose: handler for when a widget is dropped on a directory button
 * In parameters: w, call, cbs
 * Function result:
 * Precondition: drop message to widget w (a directory button) has occurred
 * Postcondition: 
 ************************************************************************/ 
void
DirDrop 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer call, XtPointer client_data)
#else
	(w, call, client_data)
	Widget w;
	XtPointer call;
	XtPointer client_data;

#endif
{	pane_button_info *pbi;
	RddCallbackStruct *cbs = (RddCallbackStruct *) client_data;

	XtVaGetValues (w,
		XmNuserData, &pbi, NULL);
#ifdef DEBUG
	fprintf (stderr, "drop on directory %s of file %s", 
			pbi -> name, cbs -> data);
#endif
}

/*************************************************************************
 * Function: ExecutableDrop ()
 * Purpose: handler for when a widget is dropped on an executable button
 * In parameters: w, call, cbs
 * Function result:
 * Precondition: drop message to widget w (an executable button) has occurred
 * Postcondition: 
 ************************************************************************/ 
void
ExecutableDrop 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer call, XtPointer client_data)
#else
	(w, call, client_data)
	Widget w;
	XtPointer call;
	XtPointer client_data;

#endif
{	pane_button_info *pbi;
	RddCallbackStruct *cbs = (RddCallbackStruct *) client_data;

	XtVaGetValues (w,
		XmNuserData, &pbi, NULL);
#ifdef DEBUG
	fprintf (stderr, "drop on executable %s of file %s", 
			pbi -> name, cbs -> data);
#endif
}

/*************************************************************************
 * Function: MainWindowDrop ()
 * Purpose: handler for when a widget is dropped on an executable button
 * In parameters: w, call, cbs
 * Function result:
 * Precondition: drop message to widget w (an executable button) has occurred
 * Postcondition: 
 ************************************************************************/ 
void
MainWindowDrop 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer call, XtPointer client_data)
#else
	(w, call, client_data)
	Widget w;
	XtPointer call;
	XtPointer client_data;

#endif
{	pane_button_info *pbi;
	RddCallbackStruct *cbs = (RddCallbackStruct *) client_data;

	XtVaGetValues (w,
		XmNuserData, &pbi, NULL);
#ifdef DEBUG
	fprintf (stderr, "drop on main window of file %s", 
			 cbs -> data);
#endif
}

/*************************************************************************
 * Function: ToolbarDrop ()
 * Purpose: handler for when a widget is dropped on a toobar button
 * In parameters: w, call, cbs
 * Function result:
 * Precondition: drop message to widget w (a toolbar button) has occurred
 * Postcondition: action corresponding to toolbar button has been done
 ************************************************************************/ 
void
ToolbarDrop 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer call, XtPointer client_data)
#else
	(w, call, client_data)
	Widget w;
	XtPointer call;
	XtPointer client_data;

#endif
{
	RddCallbackStruct *cbs = (RddCallbackStruct *) client_data;
#ifdef DEBUG
	fprintf (stderr, "File dropped: %s", cbs -> data);
#endif
	FileToolButtonPressedCB (w, NULL, NULL);
}
#endif /* RDD */

#ifdef MOTIF_DD
/*************************************************************************
 *
 * DRAG SIDE OF MOTIF DRAG AND DROP
 *
 *************************************************************************/

/*************************************************************************
 * Function: MotifDragConvertProc ()
 * Purpose: convert data into form suitable to send to drop client
 * In parameters: w, selection, target, client_data
 * Out parameters: typeRtn, valueRtn, formatRtn, max_lengthRtn
 * Precondition: 
 * Postcondition: full path name of selected file set as data
 ************************************************************************/ 

/* ARGSUSED */
Boolean
MotifDragConvertProc 
#ifdef UseFunctionPrototypes
	(Widget w, Atom *selection, Atom *target, Atom *typeRtn, XtPointer *valueRtn, long unsigned int *lengthRtn, int *formatRtn, long unsigned int *max_lengthRtn, XtPointer client_data, XtRequestId *request_id)
#else
	(w, selection, target,
	typeRtn, valueRtn, lengthRtn, formatRtn,
	max_lengthRtn, client_data,
	request_id)
	Widget		w;
	Atom		*selection;
	Atom		*target;
	Atom		*typeRtn;
	XtPointer	*valueRtn;
	unsigned long	*lengthRtn;
	int		*formatRtn;
	unsigned long	*max_lengthRtn;
	XtPointer	client_data;
	XtRequestId	*request_id;

#endif
{
	char *path;

	if (*target != XA_STRING)
		return False;
	/* build up full path name for file */
	path = (char *) XtMalloc (MAXPATHLEN);
	strcpy (path, DirectoryPath (DirectoryMgrDir (pbi -> dpi -> directory_manager)));
	strcat (path, pbi -> name);
	*lengthRtn = strlen (path);
	*typeRtn = XA_STRING;
	*valueRtn = path;
	*formatRtn = 8;		/* dont know what 8 means */
#ifdef DEBUG_DD
	fprintf (stderr, "starting drop for %s\n", path);
#endif
	return True;
}

/*************************************************************************
 * Function: MotifDDStartAction ()
 * Purpose: what to do when a drag begins
 * In parameters: w, event
 * Out parameters:
 * Precondition: 
 * Postcondition:  icon set to image, drag started
 ************************************************************************/ 
void MotifDDStartAction 
#ifdef UseFunctionPrototypes
	(Widget w, XButtonEvent *event)
#else
	(w, event)
	Widget w;
	XButtonEvent *event;

#endif
{	Atom	exportList[1];
	Arg	args[10];
        int n;

        /* store in a global variable the user data for this button
           till I figure out which widgets take part in what 
           The widget in the ConvertProc doesn't seem to be this one
         */
        XtVaGetValues (w, XmNuserData, &pbi, NULL);

	if (drag_icon == NULL)
	{	n = 0;
		/* set the pixmap to be the icon of the file
		   used reverse icon cos it has been selected by now */
		XtSetArg (args[n], XmNpixmap, pbi -> pixmap_reversed); n++;
		drag_icon = XmCreateDragIcon (w, "drag_icon", args, n);
	}
	else
	XtVaSetValues (w,
			XmNpixmap, pbi -> pixmap_reversed,
			NULL);
	
	exportList[0] = XA_STRING;
        n = 0;
	XtSetArg (args[n], XmNexportTargets,	(XtArgVal) exportList); n++;
        XtSetArg (args[n], XmNnumExportTargets,	(XtArgVal) 1); n++;
	XtSetArg (args[n], XmNdragOperations,	(XtArgVal) XmDROP_COPY); n++;
	XtSetArg (args[n], XmNconvertProc,	(XtArgVal) MotifDragConvertProc); n++;
	XtSetArg (args[n], XmNsourcePixmapIcon,	(XtArgVal) drag_icon); n++;

#ifdef DEBUG_DD
        fprintf (stderr, "starting drag\n");
#endif  /* DEBUG_DD */

	XmDragStart (w, (XEvent *) event, args, n);
}

/*************************************************************************
 * Function: InitMotifDD
 * Purpose         : set up global values for Motif DD
 * In parameters   : app_shell, app_context
 * Out parameters  :
 * Side effects    :
 * Function returns:
 * Precondition    :
 * Postcondition   : soem vbls set
 ************************************************************************/
void InitMotifDD 
#ifdef UseFunctionPrototypes
	(Widget app_shell, XtAppContext app_context)
#else
	(app_shell, app_context)
        Widget app_shell;
        XtAppContext app_context;

#endif
{

	/* MOTIF_DD add action MotifDDStartAction */
	{
		XtActionsRec actions;
		actions.string	= "MotifDDStartAction";
		actions.proc	= MotifDDStartAction;
		XtAppAddActions (app_context, &actions, 1);
	}
	trans_table = XtParseTranslationTable (myTranslations);
	
	/* set the atom to allow communication with other widgets */
	TEXT = XmInternAtom (XtDisplay (app_shell),
				"TEXT", False);
#ifdef DEBUG_DD
        fprintf (stderr, "initialised Motif drag n' drop\n");
#endif /* DEBUG_DD */

}
 
/*************************************************************************
 *
 * DROP SIDE OF MOTIF DRAG AND DROP
 *
 *************************************************************************/

/*************************************************************************
 * Function: ToolbarTransferProc
 * Purpose         : execute the action on the dropped file
 * In parameters   : all of them
 * Out parameters  :
 * Side effects    :
 * Function returns:
 * Precondition    :
 * Postcondition   : legal drop site -> action executed on drop file
 ************************************************************************/

/* ARGSUSED */
static void
ToolbarTransferProc 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer closure, Atom *seltype, Atom *type, XtPointer value, long unsigned int *length, int format)
#else
	(w, closure, seltype,
              type, value, length, format)
       Widget w;
       XtPointer closure;
       Atom *seltype;
       Atom *type;
       XtPointer value;
       unsigned long *length;
       int format;

#endif
{
      tool_button_info *tbi;
       char selected_file[MAXPATHLEN];
      
       if (*type == XA_STRING)
       {
#              ifdef DEBUG_DD
                     fprintf (stderr, "drop data received okay: %s %s\n",
                              (char *) value);
#              endif
               /* closure has the button we just dropped on.
                  Suppose a user has dropped from a *different*
                  pane - probably an error. We must check that the
                  file already selected in this pane is the same as
                  the file we have just dropped here!
               */
               XtVaGetValues (closure, XmNuserData, &tbi, NULL);
               strcpy (selected_file,
                       DirectoryPath (DirectoryMgrDir (tbi -> dpi -> directory_manager)));

               strcat (selected_file, tbi -> dpi -> file_selected);
#              ifdef DEBUG_DD
                     fprintf (stderr, "current selected file in this pane %s\n",
                            selected_file);
#              endif
               if (strcmp (value, selected_file) == 0)
                      FileToolButtonPressedCB (closure, NULL, NULL);
       }
#      ifdef DEBUG_DD
       else
                     fprintf (stderr, "drop data not ok\n");
#      endif
}
/*************************************************************************
 * Function: HandleToolbarDrop
 * Purpose         : start drop on toolbar button
 * In parameters   : w, client_data, call_data
 * Out parameters  :
 * Side effects    :
 * Function returns:
 * Precondition    :
 * Postcondition   :
 ************************************************************************/

/* ARGSUSED */
static void
HandleToolbarDrop 
#ifdef UseFunctionPrototypes
	(Widget w, XtPointer client_data, XmDropProcCallback DropData)
#else
	(w, client_data, DropData)
       Widget w;
       XtPointer client_data;
       XmDropProcCallback DropData;

#endif
{
       
       XmDropTransferEntryRec transferEntries[2];
       Arg args[10];
       int n;

       n = 0;
       if (DropData -> dropAction != (unsigned char) XmDROP ||
              DropData -> operation != (unsigned char) XmDROP_COPY)
       {      XtSetArg (args[n], XmNtransferStatus, XmTRANSFER_FAILURE); n++;
#             ifdef DEBUG_DD
              fprintf (stderr, "drop: receive type failed\n");
#              endif
       }
       else
       {      transferEntries[0].target = XA_STRING;
              transferEntries[0].client_data = (XtPointer) w;
              XtSetArg (args[n], XmNdropTransfers, transferEntries); n++;
              XtSetArg (args[n], XmNnumDropTransfers, 1); n++;
              XtSetArg (args[n], XmNtransferProc, ToolbarTransferProc); n++;
#             ifdef DEBUG_DD
              fprintf (stderr, "drop: receive type okay\n");
#              endif
       }
       
       XmDropTransferStart (DropData -> dragContext, args, n);
}

/*************************************************************************
 * Function: MotifDDRegisterToolbar
 * Purpose         : let the Motif DD system know about this toolbar button
 * In parameters   : button
 * Out parameters  :
 * Side effects    :
 * Function returns:
 * Precondition    :
 * Postcondition   : button registered in DD
 ************************************************************************/
void 
MotifDDRegisterToolbar 
#ifdef UseFunctionPrototypes
	(Widget button)
#else
	(button)
       Widget button;

#endif
{
       Atom importList[1];
       Arg args[10];
       int n;

       importList[0] = XA_STRING;
       n = 0;
       XtSetArg (args[n], XmNimportTargets, (XtArgVal) importList); n++;
       XtSetArg (args[n], XmNnumImportTargets, (XtArgVal) 1); n++;
       XtSetArg (args[n], XmNdropSiteOperations, (XtArgVal) XmDROP_COPY); n++;
       XtSetArg (args[n], XmNdropProc, (XtArgVal) HandleToolbarDrop); n++;
       XmDropSiteRegister (button, args, n);
}
#endif /* MOTIF_DD */
