.\"
.\" @(#)xmcd.man	7.22 01/05/16
.\"
.\"   xmcd - Motif(tm) CD Audio Player
.\"
.\"   Copyright (C) 1993-2001  Ti Kan
.\"   E-mail: xmcd@amb.org
.\"
.\"   This program is free software; you can redistribute it and/or modify
.\"   it under the terms of the GNU General Public License as published by
.\"   the Free Software Foundation; either version 2 of the License, or
.\"   (at your option) any later version.
.\"
.\"   This program is distributed in the hope that it will be useful,
.\"   but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"   GNU General Public License for more details.
.\"
.\"   You should have received a copy of the GNU General Public License
.\"   along with this program; if not, write to the Free Software
.\"   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH XMCD 1 "01/05/16" "v3.0"

.SH "NAME"
xmcd \- CD digital audio player utility for X11/Motif

.SH "SYNOPSIS"
.B xmcd
.nh
[\fItoolkitoption ...\fP] [-\fIdev\fP device] [-\fIinstcmap\fP]
[-\fIremote\fP] [-\fIrmthost\fP hostname] [-\fIhelp\fP]
[-\fIdebug\fP level#] [-\fIc\fP device] [-\fIX\fP] [-\fIo\fP]
[\fIcommand\fP [\fIarg\fP ...]]

.SH "DESCRIPTION"
.I Xmcd
is a program that allows the use of the CD-ROM, CD-R or CD-RW drive as
a full-featured stereo compact-disc player for the X window system.
See
.I cda(1)
for the command-line CD player.
.I xmcd
and
.I cda
uses the same configuration and support files.
.PP
Most of the features found on "real" CD players are available in
.I xmcd,
such as shuffle and repeat, track programming functions,
a numeric keypad and track warp slider for direct track access.
Additional functions include sample play, A to B segment play,
volume control, balance control, etc.  Several automation
options are also available on CD load, eject, play completion
and program exit.  A Channel Routing feature allow you to
select from several stereo or mono routing options.  The
volume control slider taper characteristics can also be
altered.
.PP
Multi-disc changers are also supported.  There are buttons
to switch to the next or previous disc in the changer, as well
as a way to specify a specific disc via the keypad.  You can
select to play only a single disc or auto-play all discs in
normal or reverse order.
.PP
The Gracenote CDDB(tm) Music Recognition Service(sm) is supported by
.I xmcd,
which allows the CD artist/title and track titles, and other
information associated with the loaded CD to be displayed.
You may also add/modify and submit information to the CDDB service.
This release of
.I xmcd
supports the enhanced Gracenote CDDB2(tm) service on
selected platforms, and offers
much richer features and content than the "classic" CDDB service.
Moreover, CDDB2-supplied information is now in UTF-8
data format, providing localization support.  See LOCALIZATION below.
.PP
.I Xmcd
provides the ability to drive a web browser and search for web
sites related to the currently playing CD artist or track.
You may also access online music reviews and go to the official
.I xmcd
and
.I Gracenote
web sites, invoke the CDDB Music Browser(tm),
as well as CDDB-provided links to related content.
Moreover, the browser integration gives
users the ability to manage \fILocal Discography\fR information
pertaining to their CD collections.
.PP
Full feature-specific pop-up help is available for
all controls, indicators, text input fields, and lists.
.PP
On systems with more than one CD-ROM or CD-R drive, multiple
invocations of
.I xmcd
can be used to operate each drive independently.
.PP
.I Xmcd
is designed to be easy to use, as the main window is
purposely made to resemble a real CD player front panel.
All other pop-up windows are also designed to be as
intuitive as possible.  Moreover, while the use of a mouse
is natural with
.I xmcd,
all functionality can also be operated via the keyboard.
This is in conformance to the guidelines published in the
.I OSF/Motif Style Guide
from the Open Software Foundation.
.PP
Many functions on a running
.I xmcd
session can be "remote controlled"
from the command line via the -\fIremote\fP option.  See the OPTIONS
section below.
.PP
The internal architecture of
.I xmcd
is designed to be easily portable to many UNIX operating
system variants, and adaptable to the myriad of CD-ROM drives
available.

.SH "OPTIONS"
All standard \fIXt Intrinsics\fR toolkit options are supported
(such as -\fIdisplay\fP, -\fIgeometry\fP. -\fIiconic\fP, etc.).
In addition,
.I xmcd
supports the following options:
.TP
\fI\-dev\ device\fR
.br
Specifies the path name to the raw CD-ROM device.  If this option is
not used, the default device to be used is the first
drive set up with the
.I xmcd
configuration program (See below).
.TP
\fI\-help\fR
Causes command line usage information to be displayed on \fIstderr\fR.
.TP
\fI\-debug\ level#\fR
Causes verbose debugging diagnostics to be displayed on \fIstderr\fR.
The level specifies the type of debugging messages desired:
.sp
.nf
1	General debugging
2	Device I/O debugging
4	CD information debugging
8	User interface debugging
16	Remote control debugging
.fi
.sp
You may add the values together to enable multiple debugging types
(i.e., A value of 3 turns on both General and Device I/O debugging).
.TP
\fI\-instcmap\fR
Causes
.I xmcd
to install its own colormap.  This may be desirable if
.I xmcd
is to be used at the same time as other color-intensive
applications, which would otherwise cause
.I xmcd
to be unable to
allocate all its needed colors.  Note that when running on an X
display that does not support many concurrent colormaps, this may
cause other windows to change colors when
.I xmcd
has the input focus.
.TP
\fI\-remote\fR
Causes a command to be sent to another running
.I xmcd
process.
The command and appropriate arguments are specified at the
invoking shell (or shell script) as command-line arguments,
After the command is delivered, the "sender"
.I xmcd
process exits,
and the "receiver" process responds by executing the command.
In effect, the sender becomes a remote control for a running
.I xmcd
session.  See "COMMANDS" below for a list of supported
commands.
.sp
The sender
.I xmcd
process can be invoked on the same host or on
a different host than the receiver
.I xmcd
process.  By default,
the sender will attempt to locate an
.I xmcd
process running on the
same X display (determined by the DISPLAY environment variable
or the -\fIdisplay\fP option), and controlling the same
default CD-ROM device.  You may specify the device via the -\fIdev\fP
option to override the default.  Use of the -\fIdev\fP and
-\fIrmthost\fP options on the sender's command line can resolve
ambiguities when there are multiple
.I xmcd
clients displaying on the
same X server.
.TP
\fI\-rmthost\ hostname\fR
This may be used with the -\fIremote\fP option to specify the host
on which the receiver
.I xmcd
client must be running.
.TP
\fI\-c\ device (Solaris only)\fR
Same as the
.I -dev
option.
.TP
\fI\-X (Solaris only)\fR
Causes the \fBexitOnEject\fR parameter to be set to True.
.TP
\fI\-o (Solaris only)\fR
This option has no effect.
.PP
The
.I -c, -X
and
.I -o
options are provided only on the Solaris platform
for compatibility with the
.I action_workman.so
auto-startup program, running under the Solaris Volume Manager (\fIvold\fP).
See the README file in the
.I xmcd
distribution about configuring
.I xmcd
for the Solaris Volume Manager.

.SH "X RESOURCES"
.I Xmcd
has many adjustable X resources to customize its look and feel, as well
as its behavior.  Notably, the colors of virtually every feature on
\fIxmcd\fR's windows can be changed, as well as the text fonts.  All
text labels can also be changed (for example, to another language).
.PP
There are too many resources to list here, but the resource names
and their defaults (plus descriptive comments) can be found in the
\fBXMCDLIB\fI/app-defaults/XMcd\fR
file (where XMCDLIB is the xmcd library directory specified during
installation, typically \fI/usr/lib/X11/xmcd\fR).
It is not recommended
that you change values in the \fBXMCDLIB\fI/app-defaults/XMcd\fR file,
unless you want the changes to be forced upon all users of
.I xmcd
on the system.  Instead, make a copy of this file, change the copy as you
see fit, then place it in your $HOME/.xmcdcfg directory.  Your custom
resource settings will then override the defaults when
.I xmcd
is subsequently started.  Alternatively, you may also place specific
resources you wish to override in the
.I .Xdefaults
file in your home directory.

.SH "COMMANDS"
You may specify a command as an xmcd command line argument,
to make xmcd execute the command after initial startup.
For example, the following command starts
.I xmcd
and then begins playing at track 4:
.sp
.in +4
\fBxmcd play 4 &\fP
.in -4
.sp
.PP
If the -\fIremote\fP option is used, then the command is
sent to another running xmcd process for execution (See "OPTIONS"
above).
.PP
The supported commands are:
.PP
.TP
\fIstop\fR
Stop playback.
.TP
\fIplay\ [track#\ |\ min:sec\ |\ track#:min:sec]\fR
Start playback.  You may also specify the starting track number,
and/or the starting minute and second offset.
.TP
\fIpause\fR
Pause the playback.  You may resume the playback by using either
the \fIpause\fP command again, or the \fIplay\fP command.
.TP
\fIsample\fR
Start sample playback.  This will play the first 10 seconds of each
track.
.TP
\fIdisc \<load\ |\ eject\ |\ prev\ |\ next\ |\ disc#>\fR
Perform a disc operation:  Load or eject the CD, or change to
another disc on a multi-disc changer.
.TP
\fItrack\ <prev\ |\ next\ |\ track#>\fR
Perform a track operation: Change to the previous or next track, or
a specified track number.
.TP
\fIindex\ <prev\ |\ next>\fR
Perform an index operation: Change to the previous or next index.
.TP
\fIlock\ <on\ |\ off>\fR
Enable or disable the caddy (or disc tray) lock.  When enabled,
pressing the eject button on the drive will not eject the CD.
.TP
\fIshuffle\ <on\ |\ off>\fR
Enable or disable shuffle (random play) mode.
.TP
\fIrepeat\ <on\ |\ off>\fR
Enable or disable repeat mode.
.TP
\fIprogram\ <clear\ |\ save \| track#\ ...>\fR
Clear, save or set a track program sequence.  Track numbers may be space or
comma-separated.
.TP
\fIvolume\ <value#\ |\ linear\ |\ square\ |\ invsqr>\fR
Volume control operation.  You can specify a numeric value to set
the volume level (The range is 0 to 100), or change the volume control's
taper characteristic: linear, square, or inverse-square.
.TP
\fIbalance\ value#\fR
Balance control.  The value should be between 0 and 100.   50 is center,
0 is full-left, and 100 is full-right.
.TP
\fIroute\ <stereo\ |\ reverse\ |\ mono-l\ |\ mono-r\ |\ mono\ |\ value#>\fR
Channel routing control.  Use one of the appropriate keywords, or
a value as follows:
.sp
.nf
0	Normal stereo
1	Reverse stereo
2	Mono-L
3	Mono-R
4	Mono-L+R
.fi
.TP
\fItime\ <elapse\ |\ e-disc\ |\ r-trac\ |\ r-disc>\fR
Change the time display mode.  Select from elapsed track time,
elapsed disc time, remaining track time, or remaining disc time.
.TP
\fIon-load\ <autolock\ |\ noautolock\ |\ none\ |\ spindown\ |\ autoplay>\fR
Enable or disable options when a CD is loaded.  The
.I autolock
option causes the caddy or disc tray to be automatically locked,  The
.I spindown
option will cause the CD to stop after loading to conserve the laser
and motor.  The
.I autoplay
option will cause the CD to automatically start
playing after loading.  The
.I none,
.I spindown
and
.I autoplay
options are mutually-exclusive.
.TP
\fIon-exit\ <none\ |\ autostop\ |\ autoeject>\fR
Enable or disable options when
.I xmcd
exits.  The
.I autostop
option will cause xmcd to stop playback,
and the
.I autoeject
option will cause xmcd to eject the CD.  Use
.I none
to cancel these options.
.TP
\fIon-done\ <autoeject\ |\ noautoeject\ |\ autoexit\ |\ noautoexit>\fR
Enable or disable options when
.I xmcd
is done with playback.  The
.I autoeject
option causes xmcd to eject the CD.  The
.I autoexit
option will cause xmcd to exit.
.TP
\fIon-eject\ <autoexit\ |\ noautoexit>\fR
Enable or disable options when
.I xmcd
ejects a CD.  The
.I autoexit
option will cause xmcd to exit after ejecting the CD.
.TP
\fIchanger\ <multiplay\ |\ nomultiplay\ |\ reverse\ |\ noreverse>\fR
Enable or disable multi-disc changer options.  The
.I multiplay
option specifies that
.I xmcd
plays all discs in sequence.  The
.I nomultiplay
option will cause xmcd to stop after the current disc is done.
The
.I reverse
option implies
.I multiplay,
except that the disc order is reversed.
.TP
\fIwindow\ <modechg\ |\ iconify\ |\ deiconify\ |\ raise\ |\ lower>\fR
.I Xmcd
window control.  The
.I modechg
command causes the
.O xmcd
main window to toggle between the normal mode and basic mode.  In normal
mode, all controls and indicators are available.  In basic mode,
.I xmcd
shrinks to a smaller size and only basic controls are shown.
The
.I iconify,
.I deiconify,
.I raise
and
.I lower
commands cause the
.I xmcd
window to change as specified.
.TP
\fIquit\fR
Causes xmcd to exit.
.TP
\fIdebug\ <level#>\fR
Set the debug level.  When debug level is non-zero,
.I xmcd
generates verbose debugging diagnostics to be displayed on \fIstderr\fR.
See the description for the \fI-debug\fR option above for supported level
values.
.PP
Some of these commands, when used in start-up mode, do not
perform a meaningful function.  For example, the "\fItrack prev\fP"
command is not useful just after xmcd startup.  It is more appropriate
to use this command in the remote control mode.

.SH "DEVICE CONFIGURATION"
The X resources described in the previous section affect the
general appearance and behavior of
.I xmcd.
There are two additional configuration files which are used
to adapt
.I xmcd
to your site requirements.  The first of these contain
common parameters, and the second contain
configurable parameters that must vary on a
per-drive basis.  For example, in some cases
.I xmcd
must operate the drive differently depending upon the brand
and model of the drive.  Thus, there must be a separate
configuration file for these parameters \fIper-device\fR.
The common parameters file is \fBXMCDLIB\fI/config/common.cfg\fR
and the device-specific parameters file is
\fBXMCDLIB\fI/config/\fBDEVICE\fR
(where XMCDLIB is typically \fI/usr/lib/X11/xmcd\fR and DEVICE is
the base name of the raw device special file for the CD-ROM drive;
e.g., \fI/usr/lib/X11/xmcd/config/rcd0\fR).
A configuration program \fBXMCDLIB\fI/config/config.sh\fR
is provided to make maintaining these configuration
file easy (Note: on SCO UNIX/Open Desktop/Open Server systems the
configuration program can also be invoked as "\fImkdev xmcd\fR").
.PP
You should always use the configuration program to set the
configuration parameters when installing
.I xmcd
for the first time, or when the CD-ROM hardware configuration has
changed.  If this is not done then
.I xmcd
will probably not operate correctly with your CD-ROM drive.
.PP
.B WARNING:
If
.I xmcd
is not correctly configured, you may cause
.I xmcd
to deliver commands that are not supported by your CD-ROM drive.
Under some environments this may lead to system hang or crash.
.PP
You can override some of the device-specific configuration parameters
by adding your own configuration files.
.I Xmcd
will also look in the
\fB$HOME\fI/.xmcdcfg/common.cfg\fR and
\fB$HOME\fI/.xmcdcfg/\fBDEVICE\fR files for
common and device-specific parameters (where $HOME is your home
directory and DEVICE is as specified above).  Parameters found in
this file will override the system defaults (except those
parameters that cannot be overridden; see the comments in the
\fBXMCDLIB\fI/config/device.cfg\fR for details).

.SH "USING XMCD"
The basic functions of
.I xmcd
are designed to operate the same way as on a real stereo CD player.
The pictorial symbols used on the main window buttons are intended
to illustrate the function in a non-language-specific manner.  If
enabled, a small "tooltip" will appear after a short delay, when
you position the mouse cursor over any xmcd main window feature.
The tooltip contains textual description of the feature.
.PP
The CD information and track programming functions are operated
via the CD Information subwindow.  You open the subwindow by clicking the
.B CD Information
button (file cabinet symbol) on the main window (See "CD DATABASE" below).
.PP
There is not a per-item description of all the features here,
because full on-line help is available (See "ONLINE HELP" below).

.SH "ONLINE HELP"
For general information about
.I xmcd,
click the \fBwwwWarp\fR (world symbol) button on the
.I xmcd
main window and select '\fIXmcd help...\fR' in the menu.  You can also
get specific help information about each button, control,
indicator, text entry area, selection list by positioning the
mouse cursor over the desired item, then clicking the third mouse
button.  A pop-up window will appear, containing the relevant
help text.

.SH "TRACK PROGRAMMING"
You can program
.I xmcd
to play only certain tracks, in a custom sequence.
To do so, invoke the CD Information window (by clicking the
.B CD Information
button on the main window).  Select the desired track
by clicking on the entry in the
.B Track list,
and click the
.B Add
button to add to the play sequence.  Notice that the track number
appears in the
.B Program sequence
text field.  You can also type the track numbers, separated with
commas or spaces, directly in the
.B Program sequence
field.  Repeat until all desired tracks have been entered,
then click the
.B Play/Pause
button (on the main window) to start the program play.
.PP
When a program sequence is defined, the
.B prog
indicator in the main window display area "illuminates".
To erase the program sequence, click the
.B Clear
button on the CD Information window.  You may also
.B Save
a program sequence, so that the next time you load the same CD
the program will automatically be applied.  The
.Clear
button will also delete the saved program.

.SH "CD DATABASE"
Unless explicitly disabled,
.I xmcd
will automatically query the Gracenote CDDB Music Recognition Service
for information about the loaded CD.  This information includes the
artist/title, track titles, genre, and much more, and is
displayed on the CD Information window and several of its
sub-windows.

You may also add, modify or enhance the displayed
information, in the rare circumstance that CDDB does not have data
pertaining to your CD, or if the CDDB-supplied data is incomplete or
in error.  You can then submit the changes back to CDDB.
.PP
You should perform a "submit" operation (click the
.B Submit
button) after typing in the changed information before ejecting
the CD or exiting, or the information will be lost.
.PP
The CD Information window should prove to be intuitive to use.
You may use the on-line help system to obtain specific help
information about the various buttons and items.
.PP
The CD information, once queried from CDDB, is stored in a local cache
and managed by the CDDB library.  This reduces unnecessary Internet
connections to the CDDB servers.  For backward compatibility,
this release of
.I xmcd
will also read the old-style local CD database files previously
generated by xmcd versions 1.x and 2.x.  No capability is retained
in this release to write/update the old-style CD database files.
.PP
For more information about
.I Gracenote\ CDDB,
read the CDDB file included with this release, and visit the
.I http://www.cddb.com
web site for details.
.PP
While
.I xmcd
is running, the file \fB/tmp/.cdaudio/curr.\fInnnn\fR (where
nnnn is the hexadecimal representation of the CD-ROM's
device number) contains the device node path, CD database category
and disc identifier information pertaining to the currently loaded CD.
Other applications may read this file to identify the
currently loaded disc.

.SH "LOCALIZATION"
.PP
The CDDB2-supplied data, in UTF-8 data format, is displayed without
modification in
.I xmcd.
As distributed,
.I xmcd
is configured to display in a generic family of X fonts denotes similar
to the following:
.sp
.in +4
-*-helvetica-bold-o-*--14-140-*
.in -4
.sp
This will normally work correctly with English and any ISO-8859 family of
European languages, as long as your X display server supports all the
required fonts.  To display in other languages, you must change xmcd to
use the appropriate UTF8-specific fonts.  That can be accomplished by
modifying the various XMcd*\fIclassname\fI.fontList parameters in the
XMCDLIB/app-defaults/XMcd file (system wide) or your $HOME/.xmcdcfg/XMcd
file (per-user).  Be sure that the fonts you specify is actually supported
by your X display server.  See
.I xlsfonts(1)
and your X window system
documentation about font configuration.
.PP
Moreover, all titles and descriptions in xmcd are configurable in the
XMcd X resource file.  US-English is distributed by default, but the file
may be modified to use any other language as desired.

.SH "NOTES"
Not all CD-ROM drives support all features that appear on
.I xmcd.
For example, some drives do not support a software-driven
volume control.  On these drives the
.I xmcd
volume control slider may have no effect, or in some cases it is
made to function as a mute control (i.e., it will snap to the
full-off or full-on positions only).  Similarly, the \fBcaddy lock\fR,
\fBeject\fR and \fBindex search\fR buttons found on
.I xmcd
may not have any effect on drives that do not support the
appropriate functionality.
.PP
The remote control feature (using the -\fIremote\fP option)
is governed by the standard display server security mechanisms of the
X window system.  In order for an
.I xmcd
sender client to communicate
with a running
.I xmcd
receiver client, the sender must have the
appropriate access permissions to the receiver client's X display.
See
.I xhost(1),
.I xauth(1)
and
.I Xsecurity(1)
for more information.  If logging is enabled, remote control activity
is logged by the xmcd receiver client in the $HOME/.xmcdcfg/remote.log
file for each xmcd user.

.SH "ENVIRONMENT VARIABLES"
.PP
For the \fBwwwWarp\fR feature, xmcd invokes the Netscape web browser
to display the contents.  Xmcd searches a number of "standard" locations
for the web browser executable.  If you have multiple versions of the
Netscape browser installed and would like to direct xmcd to use a
particular executable, or if your Netscape executable is installed in
a non-standard location, then you may set the BROWSER_PATH environment
variable on the shell command line to the web browser executable you
desire.
.PP
An example:
.in +4
.nf
.sp
(For Bourne Shell and Korn Shell users):
.br
BROWSER_PATH=/usr/local/bin/netscape; export BROWSER_PATH
.sp
(For C Shell users):
.br
setenv BROWSER_PATH /usr/local/bin/netscape
.fi
.in -4
.PP
you may put the above command in your $HOME/.profile (sh/ksh) or
$HOME/.cshrc (csh) to set this automatically each time you log in.

.SH "FILES"
$HOME/.cddb2/\(**
.br
$HOME/.xmcdcfg/\(**
.br
XMCDLIB/app-defaults/XMcd
.br
XMCDLIB/cdinfo/\(**
.br
XMCDLIB/discog/\(**
.br
XMCDLIB/doc/\(**
.br
XMCDLIB/config/config.sh
.br
XMCDLIB/config/common.cfg
.br
XMCDLIB/config/device.cfg
.br
XMCDLIB/config/.tbl/\(**
.br
XMCDLIB/config/\(**
.br
XMCDLIB/help/\(**
.br
BINDIR/xmcd
.br
MANDIR/xmcd.1
.br
/tmp/.cdaudio/\(**

.SH "RELATED WEB SITES"
Xmcd/cda web site: \fIhttp://www.amb.org/xmcd/\fR
.br
Gracenote web site: \fIhttp://www.cddb.com/\fR
.br
Xmmix home page: \fIhttp://www.amb.org/xmmix/\fR

.SH "SEE ALSO"
cda(1), X(1), xhost(1), xauth(1), Xsecurity(1), xlsfonts(1)
.br
Xmcd's README and INSTALL files

.SH "AUTHOR"
Ti Kan (\fIxmcd@amb.org\fR)
.br
AMB Research Laboratories, Sunnyvale, CA, U.S.A.
.br
.I Xmcd
also contains code contributed by several dedicated individuals.
See the ACKS file in the
.I xmcd
distribution for information.
.br
Comments, suggestions, and bug reports are always welcome.
