/*
* xhtml.h - (c) 1994 Copyright by John R. Punin
*
* Main Header Files
*
*
*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef VMS
#include <sys/param.h>
#endif
#include <fcntl.h>

#include<X11/cursorfont.h>
#include <X11/keysym.h>

#include <Xm/Xm.h>		/* Needed by all Motif programs. */

#include <Xm/MessageB.h>        /* Needed by all X Window programs */
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/MainW.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/DialogS.h>
#include <Xm/Label.h>
#include <Xm/SelectioB.h>
#include <Xm/FileSB.h>
#include <Xm/BulletinB.h>
#include <Xm/ScrollBar.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <Xm/Frame.h>
#include <Xm/ScrolledW.h>

/*
#include <Graph.h>
#include <Arc.h>

#include <ListTree.h>
*/

#include <HTML.h>
#include <cci.h>

/*
 * * Global Constant variables
 */
/* This is the number of the Version of the libhtmlw 2.7b2 */
#define Libhtmlw_VERSION 27


#define XTEXT_STRING \
"<!-- This is ASHE 1.3, Editor of the HTML Documents \n Written by John R. Punin \n(C) 1994 Copyright by Rensselaer Polytechnic Institute -->\n"
#define SIZESTR                 60
#define PERMS                   0664
#define BUFSIZE                 1024  /* Size of the buffer */
#define MAXARGS                 20
#define MAXIPATH                 255
#define STR_LEN                  255

#ifndef VMS
#define SCRATCHFILE "*scratch*"
#else
#define SCRATCHFILE "scratch.html"
#endif

#define YES 1
#define NO 2
#define CANCEL 3

#if defined(SYSV) || defined(SVR4) || defined(__svr4__) || defined(VMS)
#define bcopy(source, dest, count) memcpy(dest, source, count)
#define bzero(b, len) memset(b, 0, len)
#define getwd(a) getcwd(a, STR_LEN)
#endif



/* HTML Commands used in this editor */

enum commands { NONE, CLEAR,TITLE, PARAG, HEADER,LINKER ,REFER,IMAGE,PRE,
	     CITE,CODE,BLOCKQ,ADDR,BOLD,ITALIC,UNDER,DEFLIST,TERM,
	     UNLIST,ORLIST,ITEM,FORM,INPUT,SELECT,OPTION,TEXTAREA,HR,LINEBREAK,
	     COMMENT,HTML,BODY,HEAD,EM,STRONG,TT,CARAC};

/* Structure Undo */

typedef struct {
   XmTextPosition right;
   XmTextPosition left;
   int lenleft;
   int lenright;
   enum commands com_html;
   char ubuffer[BUFSIZE];
} undo_struct;


struct html_editor {
   Widget shell;
   Widget textarea;/* Text                */
   Widget file_output;  /* Name of the file */
   Widget text_output; /* Labels            */
   Widget title_output;
   Widget html_text;
   Widget shell_graph; /* shell of the graph */
   Widget shell_tree; /* shell of the tree */
   Widget shell_html_view; /* shell of the HTML tree viewer */
   Widget editwidget;
   Widget open_dialog;
   Widget insert_dialog;
   Widget save_dialog;
   Widget export_dialog;
   XtPointer user_data;
   int header_num;
   int fonts;
   int export_option;
   Boolean toggle_mark_tag;
   Boolean modified_file;
   Boolean load_image;
   Boolean table_support;
   int method;
   enum commands last_command;
   undo_struct undo_buffer;
   char Name_File[MAXIPATH];
   char *format_file;
   Boolean lose_focus;
   char *warning;
   char *href;
   char *anchor_target;
   char *text_cleared;
};

typedef struct html_editor HTMLED;


struct html_list{
   HTMLED *fr;
   struct html_list *next;
};
typedef struct html_list HTML_LIST;
   
struct _myAppRes {
   String htmldir;
#if Libhtmlw_VERSION == 27
   Boolean print_header;
   Boolean print_footer;
   Boolean print_us;
#endif
};
typedef struct _myAppRes MyAppResType;



