/*
	$Id: callback.h,v 1.2 2000/12/30 01:22:36 rogue Exp $

	Copyright (c) 1999, 2000 Xforge project
*/

#ifndef _CALLBACK_H
#define _CALLBACK_H

/* misc protos */
extern void set_window_title(struct buffer *);

/* callback protos */

extern void render_buffer(Widget, struct buffer *);
extern void render_selection(Widget, struct buffer *, int);
extern void render_statbar(struct buffer *);
extern void refresh_scrollbar(struct buffer *);
extern void render_all(Widget, struct buffer *);
extern void scroll_canvas(Widget, struct buffer *,
	XmScrollBarCallbackStruct *);
extern void new_window(Widget, struct buffer *);
extern void open_help(Widget, struct buffer *);
extern void open_hide_dialog(Widget, struct buffer *);
extern void open_really(Widget, struct buffer *,
	XmFileSelectionBoxCallbackStruct *);
extern void open_query(Widget, struct buffer *);
extern void save_hide_dialog(Widget, struct buffer *);
extern void save_really(Widget, struct buffer *,
	XmFileSelectionBoxCallbackStruct *);
extern void save_inst(Widget, struct buffer *);
extern void save_query(Widget, struct buffer *);
extern void revert_destroy_dialog(Widget, struct buffer *);
extern void revert_really(Widget, struct buffer *);
extern void revert_query(Widget, struct buffer *);
extern void quit_really(void);
extern void quit_query(Widget, struct buffer *);
extern void buf_undo(Widget, struct buffer *);
extern void clip_copy(Widget, struct buffer *);
extern void clip_cut(Widget, struct buffer *);
extern void clip_paste(Widget, struct buffer *);
extern void clip_swap(Widget, struct buffer *);
extern void clear_really(Widget, struct buffer *);
extern void clear_query(Widget, struct buffer *);
extern void clip_delete(Widget, struct buffer *);
extern void select_chg(Widget, XButtonEvent *, String *, int *);
extern void select_all(Widget, struct buffer *);
extern void select_left(Widget, struct buffer *);
extern void select_right(Widget, struct buffer *);
extern void select_none(Widget, struct buffer *);
extern void begin_data(Widget, struct buffer *);
extern void ext_begin_data(Widget, struct buffer *);
extern void end_data(Widget, struct buffer *);
extern void ext_end_data(Widget, struct buffer *);
extern void addws_help(Widget, struct buffer *);
extern void addws_really(Widget, struct buffer *,
	XmSelectionBoxCallbackStruct *);
extern void addws_query(Widget, struct buffer *);
extern void clip_remdc(Widget, struct buffer *);
extern void show_range(Widget, struct buffer *);
extern void show_all(Widget, struct buffer *);
extern void zoom_out(Widget, struct buffer *);
extern void close_really(Widget, struct buffer *);
extern void close_query(Widget, struct buffer *);
extern void refresh_window(Widget, struct buffer *);
extern void play_stop(Widget, struct buffer *);
extern void play_range(Widget, struct buffer *);
extern void play_all(Widget, struct buffer *);
extern void play_loop(Widget, struct buffer *);
extern void param_help(Widget, struct buffer *);
extern void param_set(Widget, struct buffer *, XmPushButtonCallbackStruct *);
extern void param_hide_dialog(Widget, struct buffer *);
extern void param_query(Widget, struct buffer *);
extern void resample_really(Widget, struct buffer *);
extern void resample_hide_dialog(Widget, struct buffer *);
extern void resample_query(Widget, struct buffer *);
extern void mono_really(Widget, struct buffer *);
extern void mono_hide_dialog(Widget, struct buffer *);
extern void mono_query(Widget, struct buffer *);
extern void stereo_really(Widget, struct buffer *);
extern void phase_invert(Widget, struct buffer *);
extern void range_reverse(Widget, struct buffer *);
extern void mix_really(Widget, struct buffer *);
extern void mix_hide_dialog(Widget, struct buffer *);
extern void mix_query(Widget, struct buffer *);
extern void vol_really(Widget, struct buffer *);
extern void vol_hide_dialog(Widget, struct buffer *);
extern void vol_query(Widget, struct buffer *);
extern void echo_really(Widget, struct buffer *);
extern void echo_hide_dialog(Widget, struct buffer *);
extern void echo_query(Widget, struct buffer *);
extern void reverb_really(Widget, struct buffer *);
extern void reverb_hide_dialog(Widget, struct buffer *);
extern void reverb_query(Widget, struct buffer *);
extern void flange_really(Widget, struct buffer *);
extern void flange_hide_dialog(Widget, struct buffer *);
extern void flange_query(Widget, struct buffer *);
extern void filt_hide_dialog(Widget, struct buffer *);
extern void filt_apply(Widget, struct buffer *);
extern void filt_query(Widget, struct buffer *);
extern void comp_really(Widget, struct buffer *);
extern void comp_hide_dialog(Widget, struct buffer *);
extern void comp_query(Widget, struct buffer *);
extern void okprompt_set(Widget, struct buffer *);
extern void about_manage(Widget, struct buffer *);
extern void about_unmanage(Widget, struct buffer *);
extern void license_manage(Widget, struct buffer *);

#endif /* !_CALLBACK_H */
