/*
 * extarr.c
 * kirk johnson
 * july 1993
 *
 * RCS $Id: extarr.c,v 1.1 1993/07/23 03:38:43 tuna Exp $
 *
 * Copyright 1993 by Kirk Lauritz Johnson (see the included file
 * "kljcpyrt.h" for complete copyright information)
 */

#include "xearth.h"
#include "kljcpyrt.h"


ExtArr extarr_alloc(eltsize)
     int eltsize;
{
  ExtArr rslt;

  rslt = (ExtArr) malloc(sizeof(struct extarr));
  assert(rslt != NULL);

  rslt->eltsize = eltsize;
  rslt->limit   = 1;
  rslt->count   = 0;

  rslt->body = (void *) malloc(eltsize*rslt->limit);
  assert(rslt->body != NULL);

  return rslt;
}


void extarr_free(x)
     ExtArr x;
{
  free(x->body);
  free(x);
}


void *extarr_next(x)
     ExtArr x;
{
  int   eltsize;
  int   limit;
  int   count;
  void *body;
  void *rslt;

  eltsize = x->eltsize;
  limit   = x->limit;
  count   = x->count;
  body    = x->body;

  if (count == limit)
  {
    limit *= 2;
    body   = (void *) realloc(body, eltsize*limit);
    assert(body != NULL);

    x->limit = limit;
    x->body  = body;
  }

  rslt = (char *) body + count * eltsize;
  x->count = count + 1;

  return rslt;
}
