 #ifndef lintT static char Xrcsid[] = "$XConsortium: Clock.c,v 1.42 88/09/06 17:39:27 swick Exp $"; #endif lint       < /***********************************************************N Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,H and the Massachusetts Institute of Technology, Cambridge, Massachusetts.   +                         All Rights Reserved    F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.     H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.    C ******************************************************************/    
 #ifdef VMS # include <decw$include/Xos.h> # include <decw$include/Xlib.h> % # include <decw$include/StringDefs.h> % # include <decw$include/IntrinsicP.h>  #else  # include <X11/Xos.h>  # include <X11/Xlib.h> # include <X11/StringDefs.h> # include <X11/IntrinsicP.h> #endif   . #define XtCReverseVideo         "ReverseVideo" #include "ClockP.h"     #ifndef __DECC extern long time();  #endif  M static void clock_tic(), DrawHand(), DrawSecond(), SetSeg(), DrawClockFace();  	  /* Private Definitions */    2 #define VERTICES_IN_HANDS	6	/* to draw triangle */ #define PI			3.14159265358979  #define TWOPI			(2. * PI)     #define SECOND_HAND_FRACT	90 #define MINUTE_HAND_FRACT	70 #define HOUR_HAND_FRACT		40  #define HAND_WIDTH_FRACT	7 #define SECOND_WIDTH_FRACT	5 #define SECOND_HAND_TIME	30     #define ANALOG_SIZE_DEFAULT	164    ) #define max(a, b) ((a) > (b) ? (a) : (b)) ) #define min(a, b) ((a) < (b) ? (a) : (b)) % #define abs(a) ((a) < 0 ? -(a) : (a))         /* Initialization of defaults */   7 #define offset(field) XtOffset(ClockWidget,clock.field) 2 #define goffset(field) XtOffset(Widget,core.field)   ! static XtResource resources[] = { 9     {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension), ! 	goffset(width), XtRString, "0"}, ;     {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension), " 	goffset(height), XtRString, "0"},;     {XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel), 0 	goffset(background_pixel), XtRString, "white"},2     {XtNupdate, XtCInterval, XtRInt, sizeof(int), *         offset(update), XtRString, "60" },;     {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel), -         offset(fgpixel), XtRString, "black"}, 5     {XtNhand, XtCForeground, XtRPixel, sizeof(Pixel), -         offset(Hdpixel), XtRString, "black"}, :     {XtNhighlight, XtCForeground, XtRPixel, sizeof(Pixel),-         offset(Hipixel), XtRString, "black"}, 8     {XtNanalog, XtCBoolean, XtRBoolean, sizeof(Boolean),+         offset(analog), XtRString, "TRUE"}, 7     {XtNchime, XtCBoolean, XtRBoolean, sizeof(Boolean), % 	offset(chime), XtRString, "FALSE" }, 0     {XtNpadding, XtCMargin, XtRInt, sizeof(int),)         offset(padding), XtRString, "8"}, <     {XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),*         offset(font), XtRString, "fixed"},D     {XtNreverseVideo, XtCReverseVideo, XtRBoolean, sizeof (Boolean),- 	offset (reverse_video), XtRString, "FALSE"}, E     {XtNbackingStore, XtCBackingStore, XtRBackingStore, sizeof (int), 3     	offset (backing_store), XtRString, "default"},  };   
 #undef offset  #undef goffset    static void ClassInitialize();F static void Initialize(), Realize(), Destroy(), Resize(), Redisplay(); static Boolean SetValues();     ClockClassRec clockClassRec = {      { /* core fields */ &     /* superclass		*/	&widgetClassRec,     /* class_name		*/	"Clock",(     /* widget_size		*/	sizeof(ClockRec),,     /* class_initialize		*/	ClassInitialize,%     /* class_part_initialize	*/	NULL,      /* class_inited		*/	FALSE,!     /* initialize		*/	Initialize,       /* initialize_hook		*/	NULL,     /* realize			*/	Realize,     /* actions			*/	NULL,      /* num_actions		*/	0,      /* resources		*/	resources, .     /* resource_count		*/	XtNumber(resources),     /* xrm_class		*/	NULL,      /* compress_motion		*/	TRUE,!     /* compress_exposure	*/	TRUE, #     /* compress_enterleave	*/	TRUE, "     /* visible_interest		*/	FALSE,     /* destroy			*/	Destroy,     /* resize			*/	Resize,     /* expose			*/	Redisplay,       /* set_values		*/	SetValues,      /* set_values_hook		*/	NULL,5     /* set_values_almost	*/	XtInheritSetValuesAlmost,       /* get_values_hook		*/	NULL,     /* accept_focus		*/	NULL,      /* version			*/	XtVersion,!     /* callback_private		*/	NULL,      /* tm_table			*/	NULL,:     /* query_geometry           */	XtInheritQueryGeometry,?     /* display_accelerator      */	XtInheritDisplayAccelerator, '     /* extension                */	NULL      }  };   < WidgetClass clockWidgetClass = (WidgetClass) &clockClassRec;   A /****************************************************************   *  * Private Procedures   *B  ****************************************************************/    static void ClassInitialize()  { K     XtAddConverter( XtRString, XtRBackingStore, XmuCvtStringToBackingStore,  		    NULL, 0 ); }     /* ARGSUSED */% static void Initialize (request, new)      Widget request, new; { %     ClockWidget w = (ClockWidget)new;      XtGCMask		valuemask;     XGCValues	myXGCV;      int min_height, min_width;   C     valuemask = GCForeground | GCBackground | GCFont | GCLineWidth;      if (w->clock.font != NULL))         myXGCV.font = w->clock.font->fid;      else;         valuemask &= ~GCFont;	/* use server default font */    1     min_width = min_height = ANALOG_SIZE_DEFAULT;      if(!w->clock.analog) {        char *str; "        struct tm tm, *localtime();        long time_value;          (void) time(&time_value);$        tm = *localtime(&time_value);        str = asctime(&tm);!        if (w->clock.font == NULL) 3           w->clock.font = XQueryFont( XtDisplay(w),  				      XGContextFromGC(* 					   DefaultGCOfScreen(XtScreen(w))) );@        min_width = XTextWidth(w->clock.font, str, strlen(str)) + 	  2 * w->clock.padding;+        min_height = w->clock.font->ascent + 1 	  w->clock.font->descent + 2 * w->clock.padding;      }      if (w->core.width == 0)  	w->core.width = min_width;      if (w->core.height == 0) 	w->core.height = min_height;         /*K      * set the colors if reverse video; this is somewhat tricky since there       * are 5 colors:      *$      *     background - paper		white)      *     foreground - text, ticks	black .      *     border - border		black (foreground)7      *     highlight - edge of hands	black (foreground) 2      *     hands - solid parts		black (foreground)      *K      * This doesn't completely work since the parent has already made up a        * border.  Sigh.       */ !     if (w->clock.reverse_video) {  	Pixel fg = w->clock.fgpixel; % 	Pixel bg = w->core.background_pixel;    3 	if (w->clock.Hdpixel == fg) w->clock.Hdpixel = bg; 3 	if (w->clock.Hipixel == fg) w->clock.Hipixel = bg; ; 	if (w->core.border_pixel == fg) w->core.border_pixel = bg;  	w->clock.fgpixel = bg;  	w->core.background_pixel = fg;      }    )     myXGCV.foreground = w->clock.fgpixel; 1     myXGCV.background = w->core.background_pixel;      if (w->clock.font != NULL))         myXGCV.font = w->clock.font->fid;      else;         valuemask &= ~GCFont;	/* use server default font */      myXGCV.line_width = 0;;     w->clock.myGC = XtGetGC((Widget)w, valuemask, &myXGCV);    ,     valuemask = GCForeground | GCLineWidth ;1     myXGCV.foreground = w->core.background_pixel; >     w->clock.EraseGC = XtGetGC((Widget)w, valuemask, &myXGCV);   )     myXGCV.foreground = w->clock.Hipixel; =     w->clock.HighGC = XtGetGC((Widget)w, valuemask, &myXGCV);         valuemask = GCForeground; )     myXGCV.foreground = w->clock.Hdpixel; =     w->clock.HandGC = XtGetGC((Widget)w, valuemask, &myXGCV);         if (w->clock.update <= 0) @ 	w->clock.update = 60;	/* make invalid update's use a default */F     w->clock.show_second_hand = (w->clock.update <= SECOND_HAND_TIME);     w->clock.numseg = 0;     w->clock.interval_id = 0;  }    * static void Realize (gw, valueMask, attrs)      Widget gw;       XtValueMask *valueMask;!      XSetWindowAttributes *attrs;  { &      ClockWidget	w = (ClockWidget) gw;
 #ifdef notdef        *valueMask |= CWBitGravity;(      attrs->bit_gravity = ForgetGravity; #endif&      switch (w->clock.backing_store) {      case Always:       case NotUseful:      case WhenMapped: "      	*valueMask |=CWBackingStore;/ 	attrs->backing_store = w->clock.backing_store;  	break;       }?      XtCreateWindow( gw, InputOutput, (Visual *)CopyFromParent,  		     *valueMask, attrs);      Resize(gw); }     static void Destroy (gw)      Widget gw;  { &      ClockWidget w = (ClockWidget) gw;F      if (w->clock.interval_id) XtRemoveTimeOut (w->clock.interval_id);!      XtDestroyGC (w->clock.myGC); #      XtDestroyGC (w->clock.HighGC); #      XtDestroyGC (w->clock.HandGC); $      XtDestroyGC (w->clock.EraseGC); }     static void Resize (gw)      Widget gw; { %     ClockWidget w = (ClockWidget) gw; G     /* don't do this computation if window hasn't been realized yet. */ .     if (XtIsRealized(gw) && w->clock.analog) {4 	/* need signed value since Dimension is unsigned */\ 	int radius = ((int) min(w->core.width, w->core.height) - (int) (2 * w->clock.padding)) / 2;6         w->clock.radius = (Dimension) max (radius, 1);   T         w->clock.second_hand_length = ((SECOND_HAND_FRACT * w->clock.radius) / 100);T         w->clock.minute_hand_length = ((MINUTE_HAND_FRACT * w->clock.radius) / 100);P         w->clock.hour_hand_length = ((HOUR_HAND_FRACT * w->clock.radius) / 100);K         w->clock.hand_width = ((HAND_WIDTH_FRACT * w->clock.radius) / 100); T         w->clock.second_hand_width = ((SECOND_WIDTH_FRACT * w->clock.radius) / 100);   -         w->clock.centerX = w->core.width / 2; .         w->clock.centerY = w->core.height / 2;     }  }     /* ARGSUSED */) static void Redisplay (gw, event, region)      Widget gw;      XEvent *event;		/* unused */      Region region;		/* unused */ { %     ClockWidget w = (ClockWidget) gw;      if (w->clock.analog) { 	if (w->clock.numseg != 0)& 	    erase_hands (w, (struct tm *) 0);         DrawClockFace(w);      } else {% 	w->clock.prev_time_string[0] = '\0';      } +     clock_tic((caddr_t)w, (XtIntervalId)0);  }     /* ARGSUSED */& static void clock_tic(client_data, id)         caddr_t client_data;         XtIntervalId *id;  { 5         ClockWidget w = (ClockWidget)client_data;      	struct tm *localtime(); 	struct tm tm;   	long	time_value;  	char	time_string[28]; 	char	*time_ptr = time_string;-         register Display *dpy = XtDisplay(w); *         register Window win = XtWindow(w);   ! 	if (id || !w->clock.interval_id)  	    w->clock.interval_id = > 		XtAddTimeOut( w->clock.update*1000, clock_tic, (caddr_t)w ); 	(void) time(&time_value); 	tm = *localtime(&time_value); 	/* 3 	 * Beep on the half hour; double-beep on the hour.  	 */ 	if (w->clock.chime == TRUE) {0 	    if (w->clock.beeped && (tm.tm_min != 30) && 		(tm.tm_min != 0))  	      w->clock.beeped = FALSE; 1 	    if (((tm.tm_min == 30) || (tm.tm_min == 0))   		&& (!w->clock.beeped)) { 		w->clock.beeped = TRUE;  		XBell(dpy, 50);	 		if (tm.tm_min == 0)  		  XBell(dpy, 50);  	    } 	}! 	if( w->clock.analog == FALSE ) {  	    int	clear_from; 	    int i, len, prev_len;    	    time_ptr = asctime(&tm);  	    len = strlen (time_ptr); ; 	    if (time_ptr[len - 1] == '\n') time_ptr[--len] = '\0'; 3 	    prev_len = strlen (w->clock.prev_time_string); 1 	    for (i = 0; ((i < len) && (i < prev_len) &&  = 	    		 (w->clock.prev_time_string[i] == time_ptr[i])); i++); 6 	    strcpy (w->clock.prev_time_string+i, time_ptr+i);   / 	    XDrawImageString (dpy, win, w->clock.myGC,  			      (2+w->clock.padding +3 			       XTextWidth (w->clock.font, time_ptr, i)), 2 			      2+w->clock.font->ascent+w->clock.padding,  			      time_ptr + i, len - i); 	    /*   	     * Clear any left over bits 	     */; 	    clear_from = XTextWidth (w->clock.font, time_ptr, len)   	    		+ 2 + w->clock.padding; $ 	    if (clear_from < w->core.width)- 		XFillRectangle (dpy, win, w->clock.EraseGC, A 		    clear_from, 0, w->core.width - clear_from, w->core.height); 	 	} else {  			/* 2 			 * The second (or minute) hand is sec (or min) 7 			 * sixtieths around the clock face. The hour hand is 4 			 * (hour + min/60) twelfths of the way around the9 			 * clock-face.  The derivation is left as an excercise  			 * for the reader.  			 */    			/*  			 * 12 hour clock. 			 */ 			if(tm.tm_hour > 12) 				tm.tm_hour -= 12;     			erase_hands (w, &tm);   ! 		    if (w->clock.numseg == 0 || & 			tm.tm_min != w->clock.otm.tm_min ||( 			tm.tm_hour != w->clock.otm.tm_hour) {. 			    w->clock.segbuffptr = w->clock.segbuff; 			    w->clock.numseg = 0; 	 			    /* 6 			     * Calculate the hour hand, fill it in with its7 			     * color and then outline it.  Next, do the same 7 			     * with the minute hand.  This is a cheap hidden  			     * line algorithm. 
 			     */ 			    DrawHand(w,5 				w->clock.minute_hand_length, w->clock.hand_width,  				((double) tm.tm_min)/60.0 	 			    ); 7 			    if(w->clock.Hdpixel != w->core.background_pixel)  				XFillPolygon( dpy, 				    win, w->clock.HandGC, , 				    w->clock.segbuff, VERTICES_IN_HANDS, 				    Convex, CoordModeOrigin  				); 			    XDrawLines( dpy,  				win, w->clock.HighGC, ( 				w->clock.segbuff, VERTICES_IN_HANDS, 				       CoordModeOrigin);+ 			    w->clock.hour = w->clock.segbuffptr;  			    DrawHand(w,  3 				w->clock.hour_hand_length, w->clock.hand_width,  				((((double)tm.tm_hour) +  + 				    (((double)tm.tm_min)/60.0)) / 12.0) 	 			    ); 9 			    if(w->clock.Hdpixel != w->core.background_pixel) {  			      XFillPolygon(dpy, 					   win, w->clock.HandGC,  					   w->clock.hour, 					   VERTICES_IN_HANDS, 					   Convex, CoordModeOrigin 
 					   ); 			    } 			    XDrawLines( dpy,   				       win, w->clock.HighGC,, 				       w->clock.hour, VERTICES_IN_HANDS, 				       CoordModeOrigin );    * 			    w->clock.sec = w->clock.segbuffptr; 		    } . 		    if (w->clock.show_second_hand == TRUE) {* 			    w->clock.segbuffptr = w->clock.sec; 			    DrawSecond(w,% 				w->clock.second_hand_length - 2,   				w->clock.second_hand_width, $ 				w->clock.minute_hand_length + 2, 				((double) tm.tm_sec)/60.0 	 			    ); 7 			    if(w->clock.Hdpixel != w->core.background_pixel)  				XFillPolygon( dpy, 				    win, w->clock.HandGC,  				    w->clock.sec,  				    VERTICES_IN_HANDS -2,  				    Convex, CoordModeOrigin 	 			    );  			    XDrawLines( dpy,   				       win, w->clock.HighGC, 				       w->clock.sec, 				       VERTICES_IN_HANDS-1,  				       CoordModeOrigin 				        );    			} 			w->clock.otm = tm;  		}  }  	  static erase_hands (w, tm) ClockWidget	w; struct tm	*tm; {      /*      * Erase old hands.       */      if(w->clock.numseg > 0) {  	Display	*dpy; 	Window	win;    	dpy = XtDisplay (w);  	win = XtWindow (w);) 	if (w->clock.show_second_hand == TRUE) {  	    XDrawLines(dpy, win,  		w->clock.EraseGC,  		w->clock.sec,  		VERTICES_IN_HANDS-1, 		CoordModeOrigin); 7 	    if(w->clock.Hdpixel != w->core.background_pixel) {  		XFillPolygon(dpy,  			win, w->clock.EraseGC,  			w->clock.sec, 			VERTICES_IN_HANDS-2,  			Convex, CoordModeOrigin 			);  	    } 	}/ 	if(!tm || tm->tm_min != w->clock.otm.tm_min || ( 		  tm->tm_hour != w->clock.otm.tm_hour)  	{  	    XDrawLines( dpy, win, 			w->clock.EraseGC, 			w->clock.segbuff, 			VERTICES_IN_HANDS,e 			CoordModeOrigin); 	    XDrawLines( dpy, win, 			w->clock.EraseGC, 			w->clock.hour,; 			VERTICES_IN_HANDS,  			CoordModeOrigin);7 	    if(w->clock.Hdpixel != w->core.background_pixel) {9 		XFillPolygon( dpy, win,p  			      w->clock.EraseGC,t- 			      w->clock.segbuff, VERTICES_IN_HANDS,g" 			      Convex, CoordModeOrigin); 		XFillPolygon( dpy, win,i  			      w->clock.EraseGC,n 			      w->clock.hour,d 			      VERTICES_IN_HANDS, " 			      Convex, CoordModeOrigin); 	    } 	}     }h }b  r /*  * DrawLine - Draws a line.   *F  * blank_length is the distance from the center which the line begins.,  * length is the maximum length of the hand.L  * Fraction_of_a_circle is a fraction between 0 and 1 (inclusive) indicating8  * how far around the circle (clockwise) from high noon.  *M  * The blank_length feature is because I wanted to draw tick-marks around theNL  * circle (for seconds).  The obvious means of drawing lines from the centerI  * to the perimeter, then erasing all but the outside most pixels doesn't,*  * work because of round-off error (sigh).  */EC static void DrawLine(w, blank_length, length, fraction_of_a_circle)N ClockWidget w; Dimension blank_length;E Dimension length;  double fraction_of_a_circle; {IG 	double dblank_length = (double)blank_length, dlength = (double)length;*" 	double angle, cosangle, sinangle; 	double cos(); 	double sin();B 	int cx = w->clock.centerX, cy = w->clock.centerY, x1, y1, x2, y2;    	/*$# 	 *  A full circle is 2 PI radians.c? 	 *  Angles are measured from 12 o'clock, clockwise increasing.d7 	 *  Since in X, +x is to the right and +y is downward:X 	 *t 	 *	x = x0 + r * sin(theta)n 	 *	y = y0 - r * cos(theta)v 	 *i 	 */& 	angle = TWOPI * fraction_of_a_circle; 	cosangle = cos(angle);e 	sinangle = sin(angle);_  (7 	/* break this out so that stupid compilers can cope */ + 	x1 = cx + (int)(dblank_length * sinangle);E+ 	y1 = cy - (int)(dblank_length * cosangle);f% 	x2 = cx + (int)(dlength * sinangle);P% 	y2 = cy - (int)(dlength * cosangle);_ 	SetSeg(w, x1, y1, x2, y2);_ }C  0 /*  * DrawHand - Draws a hand.d  *,  * length is the maximum length of the hand.'  * width is the half-width of the hand.dL  * Fraction_of_a_circle is a fraction between 0 and 1 (inclusive) indicating8  * how far around the circle (clockwise) from high noon.  *  */ < static void DrawHand(w, length, width, fraction_of_a_circle) ClockWidget w; Dimension length, width; double fraction_of_a_circle; {(  l+ 	register double angle, cosangle, sinangle;R 	register double ws, wc; 	Position x, y, x1, y1, x2, y2;s 	double cos(); 	double sin();  w 	/*,# 	 *  A full circle is 2 PI radians.t? 	 *  Angles are measured from 12 o'clock, clockwise increasing.S7 	 *  Since in X, +x is to the right and +y is downward:, 	 *o 	 *	x = x0 + r * sin(theta)n 	 *	y = y0 - r * cos(theta), 	 *  	 */& 	angle = TWOPI * fraction_of_a_circle; 	cosangle = cos(angle);  	sinangle = sin(angle);X 	/*e* 	 * Order of points when drawing the hand. 	 *  	 *		1,4 	 *		/ \ 	 *	       /   \ 	 *	      /     \a 	 *	    2 ------- 3R 	 */ 	wc = width * cosangle;  	ws = width * sinangle;g
 	SetSeg(w,8 	       x = w->clock.centerX + round(length * sinangle),8 	       y = w->clock.centerY - round(length * cosangle),0 	       x1 = w->clock.centerX - round(ws + wc), @ 	       y1 = w->clock.centerY + round(wc - ws));  /* 1 ---- 2 */ 	/* 2 */ 	SetSeg(w, x1, y1, l0 	       x2 = w->clock.centerX - round(ws - wc), A 	       y2 = w->clock.centerY + round(wc + ws));  /* 2 ----- 3 */i  ,, 	SetSeg(w, x2, y2, x, y);	/* 3 ----- 1(4) */ }t  u /*0  * DrawSecond - Draws the second hand (diamond).  *,  * length is the maximum length of the hand.'  * width is the half-width of the hand.f5  * offset is direct distance from center to tail end.kL  * Fraction_of_a_circle is a fraction between 0 and 1 (inclusive) indicating8  * how far around the circle (clockwise) from high noon.  *  */gF static void DrawSecond(w, length, width, offset, fraction_of_a_circle) ClockWidget w;  Dimension length, width, offset; double fraction_of_a_circle; {C  s+ 	register double angle, cosangle, sinangle;*  	register double ms, mc, ws, wc; 	register int mid; 	Position x, y;k 	double cos(); 	double sin();  l 	/*c# 	 *  A full circle is 2 PI radians.I? 	 *  Angles are measured from 12 o'clock, clockwise increasing.i7 	 *  Since in X, +x is to the right and +y is downward:  	 *i 	 *	x = x0 + r * sin(theta)* 	 *	y = y0 - r * cos(theta)* 	 *o 	 */& 	angle = TWOPI * fraction_of_a_circle; 	cosangle = cos(angle);c 	sinangle = sin(angle);n 	/*	* 	 * Order of points when drawing the hand. 	 *  	 *		1,5 	 *		/ \ 	 *	       /   \ 	 *	      /     \e 	 *	    2<       >4m 	 *	      \     /	 	 *	       \   / 	 *		\ / 	 *	-	 3 	 *	|  	 *	|s 	 *   offset 	 *	|  	 *	|s 	 *	-	 + center  	 */  p 	mid = (length + offset) / 2;t 	mc = mid * cosangle;  	ms = mid * sinangle;	 	wc = width * cosangle;e 	ws = width * sinangle;a 	/*1 ---- 2 */
 	SetSeg(w,8 	       x = w->clock.centerX + round(length * sinangle),8 	       y = w->clock.centerY - round(length * cosangle),* 	       w->clock.centerX + round(ms - wc),, 	       w->clock.centerY - round(mc + ws) );6 	SetSeg(w, w->clock.centerX + round(offset *sinangle),B 	       w->clock.centerY - round(offset * cosangle), /* 2-----3 */+ 	       w->clock.centerX + round(ms + wc), )+ 	       w->clock.centerY - round(mc - ws));* 	w->clock.segbuffptr->x = x; 	w->clock.segbuffptr++->y = y; 	w->clock.numseg ++; }*  *% static void SetSeg(w, x1, y1, x2, y2)* ClockWidget w; int x1, y1, x2, y2;i {z 	w->clock.segbuffptr->x = x1;t 	w->clock.segbuffptr++->y = y1;t 	w->clock.segbuffptr->x = x2;L 	w->clock.segbuffptr++->y = y2;t 	w->clock.numseg += 2; }s  n /*8  *  Draw the clock face (every fifth tick-mark is longer  *  than the others).a  */a static void DrawClockFace(w) ClockWidget w; {g 	register int i;J 	register int delta = (w->clock.radius - w->clock.second_hand_length) / 3; 	(( 	w->clock.segbuffptr = w->clock.segbuff; 	w->clock.numseg = 0;  	for (i = 0; i < 60; i++)sU 		DrawLine(w, (i % 5) == 0 ? w->clock.second_hand_length : (w->clock.radius - delta),I6                    w->clock.radius, ((double) i)/60.); 	/*  	 * Go ahead and draw it.t 	 */) 	XDrawSegments(XtDisplay(w), XtWindow(w),i; 		      w->clock.myGC, (XSegment *) &(w->clock.segbuff[0]),  		      w->clock.numseg/2);i 	w( 	w->clock.segbuffptr = w->clock.segbuff; 	w->clock.numseg = 0;i }a  ) static int round(x)x	 double x;	 { 2 	return(x >= 0.0 ? (int)(x + .5) : (int)(x - .5)); }=  e /* ARGSUSED */3 static Boolean SetValues (gcurrent, grequest, gnew) $     Widget gcurrent, grequest, gnew; { 3       ClockWidget current = (ClockWidget) gcurrent; +       ClockWidget new = (ClockWidget) gnew;o        Boolean redisplay = FALSE;       XtGCMask valuemask;e       XGCValues	myXGCV;    O       /* first check for changes to clock-specific resources.  We'll accept all D          the changes, but may need to do some computations first. */   7       if (new->clock.update != current->clock.update) { " 	  if (current->clock.interval_id)4 	      XtRemoveTimeOut (current->clock.interval_id); 	  if (XtIsRealized(new))sD 	      new->clock.interval_id = XtAddTimeOut(new->clock.update*1000,$ 						    clock_tic, (caddr_t)gnew);I 	  new->clock.show_second_hand = (new->clock.update <= SECOND_HAND_TIME);l       }c  k7       if (new->clock.padding != current->clock.padding)i 	   redisplay = TRUE;f  w5       if (new->clock.analog != current->clock.analog)> 	   redisplay = TRUE;i  w2        if (new->clock.font != current->clock.font) 	   redisplay = TRUE;    8       if ((new->clock.fgpixel != current->clock.fgpixel)N           || (new->core.background_pixel != current->core.background_pixel)) {I           valuemask = GCForeground | GCBackground | GCFont | GCLineWidth;f* 	  myXGCV.foreground = new->clock.fgpixel;2 	  myXGCV.background = new->core.background_pixel;-           myXGCV.font = new->clock.font->fid;, 	  myXGCV.line_width = 0; % 	  XtDestroyGC (current->clock.myGC);d; 	  new->clock.myGC = XtGetGC(gcurrent, valuemask, &myXGCV);  	  redisplay = TRUE;           }w  a9       if (new->clock.Hipixel != current->clock.Hipixel) {p1           valuemask = GCForeground | GCLineWidth;l* 	  myXGCV.foreground = new->clock.fgpixel;-           myXGCV.font = new->clock.font->fid;p 	  myXGCV.line_width = 0; ' 	  XtDestroyGC (current->clock.HighGC); E 	  new->clock.HighGC = XtGetGC((Widget)gcurrent, valuemask, &myXGCV);v 	  redisplay = TRUE;           }   c9       if (new->clock.Hdpixel != current->clock.Hdpixel) {E#           valuemask = GCForeground;c* 	  myXGCV.foreground = new->clock.fgpixel;' 	  XtDestroyGC (current->clock.HandGC);eE 	  new->clock.HandGC = XtGetGC((Widget)gcurrent, valuemask, &myXGCV);  	  redisplay = TRUE;           }d  )I       if (new->core.background_pixel != current->core.background_pixel) {v1           valuemask = GCForeground | GCLineWidth;.2 	  myXGCV.foreground = new->core.background_pixel; 	  myXGCV.line_width = 0;d( 	  XtDestroyGC (current->clock.EraseGC);F 	  new->clock.EraseGC = XtGetGC((Widget)gcurrent, valuemask, &myXGCV); 	  redisplay = TRUE; 	  }      s      return (redisplay);    }a