#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <varargs.h>

/*
 * Function SetArgs
 *
 * SetArgs fills an ArgList (an array of Args) with a given list of values.
 * The list of values is NULL terminated.
 *
 * SetArgs returns the number of arguments that were set.
 *
 * EXAMPLE USAGE:
 *
 * int n;
 * Arg args[10];
 *
 * n = SetArgs (args,
 *		XmNwidth, 10,
 *		XmNheight, 20,
 *		NULL);
 * XtSetValues (w, args, n);
 */

SetArgs(va_alist)
va_dcl
{
  va_list a;

  /* The first argument is the array to fill. */
  register ArgList this_arg;

  /* Others are name and value pairs. */
  String name;
  
  /* How many Args have we set? */
  int count = 0;
  
  va_start(a);
  this_arg = va_arg(a, ArgList);
  
  while ((name = va_arg(a, String)) != NULL)
    {
      XtSetArg(this_arg[count], name, va_arg(a, XtArgVal));    
      ++count;
    }
  
  va_end(a);
  return count;
}


