.TH XBLOCKBUSTER 6 "16 November 1992"
.br
.SH NAME
xblockbuster \- game
.SH SYNOPSIS
.B xblockbuster -playground
.I play_ground
.B -display
.I display
.B -geometry
.I geometry
.B -nopause
.SH DESCRIPTION
XBlockbuster is a variation of the break-out type games, only a bit more
complex in the type of bricks it has and effects the bricks have.  It is
X11 based.
.LP
The object of the game is to collect as many points as possible by
.I busting
through
.I blocks
of various types with a ball that reflects from the blocks and from a pallet
controlled by mouse movement.
.LP
The ball must be seen as a high-energy particle that penetrates the block
before being repelled.
If it gets repelled into another block it will find its own way out again.
This process, which often leads to surprises, is known as
.I tunnelling.
.br
(By design, tunnelling only occurs along a horizontal connection between blocks
or along the vertical sides, so never vertically between blocks.)
.LP
As the game progresses, balls are launched faster and faster.
When the speed has reached it maximum, the pallet is gradually,
though cumulatively, shrunk.
Be aware that the maximum launch speed (see below),
and hence the point from which the pallet is shrunk,
is only 2/3 of the speed limit, and the effect is much larger than that of
hitting a speeder (but of course you may hit them often).
.LP
The pallet is convex.
Hence reflection is a function of both the incoming angle and the excentricity
of the point of impact.
If the pallet is sufficiently convex (differs from stage to stage), the ball
may even rebound.
.LP
The mouse buttons control the pallet:
LEFT moves it up one row, MIDDLE moves it all the way down again.
Each ball is launched with the RIGHT mouse button.
.LP
A stage can be halted by closing the window.
Be advised however, that the game will resume immediately upon opening the
window.
If no-pause has not
been selected (see below), moving the pointer out 
of the XBlockBuster window will also stop the action.
.LP
During a game, the score, number of balls left and speeds are shown.
The speeds are represented by up to 3 thin lines (one for each ball),
above a thick line representing the speed limit.
The short vertical bar indicates the launch speed
(black upon reaching the maximum launch speed, white below that).
If, during a stage, you have busted a 'double' or 'triple' brick, your
bonus multiplier will also be displayed at the top.
.LP
A game can be saved in between stages with the Escape key.
At this point, as well as at the end of the game, your score is logged.
The score board shows scores, number of balls left between parentheses if any
and user name.
Finally, an indication of your current pallet shrinkage is given.
.LP
At any time, 'q' or 'Q' may be pressed to quit the present game.  This quits
the game immediately, so may be useful if your boss is closing in.  Also
useful if you mess up on the first stage, and thus, continuing play of that
game is no longer worth it.
.LP
\'P' or 'p' may be pressed during the game to toggle the no-pause option.
When no-pause is active, the game will continue even when the mouse pointer
is outside the window.  With it turned off, action stops once the mouse
pointer is outside the window.
.SH COMMAND LINE OPTIONS
.TP 8
-playground \fIplayground\fR
This determines the playground to use.  Either the directory containing
the score file, stages, and save directory can be given, or only the
final part after the STAGES name can be given for public play grounds.

By default, the standard playground will be used if this option is
not given.

To see a list of the public play grounds, enter \fIlist\fB as the 
playground name.
.TP
-display \fIdisplay\fR
This is the display to run XBlockBuster on.  If not otherwise specified,
the DISPLAY environmental variable will be used to determine the 
display to use.
.TP
-geometry \fIgeometry\fR
This is the geometry to use for the XBlockBuster window.  Only the
positioning, and not size, information is used.  If size information
is given, it is just ignored.
.TP
-nopause
Determines if no-pause mode is on by default when the game is started up.
When no-pause mode is on, action continues if the mouse pointer is outside
the XBlockBuster window.
.SH NOTES
.LP
In order to avoid infinite loops
(i.e., the ball(s) never reflecting from the pallet),
a ball will, upon hitting too many solid bricks,
undergo a horizontal shift,
proportional to, but opposite to the current horizontal speed.
.LP
The score board imposes a maximum on the number of entries for any given user
name.
If your current score didn't make it onto the score board,
it will be displayed at the bottom.
.LP
If a score entry is detected which obviously must have originated from a saved
game which for some reason "died", a `+' is appended and the entry will hence
forward be treated as any completed game.
.LP
A common problem players encounter is that of losing track of their mouse.
Be advised that mouse movement only alters the horizontal pallet position,
but the mouse of course may move vertically as well.
If your mouse is not neatly perpendicular to the reflection plate, you may
find yourself outside the window, halting play.
For this reason the horizontal crosshair is shown at the window border,
helping you to keep track of the mouse.
.LP
By design, the pointer is invisible while in the XBlockBuster window.
I found that a visible pointer in the window was very distracting
during play.
.SH "CREATION OF PLAY GROUNDS"
A private play ground can be created in any directory.
The stages can be defined from the ascii map codes using any text editor.
They must be numbered consecutively from 0 with the total number
(i.e., one more than the highest number) available in the file nb_stages.
Furthermore a directory 'save' and an empty file 'scores' must be created.
.LP
Individual stages can be tried in the public play ground "try" (q.v. 'try'),
provided you have write access.
.SH "TYPES OF BLOCKS"
.sp
.nf
.na
CODE\h'|7m'NAME\h'|24m'REPRESENTATION
.sp
\&' ' \h'|7m'clear space\h'|24m'white
#\h'|7m'solid wall\h'|24m'black
/,\\\h'|7m'launchpad\h'|24m'black with arrow (like solid wall)
  The balls enters the stage diagonally at the tip of the arrow.
.SS BRICKS
.sp
0\h'|7m'solid brick\h'|24m'75% gray
  Scores 1 on each hit.
.sp
1-9\h'|7m'hit bricks\h'|24m'white with border (and slanted bars)
  Requires as many hits as their are bars (plus 1),
  each scoring equal to how often you have hit it.
  The stage is over when no such bricks remain.
.sp
a-e,j\h'|7m'bonus bricks\h'|24m'50% gray with value inscribed
  Requires value/10+1 hits before scoring.
.SS MAGIC
.sp
A\h'|7m'absorber\h'|24m'25% gray (no border)
^\h'|7m'emitter\h'|24m'black (like solid wall)
  The ball is absorbed and emitted (whilst being reflected).
.sp
C\h'|7m'clipper\h'|24m'pair of scissors between "> <"
  (On 2nd hit) Clips 10% off the pallet.
  By design, the remnants litter the screen!
  [Until the end of the current stage only.]
.sp
D\h'|7m'double\h'|24m'"double"
  (On 2nd hit) Doubles all subsequent hit values.
  [Until the end of the current stage only.]
.sp
E\h'|7m'extra ball\h'|24m'"+O+"
  (On 2nd hit) Adds an extra ball to the stock.
.sp
G\h'|7m'gap\h'|24m'the danger sign (! in a triangle)
  (On 2nd hit) The ball is lost.
  [As if it would have left the stage.]
.sp
H\h'|7m'halt\h'|24m'maze of small squares
  Successively takes 10, 20 and 30% of the speed.
.sp
I\h'|7m'invisible brick\h'|24m'white (like open space)
  Turns into a single hit brick when first hit, scoring 1.
.sp
L\h'|7m'launch ball\h'|24m'"=O="
  (On 2nd hit) Launches an extra ball.
  [Behaves like an 'extra ball' from 3 balls in game.]
.sp
M\h'|7m'mine\h'|24m'"kaboom" in dashed border
  (On 3rd hit) Blows up all adjacent bricks (no score);
  leaving debris 'refractor's.
.sp
P\h'|7m'pause\h'|24m'maze of small squares with launchpad images.
  (On 8th hit) Takes 30% of the excessive launch speed.
.sp
R\h'|7m'refractor\h'|24m'dashed border with crosses
  Interchanges motion along the axes.
.sp
S\h'|7m'speeder\h'|24m'concentric borders
  Adds speed (up to the speed limit; then pallet shrinkage).
.sp
T\h'|7m'triple\h'|24m'"triple"
  (On 3rd hit) Triples all subsequent hit values.
  [Until the end of the current stage only.]
.sp
U\h'|7m'undo\h'|24m'"undo"
  Restores the last block busted (with 0 hit count).
.sp
W\h'|7m'open window\h'|24m'bracketed set of vertical lines
%\h'|7m'closed window\h'|24m'black (like solid wall)
  Alternates between the two states upon each hit.
.sp
X\h'|7m'expander\h'|24m'a pallet image between "< >"
  (On 4th hit) Expands the pallet.
  [Equivalent to twice the full launch speed shrinkage.]
  [Effective in the next stage only.]

.fi
.ad
.SH X Defaults
.LP
The resource name
.I XBlockbuster
can be used to control the color the bricks to be displayed.  Each brick
has both a foreground and background color that can be displayed.  The
format is brick\fIcode\fP_fg or brick\fIcode\fP_bg.
.I code
represents the brick code, as detailed above.  Therefore a line such
as:
.LP
XBlockbuster.brick0_fg:		green

Makes the foreground color of the solid brick green.
.LP
In addition, the resource \fIalternate_bricks\fP
exists.  If selected,  alternate brick patterns will be used on color displays.
The alternate bricks tend to take coloring better than the standard bricks.
If you want to use alternate bricks, add the line:

XBlockbuster.alternate_bricks:  True

to your .Xdefaults file.
.LP
The coloring information and alternate brick request is ignored on
black and white systems.


.SH FILES
.nf
.na
stagemm\h'|30m'[optional] bookkeeping program

The location of the following is installation depedent.
stage.skel\h'|30m'skeleton stage
STAGES.\h'|30m'anonymous public play ground
STAGES.*\h'|30m'named public play grounds
\h'|30m'(including a try out environment)
XBlockbuster.ad\h'|30m'Sample Xdefaults for xblockbuster.
.fi
.ad

.SH BUGS
When two balls hit the same brick simultaneously,
one may leave a shadow on the stage.
.LP
If the ball hits the bottom corners of the playing area, they will at times
reflect back in a reverse direction, instead of reflecting downward and
out of bounds.
.LP
XBlockbuster uses a public colormap for systems which use color.  If it is
unable to get all the colors it wants, it will use black and white for
the bricks it was unable to color.  If using alternate bricks, it can be
difficult to differentiate bricks without the coloring.
.LP
Only a few of the standard command line X arguements are interperted.
Likewise,
only a few of the standard X defaults (in the .Xdefaults file) are used.
