/*
 * File:       smm.c
 * Author:     Eric Van Gestel
 *
 * Aux. For:   blockbuster
 *
 * Implementation:
 *     Calculates a minimum and approximate maximum score for the stage.
 *     If there are both 'D's or 'T's and 'U's, this tends to grow rapidly.
 */

#include "xblockbuster.h"

#ifdef VMS
int
#else
void
#endif
main( argc, argv )
	int             argc;
	char           *argv[];

{
	FILE           *fd;
	char            buf[MAX_COL + 3];
	register int    row, col, tmp;
	int    codes[256];	/* indexed by char */

	for ( tmp = 0; tmp < 256; )
		codes[tmp++] = 0;

	/* open stage file */
	if ( !( fd = fopen( argv[1], "r" ) ) ) {
		perror( "Can't open stage" );
		exit( 1 );
	}
	/* read stage name */
	fscanf( fd, "%s\n", stage_name );
	printf( ">>> %s:", stage_name );

	/* read pallet dimensions */
	fscanf( fd, "%d%d\n", &pallet_lengthI, &pallet_heightI );
	if ( pallet_lengthI < MIN_PALLET_LENGTH ||
	     pallet_lengthI > MAX_PALLET_LENGTH ||
	     pallet_heightI < pallet_lengthI ||
	     pallet_heightI > MAX_PALLET_HEIGHT ) {
		perror( "Inconsistent pallet dimensions" );
		exit( 1 );
	}
	/* read stage map */
	for ( row = 0; row <= MAX_ROW; row++ ) {
		if ( !fgets( buf, MAX_COL + 3, fd ) ) {
			perror( "Can't read stage" );
			exit( 1 );
		}
		for ( col = 0; col <= MAX_COL; col++ )
			codes[buf[col]]++;
	}
	fclose( fd );

	/* minimax approximation */
	score = codes['1']
		+ codes['2'] * 3
		+ codes['3'] * 6
		+ codes['4'] * 10
		+ codes['5'] * 15
		+ codes['6'] * 21
		+ codes['7'] * 28
		+ codes['8'] * 36
		+ codes['9'] * 45;
	printf( " from %d", score );
	score += codes['I'] * 2
		+ codes['a'] * 10
		+ codes['b'] * 20
		+ codes['c'] * 30
		+ codes['d'] * 40
		+ codes['e'] * 50
		+ codes['j'] * 100;
	for ( tmp = codes['D']; tmp; tmp-- )
		score *= 2;
	for ( tmp = codes['T']; tmp; tmp-- )
		score *= 3;
	if ( codes['U'] ) {
		if ( codes['T'] )
			for ( tmp = codes['U']; tmp; tmp-- )
				score *= 3;
		else if ( codes['D'] )
			for ( tmp = codes['U']; tmp; tmp-- )
				score *= 2;
		else if ( codes['j'] )
			score += codes['U'] * 100;
		else if ( codes['e'] )
			score += codes['U'] * 50;
		else if ( codes['9'] )
			score += codes['U'] * 45;
		else if ( codes['d'] )
			score += codes['U'] * 40;
		else if ( codes['8'] )
			score += codes['U'] * 36;
		else if ( codes['c'] )
			score += codes['U'] * 30;
		else if ( codes['7'] )
			score += codes['U'] * 28;
		else if ( codes['6'] )
			score += codes['U'] * 21;
		else if ( codes['b'] )
			score += codes['U'] * 20;
		else if ( codes['5'] )
			score += codes['U'] * 15;
		else if ( codes['4'] )
			score += codes['U'] * 11;
		else if ( codes['a'] )
			score += codes['U'] * 10;
		else if ( codes['3'] )
			score += codes['U'] * 6;
		else if ( codes['2'] )
			score += codes['U'] * 3;
		else if ( codes['I'] )
			score += codes['U'];
		else if ( codes['1'] )
			score += codes['U'];
	}
	printf( " to %d", score );
	if ( codes['0'] )
		printf( " and more" );
	printf( "\n" );

	/* verify stage map */
	if ( codes['/'] + codes['\\'] != 1 )
		printf( "*** no or several launchpads\n" );
	if ( codes['A'] && codes['^'] != 1 )
		printf( "*** no or several emitters\n" );
}
