/*
** lock.h: headerfile for lock.c
**
**  	   LockScoreFile(filename) locks the given file. returns -1 on error.
**         UnlockScoreFile(filename) unlocks the given file.
**
** the lockfilename is built from the given parameter by adding ".lock" at
** the end of it. the callers process id will be written in the file.
** when the file is unlocked again the pid will be read and checked
** before the file is unlinked.
**
** Copyright (C) 1993, Gerald Vogt <vogt@isa.de>
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
*/

#ifdef LOCK_FILE
extern char *CreateLockFileName();
extern int LockScoreFile();
extern void UnlockScoreFile();
#endif
#ifdef LOCK_FCNTL
extern int LockFile();
extern void UnlockFile();
#endif
