/*
 * File:       bricks.c
 * Author:     Eric Van Gestel
 * Updated to X11, alternate brick support and color added by Mark S. Wedel
 *
 * For:                xblockbuster
 */
#include "xblockbuster.h"
static int	has_color=FALSE;


Pixmap 	launchNW_pr,launchNW0_pr,launchNE_pr,launchNE0_pr,
solid_pr,solid0_pr,clear_pr,clear0_pr,
brick_0_pr,brick_1_pr,brick_2_pr,brick_3_pr,brick_4_pr,
brick_5_pr,brick_6_pr,brick_7_pr,brick_8_pr,brick_9_pr,
brick_sa_pr,brick_sb_pr,brick_sc_pr,brick_sd_pr,brick_se_pr,
brick_sj_pr,brick_A_pr,brick_C_pr,brick_D_pr,brick_E_pr,
brick_G_pr,brick_H_pr,brick_L_pr,brick_M_pr,brick_P_pr,
brick_R_pr,brick_S_pr,brick_T_pr,brick_U_pr,brick_W_pr,
brick_X_pr;


/* Include all the brick images */
#include "icons/clear.pr"
#include "icons/solid.pr"
#include "icons/launchNE.pr"
#include "icons/launchNW.pr"
#include "icons/clear0.pr"
#include "icons/solid0.pr"
#include "icons/launchNE0.pr"
#include "icons/launchNW0.pr"
#include "icons/brick_0.pr"
#include "icons/brick_1.pr"
#include "icons/brick_2.pr"
#include "icons/brick_3.pr"
#include "icons/brick_4.pr"
#include "icons/brick_5.pr"
#include "icons/brick_6.pr"
#include "icons/brick_7.pr"
#include "icons/brick_8.pr"
#include "icons/brick_9.pr"
#include "icons/brick_sa.pr"
#include "icons/brick_sb.pr"
#include "icons/brick_sc.pr"
#include "icons/brick_sd.pr"
#include "icons/brick_se.pr"
#include "icons/brick_sj.pr"
#include "icons/brick_A.pr"
#include "icons/brick_C.pr"
#include "icons/brick_D.pr"
#include "icons/brick_E.pr"
#include "icons/brick_G.pr"
#include "icons/brick_H.pr"
#include "icons/brick_L.pr"
#include "icons/brick_M.pr"
#include "icons/brick_P.pr"
#include "icons/brick_R.pr"
#include "icons/brick_S.pr"
#include "icons/brick_T.pr"
#include "icons/brick_U.pr"
#include "icons/brick_W.pr"
#include "icons/brick_X.pr"

/* Alternate bricks for some of the above - meant for color displays  - MSW */
#include "icons/brick_a_alt.pr"
#include "icons/brick_b_alt.pr"
#include "icons/brick_c_alt.pr"
#include "icons/brick_d_alt.pr"
#include "icons/brick_e_alt.pr"
#include "icons/brick_j_alt.pr"
#include "icons/brick_S_alt.pr"
#include "icons/brick_0_alt.pr"

/* Our Cursor */
#include "icons/cursor.pr"


void	do_brick_colors()
{
	Colormap	def_cmap;
	XColor		exact_def;
	Cursor          cursor;
	Pixmap		cursor_pr;
	int	count;
	char		*bricks="0123456789 #/\\abcdejA^CDEGHILMPRSTUW%X";
	char		option[30],*value;

	for (count=0; count<=NUM_BRICK_TYPES; count++) {
		brick_color[count].bg = whitepixel;
		brick_color[count].fg = blackpixel;
	}


	def_cmap = DefaultColormap(display, screen_num);


	/* This cursor code should really be in xblockbuster.c, but
	since we are dealing with colormaps here, it is easier to place
	the cursor code here.  I re-color the cursor so that it does
	not show up on the screen. */

	cursor_pr = XCreateBitmapFromData(display,win,cursor_bits, 
		cursor_width, cursor_height);
	exact_def.pixel = whitepixel;
	XQueryColor(display, def_cmap, &exact_def);
	cursor = XCreatePixmapCursor(display, cursor_pr, cursor_pr,
		&exact_def, &exact_def, 0, 0);
	XDefineCursor(display, win,cursor);

	/* Figure we need at least a 5 bit display (32 colors) in order
	to support color bricks.  Probably not many 5, 6, or 7 bit displays
	out there, but you never know -MSW */

	if (DefaultDepth(display,screen_num)<5) return;
	else has_color=TRUE;


	count=0;
	while (bricks[count]!='\0') {
		sprintf(option,"brick%c_fg",bricks[count]);
		value = XGetDefault(display, "XBlockbuster", option);
		if (value) {
		    if (!XParseColor(display, def_cmap, value, &exact_def)) {
 		       printf("Couldn't find color %s for option %s\n",value,option);
		    }
		    else 
			if (!XAllocColor(display, def_cmap, &exact_def))
				printf("couldn't allocate color %s in option %s\n",value,option);
			else
				brick_color[count].fg=exact_def.pixel;
		}

		sprintf(option,"brick%c_bg",bricks[count]);
		value = XGetDefault(display, "XBlockbuster", option);
		if (value) {
		    if (!XParseColor(display, def_cmap, value, &exact_def)) {
		    printf("Couldn't find color %s for option %s\n",value,option);
		    }
		    else 
			if (!XAllocColor(display, def_cmap, &exact_def))
				printf("couldn't allocate color %s in option %s\n",value,option);
			else
				brick_color[count].bg=exact_def.pixel;
		}
		count++;
	}
}


void bricks_init()
{

	char	*value;
	int	use_alt_bricks=FALSE;

	do_brick_colors();


/* The width and height of these should really be keyed in from the defintions
in the files themselves.  However, that would take a considerable amount of
typing effort that I don't feel like doing.  The width and height values are
hardcoded into other areas of the program anyways.  I must admit that it
would be interesting to have different brick sizes, but in order to do that,
it would also entail changing how the stages are stored  - MSW */

	launchNW_pr = XCreateBitmapFromData(display,win,launchNW_bits, 64,16);
	launchNW0_pr = XCreateBitmapFromData(display,win,launchNW0_bits, 16,16);
	launchNE_pr = XCreateBitmapFromData(display,win,launchNE_bits, 64,16);
	launchNE0_pr = XCreateBitmapFromData(display,win,launchNE0_bits, 16,16);
	solid_pr =   XCreateBitmapFromData(display,win,solid_bits, 64,16);
	solid0_pr =  XCreateBitmapFromData(display,win,	solid0_bits, 16,16);
	clear_pr =   XCreateBitmapFromData(display,win,	clear_bits, 64,16);
	clear0_pr =  XCreateBitmapFromData(display,win,	clear0_bits, 16,16);
	brick_1_pr = XCreateBitmapFromData(display,win,	brick_1_bits, 64,16);
	brick_2_pr = XCreateBitmapFromData(display,win,	brick_2_bits, 64,16);
	brick_3_pr = XCreateBitmapFromData(display,win,	brick_3_bits, 64,16);
	brick_4_pr = XCreateBitmapFromData(display,win,	brick_4_bits, 64,16);
	brick_5_pr = XCreateBitmapFromData(display,win,	brick_5_bits, 64,16);
	brick_6_pr = XCreateBitmapFromData(display,win,	brick_6_bits, 64,16);
	brick_7_pr = XCreateBitmapFromData(display,win,	brick_7_bits, 64,16);
	brick_8_pr = XCreateBitmapFromData(display,win,	brick_8_bits, 64,16);
	brick_9_pr = XCreateBitmapFromData(display,win,	brick_9_bits, 64,16);
	brick_A_pr = XCreateBitmapFromData(display,win,	brick_A_bits, 64,16);
	brick_C_pr = XCreateBitmapFromData(display,win,	brick_C_bits, 64,16);
	brick_D_pr = XCreateBitmapFromData(display,win,	brick_D_bits, 64,16);
	brick_E_pr = XCreateBitmapFromData(display,win,	brick_E_bits, 64,16);
	brick_G_pr = XCreateBitmapFromData(display,win,	brick_G_bits, 64,16);
	brick_H_pr = XCreateBitmapFromData(display,win,	brick_H_bits, 64,16);
	brick_L_pr = XCreateBitmapFromData(display,win,	brick_L_bits, 64,16);
	brick_M_pr = XCreateBitmapFromData(display,win,	brick_M_bits, 64,16);
	brick_P_pr = XCreateBitmapFromData(display,win,	brick_P_bits, 64,16);
	brick_R_pr = XCreateBitmapFromData(display,win,	brick_R_bits, 64,16);
	brick_T_pr = XCreateBitmapFromData(display,win,	brick_T_bits, 64,16);
	brick_U_pr = XCreateBitmapFromData(display,win,	brick_U_bits, 64,16);
	brick_W_pr = XCreateBitmapFromData(display,win,	brick_W_bits, 64,16);
	brick_X_pr = XCreateBitmapFromData(display,win,	brick_X_bits, 64,16);


	/* Since everywhere else in the program uses the bitmap structures,
	the use_alt_bricks only needs to be local to determine which
	way to initialize the bitmap structures */

	/* See if we should use the alternate bricks */
	value = XGetDefault(display, "XBlockbuster", "alternate_bricks");
	if (value) {
		if (strcasecmp(value,"true")==0) {
			use_alt_bricks=TRUE;
		}
	}
	/* only use the alternate bricks on a color system */
	if (use_alt_bricks && has_color) {
		brick_0_pr = XCreateBitmapFromData(display,win,brick_0_alt_bits, 64,16);
		brick_sa_pr = XCreateBitmapFromData(display,win,brick_a_alt_bits, 64,16);
		brick_sb_pr = XCreateBitmapFromData(display,win,brick_b_alt_bits, 64,16);
		brick_sc_pr = XCreateBitmapFromData(display,win,brick_c_alt_bits, 64,16);
		brick_sd_pr = XCreateBitmapFromData(display,win,brick_d_alt_bits, 64,16);
		brick_se_pr = XCreateBitmapFromData(display,win,brick_e_alt_bits, 64,16);
		brick_sj_pr = XCreateBitmapFromData(display,win,brick_j_alt_bits, 64,16);
		brick_S_pr = XCreateBitmapFromData(display,win,	brick_S_alt_bits, 64,16);
	}
	else {
		brick_0_pr = XCreateBitmapFromData(display,win,brick_0_bits, 64,16);
		brick_sa_pr = XCreateBitmapFromData(display,win,brick_sa_bits, 64,16);
		brick_sb_pr = XCreateBitmapFromData(display,win,brick_sb_bits, 64,16);
		brick_sc_pr = XCreateBitmapFromData(display,win,brick_sc_bits, 64,16);
		brick_sd_pr = XCreateBitmapFromData(display,win,brick_sd_bits, 64,16);
		brick_se_pr = XCreateBitmapFromData(display,win,brick_se_bits, 64,16);
		brick_sj_pr = XCreateBitmapFromData(display,win,brick_sj_bits, 64,16);
		brick_S_pr = XCreateBitmapFromData(display,win,	brick_S_bits, 64,16);
	}
}




/*** address functions ***/

Pixmap        brick_addr( row, col )
	int             row, col;	/* col > 0 && col < MAX_COL */
{
	int             tmp = stage[row][col].nhits;

	switch ( stage[row][col].code ) {
	case ' ':return ( clear_pr );
	case '#':return ( solid_pr );
	case '/':return ( launchNE_pr );
	case '\\':return ( launchNW_pr );

	case '9':if ( !tmp-- )	return ( brick_9_pr );
	case '8':if ( !tmp-- )	return ( brick_8_pr );
	case '7':if ( !tmp-- )	return ( brick_7_pr );
	case '6':if ( !tmp-- )	return ( brick_6_pr );
	case '5':if ( !tmp-- )	return ( brick_5_pr );
	case '4':if ( !tmp-- )	return ( brick_4_pr );
	case '3':if ( !tmp-- )	return ( brick_3_pr );
	case '2':if ( !tmp-- )	return ( brick_2_pr );
	case '1':return ( brick_1_pr );
	case '0':return ( brick_0_pr );
	case 'a':return ( brick_sa_pr );
	case 'b':return ( brick_sb_pr );
	case 'c':return ( brick_sc_pr );
	case 'd':return ( brick_sd_pr );
	case 'e':return ( brick_se_pr );
	case 'j':return ( brick_sj_pr );
	case 'A':return ( brick_A_pr );
	case '^':return ( solid_pr );
	case 'C':return ( brick_C_pr );
	case 'D':return ( brick_D_pr );
	case 'E':return ( brick_E_pr );
	case 'G':return ( brick_G_pr );
	case 'H':return ( brick_H_pr );
	case 'I':return ( clear_pr );
	case 'L':return ( brick_L_pr );
	case 'M':return ( brick_M_pr );
	case 'P':return ( brick_P_pr );
	case 'R':return ( brick_R_pr );
	case 'S':return ( brick_S_pr );
	case 'T':return ( brick_T_pr );
	case 'U':return ( brick_U_pr );
	case 'W':return ( brick_W_pr );
	case '%':return ( solid_pr );
	case 'X':return ( brick_X_pr );

	default:
		fprintf(stderr, "Illegal map code, stage %s\n",stage_name );
		exit( 1 );
	}
}

Pixmap        brick_addr0( row, col )
	int             row, col;	/* col == 0 || col == MAX_COL */
{
	switch ( stage[row][col].code ) {
	case ' ':return ( clear0_pr );
	case '#':return ( solid0_pr );
	case '/':return ( launchNE0_pr );
	case '\\':return ( launchNW0_pr );

	default:
		fprintf(stderr, "Illegal map code, stage %s\n",stage_name );
		exit( 1 );
	};
}



int        brick_value( row,col )
int             row, col;	/* col > 0 && col < MAX_COL */
{

	switch ( stage[row][col].code ) {

	case '0':return(0);
	case '1':return(1);
	case '2':return(2-stage[row][col].nhits);
	case '3':return(3-stage[row][col].nhits);
	case '4':return(4-stage[row][col].nhits);
	case '5':return(5-stage[row][col].nhits);
	case '6':return(6-stage[row][col].nhits);
	case '7':return(7-stage[row][col].nhits);
	case '8':return(8-stage[row][col].nhits);
	case '9':return(9-stage[row][col].nhits);
	case ' ':return(10);
	case '#':return(11);
	case '/':return(12);
	case '\\':return(13);
	case 'a':return(14); 
	case 'b':return(15);
	case 'c':return(16);
	case 'd':return(17);
	case 'e':return(18);
	case 'j':return(19);
	case 'A':return(20);
	case '^':return(21);
	case 'C':return(22);
	case 'D':return(23);
	case 'E':return(24);
	case 'G':return(25);
	case 'H':return(26);
	case 'I':return(27);
	case 'L':return(28);
	case 'M':return(29);
	case 'P':return(30);
	case 'R':return(31);
	case 'S':return(32);
	case 'T':return(33);
	case 'U':return(34);
	case 'W':return(35);
	case '%':return(36);
	case 'X':return(37);

	default:
		fprintf(stderr, "Illegal map code, stage %s\n",stage_name );
		exit( 1 );
	}
}




void draw_brick( row, col ) 
int row, col;
{
	if (has_color) {
		XSetForeground(display, gc_color, brick_color[brick_value(row,col)].fg); 
		XSetBackground(display, gc_color, brick_color[brick_value(row,col)].bg);
	}
	XCopyPlane(display, brick_addr(row,col), win, gc_color, 0, 0, 
		64, 16, COL_X(col), ROW_Y(row), 1);

}

void draw_brick0( row, col )
int row, col;
{
	XCopyPlane(display, brick_addr0(row,col), win, gc, 0, 0,
		16, 16, COL_X(col), ROW_Y(row), 1);
}
