/*
 * dialog.c
 * Copyright (C) 1995  Johannes Plass
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes-Gutenberg University, Mainz, Germany
 * Internet: plass@dipmza.physik.uni-mainz.de
*/

/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/

#include "config.h"

#include <stdio.h>

/*
#define MESSAGE_NO_ESC
*/
#include "message.h"

#ifdef VMS
#   include <X11_DIRECTORY/IntrinsicP.h>
#   include <X11_DIRECTORY/StringDefs.h>
#   include <XAW_DIRECTORY/Box.h>
#   include <XAW_DIRECTORY/Command.h>
#   if defined(USE_XAW3D) && defined(USE_FORM3D)
#      ifdef _FORM3D_LOCAL_
#         include "Form3d.h"
#      else
#         include <XAW_DIRECTORY/Form3d.h>
#      endif
#   else
#      include <XAW_DIRECTORY/Form.h>
#   endif   
#   include <XAW_DIRECTORY/Label.h>
#   include <XAW_DIRECTORY/AsciiText.h>
#   include <X11_DIRECTORY/Shell.h>
#   ifdef _LAYOUT_LOCAL_
#      include "Layout.h"
#   else
#      include <XAW_DIRECTORY/Layout.h>
#   endif
#else
#   include <X11/IntrinsicP.h>
#   include <X11/StringDefs.h>
#   include <X11/Xaw/Box.h>
#   include <X11/Xaw/Command.h>
#   if defined(USE_XAW3D) && defined(USE_FORM3D)
#      ifdef _FORM3D_LOCAL_
#         include "Form3d.h"
#      else
#         include <X11/Xaw/Form3d.h>
#      endif
#   else
#      include <X11/Xaw/Form.h>
#   endif   
#   include <X11/Xaw/Label.h>
#   include <X11/Xaw/AsciiText.h>
#   include <X11/Shell.h>
#endif

#include "popup.h"

#ifndef max
#   define max(a, b)    ((a) > (b) ? (a) : (b))
#endif

/*### Application dependencies ##############################################*/

#define DIALOG_TOPLEVEL		toplevel
#define DIALOG_POPUP_NAME	"dialogPopup"
#define DIALOG_POPUP		dialogpopup

#include "gv.h"
#include "note.h"
#include "dialog.h"
#include "texttr.h"

static Bool dialogPopupCreated = False;
static Bool dialogPopupVisible = False;

/*###############################################################################
   getText
   get the current contents of a text field
###############################################################################*/

static char *getText(w)
   Widget       w;
{
   Arg          args[2];
   Cardinal     n;
   String       value;

   BEGINMESSAGE(getText)
   n = 0;
   XtSetArg(args[n], XtNstring, &value);  n++;
   XtGetValues(w, args, n);
   ENDMESSAGE(getText)
   return value;
}   

/*###############################################################################
   setText
   set the contents of a text field to a string
###############################################################################*/

static void setText(w, value)
   Widget       w;
   String       value;
{
   Arg          args[2];
   Cardinal     n;

   BEGINMESSAGE(setText)
   n = 0;
   XtSetArg(args[n], XtNstring, value);  n++;
   XtSetValues(w, args, n);
   ENDMESSAGE(setText)
}

/*###############################################################################
   createTextFieldL
   create a labelled single-line text field widget pair
###############################################################################*/

static Widget createTextFieldL(name, parent)
   char         *name;
   Widget       parent;
{
   char         tempName[50];
   char         tempName3d[50];
   Widget       theForm, theText3d, theText, theLabel; 
   Arg          args[20];
   Cardinal     n;
   Dimension    w, h;

   INFMESSAGE(executing createTextFieldL)   
          sprintf(tempName,"%sLabel",name);
          n = 0;
   theLabel = XtCreateManagedWidget(tempName, labelWidgetClass,parent, args, n);

          sprintf(tempName,"%sText3d",name);
          n=0;
#   if defined(USE_XAW3D) && defined(USE_FORM3D)
       theText3d = XtCreateManagedWidget(tempName, form3dWidgetClass,parent, args, n);
#   else
       theText3d = XtCreateManagedWidget(tempName, formWidgetClass,parent, args, n);
#   endif
          sprintf(tempName,"%sText",name);
          								n=0;
          XtSetArg(args[n], XtNfromVert, NULL);				n++;
          XtSetArg(args[n], XtNfromHoriz, NULL);			n++;
          XtSetArg(args[n], XtNtop,    XtChainTop);			n++;
          XtSetArg(args[n], XtNbottom, XtChainBottom);			n++;
          XtSetArg(args[n], XtNleft,   XtChainLeft);			n++;
          XtSetArg(args[n], XtNright,  XtChainRight);			n++;
          XtSetArg(args[n], XtNtype, XawAsciiString);			n++;
          XtSetArg(args[n], XtNuseStringInPlace, False);		n++;
          XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever);	n++;
          XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever);	n++;
          XtSetArg(args[n], XtNdisplayCaret, False);			n++;
          XtSetArg(args[n], XtNeditType, XawtextEdit);			n++;
          XtSetArg(args[n], XtNresize, XawtextResizeWidth);		n++;
          XtSetArg(args[n], XtNresizable, True);			n++;
   theText = XtCreateManagedWidget(tempName, asciiTextWidgetClass,theText3d, args, n);
          XtOverrideTranslations(theText,XtParseTranslationTable(OneLineTextTr));

   return theText;
}

/*###############################################################################
   cb_popdownDialogPopup
###############################################################################*/

void cb_popdownDialogPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;  
{
   BEGINMESSAGE(cb_popdownDialogPopup)
   if (dialogPopupVisible) {
      cb_popdownNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
      XtPopdown(DIALOG_POPUP);
      dialogPopupVisible=False;
   }
   ENDMESSAGE(cb_popdownDialogPopup)
}

/*###############################################################################
   cb_popupDialogPopup
###############################################################################*/

void cb_popupDialogPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;  
{
   BEGINMESSAGE(cb_popupDialogPopup)
   if (!dialogPopupVisible) {
      if (!dialogPopupCreated) makeDialogPopup();
      positionPopup(DIALOG_POPUP,1,NULL,0,0, 1,1);
      XtPopup(DIALOG_POPUP,XtGrabNone);
      dialogPopupVisible=True;
   }
   ENDMESSAGE(cb_popupDialogPopup)
}

/*###############################################################################
   action_handleDialogPopup
###############################################################################*/

void 
action_handleDialogPopup(top, event, params, num_params)
    Widget top;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    BEGINMESSAGE(action_handleDialogPopup)
    if (!params) {
       INFMESSAGE(no parameters)
       ENDMESSAGE(action_handleDialogPopup)
       return;
    }
    if (!(strcmp(params[0],"popup"))) {
       cb_popupDialogPopup((Widget)NULL,(XtPointer)NULL,NULL);
    } else
    if (!(strcmp(params[0],"popdown"))) {
       cb_popdownDialogPopup((Widget)NULL,(XtPointer)NULL,NULL);
    }
    ENDMESSAGE(action_handleDialogPopup)
}

/*###############################################################################
   makeDialogPopup
###############################################################################*/

void makeDialogPopup()
{
   Arg          args[10];
   Cardinal     n;
   Dimension	minw,minh;
   Widget   dialogLayout;
   Widget   doneButton, cancelButton;
   Widget   dialogText;
   Widget   messageLabel;   

   BEGINMESSAGE(makeDialogPopup)

					n=0;
        XtSetArg(args[n], XtNallowShellResize, True);  n++;
   DIALOG_POPUP = XtCreatePopupShell(DIALOG_POPUP_NAME,transientShellWidgetClass,DIALOG_TOPLEVEL, args, n);

					n=0;
        XtSetArg(args[n], XtNresizeWidth, True);	n++;
        XtSetArg(args[n], XtNresizeHeight, True);	n++;
        XtSetArg(args[n], XtNconditionedResize, False);	n++;
        XtSetArg(args[n], XtNmaximumWidth, 0);	 	n++;
        XtSetArg(args[n], XtNmaximumHeight,0);	 	n++;
   dialogLayout = XtCreateManagedWidget("dialogLayout",layoutWidgetClass,DIALOG_POPUP,args,n);
 
        				n=0;
   messageLabel = XtCreateManagedWidget("message", labelWidgetClass,dialogLayout, args, n);

        				n=0;
   doneButton = XtCreateManagedWidget("done",commandWidgetClass,dialogLayout,args,n);
   cancelButton = XtCreateManagedWidget("cancel",commandWidgetClass,dialogLayout,args,n);
 
   dialogText = createTextFieldL("dialog_text", dialogLayout);

   XtRealizeWidget(DIALOG_POPUP);

   LayoutWidgetGetNaturalSize((LayoutWidget)dialogLayout,&minw,&minh);
   IMESSAGE(minw) IMESSAGE(minh)

                                          n=0;
   XtSetArg(args[n], XtNminWidth, minw);  ++n;
   XtSetArg(args[n], XtNminHeight, minh); ++n;
   XtSetArg(args[n], XtNmaxWidth, XtUnspecifiedShellInt);  ++n;
   XtSetArg(args[n], XtNmaxHeight, minh); ++n;
   XtSetValues(DIALOG_POPUP, args, n);

   XSetWMProtocols(XtDisplay(DIALOG_POPUP),XtWindow(DIALOG_POPUP),&wm_delete_window,1);
   dialogPopupCreated=True;
                              
   ENDMESSAGE(makeDialogPopup)
}

/*###############################################################################
    DialogPopupSetButton
###############################################################################*/

void DialogPopupSetButton(button,label,callback)
 int button;
 String label;
 XtCallbackProc callback;
 {
    Arg args[5];
    Cardinal n;
    Widget response=NULL;

    BEGINMESSAGE(DialogPopupSetButton)
    if (!dialogPopupCreated) makeDialogPopup();
    if       (button&DIALOG_BUTTON_DONE)   response = XtNameToWidget(DIALOG_POPUP, "*done");
    else if  (button&DIALOG_BUTTON_CANCEL) response = XtNameToWidget(DIALOG_POPUP, "*cancel");

    if (response) {
       if (label) {
          n=0;
          XtSetArg(args[n], XtNlabel, label);  n++;
          XtSetValues(response, args, n);
       }
       if (callback) {
          XtRemoveAllCallbacks(response,XtNcallback);
          XtAddCallback(response, XtNcallback,callback,NULL);
       }
    }
    ENDMESSAGE(DialogPopupSetButton)
}

/*###############################################################################
    DialogPopupClearText
###############################################################################*/

void DialogPopupClearText()
 {
    Arg args[5];
    Cardinal n;
    Widget response;

    BEGINMESSAGE(DialogPopupClearText)
    if (!dialogPopupCreated) makeDialogPopup();
    response = XtNameToWidget(DIALOG_POPUP, "*dialog_textText");
    n=0;
    XtSetArg(args[n], XtNstring, "");  n++;
    XtSetValues(response, args, n);
    ENDMESSAGE(DialogPopupClearText)
}

/*###############################################################################
    DialogPopupSetText
###############################################################################*/

void DialogPopupSetText(s)
    String s;
{
    Arg args[10];
    Cardinal n;
    Widget response;
    Dimension width;
#   define DIALOG_POPUP_FREE_SPACE 50
#   define DIALOG_POPUP_TEXT_MIN_WIDTH 100
    String os;
    Dimension lm,rm,bw,nw;
    XFontStruct *font;

    BEGINMESSAGE(DialogPopupSetText)
    if (!s) {INFMESSAGE(no text) ENDMESSAGE(DialogPopupSetText) return;}
    if (!dialogPopupCreated) makeDialogPopup();
    response = XtNameToWidget(DIALOG_POPUP, "*dialog_textText");

    						n=0;
    XtSetArg(args[n], XtNfont, &font);		n++;
    XtSetArg(args[n], XtNleftMargin, &lm);	n++;
    XtSetArg(args[n], XtNrightMargin, &rm);	n++;
    XtSetArg(args[n], XtNborderWidth, &bw);	n++;
    XtSetArg(args[n], XtNstring, &os);		n++;
    XtSetArg(args[n], XtNwidth, &width);	n++;
    XtGetValues(response, args, n);
    if (!os) os="";
    if (strcmp(os,s)) {
    						n=0;
       nw= ((font->max_bounds.width+font->min_bounds.width)*((Dimension)strlen(s))+1)/2
	   +lm+rm+DIALOG_POPUP_FREE_SPACE+2*bw;
       if (nw<DIALOG_POPUP_TEXT_MIN_WIDTH) nw=DIALOG_POPUP_TEXT_MIN_WIDTH;
       if (nw>width) {
	  INFIMESSAGE(new width,nw)
	  XtSetArg(args[n], XtNwidth,nw);	n++;
       }
       XtSetArg(args[n], XtNstring, s);		n++;
       XtSetValues(response, args, n);
 
    }
    ENDMESSAGE(DialogPopupSetText)
}

/*###############################################################################
    DialogPopupGetText
###############################################################################*/
 
String DialogPopupGetText()
{
    Arg args[5];
    Cardinal n;
    Widget response;
    String s;
    static char string[256];
    int l;

    BEGINMESSAGE(DialogPopupGetText)
    if (!dialogPopupCreated) makeDialogPopup();
    response = XtNameToWidget(DIALOG_POPUP, "*dialog_textText");
    n=0;
    XtSetArg(args[n], XtNstring, &s);   n++;
    XtGetValues(response, args, n);
    l= strlen(s);
    if (l<255) strcpy(string,s);
    else { strncpy(string,s,255); string[255]='\0'; }
    ENDMESSAGE(DialogPopupGetText)
    return string;
}

/*###############################################################################
    DialogPopupSetPrompt
###############################################################################*/

void DialogPopupSetPrompt(newprompt)
    String newprompt;
{
    Arg args[5];
    Cardinal n;
    Widget label;

    BEGINMESSAGE(DialogPopupSetPrompt)
    if (!dialogPopupCreated) makeDialogPopup();
    label = XtNameToWidget(DIALOG_POPUP, "*dialog_textLabel");
    n=0;
    XtSetArg(args[n], XtNlabel, newprompt); n++;
    XtSetValues(label, args, n);
    ENDMESSAGE(DialogPopupSetPrompt)
}

/*###############################################################################
    DialogPopupSetMessage
###############################################################################*/

void DialogPopupSetMessage(message)
    String message;
{
    Arg args[5];
    Cardinal n;
    Widget label;

    BEGINMESSAGE(DialogPopupSetMessage)
    if (!dialogPopupCreated) makeDialogPopup();
    label = XtNameToWidget(DIALOG_POPUP, "*message");
    n=0;
    XtSetArg(args[n], XtNlabel, message); n++;
    XtSetValues(label, args, n);
    ENDMESSAGE(DialogPopupSetMessage)
}
