L /***************************************************************************  *  * xautolock  * =========  *!  * Authors   :  S. De Troch (SDT) !  *              M. Eyckmans (MCE)   *  * Date      :  22/07/90  *  * Comments  :  *"  * Review    :  - 12/02/92 (MCE) :7  *                . Hacked around a dxcalendar problem. "  *              - 21/02/92 (MCE) :"  *                . Major rewrite."  *              - 24/02/92 (MCE) :2  *                . Removed an initialization bug."  *              - 25/02/92 (MCE) :>  *                . Added code to detect multiple invocations."  *              - 06/03/92 (MCE) :I  *                . Re-arranged the event loop in order to detect defunct 1  *                  children as soon as possible. (  *              - 10/03/92 (SDT & MCE) :C  *                . Added code to detect broken server connections. "  *              - 24/03/92 (MCE) :F  *                . Don't reset the time-out counter after receiving a<  *                  synthetic or otherwise unexpected event."  *              - 15/04/92 (MCE) :D  *                . Changed the default locker to "xlock 2>&- 1>&-".A  *                . Fixed a couple of event mask bugs. (Thanks to :  *                  jwz@lucid.com for running into these.)H  *                . Corrected a property type bug in CheckConnection ()."  *              - 20/04/92 (MCE) :;  *                . Cut Main () into more managable pieces. 7  *                . Periodically call XQueryPointer (). "  *              - 25/04/92 (MCE) :>  *                . Added the `corners' feature. (Suggested by(  *                  weisen@alw.nih.gov.)H  *                . Fixed a problem with pseudo-root windows. (Thanks toB  *                  sherman@unx.sas.com, nedwards@titan.trl.OZ.AU,H  *                  dave@elxr.jpl.Nasa.Gov and tmcconne@sedona.intel.comH  *                  for pointing out the problem and testing the patch.)C  *                . Added `disable/enable on SIGHUP'. (Suggested by '  *                  paul_smith@dg.com.) ;  *                . Added support for multiheaded displays. "  *              - 28/04/92 (MCE) :/  *                . Use the X resource manager. "  *              - 06/05/92 (MCE) :G  *                . Fixed a few potential portability problems. (Thanks 0  *                  to paul_smith@dg.com again.)H  *                . CheckConnection () now works properly on multiheadedF  *                  displays. (Thanks to brian@natinst.com for testing/  *                  the `multiheaded' feature.) .  *                . Better version of Sleep().@  *                . Recognize X resources for class "Xautolock".7  *                . Don't update timer while sighupped. 6  *                . Switched to vfork () and execl ().)  *                . New copyright notice. "  *              - 11/05/92 (MCE) :J  *                . Close stdout and stderr in stead of using "2>&- 1>&-".9  *                  (Suggested by sinkwitz@ifi.unizh.ch.) 3  *                . Added "-noclose" for debugging.   *L  * -------------------------------------------------------------------------  *B  * Please send bug reports to detroch@imec.be or eyckmans@imec.be.  *L  * -------------------------------------------------------------------------  */  * Copyright 1990, 1992 by S. De Troch and MCE.   *G  * Permission to use, copy, modify and distribute this software and the J  * supporting documentation without fee is hereby granted, provided that :  *B  *  1 : Both the above copyright notice and this permission noticeD  *      appear in all copies of both the software and the supporting  *      documentation.*  *  2 : You don't make a profit out of it.  *D  * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,I  * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO H  * EVENT SHALL THEY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIALE  * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA D  * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHERC  * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    * PERFORMANCE OF THIS SOFTWARE.  *M  ***************************************************************************/        /*"  *  Have a guess what this does..."  *  ==============================  *F  *  Warning for swm & tvtwm users : xautolock should *not* be compiled@  *  with vroot.h, because it needs to know the real root window.  */  #include <stdio.h> #include <X11/Xlib.h>  #include <X11/Xatom.h> #include <X11/Xresource.h> #ifdef VAXC  #include <string.h>  #include "wait.h"  #define pid_t long #else  #include <X11/strings.h> #include <X11/wait.h>  #include <X11/memory.h>  #endif #include <types.h> #include <signal.h>  #include <math.h>    #ifdef AIXV3 #include <sys/m_wait.h>  #endif /* AIXV3 */  , #if !defined (news1800) && !defined (sun386)   #include <stdlib.h>    #ifndef VMS  #ifndef apollo #include <X11/malloc.h>  #include <X11/unistd.h>  #endif /* apollo */  #endif  ! #endif /* !news1800 && !sun386 */    #include "patchlevel.h"          /**  *  Usefull macros and customization stuff*  *  ======================================  */  #ifdef HasPrototypes$ #define PP(x)                      x #else /* HasPrototypes */ % #define PP(x)                      ()  #endif /* HasPrototypes */    M #define FALSE                      0       /* as it says                   */ M #define TRUE                       1       /* as it says                   */   M #define ALL_OK                     0       /* for use by exit ()           */ M #define PROBLEMS                   1       /* for use by exit ()           */ M #define BELL_PERCENT               40      /* as is says                   */ G #define MIN_MINUTES                1       /* minimum number of minutes * 					      before firing up the locker  */M #define MINUTES                    10      /* default ...                  */ M #define MAX_MINUTES                60      /* maximum ...                  */ G #define INITIAL_SLEEP              20      /* for machines on which the - 			 	  	      login sequence takes forever */ M #define INCREMENTAL_SLEEP          1       /* time step in seconds         */ @ #define CREATION_DELAY             30      /* should be > 10 and+ 				 	      < min (45,(MIN_MINUTES*30))  */ C #define CORNER_SIZE                10      /* size in pixels of the , 			  		      force-lock areas             */G #define CORNER_DELAY               5       /* number of seconds to wait * 					      before forcing a lock        */O /*#define LOCKER                     "xlock" /* NEVER use the -root option!  */ 0 #define LOCKER    "sys$system:decw$pausesession". #define CLASS                      "Xautolock"2 			 	           /* as it says                   */   /*#if SystemV == YES' #define vfork                      fork  #endif /* SystemV == YES */   ' #define Main                       main 2 #define Min(a,b)                   (a < b ? a : b)+ #define forever                    for (;;) 6 #define Output0(str)               (Void) printf (str)< #define Output1(str,arg1)          (Void) printf (str, arg1)B #define Output2(str,arg1,arg2)     (Void) printf (str, arg1, arg2)6 #define Error0(str)                (Void) printf (str)< #define Error1(str,arg1)           (Void) printf (str, arg1)B #define Error2(str,arg1,arg2)      (Void) printf (str, arg1, arg2)B #define UpdateTimer(new_val)       if (!sighupped) timer = new_val  ? static void*                       ch_ptr;  /* this is dirty */ M #define Skeleton(t,s)              (ch_ptr = (Void*) malloc ((unsigned) s), \ 2 			 	      ch_ptr == (Void*) NULL                \4 			   	    ?   (Error0 ("Out of memory.\n"),       \2 			 	       (Void) exit (PROBLEMS),              \2 			 	       (t*) NULL                            \2 			 	      )                                     \5 			    	    : (t*) ch_ptr                           \ F 	                           )                                        \  A #define New(type)                  Skeleton (type, sizeof (type)) M #define NewArray(type,nof_elems)   Skeleton (type, sizeof (type) * nof_elems)          /*
  *  New types 
  *  =========   */ * #if defined (apollo) || defined (news1800)A typedef int                        (*XErrorHandler) PP((Display*,  						       XErrorEvent*)); #endif /* apollo || news1800 */   * #if defined (news1800) || defined (sun386)) typedef int                        pid_t;   #endif /* news1800  || sun386 */  K #define Void                       void     /* no typedef because of VAX */ ' typedef int                        Int; ( typedef char                       Char;* typedef char*                      String;+ typedef int                        Boolean; * typedef caddr_t                    Caddrt;( typedef unsigned long              Huge;   #ifdef HasVoidSignalReturnK #define SigRet                     Void     /* no typedef because of VAX */  #else /* HasVoidSignalReturn */ * typedef Int                        SigRet;  #endif /* HasVoidSignalReturn */  J typedef SigRet                     (*SigHandler) PP((/* OS dependent */));F typedef Boolean                    (*OptAction)  PP((Display*, String, 						     String));@ typedef Void                       (*OptChecker) PP((Display*));   typedef enum 	{D 	  IGNORE,                                 /* ignore this corner  */D 	  DONT_LOCK,                              /* never lock          */D 	  FORCE_LOCK,                             /* lock immediately    */ 	} CornerAction;   typedef struct QueueItem_  	{D 	  Window                   window;        /* as it says          */D 	  Time                     creationtime;  /* as it says          */D 	  struct QueueItem_*       next;          /* as it says          */D 	  struct QueueItem_*       prev;          /* as it says          */ 	} aQueueItem, *QueueItem;   typedef struct Queue_  	{D 	  struct QueueItem_*       head;          /* as it says          */D 	  struct QueueItem_*       tail;          /* as it says          */ 	} aQueue, *Queue;   typedef struct Opt_  	{D 	  String                   name;          /* as it says          */D 	  XrmOptionKind            kind;          /* as it says          */D 	  Caddrt                   value;         /* XrmOptionNoArg only */D 	  OptAction                action;        /* as it says          */D 	  OptChecker               checker;       /* as it says          */ 	} anOpt, *Opt;          /*  *  Function declarations   *  =====================   */  #ifdef news1800 6 extern Void*    malloc             PP((unsigned int)); #endif /* news1800 */   5 static Void     Usage              PP((String, Int)); . static Void     Sleep              PP((Void));: static Void     EvaluateCounter    PP((Display*,Window*));2 static Void     QueryPointer       PP((Display*));9 static Void     ProcessEvents      PP((Display*, Queue)); . static Queue    NewQueue           PP((Void));7 static Void     AddToQueue         PP((Queue, Window)); ? static Void     ProcessQueue       PP((Queue, Display*, Time)); C static Void     SelectEvents       PP((Display*, Window, Boolean)); : static Void     CheckConnection    PP((Display*, String));: static Int      FetchFalseAlarm    PP((Display*, XEvent));@ static Void     ProcessOpts        PP((Display*, Int, String*));B static Boolean  TimeAction         PP((Display*, String, String));B static Boolean  LockerAction       PP((Display*, String, String));B static Boolean  CornersAction      PP((Display*, String, String));B static Boolean  CornerSizeAction   PP((Display*, String, String));B static Boolean  CornerDelayAction  PP((Display*, String, String));B static Boolean  NotifyAction       PP((Display*, String, String));B static Boolean  BellAction         PP((Display*, String, String));B static Boolean  NoCloseAction      PP((Display*, String, String));B static Boolean  HelpAction         PP((Display*, String, String));B static Boolean  VersionAction      PP((Display*, String, String));6 static Boolean  GetPositive        PP((String, Int*));2 static Void     TimeChecker        PP((Display*));2 static Void     NotifyChecker      PP((Display*));2 static Void     CornerSizeChecker  PP((Display*));2 static Void     BellChecker        PP((Display*));. static SigRet   DisableBySignal    PP((Void));   /*  *  Global variables  *  ================  */ H static Time          now = 0;               /* number of sleeps since we- 		    			       started (not `Int')        */ L static Int           timer = 0;             /* as it says (not `Time')    */L static String        locker = LOCKER;       /* as it says                 */L static Int           time_limit = MINUTES;  /* as it says (not `Time')    */L static Int           notify_margin;         /* as it says (not `Time')    */1 static Int           bell_percent = BELL_PERCENT; ) 					    /* as it says                 */ / static Int           corner_size = CORNER_SIZE; ) 					    /* as it says                 */ 1 static Int           corner_delay = CORNER_DELAY; ) 					    /* as it says (not `Time')    */ D static Boolean       sighupped = FALSE;     /* whether to ignore all) 					       time-outs                  */ I static Boolean       notify_lock = FALSE;   /* whether to notify the user 0 				               before locking             */E static CornerAction  corners[4] = { IGNORE, IGNORE, IGNORE, IGNORE }; E 	                                    /* default CornerActions      */ F static Boolean       close_output = TRUE;   /* whether to close stdoutL                                                and stderr                 */  static anOpt         options[] =
      		     { 2        		       {"help"       , XrmoptionNoArg   ,F         	        (Caddrt) ""  , HelpAction       , (OptChecker) NULL},2        		       {"version"    , XrmoptionNoArg   ,F         	        (Caddrt) ""  , VersionAction    , (OptChecker) NULL},2        		       {"locker"     , XrmoptionSepArg  ,F         	        (Caddrt) NULL, LockerAction     , (OptChecker) NULL},2        		       {"corners"    , XrmoptionSepArg  ,F         	        (Caddrt) NULL, CornersAction    , (OptChecker) NULL},2        		       {"cornersize" , XrmoptionSepArg  ,F         	        (Caddrt) NULL, CornerSizeAction , CornerSizeChecker},2        		       {"cornerdelay", XrmoptionSepArg  ,F         	        (Caddrt) NULL, CornerDelayAction, (OptChecker) NULL},2        		       {"time"       , XrmoptionSepArg  ,F         	        (Caddrt) NULL, TimeAction       , TimeChecker      },2        		       {"notify"     , XrmoptionSepArg  ,F         	        (Caddrt) NULL, NotifyAction     , NotifyChecker    },2        		       {"bell"       , XrmoptionSepArg  ,F         	        (Caddrt) NULL, BellAction       , BellChecker      },2        		       {"noclose"    , XrmoptionNoArg   ,F         	        (Caddrt) ""  , NoCloseAction    , (OptChecker) NULL},>      		     };                     /* as it says, the order is) 					       important                  */          /*+  *  Command line argument related functions +  *  =======================================   *  *  Support functions   *  -----------------   */ & static Boolean  GetPositive (arg, pos)3 String  arg;  /* string to scan                  */ 3 Int*    pos;  /* adress where to store the stuff */    { +   Char  c;           /* dummy            */ +   Int   old = *pos;  /* backup old value */     +   if (   sscanf (arg, "%d%c", pos, &c) == 1        && *pos >= 0      )   {      return TRUE;   }    else   {      *pos = old;      return FALSE;    }  }        /*  *  Action functions  *  ----------------  */  /*ARGSUSED*/) static Boolean  HelpAction (d, name, arg) & Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {    Usage (name, ALL_OK);   &   return TRUE;  /* for lint and gcc */ }      /*ARGSUSED*/, static Boolean  VersionAction (d, name, arg)& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   { 4   Error2 ("%s : patchlevel %d\n", name, PATCHLEVEL);   (Void) exit (ALL_OK);   &   return TRUE;  /* for lint and gcc */ }      /*ARGSUSED*// static Boolean  CornerSizeAction (d, name, arg)*& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {c)   return GetPositive (arg, &corner_size);  }*     /*ARGSUSED*/0 static Boolean  CornerDelayAction (d, name, arg)& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   { *   return GetPositive (arg, &corner_delay); }/     /*ARGSUSED*/) static Boolean  TimeAction (d, name, arg).& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {/(   return GetPositive (arg, &time_limit); }h     /*ARGSUSED*/+ static Boolean  NotifyAction (d, name, arg)h& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {r9   return notify_lock = GetPositive (arg, &notify_margin);  }      /*ARGSUSED*/) static Boolean  BellAction (d, name, arg)*& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {h*   return GetPositive (arg, &bell_percent); }      /*ARGSUSED*/, static Boolean  NoCloseAction (d, name, arg)& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {(   close_output = FALSE;0   return TRUE; }      /*ARGSUSED*/+ static Boolean  LockerAction (d, name, arg) & Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {    locker = arg;e   return TRUE; }      /*ARGSUSED*/, static Boolean  CornersAction (d, name, arg)& Display*  d;     /* display pointer */& String    name;  /* program name    */& String    arg;   /* argument value  */   {    Int  c;  /* loop counter */o       if (strlen (arg) == 4)   {      for (c = -1; ++c < 4; )o     {d       switch (arg[c])*       {  	case '0' :  	  corners[c] = IGNORE;' 	  continue;   	case '-' :  	  corners[c] = DONT_LOCK; 	  continue;   	case '+' :u 	  corners[c] = FORCE_LOCK;s 	  continue;  
 	default : 	  return FALSE;       }      }        return TRUE;   }    else   {      return FALSE;:   }  }        /*  *  Consistency checkers  *  --------------------  */* /*ARGSUSED*/ static Void  TimeChecker (d)# Display*  d;  /* display pointer */o   {n   if (time_limit < MIN_MINUTES)    { ?     Error1 ("Setting time to minimum value of %d minute(s).\n", &             time_limit = MIN_MINUTES);   }.$   else if (time_limit > MAX_MINUTES)   {l?     Error1 ("Setting time to maximum value of %d minute(s).\n",o&             time_limit = MAX_MINUTES);   }r  ,   time_limit *= 60; /* convert to seconds */ }      /*ARGSUSED*/ static Void  NotifyChecker (d)# Display*  d;  /* display pointer */1   {2   if (   notify_lock(       && notify_margin >= time_limit / 2      )   { 5     Error1 ("Notification time set to %d seconds.\n",u,             notify_margin = time_limit / 2);   }r }b     /*ARGSUSED*/ static Void  BellChecker (d)# Display*  d;  /* display pointer */-   {    if (   bell_percent < 1r       || bell_percent > 100m      )   { -     Error1 ("Bell percentage set to %d%%.\n",-" 	    bell_percent = BELL_PERCENT);   }C }r     /*ARGSUSED*/" static Void  CornerSizeChecker (d)# Display*  d;  /* display pointer */b   {h1   Int      s;                /* screen index   */i1   Screen*  scr;              /* screen pointer */*1   Int      max_corner_size;  /* as it says     */i    @   for (max_corner_size = 32000, s = -1; ++s < ScreenCount (d); )   {p!     scr = ScreenOfDisplay (d, s);   4     if (   max_corner_size > WidthOfScreen (scr) / 4. 	|| max_corner_size > HeightOfScreen (scr) / 4        )     {UL       max_corner_size = Min (WidthOfScreen (scr), HeightOfScreen (scr)) / 4;     }E   }L  $   if (corner_size > max_corner_size)   {I.     Error1 ("Corner size set to %d pixels.\n",$ 	    corner_size = max_corner_size);   }W }H       /*7  *  Function for informing the user about syntax errorsN7  *  ---------------------------------------------------R  */N) static Void  Usage (prog_name, exit_code)*$ String  prog_name;  /* as it says */$ Int     exit_code;  /* as it says */   {a.   String  blanks;  /* string full of blanks */.   size_t  len;     /* number of blanks      */      /*t;   *  The relative overhead is enormous here, but who cares.n<   *  I'm a perfectionist and Usage () doesn't return anyway.   */5   len = strlen ("Usage : ") + strlen (prog_name) + 1;/>   (Void) memset (blanks = NewArray (Char, len + 1), ' ', len);   blanks[len] = '\0';g      /* /   *  This is where the actual work gets done...    */   Error0 ("\n");$   Error1 ("Usage : %s ", prog_name);@   Error0 ("[-help][-version][-time minutes][-locker locker]\n");   Error0 (blanks);>   Error0 ("[-notify margin][-bell percent][-corners xxxx]\n");   Error0 (blanks);A   Error0 ("[-cornerdelay secs][-cornersize pixels][-noclose]\n");1     Error0 ("\n");B   Error0 (" -help              : print this message and exit.\n");D   Error0 (" -version           : print version number and exit.\n");M   Error2 (" -time minutes      : time to lock screen [%d < minutes < %d].\n", 4 	                         MIN_MINUTES, MAX_MINUTES);;   Error0 (" -locker locker     : program used to lock.\n"); L   Error0 (" -notify margin     : beep this many seconds before locking.\n");;   Error0 (" -bell percent      : loudness of the beep.\n"); N   Error0 (" -corners xxxx      : corner actions (0, +, -) in this order :\n");M   Error0 ("                      topleft topright bottomleft bottomright\n");1J   Error0 (" -cornerdelay secs  : time to lock screen in a `+' corner.\n");;   Error0 (" -cornersize pixels : size of corner areas.\n");IE   Error0 (" -noclose           : do not close stdout and stderr.\n");b     Error0 ("\n");   Error0 ("Defaults :\n");     Error0 ("\n");:   Error1 ("  time        : %d minutes\n"  , MINUTES     );:   Error1 ("  locker      : %s\n"          , LOCKER      );:   Error0 ("  notify      : don't beep\n"                );:   Error0 ("  bell        : 40%%\n"                      );:   Error0 ("  corners     : 0000\n"                      );:   Error1 ("  cornerdelay : %d seconds\n"  , CORNER_DELAY);:   Error1 ("  cornersize  : %d pixels\n"   , CORNER_SIZE );     Error0 ("\n");     exit (exit_code);  }        /*2  *  Function for processing command line arguments2  *  ----------------------------------------------  */ ( static Void  ProcessOpts (d, argc, argv), Display*  d;       /* display pointer     */, Int       argc;    /* number of arguments */, String    argv[];  /* array of arguments  */   {sE   Int                nof_options = sizeof (options) / sizeof (anOpt);l> 	                          /* number of supported options   */E   Int                j;           /* loop counter                  */yE   Int                l;           /* temporary storage             */iE   Char*              ptr;         /* temporary storage             */ E   Char               buffer[80];  /* as it says                    */ E   Char*              dummy;       /* as it says                    */uE   XrmValue           value;       /* resource value container      */0E   XrmOptionDescList  xoptions;    /* optionslist in Xlib format    */ -   XrmDatabase        db = (XrmDatabase) NULL;s) 				  /* command line options database */,      /*d   *  Beautify argv[0].   */C   for (ptr = argv[0] + strlen (argv[0]) - 1; ptr >= argv[0]; ptr--)    {_     if (*ptr == '/')     {d       break;     }    }      argv[0] = ptr + 1;      /*n>   *  Calling XGetDefault () on a dummy resource is the easiest/   *  way to get both Xrm and d->db initialized.    */+   (Void) XGetDefault (d, argv[0], "dummy");       /*	B   *  Parse the command line options into a resource database. (TheA   *  command line database and the resource file database are not @   *  merged, because we want to know where exactly each resource   *  value came from.)   */6   xoptions = NewArray (XrmOptionDescRec, nof_options);  #   for (j = -1; ++j < nof_options; )l   { !     l = strlen (options[j].name);f  @     (Void) sprintf (xoptions[j].option = NewArray (Char, l + 2),% 	            "-%s", options[j].name);eC     (Void) sprintf (xoptions[j].specifier = NewArray (Char, l + 2),	% 	            ".%s", options[j].name);o*     xoptions[j].argKind = options[j].kind;)     xoptions[j].value = options[j].value;    }   E   XrmParseCommand (&db, xoptions, nof_options, argv[0], &argc, argv);   
   if (--argc)    {n     Usage (argv[0], PROBLEMS);   }   #   for (j = -1; ++j < nof_options; )e   {r     free (xoptions[j].option);!     free (xoptions[j].specifier);r   }      free (xoptions);      /*    *  Call the action functions.    */#   for (j = -1; ++j < nof_options; )n   { D     (Void) sprintf (buffer, "%s%s", argv[0], xoptions[j].specifier);  C     if (XrmGetResource (db, buffer, (String) NULL, &dummy, &value))i     {u;       if (!(*(options[j].action)) (d, argv[0], value.addr))        {g"         Usage (argv[0], PROBLEMS);       }      }SK     else if (XrmGetResource (d->db, buffer, (String) NULL, &dummy, &value))t     { ;       if (!(*(options[j].action)) (d, argv[0], value.addr))        { G         Error2 ("Can't interprete \"%s\" for \"%s\", using default.\n",  	        value.addr, buffer);        }i     }r     else     {KD       (Void) sprintf (buffer, "%s%s", CLASS, xoptions[j].specifier);  J       if (   XrmGetResource (d->db, buffer, (String) NULL, &dummy, &value)=           && !(*(options[j].action)) (d, argv[0], value.addr)d
          )       {aG         Error2 ("Can't interprete \"%s\" for \"%s\", using default.\n",  	        value.addr, buffer);_       }e     }    }/        /*s#   *  Call the consistency checkers.    */#   for (j = -1; ++j < nof_options; )/   {a0     if (options[j].checker != (OptChecker) NULL)     {s"       (*(options[j].checker)) (d);     }s   }a }          /*)  *  Functions related to the window queue/)  *  =====================================;  *%  *  Function for creating a new queue %  *  ---------------------------------a  */  static Queue  NewQueue ()    { #   Queue  queue;  /* return value */        queue = New (aQueue); !   queue->tail = New (aQueueItem);A!   queue->head = New (aQueueItem);   "   queue->tail->next = queue->head;"   queue->head->prev = queue->tail;;   queue->tail->prev = queue->head->next = (QueueItem) NULL;      return queue;i }d       /**  *  Function for adding an item to a queue*  *  --------------------------------------  */(' static Void  AddToQueue (queue, window) ! Queue   queue;   /* as it says */ ! Window  window;  /* as it says */    {e!   QueueItem  new;  /* new item */V       new = New (aQueueItem);D     new->window = window;V   new->creationtime = now;    new->next = queue->tail->next;   new->prev = queue->tail;    queue->tail->next->prev = new;   queue->tail->next = new; }t       /*=  *  Function for processing those entries that are old enoughc=  *  ---------------------------------------------------------e  */v) static Void  ProcessQueue (queue, d, age) ' Queue     queue;  /* as it says      */D' Display*  d;      /* display pointer */F' Time      age;    /* required age    */t   {i'   QueueItem  current;  /* as it says */t       if (now > age)   {n      current = queue->head->prev;       while (   current->preve( 	   && current->creationtime + age < now 	  )     { /       SelectEvents (d, current->window, False);S       current = current->prev;       free (current->next);l     }r        current->next = queue->head;      queue->head->prev = current;   }r })         /*4  *  Functions related to (the lack of) user activity4  *  ================================================  *+  *  Function for processing the event queue +  *  ---------------------------------------B  */n% static Void  ProcessEvents (d, queue)n' Display*  d;      /* display pointer */o' Queue     queue;  /* as it says      */t   {B"   XEvent  event;  /* as it says */      /*;,   *  Read whatever is available for reading.   */   while (XPending (d))   {e<     if (XCheckMaskEvent (d, SubstructureNotifyMask, &event))     {y%       if (event.type == CreateNotify)        {l0 	AddToQueue (queue, event.xcreatewindow.window);       }*     }l     else     {*       XNextEvent (d, &event);c     }         /*=>     *  Reset the counter if and only if the event is of one ofC     *  the types we are expecting to get *and* was not generated by      *  XSendEvent ().t     */!     if (   event.type == KeyPress  	&& !event.xany.send_event        )     {        UpdateTimer (0);     }i   }       /* ;   *  Check the window queue for entries that are older than_   *  CREATION_DELAY seconds.   */1   ProcessQueue (queue, d, (Time) CREATION_DELAY);E }P       /*-  *  Function for monitoring pointer movementst-  *  -----------------------------------------	  */  static Void  QueryPointer (d)*# Display*  d;  /* display pointer */    {NI   Window          dummy_w;            /* as it says                    */ I   Int             dummy_c;            /* as it says                    */ I   Mask            dummy_m;            /* as it says                    */ I   Int             root_x;             /* as it says                    */CI   Int             root_y;             /* as it says                    */ I   Int             corner;             /* corner index                  */ I   Int             i;                  /* loop counter                  */ I   static Window   root;               /* root window the pointer is on */ I   static Screen*  screen;             /* screen the pointer is on      */AI   static Int      prev_root_x = -1;   /* as it says                    */LI   static Int      prev_root_y = -1;   /* as it says                    */aI   static Boolean  first_call = TRUE;  /* as it says                    */r      /*r   *  Have a guess...   */   if (first_call)L   {k     first_call = FALSE;r!     root = DefaultRootWindow (d);"4     screen = ScreenOfDisplay (d, DefaultScreen (d));   }o      /*oI   *  Find out whether the pointer has moved. Using XQueryPointer for this G   *  is gross, but it also is the only way never to mess up propagation,   *  of pointer events.r   *"D   *  Remark : Unlike XNextEvent(), XPending () doesn't notice if theH   *           connection to the server is lost. For this reason, earlierE   *           versions of xautolock periodically called XNoOp (). But,C   *           why not let XQueryPointer () do the job for us, since D   *           we now call it every INCREMENTAL_SLEEP seconds anyway?   */A   if (!XQueryPointer (d, root, &root, &dummy_w, &root_x, &root_y,l& 		      &dummy_c, &dummy_c, &dummy_m))   {     /*"H     *  Pointer has moved to another screen, so let's find out which one.     */)     for (i = -1; ++i < ScreenCount (d); )      { $       if (root == RootWindow (d, i))       { (         screen = ScreenOfDisplay (d, i); 	break;m       }a     }    }e     if (   root_x == prev_root_x       && root_y == prev_root_y      )   {c    /* ?     *  If the pointer has not moved since the previous call ando>     *  is inside one of the 4 corners, we act according to the'     *  contents of the "corners" array.f     */     if (   (corner = 0,/ 	       root_x <= corner_size  	    && root_y <= corner_sizee 	   )  	|| (corner++,; 	       root_x >= WidthOfScreen  (screen) - corner_size - 1  	    && root_y <= corner_sizel 	   )  	|| (corner++, 	       root_x <= corner_size ; 	    && root_y >= HeightOfScreen (screen) - corner_size - 1  	   )S 	|| (corner++,; 	       root_x >= WidthOfScreen  (screen) - corner_size - 1 ; 	    && root_y >= HeightOfScreen (screen) - corner_size - 1  	   )/        )     {        switch (corners[corner])       {e 	case FORCE_LOCK :- 	  if (timer < time_limit - corner_delay + 2)o 	  {1 	    UpdateTimer (time_limit - corner_delay + 2);i 	  }	 	  break;    	case DONT_LOCK :r 	  UpdateTimer (0);i       };     }r   }t   else   {      prev_root_x = root_x;v     prev_root_y = root_y;;     UpdateTimer (0);   }  }        /*)  *  Function for deciding whether to lockS)  *  -------------------------------------n  */a" static Void  EvaluateCounter (d,r)# Display*  d;  /* display pointer */ 
 Window* r;   {g1   static pid_t  locker_pid = 0;  /* child pid  */t1   static Time   prev_bell = 0;   /* as it says *//      /*B>   *  Find out whether we should do something special. This can(   *  be one (or more) of the following :   *a.   *   - Wait for the previous locker (if any).A   *   - Ring the bell, if we were asked to and are about to lock.SA   *   - Start up a new locker if the time limit has been reached./   */     if (locker_pid)g   {a4     union wait  status;  /* childs process status */    = /*   if (!wait3 (&status, WNOHANG, (struct rusage*) NULL)) */       if (SmPauseWindow(d,r))     {y       UpdateTimer (0);     }*     else     {a       locker_pid = 0;      }/   }g     if (   notify_lock+       && timer + notify_margin > time_limitn,       && prev_bell < now - notify_margin - 1      )   {      prev_bell = now;     XBell (d, bell_percent);     XSync (d, 0);    }      if (timer > time_limit)    {      if (!locker_pid)     {g$       switch (locker_pid = vfork ())       {n
 	case -1 : 	  locker_pid = 0;	 	  break;   	 	case 0 : ' 	  (Void) close (ConnectionNumber (d));rC /*	  (Void) execl ("/bin/sh", "sh", "-c", locker, (String) NULL);*/aJ /*        Only fire up locker if not there--may have been done manually */"           if (!SmPauseWindow(d,r))1          	  (Void) execl (locker, (String) NULL);a 	  (Void) _exit (PROBLEMS);p  
 	default : 	  UpdateTimer (0);        }a     }/   }i }          /*  *  Miscellaneous functionso  *  =======================   *  *  X Error handlert  *  ---------------t  */d /*ARGSUSED*/& static Int  FetchFalseAlarm (d, event)' Display*  d;      /* display pointer */t' XEvent    event;  /* error event     */    {n   return 0;p }u       /*  *  SIGHUP signal handler)  *  ---------------------c  */ ! static SigRet  DisableBySignal ()    {   /*cA   *  The order in which things are done is rather important here.    */   UpdateTimer (0);   sighupped = !sighupped; 7   (Void) signal (SIGHUP, (SigHandler) DisableBySignal);t   #ifndef HasVoidSignalReturn    return 0;   #endif /* HasVoidSignalReturn */ }        /*  *  Lazy function   *  -------------c  */c static Void  Sleep ()-   {-   Int  i;  /* loop counter */i    )   for (i = -1; ++i < INCREMENTAL_SLEEP; )i   {*     (Void) sleep (1);m     UpdateTimer (timer + 1);
     now++;   }t }        /*I  *  Function for finding out whether another xautolock is already running I  *  ---------------------------------------------------------------------x  */v+ static Void  CheckConnection (d, prog_name)l+ Display*  d;          /* display pointer */ + String    prog_name;  /* as it says      */S   { 3   pid_t   pid;        /* as it says              */l3   Int     kill_val;   /* return value of kill () */n3   Window  r;          /* root window             */o3   Atom    property;   /* property atom           */ 3   Atom    type;       /* property type atom      */ 3   Int     format;     /* property format         */ 3   Huge    nof_items;  /* actual number of items  */n3   Huge    after;      /* dummy                   */ 3   pid_t*  contents;   /* actual property value   */l    2   r = RootWindowOfScreen (ScreenOfDisplay (d, 0));?   property = XInternAtom (d, "XAUTOLOCK_SEMAPHORE_PID", False);t     XGrabServer (d);E   XGetWindowProperty (d, r, property, 0L, 2L, False, AnyPropertyType, + 		      &type, &format, &nof_items, &after,_% 		      (unsigned char**) &contents);      if (type == XA_INTEGER)    {+    /*e0     *  This breaks if the other xautolock is not#     *  running on the same machine.>     */#     kill_val = kill (*contents, 0);        if (kill_val == 0)     { 2       Error2 ("%s is already running (PID %d).\n", 	      prog_name, *contents);        (Void) exit (PROBLEMS);n     }    }_     pid = getpid ();1   XChangeProperty (d, r, property, XA_INTEGER, 8,c9 	           PropModeReplace, (Char*) &pid, sizeof (pid));c   XUngrabServer (d);     XFree ((Char*) contents);  }-       /*6  *  Function for selecting events on a tree of windows6  *  --------------------------------------------------  */t8 static Void  SelectEvents (d, window, substructure_only)5 Display*  d;                  /* display pointer   */e5 Window    window;             /* window            */r5 Boolean   substructure_only;  /* as it says        */    {aH   Window             root;              /* root window of this window */H   Window             parent;            /* parent of this window      */H   Window*            children;          /* children of this window    */H   Int                nof_children = 0;  /* number of children         */H   Int                i;                 /* loop counter               */H   XWindowAttributes  attribs;           /* attributes of the window   */      /*-A   *  Start by querying the server about parent and child windows.c   */H   if (!XQueryTree (d, window, &root, &parent, &children, &nof_children))   {      return;t   }e      /* F   *  Build the appropriate event mask. The basic idea is that we don'tE   *  want to interfere with the normal event propagation mechanism ifn   *  we don't have to.   */   if (substructure_only)   {M5     XSelectInput (d, window, SubstructureNotifyMask);    }c   else   {r4     if (parent == None)  /* the *real* rootwindow */     {c       attribs.all_event_masks =c3       attribs.do_not_propagate_mask = KeyPressMask;c     }x=     else if (XGetWindowAttributes (d, window, &attribs) == 0)o     { 
       return;      }e  5     XSelectInput (d, window,   SubstructureNotifyMaskr. 		             | (  (  attribs.all_event_masks' 				   | attribs.do_not_propagate_mask)s 				& KeyPressMask));.   }I      /*0,   *  Now do the same thing for all children.   */$   for (i = -1; ++i < nof_children; )   {D5     SelectEvents (d, children[i], substructure_only);    }:     if (nof_children != 0)   {      XFree ((Char*) children);"   }  }        /*  *  Main function   *  -------------t  */\ Int  Main (argc, argv)* Int     argc;    /* number of arguments */* String  argv[];  /* array of arguments  */   { )   Display*  d;      /* display pointer */d)   Window    r;      /* root window     */r)   Int       s;      /* screen index    */N)   Queue     queue;  /* as it says      */x      /* E   *  Find out whether there actually is a server on the other side...    */+   if (   (d = XOpenDisplay ((String) NULL))        == (Display*) NULL      )   {g     (Void) exit (PROBLEMS);p   }o    &   fprintf(stderr, "Initializing....");    /*e   *  Some initializations.   */   ProcessOpts (d, argc, argv);  5   XSetErrorHandler ((XErrorHandler) FetchFalseAlarm);n   CheckConnection (d, argv[0]); 7   (Void) signal (SIGHUP, (SigHandler) DisableBySignal);      XSync (d, 0);o/   fprintf(stderr, "Setting initial sleep....");    (Void) sleep (INITIAL_SLEEP);a     queue = NewQueue ();  '   for (s = -1; ++s < ScreenCount (d); )o   { H     AddToQueue (queue, r = RootWindowOfScreen (ScreenOfDisplay (d, s)));     SelectEvents (d, r, True);   }m     if (close_output)    {      (Void) fclose (stdout);      (Void) fclose (stderr);u   }a      /*i   *  Main event loop.o   */	   forevern   { (   fprintf(stderr, "Going to sleep....");
     Sleep (); #   fprintf(stderr, "Waking up....");c       ProcessEvents (d, queue);      QueryPointer (d);      EvaluateCounter (d,r);   }[ }+