/*
# X-BASED ABACUS
#
#  AbacusP.h
#
###
#
#  Copyright (c) 1994 - 95	David Albert Bagley, bagleyd@source.asset.com
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Abacus */

#ifndef _AbacusP_h
#define _AbacusP_h

#include "Abacus.h"

#define MAXBEADS 10
#define MAXLEVELS 2
#define UP 1
#define DOWN 0

/* The following 4 are in xabacus.c also */
#define TOP 1
#define BOTTOM 0
#define MAXBARS 20
#define MAXDIGITS (MAXBARS+3) /* Don't forget the carry */

#define NUM_DEGREES 360
#define MULT 64
#define CIRCLE (NUM_DEGREES*MULT)

#define ABS(a) (((a)<0)?(-a):(a))
#define SIGN(a) (((a)<0)?-1:1)
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))

typedef struct _LevelPart {
  int			number;
  Boolean		orientation;
  int			factor;
  int			position[MAXBARS];
  int			room; /* spaces + number */
  Position		height;
} LevelPart;

typedef struct _AbacusPart {
  Pixel			foreground;
  Pixel			bead;
  LevelPart		levels[MAXLEVELS];
  int			bars; /* number of columns of beads */
  int			spaces; /* spaces between beads */
  int			base; /* 10 usually */
  Position		bead_width, bead_height;
  Position		wid, ht;
  Position		width;
  XPoint		delta, offset;
  char			digits[MAXDIGITS];
  GC			abacusGC;
  GC			beadGC;
  GC			eraseGC;
  XtCallbackList	select;
} AbacusPart;

typedef struct _AbacusRec {
  CorePart core;
  AbacusPart abacus;
} AbacusRec;

/* This gets around C's inability to do inheritance */
typedef struct _AbacusClassPart {
  int ignore;
} AbacusClassPart;

typedef struct _AbacusClassRec {
  CoreClassPart core_class;
  AbacusClassPart abacus_class;
} AbacusClassRec;

extern AbacusClassRec abacusClassRec;

#endif /* _AbacusP_h */
