> /* $XConsortium: VisCmap.c,v 1.10 89/10/08 15:05:47 rws Exp $   *  >  * Copyright 1989 by the Massachusetts Institute of Technology  *H  * Permission to use, copy, modify, and distribute this software and itsM  * documentation for any purpose and without fee is hereby granted, provided  K  * that the above copyright notice appear in all copies and that both that  D  * copyright notice and this permission notice appear in supporting H  * documentation, and that the name of M.I.T. not be used in advertisingM  * or publicity pertaining to distribution of the software without specific,  G  * written prior permission. M.I.T. makes no representations about the  H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *,  * Author:  Donna Converse, MIT X Consortium  */    #include <stdio.h> #include <math.h>  #include <X11/Xlib.h>  #include <X11/Xatom.h> #include <X11/Xutil.h> #include <X11/Xmu/StdCmap.h>   /*L  * To create all of the appropriate standard colormaps for a given visual on2  * a given screen, use XmuVisualStandardColormaps.  *  L  * Define all appropriate standard colormap properties for the given visual.?  * If replace is true, any previous definition will be removed. I  * If retain is true, new properties will be retained for the duration of A  * the server session.  Return 0 on failure, non-zero on success. H  * On failure, no new properties will be defined, and, old ones may have$  * been removed if replace was True.  *I  * Not all standard colormaps are meaningful to all visual classes.  This K  * routine will check and define the following properties for the following D  * classes, provided that the size of the colormap is not too small.  *  *	DirectColor and PseudoColor  *	    RGB_DEFAULT_MAP  *	    RGB_BEST_MAP   *	    RGB_RED_MAP  *	    RGB_GREEN_MAP  * 	    RGB_BLUE_MAP  *          RGB_GRAY_MAP  *  *	TrueColor and StaticColor  *	    RGB_BEST_MAP   *  *	GrayScale and StaticGray   *	    RGB_GRAY_MAP   */   H Status XmuVisualStandardColormaps(dpy, screen, visualid, depth, replace,
 				  retain) 5     Display		*dpy;		/* specifies server connection */ 0     int			screen;		/* specifies screen number */2     VisualID		visualid;	/* specifies the visual */3     unsigned int	depth;		/* specifies the visual */ 5     Bool		replace;	/* specifies whether to replace */ 4     Bool		retain;		/* specifies whether to retain */ {      Status		status;      int			n;     long		vinfo_mask; (     XVisualInfo		vinfo_template, *vinfo;         #     vinfo_template.screen = screen; '     vinfo_template.visualid = visualid; !     vinfo_template.depth = depth; C     vinfo_mask = VisualScreenMask | VisualIDMask | VisualDepthMask; O     if ((vinfo = XGetVisualInfo(dpy, vinfo_mask, &vinfo_template, &n)) == NULL) 
 	return 0;  $     if (vinfo->colormap_size <= 2) {F 	/* Monochrome visuals have no standard maps; considered successful */ 	XFree((char *) vinfo); 
 	return 1;     }        switch (vinfo->class)      {        case PseudoColor:        case DirectColor: A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, , 					   XA_RGB_DEFAULT_MAP, replace,retain); 	if (!status) break;  A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, * 					   XA_RGB_GRAY_MAP, replace, retain); 	if (!status) { @ 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP); 	    break;  	}  A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, ) 					   XA_RGB_RED_MAP, replace, retain);  	if (!status) { @ 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);= 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP);  	    break;  	}  A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, + 					   XA_RGB_GREEN_MAP, replace, retain);  	if (!status) { @ 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);= 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP); < 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_RED_MAP); 	    break;  	}  A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, * 					   XA_RGB_BLUE_MAP, replace, retain); 	if (!status) { @ 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);= 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP); < 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_RED_MAP);> 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GREEN_MAP); 	    break;  	} 	/* fall through */          case StaticColor:        case TrueColor:   A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, * 					   XA_RGB_BEST_MAP, replace, retain);0 	if (!status && (vinfo->class == PseudoColor || " 			vinfo->class == DirectColor)) {@ 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP);= 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GRAY_MAP); < 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_RED_MAP);> 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_GREEN_MAP);= 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_BLUE_MAP);  	} 	break; G 	/* the end for PseudoColor, DirectColor, StaticColor, and TrueColor */          case GrayScale: A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, $ 					   XA_RGB_DEFAULT_MAP, replace, 					   retain); 	if (! status) break;  	/* fall through */          case StaticGray:  A 	status = XmuLookupStandardColormap(dpy, screen, visualid, depth, * 					   XA_RGB_GRAY_MAP, replace, retain);- 	if (! status && vinfo->class == GrayScale) { @ 	    XmuDeleteStandardColormap(dpy, screen, XA_RGB_DEFAULT_MAP); 	    break;  	}     }        XFree((char *) vinfo);     return status; } 