> /* $XConsortium: StdCmap.c,v 1.11 89/10/08 15:04:52 rws Exp $   *  >  * Copyright 1989 by the Massachusetts Institute of Technology  *H  * Permission to use, copy, modify, and distribute this software and itsM  * documentation for any purpose and without fee is hereby granted, provided  K  * that the above copyright notice appear in all copies and that both that  D  * copyright notice and this permission notice appear in supporting H  * documentation, and that the name of M.I.T. not be used in advertisingM  * or publicity pertaining to distribution of the software without specific,  G  * written prior permission. M.I.T. makes no representations about the  H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *,  * Author:  Donna Converse, MIT X Consortium  */    #include <stdio.h> #include <X11/Xlib.h>  #include <X11/Xatom.h> #include <X11/Xutil.h> #include <X11/Xmu/StdCmap.h>  8 static Status valid_args();		/* argument restrictions */   /*B  * To create any one standard colormap, use XmuStandardColormap().  *H  * Create a standard colormap for the given screen, visualid, and visualF  * depth, with the given red, green, and blue maximum values, with theJ  * given standard property name.  Return a pointer to an XStandardColormapF  * structure which describes the newly created colormap, upon success.  * Upon failure, return NULL.   *  E  * XmuStandardColormap() calls XmuCreateColormap() to create the map.   *I  * Resources created by this function are not made permanent; that is the   * caller's responsibility.   */   N XStandardColormap *XmuStandardColormap(dpy, screen, visualid, depth, property,. 				       cmap, red_max, green_max, blue_max)7     Display		*dpy;		/* specifies X server connection */ 1     int			screen; 	/* specifies display screen */ 8     VisualID		visualid;	/* identifies the visual type */9     unsigned int	depth;		/* identifies the visual type */ 6     Atom		property;	/* a standard colormap property */8     Colormap		cmap;		/* specifies colormap ID or None */A     unsigned long	red_max, green_max, blue_max;	/* allocations */  {      XStandardColormap	*stdcmap;      Status		status; (     XVisualInfo		vinfo_template, *vinfo;     long		vinfo_mask;      int			n;  C     /* Match the required visual information to an actual visual */ (     vinfo_template.visualid = visualid;	#     vinfo_template.screen = screen; !     vinfo_template.depth = depth; C     vinfo_mask = VisualIDMask | VisualScreenMask | VisualDepthMask; O     if ((vinfo = XGetVisualInfo(dpy, vinfo_mask, &vinfo_template, &n)) == NULL) 
 	return 0;  G     /* Check the validity of the combination of visual characteristics, F      * allocation, and colormap property.  Create an XStandardColormap      * structure.       */   C     if (! valid_args(vinfo, red_max, green_max, blue_max, property) 5 	|| ((stdcmap = XAllocStandardColormap()) == NULL)) {  	XFree((char *) vinfo); 
 	return 0;     }   1     /* Fill in the XStandardColormap structure */   /     if (cmap == DefaultColormap(dpy, screen)) { D 	/* Allocating out of the default map, cannot use XFreeColormap() */E 	Window win = XCreateWindow(dpy, RootWindow(dpy, screen), 1, 1, 1, 1, & 				   0, 0, InputOnly, vinfo->visual, 				   (unsigned long) 0, % 				   (XSetWindowAttributes *)NULL); ? 	stdcmap->killid  = (XID) XCreatePixmap(dpy, win, 1, 1, depth);  	XDestroyWindow(dpy, win); 	stdcmap->colormap = cmap;     } else {, 	stdcmap->killid = ReleaseByFreeingColormap;B 	stdcmap->colormap = XCreateColormap(dpy, RootWindow(dpy, screen),# 					    vinfo->visual, AllocNone);      }      stdcmap->red_max = red_max; #     stdcmap->green_max = green_max; !     stdcmap->blue_max = blue_max; %     if (property == XA_RGB_GRAY_MAP)  B 	stdcmap->red_mult = stdcmap->green_mult = stdcmap->blue_mult = 1;
     else {" 	stdcmap->red_mult = (red_max > 0), 	    ? (green_max + 1) * (blue_max + 1) : 0;: 	stdcmap->green_mult = (green_max > 0) ? blue_max + 1 : 0;- 	stdcmap->blue_mult = (blue_max > 0) ? 1 : 0;      } :     stdcmap->base_pixel = 0;			/* base pixel may change */(     stdcmap->visualid = vinfo->visualid;       /* Make the colormap */   -     status = XmuCreateColormap(dpy, stdcmap);        /* Clean up */       XFree((char *) vinfo);     if (!status) {  9 	/* Free the colormap or the pixmap, if we created one */ 1 	if (stdcmap->killid == ReleaseByFreeingColormap) + 	    XFreeColormap(dpy, stdcmap->colormap); " 	else if (stdcmap->killid != None)' 	    XFreePixmap(dpy, stdcmap->killid);  	  	XFree((char *) stdcmap); # 	return (XStandardColormap *) NULL;      }      return stdcmap;  }   N /****************************************************************************/G static Status valid_args(vinfo, red_max, green_max, blue_max, property) 0     XVisualInfo		*vinfo;		/* specifies visual */E     unsigned long	red_max, green_max, blue_max;	/* specifies alloc */ 1     Atom		property;	/* specifies property name */  { ;     unsigned long	ncolors;	/* number of colors requested */   F     /* Determine that the number of colors requested is <= map size */  G     if ((vinfo->class == DirectColor) || (vinfo->class == TrueColor)) {  	unsigned long mask;   	mask = vinfo->red_mask; 	while (!(mask & 1)) 	    mask >>= 1; 	if (red_max > mask) 	    return 0; 	mask = vinfo->green_mask; 	while (!(mask & 1)) 	    mask >>= 1; 	if (green_max > mask) 	    return 0; 	mask = vinfo->blue_mask;  	while (!(mask & 1)) 	    mask >>= 1; 	if (blue_max > mask)  	    return 0;-     } else if (property == XA_RGB_GRAY_MAP) { . 	ncolors = red_max + green_max + blue_max + 1;$ 	if (ncolors > vinfo->colormap_size) 	    return 0;     } else {< 	ncolors = (red_max + 1) * (green_max + 1) * (blue_max + 1);$ 	if (ncolors > vinfo->colormap_size) 	    return 0;     }      N     /* Determine that the allocation and visual make sense for the property */       switch (property)      {        case XA_RGB_DEFAULT_MAP:9 	if ((red_max == 0 || green_max == 0 || blue_max == 0) || C 	    (vinfo->class != PseudoColor && vinfo->class != DirectColor && ! 	     vinfo->class != GrayScale))  	    return 0; 	break;        case XA_RGB_RED_MAP:D 	if ((vinfo->class != PseudoColor && vinfo->class != DirectColor) || 	    (red_max == 0)) 	    return 0; 	break;        case XA_RGB_GREEN_MAP:D 	if ((vinfo->class != PseudoColor && vinfo->class != DirectColor) || 	    (green_max == 0)) 	    return 0; 	break;        case XA_RGB_BLUE_MAP:	D 	if ((vinfo->class != PseudoColor && vinfo->class != DirectColor) || 	    blue_max == 0)  	    return 0; 	break;        case XA_RGB_BEST_MAP: ? 	if (vinfo->class == GrayScale || vinfo->class == StaticGray || 5 	    red_max == 0 || green_max == 0 || blue_max == 0)  	    return 0; 	break;        case XA_RGB_GRAY_MAP: @ 	if (vinfo->class == StaticColor || vinfo->class == TrueColor ||5 	    red_max == 0 || blue_max == 0 || green_max == 0)  	    return 0; 	break;        default:
 	return 0;     } 
     return 1;  } 